/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.springframework.stereotype.Service;
import org.squashtest.tm.service.internal.dto.pivotdefinition.CustomFieldPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.pivot.PivotFileManager;
import org.squashtest.tm.service.pivot.projectexporter.CustomFieldPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.CustomFieldPivotDao;

@Service
public class CustomFieldPivotExporterServiceImpl
implements CustomFieldPivotExporterService {
    private final CustomFieldPivotDao customFieldPivotDao;
    private final PivotFileManager pivotFileManager;

    public CustomFieldPivotExporterServiceImpl(CustomFieldPivotDao customFieldPivotDao, PivotFileManager pivotFileManager) {
        this.customFieldPivotDao = customFieldPivotDao;
        this.pivotFileManager = pivotFileManager;
    }

    @Override
    public void generateCustomFieldsJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, Long projectId) throws IOException {
        List<CustomFieldPivot> customFieldPivotList = this.customFieldPivotDao.getCustomFieldsByProjectId(projectId);
        if (!customFieldPivotList.isEmpty()) {
            this.pivotFileManager.writeJson(jsonFactory, jsonGenerator -> this.handleCustomFields((JsonGenerator)jsonGenerator, customFieldPivotList), JsonImportFile.CUSTOM_FIELDS.getFileName(), archive);
        }
    }

    private void handleCustomFields(JsonGenerator jsonGenerator, List<CustomFieldPivot> customFieldPivotList) throws IOException {
        jsonGenerator.writeFieldName("custom_fields");
        jsonGenerator.writeStartArray();
        for (CustomFieldPivot customFieldPivot : customFieldPivotList) {
            jsonGenerator.writeObject((Object)customFieldPivot);
        }
        jsonGenerator.writeEndArray();
    }
}

