/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.converters;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jooq.Field;
import org.jooq.Record;
import org.springframework.stereotype.Service;
import org.squashtest.tm.aspect.validation.CleanHtmlAspect;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignStatus;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationStatus;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.CampaignPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.IterationPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.SprintPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.TestPlanItemPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.TestSuitePivot;
import org.squashtest.tm.service.internal.pivot.converters.ExecutionWorkspaceConverterServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.pivot.converters.ExecutionWorkspaceConverterServiceImpl$AjcClosure3;
import org.squashtest.tm.service.internal.pivot.converters.ExecutionWorkspaceConverterServiceImpl$AjcClosure5;
import org.squashtest.tm.service.internal.pivot.converters.ExecutionWorkspaceConverterServiceImpl$AjcClosure7;
import org.squashtest.tm.service.pivot.converters.ExecutionWorkspaceConverterService;
import org.squashtest.tm.service.pivot.projectexporter.SprintPivotDao;

@Service(value="ExecutionWorkspaceConverterService")
public class ExecutionWorkspaceConverterServiceImpl
implements ExecutionWorkspaceConverterService {
    private static final Logger LOGGER;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        ExecutionWorkspaceConverterServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(ExecutionWorkspaceConverterServiceImpl.class);
    }

    @Override
    public Campaign pivotToCampaign(CampaignPivot campaignPivot) throws ParseException {
        Campaign campaign = new Campaign();
        campaign.setName(campaignPivot.getName());
        CampaignPivot campaignPivot2 = campaignPivot;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)campaignPivot2);
        Object[] objectArray = new Object[]{this, campaignPivot2, joinPoint};
        ExecutionWorkspaceConverterServiceImpl$AjcClosure1 executionWorkspaceConverterServiceImpl$AjcClosure1 = new ExecutionWorkspaceConverterServiceImpl$AjcClosure1(objectArray);
        campaign.setDescription((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(executionWorkspaceConverterServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112)));
        if (Objects.nonNull(campaignPivot.getReference())) {
            campaign.setReference(campaignPivot.getReference());
        }
        campaign.setScheduledEndDate(this.parseIso8601Date(campaignPivot.getScheduledEndDate()));
        campaign.setScheduledStartDate(this.parseIso8601Date(campaignPivot.getScheduledStartDate()));
        if (!campaignPivot.isActualStartDateAuto()) {
            campaign.setActualStartDate(this.parseIso8601Date(campaignPivot.getActualStartDate()));
        }
        if (!campaignPivot.isActualEndDateAuto()) {
            campaign.setActualEndDate(this.parseIso8601Date(campaignPivot.getActualEndDate()));
        }
        campaign.setActualStartAuto(campaignPivot.isActualStartDateAuto());
        campaign.setActualEndAuto(campaignPivot.isActualEndDateAuto());
        if (Objects.nonNull(campaignPivot.getStatus())) {
            campaign.setStatus(campaignPivot.getStatus());
        }
        return campaign;
    }

    @Override
    public Iteration pivotToIteration(IterationPivot iterationPivot) throws ParseException {
        Iteration iteration = new Iteration();
        iteration.setName(iterationPivot.getName());
        IterationPivot iterationPivot2 = iterationPivot;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)iterationPivot2);
        Object[] objectArray = new Object[]{this, iterationPivot2, joinPoint};
        ExecutionWorkspaceConverterServiceImpl$AjcClosure3 executionWorkspaceConverterServiceImpl$AjcClosure3 = new ExecutionWorkspaceConverterServiceImpl$AjcClosure3(objectArray);
        iteration.setDescription((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(executionWorkspaceConverterServiceImpl$AjcClosure3.linkClosureAndJoinPoint(4112)));
        if (Objects.nonNull(iterationPivot.getReference())) {
            iteration.setReference(iterationPivot.getReference());
        }
        iteration.setScheduledEndDate(this.parseIso8601Date(iterationPivot.getScheduledEndDate()));
        iteration.setScheduledStartDate(this.parseIso8601Date(iterationPivot.getScheduledStartDate()));
        if (!iterationPivot.isActualStartDateAuto()) {
            iteration.setActualStartDate(this.parseIso8601Date(iterationPivot.getActualStartDate()));
        }
        if (!iterationPivot.isActualEndDateAuto()) {
            iteration.setActualEndDate(this.parseIso8601Date(iterationPivot.getActualEndDate()));
        }
        iteration.setActualStartAuto(iterationPivot.isActualStartDateAuto());
        iteration.setActualEndAuto(iterationPivot.isActualEndDateAuto());
        if (Objects.nonNull(iterationPivot.getStatus())) {
            iteration.setStatus(iterationPivot.getStatus());
        }
        return iteration;
    }

    @Override
    public TestSuite pivotToTestSuite(TestSuitePivot testSuitePivot) {
        TestSuite testSuite = new TestSuite();
        testSuite.setName(testSuitePivot.getName());
        TestSuitePivot testSuitePivot2 = testSuitePivot;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)testSuitePivot2);
        Object[] objectArray = new Object[]{this, testSuitePivot2, joinPoint};
        ExecutionWorkspaceConverterServiceImpl$AjcClosure5 executionWorkspaceConverterServiceImpl$AjcClosure5 = new ExecutionWorkspaceConverterServiceImpl$AjcClosure5(objectArray);
        testSuite.setDescription((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(executionWorkspaceConverterServiceImpl$AjcClosure5.linkClosureAndJoinPoint(4112)));
        if (Objects.nonNull(testSuitePivot.getStatus())) {
            testSuite.setExecutionStatus(testSuitePivot.getStatus());
        }
        return testSuite;
    }

    @Override
    public Sprint pivotToSprint(SprintPivot sprintPivot) throws ParseException {
        Sprint sprint = new Sprint();
        sprint.setName(sprintPivot.getName());
        SprintPivot sprintPivot2 = sprintPivot;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)sprintPivot2);
        Object[] objectArray = new Object[]{this, sprintPivot2, joinPoint};
        ExecutionWorkspaceConverterServiceImpl$AjcClosure7 executionWorkspaceConverterServiceImpl$AjcClosure7 = new ExecutionWorkspaceConverterServiceImpl$AjcClosure7(objectArray);
        sprint.setDescription((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(executionWorkspaceConverterServiceImpl$AjcClosure7.linkClosureAndJoinPoint(4112)));
        sprint.setReference(sprintPivot.getReference());
        sprint.setStatus(this.getSprintStatus(sprintPivot));
        sprint.setStartDate(this.parseIso8601Date(sprintPivot.getStartDate()));
        sprint.setEndDate(this.parseIso8601Date(sprintPivot.getEndDate()));
        return sprint;
    }

    private SprintStatus getSprintStatus(SprintPivot sprintPivot) {
        return switch (sprintPivot.getStatus()) {
            case SprintStatus.FUTURE -> SprintStatus.UPCOMING;
            case SprintStatus.ACTIVE -> SprintStatus.OPEN;
            default -> sprintPivot.getStatus();
        };
    }

    private Date parseIso8601Date(String date) throws ParseException {
        try {
            return DateUtils.parseIso8601Date((String)date);
        }
        catch (ParseException e) {
            LOGGER.error("Error while trying to parse date: {}", new Object[]{date});
            throw e;
        }
    }

    @Override
    public CampaignPivot campaignRecordToCampaignPivot(Record record) {
        CampaignPivot campaignPivot = new CampaignPivot();
        campaignPivot.setPivotId((Long)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID));
        campaignPivot.setName((String)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.NAME));
        campaignPivot.setDescription((String)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.DESCRIPTION));
        campaignPivot.setReference((String)record.get((Field)Tables.CAMPAIGN.REFERENCE));
        campaignPivot.setStatus(CampaignStatus.valueOf((String)((String)record.get((Field)Tables.CAMPAIGN.CAMPAIGN_STATUS))));
        campaignPivot.setActualStartDateAuto((Boolean)record.get((Field)Tables.CAMPAIGN.ACTUAL_START_AUTO));
        campaignPivot.setActualEndDateAuto((Boolean)record.get((Field)Tables.CAMPAIGN.ACTUAL_END_AUTO));
        campaignPivot.setActualStartDate(DateUtils.formatIso8601Date((Timestamp)((Timestamp)record.get((Field)Tables.CAMPAIGN.ACTUAL_START_DATE))));
        campaignPivot.setActualEndDate(DateUtils.formatIso8601Date((Timestamp)((Timestamp)record.get((Field)Tables.CAMPAIGN.ACTUAL_END_DATE))));
        campaignPivot.setScheduledStartDate(DateUtils.formatIso8601Date((Timestamp)((Timestamp)record.get((Field)Tables.CAMPAIGN.SCHEDULED_START_DATE))));
        campaignPivot.setScheduledEndDate(DateUtils.formatIso8601Date((Timestamp)((Timestamp)record.get((Field)Tables.CAMPAIGN.SCHEDULED_END_DATE))));
        Long parentId = (Long)record.get((Field)Tables.CLN_RELATIONSHIP.ANCESTOR_ID);
        if (parentId != null) {
            campaignPivot.setParentType(EntityType.CAMPAIGN_FOLDER);
            campaignPivot.setParentId(parentId, "F");
        } else {
            campaignPivot.setParentType(EntityType.CAMPAIGN_LIBRARY);
        }
        return campaignPivot;
    }

    @Override
    public IterationPivot iterationRecordToIterationPivot(Record record) {
        IterationPivot iterationPivot = new IterationPivot();
        iterationPivot.setPivotId((Long)record.get((Field)Tables.ITERATION.ITERATION_ID));
        iterationPivot.setName((String)record.get((Field)Tables.ITERATION.NAME));
        iterationPivot.setDescription((String)record.get((Field)Tables.ITERATION.DESCRIPTION));
        iterationPivot.setReference((String)record.get((Field)Tables.ITERATION.REFERENCE));
        iterationPivot.setStatus(IterationStatus.valueOf((String)((String)record.get((Field)Tables.ITERATION.ITERATION_STATUS))));
        iterationPivot.setActualStartDateAuto((Boolean)record.get((Field)Tables.ITERATION.ACTUAL_START_AUTO));
        iterationPivot.setActualEndDateAuto((Boolean)record.get((Field)Tables.ITERATION.ACTUAL_END_AUTO));
        iterationPivot.setActualStartDate(DateUtils.formatIso8601Date((Timestamp)((Timestamp)record.get((Field)Tables.ITERATION.ACTUAL_START_DATE))));
        iterationPivot.setActualEndDate(DateUtils.formatIso8601Date((Timestamp)((Timestamp)record.get((Field)Tables.ITERATION.ACTUAL_END_DATE))));
        iterationPivot.setScheduledStartDate(DateUtils.formatIso8601Date((Timestamp)((Timestamp)record.get((Field)Tables.ITERATION.SCHEDULED_START_DATE))));
        iterationPivot.setScheduledEndDate(DateUtils.formatIso8601Date((Timestamp)((Timestamp)record.get((Field)Tables.ITERATION.SCHEDULED_END_DATE))));
        iterationPivot.setParentType(EntityType.CAMPAIGN);
        iterationPivot.setParentId((Long)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID), "CP");
        return iterationPivot;
    }

    @Override
    public TestSuitePivot testSuiteRecordToTestSuitePivot(Record record) {
        TestSuitePivot testSuitePivot = new TestSuitePivot();
        testSuitePivot.setPivotId((Long)record.get((Field)Tables.TEST_SUITE.ID));
        testSuitePivot.setName((String)record.get((Field)Tables.TEST_SUITE.NAME));
        testSuitePivot.setDescription((String)record.get((Field)Tables.TEST_SUITE.DESCRIPTION));
        testSuitePivot.setStatus(ExecutionStatus.valueOf((String)((String)record.get((Field)Tables.TEST_SUITE.EXECUTION_STATUS))));
        testSuitePivot.setParentType(EntityType.ITERATION);
        testSuitePivot.setParentId((Long)record.get((Field)Tables.ITERATION_TEST_SUITE.ITERATION_ID), "IT");
        return testSuitePivot;
    }

    @Override
    public SprintPivot sprintRecordToSprintPivot(Record record) {
        SprintPivot sprintPivot = new SprintPivot();
        sprintPivot.setPivotId((Long)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID));
        sprintPivot.setName((String)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.NAME));
        sprintPivot.setDescription((String)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.DESCRIPTION));
        sprintPivot.setReference((String)record.get((Field)Tables.SPRINT.REFERENCE));
        sprintPivot.setStatus(SprintStatus.valueOf((String)((String)record.get((Field)Tables.SPRINT.STATUS))));
        sprintPivot.setStartDate(DateUtils.formatIso8601Date((Timestamp)((Timestamp)record.get((Field)Tables.SPRINT.START_DATE))));
        sprintPivot.setEndDate(DateUtils.formatIso8601Date((Timestamp)((Timestamp)record.get((Field)Tables.SPRINT.END_DATE))));
        EntityType parentType = EntityType.valueOf((String)((String)record.get(SprintPivotDao.PARENT_TYPE_FIELD, String.class)));
        sprintPivot.setParentType(parentType);
        if (!EntityType.CAMPAIGN_LIBRARY.equals((Object)parentType)) {
            sprintPivot.setParentId((Long)record.get((Field)Tables.CLN_RELATIONSHIP.ANCESTOR_ID), "F");
        }
        return sprintPivot;
    }

    @Override
    public TestPlanItemPivot campaignTestPlanItemRecordToTestPlanItemPivot(Record record) {
        return this.getTestPlanItemPivot((Long)record.get((Field)Tables.CAMPAIGN_TEST_PLAN_ITEM.CTPI_ID), (Long)record.get((Field)Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID), (Long)record.get((Field)Tables.CAMPAIGN_TEST_PLAN_ITEM.DATASET_ID));
    }

    @Override
    public TestPlanItemPivot iterationTestPlanItemRecordToTestPlanItemPivot(Record record) {
        TestPlanItemPivot testPlanItemPivot = this.getTestPlanItemPivot((Long)record.get((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID), (Long)record.get((Field)Tables.TEST_PLAN_ITEM.TCLN_ID), (Long)record.get((Field)Tables.TEST_PLAN_ITEM.DATASET_ID));
        if (testPlanItemPivot.getTestCaseId() == null) {
            testPlanItemPivot.setTestCaseLabel((String)record.get((Field)Tables.TEST_PLAN_ITEM.LABEL));
        }
        return testPlanItemPivot;
    }

    private TestPlanItemPivot getTestPlanItemPivot(Long testPlanItemId, Long tclnId, Long datasetId) {
        TestPlanItemPivot testPlanItemPivot = new TestPlanItemPivot();
        testPlanItemPivot.setPivotId(testPlanItemId);
        if (Objects.nonNull(tclnId)) {
            testPlanItemPivot.setTestCaseId(tclnId);
            if (Objects.nonNull(datasetId)) {
                testPlanItemPivot.setDatasetId(datasetId);
            }
        }
        return testPlanItemPivot;
    }

    static final /* synthetic */ String getDescription_aroundBody0(ExecutionWorkspaceConverterServiceImpl executionWorkspaceConverterServiceImpl, CampaignPivot campaignPivot, JoinPoint joinPoint) {
        return campaignPivot.getDescription();
    }

    static final /* synthetic */ String getDescription_aroundBody2(ExecutionWorkspaceConverterServiceImpl executionWorkspaceConverterServiceImpl, IterationPivot iterationPivot, JoinPoint joinPoint) {
        return iterationPivot.getDescription();
    }

    static final /* synthetic */ String getDescription_aroundBody4(ExecutionWorkspaceConverterServiceImpl executionWorkspaceConverterServiceImpl, TestSuitePivot testSuitePivot, JoinPoint joinPoint) {
        return testSuitePivot.getDescription();
    }

    static final /* synthetic */ String getDescription_aroundBody6(ExecutionWorkspaceConverterServiceImpl executionWorkspaceConverterServiceImpl, SprintPivot sprintPivot, JoinPoint joinPoint) {
        return sprintPivot.getDescription();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ExecutionWorkspaceConverterServiceImpl.java", ExecutionWorkspaceConverterServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getDescription", "org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.CampaignPivot", "", "", "", "java.lang.String"), 70);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getDescription", "org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.IterationPivot", "", "", "", "java.lang.String"), 101);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getDescription", "org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.TestSuitePivot", "", "", "", "java.lang.String"), 132);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getDescription", "org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.SprintPivot", "", "", "", "java.lang.String"), 145);
    }
}

