/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.squashtest.tm.exception.CouldNotParseJsonFileException;
import org.squashtest.tm.exception.pivotformatimport.InvalidJsonFileNameForImport;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotMetaDataModel;
import org.squashtest.tm.service.internal.pivot.exception.PivotJsonWritingException;
import org.squashtest.tm.service.pivot.PivotFileManager;

@Service
public class PivotFileManagerImpl
implements PivotFileManager {
    private static final String ERROR_WRITING_TO_JSON = "Error during the generation of the pivot format while writing to the JSON file: ";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writePivotFile(MultipartFile multipartFile, File importFile, PivotMetaDataModel pivotMetaDataModel) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            ZipInputStream zis = new ZipInputStream(multipartFile.getInputStream());
            try {
                block22: {
                    FileOutputStream fos = new FileOutputStream(importFile);
                    try {
                        try (ZipOutputStream zos = new ZipOutputStream(fos);){
                            zos.setLevel(0);
                            byte[] buffer = new byte[8192];
                            block9: while (true) {
                                ZipEntry entry;
                                if ((entry = zis.getNextEntry()) == null) {
                                    ZipEntry jsonEntry = new ZipEntry("metadata.json");
                                    zos.putNextEntry(jsonEntry);
                                    new ObjectMapper().writeValue((OutputStream)zos, (Object)pivotMetaDataModel);
                                    break;
                                }
                                ZipEntry newEntry = new ZipEntry(entry.getName());
                                if (entry.getMethod() == 0) {
                                    newEntry.setMethod(0);
                                    newEntry.setSize(entry.getSize());
                                    newEntry.setCrc(entry.getCrc());
                                }
                                zos.putNextEntry(newEntry);
                                while (true) {
                                    int length;
                                    if ((length = zis.read(buffer)) <= 0) continue block9;
                                    zos.write(buffer, 0, length);
                                }
                                break;
                            }
                        }
                        if (fos == null) break block22;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (fos == null) throw throwable;
                        fos.close();
                        throw throwable;
                    }
                    fos.close();
                }
                if (zis == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (zis == null) throw throwable;
                zis.close();
                throw throwable;
            }
            zis.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    @Override
    public void writeJson(JsonFactory jsonFactory, PivotFileManager.ConsumerThrowing<JsonGenerator, IOException> writeToJson, String fileName, ArchiveOutputStream<ZipArchiveEntry> archive) throws IOException {
        ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(fileName);
        archive.putArchiveEntry((ArchiveEntry)zipArchiveEntry);
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                try {
                    Throwable throwable2 = null;
                    Object var10_14 = null;
                    try (JsonGenerator jsonGenerator = jsonFactory.createGenerator((OutputStream)stream);){
                        jsonGenerator.setCodec((ObjectCodec)new ObjectMapper());
                        jsonGenerator.writeStartObject();
                        writeToJson.accept(jsonGenerator);
                        jsonGenerator.writeEndObject();
                        jsonGenerator.flush();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (IOException e) {
                    throw new PivotJsonWritingException(ERROR_WRITING_TO_JSON, e);
                }
                archive.write(stream.toByteArray());
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        finally {
            archive.closeArchiveEntry();
        }
    }

    @Override
    public void readPivotFile(MultipartFile multipartFile, PivotFileManager.BiConsumerThrowing<ZipInputStream, ZipEntry, IOException> zipEntryConsumer) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipInputStream zis = new ZipInputStream(multipartFile.getInputStream());){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                zipEntryConsumer.accept(zis, entry);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void checkJsonFileName(String entryName) {
        boolean nameIsValid = EnumSet.allOf(JsonImportFile.class).stream().anyMatch(enumEntry -> enumEntry.getFileName().equals(entryName));
        if (!nameIsValid) {
            String message = String.format("Invalid json file name for pivot import: \" %s\"", entryName);
            throw new InvalidJsonFileNameForImport(entryName, message);
        }
    }

    @Override
    public void checkJsonSyntaxError(ZipEntry entry, ZipInputStream zis) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JsonParser jsonParser = jsonFactory.createParser((InputStream)zis);){
                jsonParser.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
                while (jsonParser.nextToken() != null) {
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonParseException e) {
            String message = String.format("Failed to parse json file with name \"%s\". Please verify the syntax of your file.", entry.getName());
            throw new CouldNotParseJsonFileException(entry.getName(), message, (Exception)((Object)e));
        }
    }

    @Override
    public <T> Consumer<T> consumerThrowingIOException(PivotFileManager.ConsumerThrowing<T, IOException> t) {
        return i -> {
            try {
                t.accept(i);
            }
            catch (IOException e) {
                throw new PivotJsonWritingException(ERROR_WRITING_TO_JSON, e);
            }
        };
    }

    @Override
    public <T> Consumer<T> consumerThrowingRecordAndId(PivotFileManager.BiConsumerThrowing<T, AtomicInteger, IOException> records) {
        AtomicInteger idGenerator = new AtomicInteger(0);
        return i -> {
            try {
                records.accept(i, idGenerator);
            }
            catch (IOException e) {
                throw new PivotJsonWritingException(ERROR_WRITING_TO_JSON, e);
            }
        };
    }
}

