/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.projectimporterxray.convertertopivot;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.TestCasePivot;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.dto.CustomFieldXrayDto;
import org.squashtest.tm.service.internal.dto.projectimporterxray.mapping.XrayPriority;
import org.squashtest.tm.service.internal.dto.projectimporterxray.mapping.XrayStatus;

public class ExtendedTestCasePivot
extends TestCasePivot {
    @JsonIgnore
    private String xrayKey;
    @JsonIgnore
    private AtomicInteger datasetId;
    @JsonIgnore
    private AtomicInteger datasetParamId;
    @JsonIgnore
    private AtomicInteger actionStepId;

    public void setParentTypeAndId(List<CustomFieldXrayDto> testRepositoryPath, Map<String, String> testCaseFolderIdMap) {
        if (Objects.nonNull(testRepositoryPath) && !testRepositoryPath.isEmpty()) {
            this.setParentType(EntityType.TEST_CASE_FOLDER);
            String path = StringUtils.trim((String)testRepositoryPath.get(0).getValue().replaceAll("</?\\w+>", ""));
            this.setParentId(testCaseFolderIdMap.get(path));
        } else {
            this.setParentType(EntityType.TEST_CASE_LIBRARY);
        }
    }

    public String getIdDatasetParam(String name) {
        return this.getDatasetParams().stream().filter(datasetParamPivot -> datasetParamPivot.getName().equalsIgnoreCase(name)).map(AbstractPivotObject::getPivotId).findFirst().orElse(null);
    }

    public String getDatasetPivotForCalledTC(Map<String, String> calledTcParameters) {
        return this.getDatasets().stream().filter(datasetPivot -> datasetPivot.isParametersPresent(calledTcParameters)).map(AbstractPivotObject::getPivotId).findFirst().orElse(null);
    }

    public boolean isDatasetParamExist(String paramName) {
        return this.getDatasetParams().stream().anyMatch(datasetParam -> datasetParam.getName().equalsIgnoreCase(paramName));
    }

    public void setImportance(XrayPriority priority) {
        this.setImportance(priority.getTestCaseImportance());
    }

    public void setStatus(XrayStatus status) {
        this.setStatus(status.getTestCaseStatus());
    }

    public String getXrayKey() {
        return this.xrayKey;
    }

    public void setXrayKey(String xrayKey) {
        this.xrayKey = xrayKey;
    }

    public AtomicInteger getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(AtomicInteger datasetId) {
        this.datasetId = datasetId;
    }

    public AtomicInteger getDatasetParamId() {
        return this.datasetParamId;
    }

    public void setDatasetParamId(AtomicInteger datasetParamId) {
        this.datasetParamId = datasetParamId;
    }

    public AtomicInteger getActionStepId() {
        return this.actionStepId;
    }

    public void setActionStepId(AtomicInteger actionStepId) {
        this.actionStepId = actionStepId;
    }
}

