/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.sprint;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.synchronisation.SynchronisationKind;
import org.squashtest.tm.service.annotation.CheckEntityExists;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.display.sprint.SprintDisplayService;
import org.squashtest.tm.service.display.sprint.SprintReqVersionDisplayService;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.SprintKnownIssueFinder;
import org.squashtest.tm.service.internal.display.campaign.ReadUnassignedTestPlanHelper;
import org.squashtest.tm.service.internal.display.dto.AttachmentListDto;
import org.squashtest.tm.service.internal.display.dto.UserView;
import org.squashtest.tm.service.internal.display.dto.sprint.SprintDto;
import org.squashtest.tm.service.internal.display.dto.sprint.SprintReqVersionDto;
import org.squashtest.tm.service.internal.library.EntityPathHeaderService;
import org.squashtest.tm.service.internal.repository.display.AttachmentDisplayDao;
import org.squashtest.tm.service.internal.repository.display.SprintDisplayDao;
import org.squashtest.tm.service.testplanitem.TestPlanItemAssignableUserFinder;

@Service
@Transactional(readOnly=true)
public class SprintDisplayServiceImpl
implements SprintDisplayService {
    private final SprintDisplayDao sprintDisplayDao;
    private final AttachmentDisplayDao attachmentDisplayDao;
    private final EntityPathHeaderService entityPathHeaderService;
    private final SprintKnownIssueFinder sprintKnownIssueFinder;
    private final TestPlanItemAssignableUserFinder testPlanItemAssignableUserFinder;
    private final ReadUnassignedTestPlanHelper readUnassignedTestPlanHelper;
    private final SprintReqVersionDisplayService sprintReqVersionDisplayService;

    public SprintDisplayServiceImpl(SprintDisplayDao sprintDisplayDao, AttachmentDisplayDao attachmentDisplayDao, EntityPathHeaderService entityPathHeaderService, SprintKnownIssueFinder sprintKnownIssueFinder, TestPlanItemAssignableUserFinder testPlanItemAssignableUserFinder, ReadUnassignedTestPlanHelper readUnassignedTestPlanHelper, SprintReqVersionDisplayService sprintReqVersionDisplayService) {
        this.sprintDisplayDao = sprintDisplayDao;
        this.entityPathHeaderService = entityPathHeaderService;
        this.attachmentDisplayDao = attachmentDisplayDao;
        this.sprintKnownIssueFinder = sprintKnownIssueFinder;
        this.testPlanItemAssignableUserFinder = testPlanItemAssignableUserFinder;
        this.readUnassignedTestPlanHelper = readUnassignedTestPlanHelper;
        this.sprintReqVersionDisplayService = sprintReqVersionDisplayService;
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintId, 'org.squashtest.tm.domain.campaign.Sprint' ,'READ')  or hasRole('ROLE_ADMIN')")
    @CheckEntityExists(entityType=Sprint.class)
    public SprintDto getSprintView(@Id long sprintId) {
        SprintDto sprintDto = this.sprintDisplayDao.getSprintDtoById(sprintId);
        if (SynchronisationKind.XSQUASH4JIRA.getName().equals(sprintDto.getSynchronisationKind())) {
            this.translateJiraRemoteStateIntoSquashStatus(sprintDto);
        }
        AttachmentListDto attachmentList = this.attachmentDisplayDao.findAttachmentListById(sprintDto.getAttachmentListId());
        sprintDto.setAttachmentList(attachmentList);
        sprintDto.setBreadcrumbs(this.entityPathHeaderService.getCampaignLibraryNodeHeaderBreadcrumbs(sprintId, true));
        List<SprintReqVersionDto> sprintReqVersions = this.sprintReqVersionDisplayService.findSprintReqVersionDtosBySprintId(sprintId);
        sprintDto.setSprintReqVersions(sprintReqVersions);
        int nbIssues = this.sprintKnownIssueFinder.countKnownIssues(sprintId);
        sprintDto.setNbIssues(nbIssues);
        sprintDto.setNbTestPlanItems(this.countTestPlanItems(sprintId));
        sprintDto.setAssignableUsers(UserView.fromEntities(this.testPlanItemAssignableUserFinder.findAssignableUsersByCampaignLibraryId(sprintDto.getCampaignLibraryId())));
        return sprintDto;
    }

    private void translateJiraRemoteStateIntoSquashStatus(SprintDto sprintDto) {
        SprintStatus remoteState = sprintDto.getRemoteState();
        if (remoteState == SprintStatus.FUTURE) {
            sprintDto.setRemoteState(SprintStatus.UPCOMING);
        } else if (remoteState == SprintStatus.ACTIVE) {
            sprintDto.setRemoteState(SprintStatus.OPEN);
        }
    }

    private int countTestPlanItems(long sprintId) {
        String userToRestrictTo = this.readUnassignedTestPlanHelper.getUserToRestrictTo(sprintId, Sprint.class.getName());
        return this.sprintDisplayDao.countTestPlanItems(sprintId, userToRestrictTo);
    }
}

