/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.denormalizedenvironment;

import jakarta.transaction.Transactional;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.environmenttag.DenormalizedEnvironmentHolderType;
import org.squashtest.tm.domain.environmentvariable.DenormalizedEnvironmentVariable;
import org.squashtest.tm.domain.environmentvariable.EnvironmentVariable;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.service.denormalizedenvironment.DenormalizedEnvironmentVariableManagerService;
import org.squashtest.tm.service.internal.repository.DenormalizedEnvironmentVariableDao;
import org.squashtest.tm.service.internal.repository.EnvironmentVariableDao;

@Service(value="squashtest.tm.service.DenormalizedEnvironmentVariableManagerService")
@Transactional
public class DenormalizedEnvironmentVariableManagerServiceImpl
implements DenormalizedEnvironmentVariableManagerService {
    private final DenormalizedEnvironmentVariableDao denormalizedEnvironmentVariableDao;
    private final EnvironmentVariableDao environmentVariableDao;

    public DenormalizedEnvironmentVariableManagerServiceImpl(DenormalizedEnvironmentVariableDao denormalizedEnvironmentVariableDao, EnvironmentVariableDao environmentVariableDao) {
        this.denormalizedEnvironmentVariableDao = denormalizedEnvironmentVariableDao;
        this.environmentVariableDao = environmentVariableDao;
    }

    @Override
    public void createAllDenormalizedEnvironmentVariablesForAutomatedExecution(Map<String, String> environmentVariablesMap, Collection<Long> extenderIds) {
        List<EnvironmentVariable> environmentVariableList = this.environmentVariableDao.findAllByName(environmentVariablesMap.keySet());
        List<DenormalizedEnvironmentVariable> denormalizedEnvironmentVariables = this.convertEnvironmentVariablesToDenormalized(environmentVariableList, environmentVariablesMap, extenderIds);
        this.denormalizedEnvironmentVariableDao.saveAll(denormalizedEnvironmentVariables);
    }

    @Override
    public void handleEnvironmentVariableDeletion(EnvironmentVariable environmentVariable) {
        List<DenormalizedEnvironmentVariable> denormalizedEnvironmentVariables = this.denormalizedEnvironmentVariableDao.findAllByEnvironmentVariable(environmentVariable);
        if (!denormalizedEnvironmentVariables.isEmpty()) {
            denormalizedEnvironmentVariables.forEach(denormalizedEnvironmentVariable -> denormalizedEnvironmentVariable.setEnvironmentVariable(null));
        }
    }

    @Override
    public void removeDenormalizedEnvironmentVariablesOnExecutionDelete(AutomatedExecutionExtender automatedExecutionExtender) {
        DenormalizedEnvironmentHolderType holderType = DenormalizedEnvironmentHolderType.AUTOMATED_EXECUTION_EXTENDER;
        List<DenormalizedEnvironmentVariable> environmentVariables = this.denormalizedEnvironmentVariableDao.findAllByHolderIdAndHolderType(automatedExecutionExtender.getId(), holderType);
        if (!environmentVariables.isEmpty()) {
            this.denormalizedEnvironmentVariableDao.deleteAll(environmentVariables);
        }
    }

    private List<DenormalizedEnvironmentVariable> convertEnvironmentVariablesToDenormalized(List<EnvironmentVariable> environmentVariables, Map<String, String> environmentVariablesMap, Collection<Long> extenderIds) {
        return extenderIds.stream().flatMap(extenderId -> environmentVariables.stream().map(variable -> new DenormalizedEnvironmentVariable(variable, extenderId, DenormalizedEnvironmentHolderType.AUTOMATED_EXECUTION_EXTENDER, variable.getName(), (String)environmentVariablesMap.get(variable.getName()), variable.getInputType().name()))).toList();
    }
}

