/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.service.deletion.BoundToLockedMilestonesReport;
import org.squashtest.tm.service.deletion.BoundToMultipleMilestonesReport;
import org.squashtest.tm.service.deletion.MilestoneModeNoFolderDeletion;
import org.squashtest.tm.service.deletion.NotBoundToActiveMilestonesReport;
import org.squashtest.tm.service.deletion.SingleOrMultipleMilestonesReport;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

public abstract class AbstractLockedNodeDetectionService {
    private static final String NODE_IDS = "nodeIds";
    private static final String FOLDER_IDS = "folderIds";
    private final ActiveMilestoneHolder activeMilestoneHolder;

    protected AbstractLockedNodeDetectionService(ActiveMilestoneHolder activeMilestoneHolder) {
        this.activeMilestoneHolder = activeMilestoneHolder;
    }

    protected List<SuppressionPreviewReport> detectLockedByMilestone(List<Long> nodeIds, String reportType) {
        List<Long> lockedByMilestones = this.findNodesWhichMilestonesForbidsDeletion(nodeIds);
        if (lockedByMilestones.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SuppressionPreviewReport> reportList = new ArrayList<SuppressionPreviewReport>();
        BoundToLockedMilestonesReport suppressionPreviewReport = new BoundToLockedMilestonesReport(reportType);
        suppressionPreviewReport.addAllLockedNodes(lockedByMilestones);
        reportList.add(suppressionPreviewReport);
        return reportList;
    }

    protected List<SuppressionPreviewReport> detectLockedWithActiveMilestone(List<Long> nodeIds, String reportType) {
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestone.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SuppressionPreviewReport> reportList = new ArrayList<SuppressionPreviewReport>();
        Map<String, List<Long>> separateIds = this.getIdsSeparateFolderFromNodeIds(nodeIds);
        List<Long> folderIds = separateIds.getOrDefault(FOLDER_IDS, Collections.emptyList());
        this.addNoFoldersAllowedToReportList(folderIds, reportList, reportType);
        List<Long> requirementNodes = separateIds.getOrDefault(NODE_IDS, Collections.emptyList());
        List<Long> boundNodes = this.findNodeIdsHavingMultipleMilestones(requirementNodes);
        this.addMultipleMilestoneBindingToReportList(requirementNodes, boundNodes, reportList, reportType);
        this.addAdditionalReportWithActiveMilestoneToReportList(requirementNodes, activeMilestone.get().getId(), reportList, reportType);
        return reportList;
    }

    private void addNoFoldersAllowedToReportList(List<Long> folderIds, List<SuppressionPreviewReport> reportList, String reportType) {
        if (folderIds.isEmpty()) {
            return;
        }
        MilestoneModeNoFolderDeletion suppressionPreviewReport = new MilestoneModeNoFolderDeletion(reportType);
        suppressionPreviewReport.addAllLockedNodes(folderIds);
        reportList.add(suppressionPreviewReport);
    }

    protected void addNonBoundNodesWithActiveMilestoneToReportList(List<Long> nonBoundNodes, List<SuppressionPreviewReport> reportList, String reportType) {
        if (!nonBoundNodes.isEmpty()) {
            NotBoundToActiveMilestonesReport suppressionPreviewReport = new NotBoundToActiveMilestonesReport(reportType);
            suppressionPreviewReport.addAllLockedNodes(nonBoundNodes);
            reportList.add(suppressionPreviewReport);
        }
    }

    protected void addMultipleMilestoneBindingToReportList(List<Long> nodeIds, List<Long> boundNodes, List<SuppressionPreviewReport> reportList, String reportType) {
        if (!boundNodes.isEmpty()) {
            SuppressionPreviewReport suppressionPreviewReport = this.getReportMultipleMilestoneBinding(nodeIds, boundNodes, reportType);
            suppressionPreviewReport.addAllLockedNodes(boundNodes);
            reportList.add(suppressionPreviewReport);
        }
    }

    protected SuppressionPreviewReport getReportMultipleMilestoneBinding(List<Long> nodeIds, List<Long> boundNodes, String reportType) {
        if (nodeIds.size() == boundNodes.size()) {
            return new BoundToMultipleMilestonesReport(reportType);
        }
        return new SingleOrMultipleMilestonesReport(reportType);
    }

    protected abstract List<Long> findNodesWhichMilestonesForbidsDeletion(List<Long> var1);

    protected abstract void addAdditionalReportWithActiveMilestoneToReportList(List<Long> var1, Long var2, List<SuppressionPreviewReport> var3, String var4);

    protected abstract Map<String, List<Long>> getIdsSeparateFolderFromNodeIds(List<Long> var1);

    protected abstract List<Long> findNodeIdsHavingMultipleMilestones(List<Long> var1);
}

