/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.customreport;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.chart.ChartDefinition;
import org.squashtest.tm.domain.customreport.CustomReportCustomExport;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.customreport.CustomReportFolder;
import org.squashtest.tm.domain.customreport.CustomReportLibrary;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportTreeDefinition;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntity;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.domain.tree.TreeEntity;
import org.squashtest.tm.domain.tree.TreeLibraryNode;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.service.annotation.CheckEntityExists;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.internal.customreport.CRLNCopier;
import org.squashtest.tm.service.internal.customreport.CRLNDeletionHandler;
import org.squashtest.tm.service.internal.customreport.CRLNMover;
import org.squashtest.tm.service.internal.customreport.CustomReportLibraryNodeBuilder;
import org.squashtest.tm.service.internal.repository.CustomReportLibraryNodeDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service(value="org.squashtest.tm.service.customreport.CustomReportLibraryNodeService")
@Transactional
public class CustomReportLibraryNodeServiceImpl
implements CustomReportLibraryNodeService {
    @Inject
    protected PermissionEvaluationService permissionService;
    @Inject
    private CustomReportLibraryNodeDao customReportLibraryNodeDao;
    @PersistenceContext
    private EntityManager em;
    @Inject
    private CRLNDeletionHandler deletionHandler;
    @Inject
    private CRLNCopier nodeCopier;
    @Inject
    private CRLNMover nodeMover;

    @Override
    public CustomReportLibraryNode findCustomReportLibraryNodeById(Long id) {
        return (CustomReportLibraryNode)this.customReportLibraryNodeDao.getReferenceById(id);
    }

    @Override
    @PreAuthorize(value="hasPermission(#treeNodeId, 'org.squashtest.tm.domain.customreport.CustomReportLibraryNode' ,'READ')  or hasRole('ROLE_ADMIN')")
    @Transactional(readOnly=true)
    public CustomReportLibrary findLibraryByTreeNodeId(Long treeNodeId) {
        TreeEntity entity = this.findEntityAndCheckType(treeNodeId, CustomReportTreeDefinition.LIBRARY);
        return (CustomReportLibrary)entity;
    }

    @Override
    @PreAuthorize(value="hasPermission(#treeNodeId, 'org.squashtest.tm.domain.customreport.CustomReportLibraryNode' ,'READ')  or hasRole('ROLE_ADMIN')")
    @Transactional(readOnly=true)
    public CustomReportFolder findFolderByTreeNodeId(Long treeNodeId) {
        TreeEntity entity = this.findEntityAndCheckType(treeNodeId, CustomReportTreeDefinition.FOLDER);
        return (CustomReportFolder)entity;
    }

    @Override
    @PreAuthorize(value="hasPermission(#treeNodeId, 'org.squashtest.tm.domain.customreport.CustomReportLibraryNode' ,'READ')  or hasRole('ROLE_ADMIN')")
    @Transactional(readOnly=true)
    public ChartDefinition findChartDefinitionByNodeId(Long treeNodeId) {
        TreeEntity entity = this.findEntityAndCheckType(treeNodeId, CustomReportTreeDefinition.CHART);
        return (ChartDefinition)entity;
    }

    @Override
    @PreAuthorize(value="hasPermission(#treeNodeId, 'org.squashtest.tm.domain.customreport.CustomReportLibraryNode' ,'READ')  or hasRole('ROLE_ADMIN')")
    @Transactional(readOnly=true)
    @CheckEntityExists(entityType=CustomReportLibraryNode.class)
    public ReportDefinition findReportDefinitionByNodeId(@Id Long treeNodeId) {
        TreeEntity entity = this.findEntityAndCheckType(treeNodeId, CustomReportTreeDefinition.REPORT);
        return (ReportDefinition)entity;
    }

    @Override
    public CustomReportCustomExport findCustomExportByNodeId(Long treeNodeId) {
        TreeEntity entity = this.findEntityAndCheckType(treeNodeId, CustomReportTreeDefinition.CUSTOM_EXPORT);
        return (CustomReportCustomExport)entity;
    }

    @Override
    @PreAuthorize(value="hasPermission(#treeNodeId, 'org.squashtest.tm.domain.customreport.CustomReportLibraryNode' ,'READ')  or hasRole('ROLE_ADMIN')")
    @Transactional(readOnly=true)
    public CustomReportDashboard findCustomReportDashboardById(Long treeNodeId) {
        TreeEntity entity = this.findEntityAndCheckType(treeNodeId, CustomReportTreeDefinition.DASHBOARD);
        return (CustomReportDashboard)entity;
    }

    @Override
    @PreAuthorize(value="hasPermission(#parentId,'org.squashtest.tm.domain.customreport.CustomReportLibraryNode' ,'CREATE')  or hasRole('ROLE_ADMIN')")
    public CustomReportLibraryNode createNewNode(Long parentId, CustomReportTreeEntity entity) {
        CustomReportLibraryNode parentNode = (CustomReportLibraryNode)this.customReportLibraryNodeDao.getReferenceById(parentId);
        CustomReportLibraryNode newNode = new CustomReportLibraryNodeBuilder(parentNode, entity).build();
        this.customReportLibraryNodeDao.save(newNode);
        this.em.flush();
        this.em.clear();
        return (CustomReportLibraryNode)this.customReportLibraryNodeDao.getReferenceById(newNode.getId());
    }

    @Override
    public List<SuppressionPreviewReport> simulateDeletion(List<Long> nodeIds) {
        return this.deletionHandler.simulateDeletion(nodeIds);
    }

    @Override
    public OperationReport delete(List<Long> nodeIds) {
        this.permissionService.checkPermission(nodeIds, Permissions.DELETE.name(), CustomReportLibraryNode.class.getName());
        return this.deletionHandler.deleteNodes(nodeIds);
    }

    @Override
    public List<Long> findDescendantIds(List<Long> nodeIds) {
        return this.customReportLibraryNodeDao.findAllDescendantIds(nodeIds);
    }

    @Override
    public List<Long> findAllFirstLevelDescendantIds(List<Long> nodeIds) {
        return this.customReportLibraryNodeDao.findAllFirstLevelDescendantIds(nodeIds);
    }

    @Override
    @PreAuthorize(value="hasPermission(#nodeId, 'org.squashtest.tm.domain.customreport.CustomReportLibraryNode' ,'WRITE')  or hasRole('ROLE_ADMIN')")
    public void renameNode(Long nodeId, String newName) throws DuplicateNameException {
        CustomReportLibraryNode crln = (CustomReportLibraryNode)this.customReportLibraryNodeDao.getReferenceById(nodeId);
        crln.renameNode(newName);
    }

    @Override
    public void renameNode(Long entityId, String newName, Class<? extends CustomReportTreeEntity> entityClass) throws DuplicateNameException {
        CustomReportTreeEntity treeEntity = (CustomReportTreeEntity)this.em.find(entityClass, (Object)entityId);
        CustomReportLibraryNode crln = this.customReportLibraryNodeDao.findNodeFromEntity(treeEntity);
        this.permissionService.checkPermission(Collections.singletonList(crln.getId()), Permissions.WRITE.name(), CustomReportLibraryNode.class.getName());
        crln.renameNode(newName);
    }

    @Override
    public List<Long> findAncestorIds(Long nodeId) {
        return this.customReportLibraryNodeDao.findAncestorIds(nodeId);
    }

    @Override
    public List<Object[]> findAncestor(Long nodeId) {
        return this.customReportLibraryNodeDao.findAncestor(nodeId);
    }

    @Override
    public CustomReportLibraryNode findNodeFromEntity(CustomReportTreeEntity treeEntity) {
        return this.customReportLibraryNodeDao.findNodeFromEntity(treeEntity);
    }

    @Override
    @PreAuthorize(value="hasPermission(#target, 'org.squashtest.tm.domain.customreport.CustomReportLibraryNode' ,'WRITE')  or hasRole('ROLE_ADMIN')")
    public List<TreeLibraryNode> copyNodes(List<CustomReportLibraryNode> nodes, CustomReportLibraryNode target, ClipboardPayload clipboardPayload) {
        return this.makeCopy(nodes, target, clipboardPayload);
    }

    @Override
    @PreAuthorize(value="hasPermission(#targetId, 'org.squashtest.tm.domain.customreport.CustomReportLibraryNode' ,'CREATE')  or hasRole('ROLE_ADMIN')")
    public List<TreeLibraryNode> copyNodes(List<Long> nodeIds, Long targetId, ClipboardPayload clipboardPayload) {
        List nodes = this.customReportLibraryNodeDao.findAllById(nodeIds);
        CustomReportLibraryNode target = (CustomReportLibraryNode)this.customReportLibraryNodeDao.getReferenceById(targetId);
        return this.makeCopy(nodes, target, clipboardPayload);
    }

    @Override
    @PreAuthorize(value="hasPermission(#targetId, 'org.squashtest.tm.domain.customreport.CustomReportLibraryNode' ,'CREATE')  or hasRole('ROLE_ADMIN')")
    public void moveNodes(List<Long> nodeIds, Long targetId) {
        List nodes = this.customReportLibraryNodeDao.findAllById(nodeIds);
        CustomReportLibraryNode target = (CustomReportLibraryNode)this.customReportLibraryNodeDao.getReferenceById(targetId);
        this.nodeMover.moveNodes(nodes, target);
    }

    private TreeEntity findEntityAndCheckType(Long nodeId, CustomReportTreeDefinition entityDef) {
        CustomReportLibraryNode node = this.findCustomReportLibraryNodeById(nodeId);
        if (node == null || node.getEntityType() != entityDef) {
            String message = "the node for given id %d doesn't exist or doesn't represent a %s entity";
            throw new IllegalArgumentException(String.format(message, nodeId, entityDef.getTypeName()));
        }
        CustomReportTreeEntity entity = node.getEntity();
        if (entity == null) {
            String message = "the node for given id %d represent a null entity";
            throw new IllegalArgumentException(String.format(message, nodeId));
        }
        return entity;
    }

    private List<TreeLibraryNode> makeCopy(List<CustomReportLibraryNode> nodes, CustomReportLibraryNode target, ClipboardPayload clipboardPayload) {
        ArrayList<TreeLibraryNode> copies = new ArrayList<TreeLibraryNode>();
        copies.addAll(this.nodeCopier.copyNodes(nodes, target, clipboardPayload));
        return copies;
    }
}

