/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.customfield;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.EnumUtils;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Record11;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.RenderingLocation;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.customfield.CustomFieldModelService;
import org.squashtest.tm.service.internal.dto.BindableEntityModel;
import org.squashtest.tm.service.internal.dto.CustomFieldBindingModel;
import org.squashtest.tm.service.internal.dto.CustomFieldModel;
import org.squashtest.tm.service.internal.dto.CustomFieldModelFactory;
import org.squashtest.tm.service.internal.dto.InputTypeModel;
import org.squashtest.tm.service.internal.dto.RenderingLocationModel;
import org.squashtest.tm.service.internal.utils.StreamUtils;

@Service
@Transactional(readOnly=true)
public class CustomFieldModelServiceImpl
implements CustomFieldModelService {
    @Inject
    private DSLContext dsl;
    @Inject
    private MessageSource messageSource;

    @Override
    public Map<Long, Map<String, List<CustomFieldBindingModel>>> findCustomFieldsBindingsByProject(List<Long> projectIds) {
        Map<Long, CustomFieldModel<?>> cufMap = this.findUsedCustomFields(projectIds);
        return this.findCustomFieldsBindingsByProject(projectIds, cufMap);
    }

    protected List<Long> findUsedCustomFieldIds(List<Long> readableProjectIds) {
        return this.dsl.selectDistinct((SelectField)Tables.CUSTOM_FIELD_BINDING.CF_ID).from((TableLike)Tables.CUSTOM_FIELD_BINDING).where(Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID.in(readableProjectIds)).fetch((Field)Tables.CUSTOM_FIELD_BINDING.CF_ID, Long.class);
    }

    private Map<Long, CustomFieldModel<?>> findUsedCustomFields(List<Long> projectIds) {
        List<Long> usedCufIds = this.findUsedCustomFieldIds(projectIds);
        return this.findCufMap(usedCufIds);
    }

    private void creatingDropDownListCuf(Record11<Long, String, String, String, String, Boolean, String, String, String, String, Integer> r, Map<Long, CustomFieldModel<?>> cufMap, Long cufId) {
        if (cufMap.containsKey(cufId)) {
            CustomFieldModelFactory.SingleSelectFieldModel singleSelectFieldModel = (CustomFieldModelFactory.SingleSelectFieldModel)cufMap.get(cufId);
            singleSelectFieldModel.addOption(this.getCufValueOptionModel((Record)r));
        } else {
            CustomFieldModelFactory.SingleSelectFieldModel singleSelectFieldModel = this.getSingleSelectFieldModel((Record)r);
            singleSelectFieldModel.addOption(this.getCufValueOptionModel((Record)r));
            cufMap.put(singleSelectFieldModel.getId(), singleSelectFieldModel);
        }
    }

    private void creatingTagCuf(Long cufId, Record11<Long, String, String, String, String, Boolean, String, String, String, String, Integer> r, Map<Long, CustomFieldModel<?>> cufMap) {
        if (cufMap.containsKey(cufId)) {
            CustomFieldModelFactory.MultiSelectFieldModel multiSelectFieldModel = (CustomFieldModelFactory.MultiSelectFieldModel)cufMap.get(cufId);
            multiSelectFieldModel.addOption(this.getCufValueOptionModel((Record)r));
        } else {
            CustomFieldModelFactory.MultiSelectFieldModel multiSelectFieldModel = this.getMultiSelectFieldModel((Record)r);
            multiSelectFieldModel.addOption(this.getCufValueOptionModel((Record)r));
            cufMap.put(multiSelectFieldModel.getId(), multiSelectFieldModel);
        }
    }

    protected Map<Long, CustomFieldModel<?>> findCufMap(List<Long> usedCufIds) {
        HashMap cufMap = new HashMap();
        this.dsl.selectDistinct((SelectField)Tables.CUSTOM_FIELD.CF_ID, (SelectField)Tables.CUSTOM_FIELD.INPUT_TYPE, (SelectField)Tables.CUSTOM_FIELD.NAME, (SelectField)Tables.CUSTOM_FIELD.LABEL, (SelectField)Tables.CUSTOM_FIELD.CODE, (SelectField)Tables.CUSTOM_FIELD.OPTIONAL, (SelectField)Tables.CUSTOM_FIELD.DEFAULT_VALUE, (SelectField)Tables.CUSTOM_FIELD.LARGE_DEFAULT_VALUE, (SelectField)Tables.CUSTOM_FIELD_OPTION.CODE, (SelectField)Tables.CUSTOM_FIELD_OPTION.LABEL, (SelectField)Tables.CUSTOM_FIELD_OPTION.POSITION).from((TableLike)Tables.CUSTOM_FIELD).leftJoin((TableLike)Tables.CUSTOM_FIELD_OPTION).using(new Field[]{Tables.CUSTOM_FIELD.CF_ID}).where(Tables.CUSTOM_FIELD.CF_ID.in(usedCufIds)).fetch().forEach(r -> {
            Long cufId = (Long)r.get((Field)Tables.CUSTOM_FIELD.CF_ID);
            String type = (String)r.get((Field)Tables.CUSTOM_FIELD.INPUT_TYPE);
            InputType inputType = (InputType)EnumUtils.getEnum(InputType.class, (String)type);
            switch (inputType) {
                case RICH_TEXT: {
                    CustomFieldModel<String> richTextCustomFieldModel = this.getRichTextCustomFieldModel((Record)r);
                    cufMap.put(richTextCustomFieldModel.getId(), richTextCustomFieldModel);
                    break;
                }
                case DROPDOWN_LIST: {
                    this.creatingDropDownListCuf((Record11<Long, String, String, String, String, Boolean, String, String, String, String, Integer>)r, cufMap, cufId);
                    break;
                }
                case DATE_PICKER: {
                    CustomFieldModel<String> datePickerCustomFieldModel = this.getDatePickerCustomFieldModel((Record)r);
                    cufMap.put(datePickerCustomFieldModel.getId(), datePickerCustomFieldModel);
                    break;
                }
                case TAG: {
                    this.creatingTagCuf(cufId, (Record11<Long, String, String, String, String, Boolean, String, String, String, String, Integer>)r, cufMap);
                    break;
                }
                default: {
                    CustomFieldModelFactory.SingleValuedCustomFieldModel cufModel = this.getSingleValueCustomFieldModel((Record)r);
                    cufMap.put(cufId, cufModel);
                }
            }
        });
        return cufMap;
    }

    private CustomFieldModelFactory.MultiSelectFieldModel getMultiSelectFieldModel(Record r) {
        CustomFieldModelFactory.MultiSelectFieldModel multiSelectFieldModel = new CustomFieldModelFactory.MultiSelectFieldModel();
        this.initCufModel(r, multiSelectFieldModel);
        String[] stringArray = ((String)r.get((Field)Tables.CUSTOM_FIELD.DEFAULT_VALUE)).split("\\|");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            multiSelectFieldModel.addDefaultValue(value);
            ++n2;
        }
        return multiSelectFieldModel;
    }

    private CustomFieldModelFactory.SingleSelectFieldModel getSingleSelectFieldModel(Record r) {
        CustomFieldModelFactory.SingleSelectFieldModel singleSelectFieldModel = new CustomFieldModelFactory.SingleSelectFieldModel();
        this.initCufModel(r, singleSelectFieldModel);
        singleSelectFieldModel.setDefaultValue((String)r.get((Field)Tables.CUSTOM_FIELD.DEFAULT_VALUE));
        return singleSelectFieldModel;
    }

    private CustomFieldModelFactory.CustomFieldOptionModel getCufValueOptionModel(Record r) {
        CustomFieldModelFactory.CustomFieldOptionModel optionModel = new CustomFieldModelFactory.CustomFieldOptionModel();
        optionModel.setCode((String)r.get((Field)Tables.CUSTOM_FIELD_OPTION.CODE));
        optionModel.setLabel((String)r.get((Field)Tables.CUSTOM_FIELD_OPTION.LABEL));
        return optionModel;
    }

    private CustomFieldModel<String> getDatePickerCustomFieldModel(Record r) {
        CustomFieldModelFactory.DatePickerFieldModel cufModel = new CustomFieldModelFactory.DatePickerFieldModel();
        this.initCufModel(r, cufModel);
        Locale locale = LocaleContextHolder.getLocale();
        cufModel.setFormat(this.getMessage("squashtm.dateformatShort.datepicker"));
        cufModel.setLocale(locale.toString());
        cufModel.setDefaultValue((String)r.get((Field)Tables.CUSTOM_FIELD.DEFAULT_VALUE));
        return cufModel;
    }

    private CustomFieldModel<String> getRichTextCustomFieldModel(Record r) {
        CustomFieldModelFactory.SingleValuedCustomFieldModel cufModel = new CustomFieldModelFactory.SingleValuedCustomFieldModel();
        this.initCufModel(r, cufModel);
        cufModel.setDefaultValue((String)r.get((Field)Tables.CUSTOM_FIELD.LARGE_DEFAULT_VALUE));
        return cufModel;
    }

    private CustomFieldModelFactory.SingleValuedCustomFieldModel getSingleValueCustomFieldModel(Record r) {
        CustomFieldModelFactory.SingleValuedCustomFieldModel cufModel = new CustomFieldModelFactory.SingleValuedCustomFieldModel();
        this.initCufModel(r, cufModel);
        cufModel.setDefaultValue((String)r.get((Field)Tables.CUSTOM_FIELD.DEFAULT_VALUE));
        return cufModel;
    }

    private void initCufModel(Record r, CustomFieldModel<?> cufModel) {
        cufModel.setId((Long)r.get((Field)Tables.CUSTOM_FIELD.CF_ID));
        cufModel.setCode((String)r.get((Field)Tables.CUSTOM_FIELD.CODE));
        cufModel.setName((String)r.get((Field)Tables.CUSTOM_FIELD.NAME));
        cufModel.setLabel((String)r.get((Field)Tables.CUSTOM_FIELD.LABEL));
        cufModel.setOptional((Boolean)r.get((Field)Tables.CUSTOM_FIELD.OPTIONAL));
        cufModel.setDenormalized(false);
        InputTypeModel inputTypeModel = new InputTypeModel();
        String inputTypeKey = (String)r.get((Field)Tables.CUSTOM_FIELD.INPUT_TYPE);
        InputType inputType = (InputType)EnumUtils.getEnum(InputType.class, (String)inputTypeKey);
        inputTypeModel.setEnumName(inputTypeKey);
        inputTypeModel.setFriendlyName(this.getMessage(inputType.getI18nKey()));
        cufModel.setInputType(inputTypeModel);
    }

    private Map<Long, Map<String, List<CustomFieldBindingModel>>> findCustomFieldsBindingsByProject(List<Long> readableProjectIds, Map<Long, CustomFieldModel<?>> cufMap) {
        Result result = this.dsl.selectDistinct((SelectField)Tables.CUSTOM_FIELD_BINDING.CFB_ID, (SelectField)Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID, (SelectField)Tables.CUSTOM_FIELD_BINDING.POSITION, (SelectField)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY, (SelectField)Tables.CUSTOM_FIELD_BINDING.CF_ID, (SelectField)Tables.CUSTOM_FIELD_RENDERING_LOCATION.RENDERING_LOCATION).from((TableLike)Tables.CUSTOM_FIELD_BINDING).leftJoin((TableLike)Tables.CUSTOM_FIELD_RENDERING_LOCATION).on(Tables.CUSTOM_FIELD_BINDING.CFB_ID.eq((Field)Tables.CUSTOM_FIELD_RENDERING_LOCATION.CFB_ID)).where(Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID.in(readableProjectIds)).fetch();
        Function<Record, CustomFieldBindingModel> customFieldBindingModelTransformer = this.getCustomFieldModelTransformer(cufMap);
        Function<Record, RenderingLocationModel> renderingLocationModelTransformer = this.getRenderingLocationModelTransformer();
        Function<Map.Entry, CustomFieldBindingModel> injector = entry -> {
            CustomFieldBindingModel bindingModel = (CustomFieldBindingModel)entry.getKey();
            List renderingLocationModels = (List)entry.getValue();
            bindingModel.setRenderingLocations(renderingLocationModels.toArray(new RenderingLocationModel[0]));
            return bindingModel;
        };
        List<CustomFieldBindingModel> list = StreamUtils.performJoinAggregate(customFieldBindingModelTransformer, renderingLocationModelTransformer, injector, new ArrayList(result));
        Map<Long, Map<String, List<CustomFieldBindingModel>>> cufBindingsByProject = this.groupByProjectAndType(list);
        for (Long id : readableProjectIds) {
            if (cufBindingsByProject.containsKey(id)) continue;
            cufBindingsByProject.put(id, this.createEmptyCufMap());
        }
        return cufBindingsByProject;
    }

    private Map<Long, Map<String, List<CustomFieldBindingModel>>> groupByProjectAndType(List<CustomFieldBindingModel> list) {
        return list.stream().collect(Collectors.groupingBy(CustomFieldBindingModel::getProjectId, Collectors.groupingBy(customFieldBindingModel -> customFieldBindingModel.getBoundEntity().getEnumName(), this::createEmptyCufMap, Collectors.mapping(Function.identity(), Collectors.toList()))));
    }

    private HashMap<String, List<CustomFieldBindingModel>> createEmptyCufMap() {
        HashMap<String, List<CustomFieldBindingModel>> map = new HashMap<String, List<CustomFieldBindingModel>>();
        EnumSet<BindableEntity> bindableEntities = EnumSet.allOf(BindableEntity.class);
        bindableEntities.forEach(bindableEntity -> {
            ArrayList arrayList = map.put(bindableEntity.name(), new ArrayList());
        });
        return map;
    }

    private Function<Record, RenderingLocationModel> getRenderingLocationModelTransformer() {
        return r -> {
            String renderingLocationKey = (String)r.get((Field)Tables.CUSTOM_FIELD_RENDERING_LOCATION.RENDERING_LOCATION);
            if (renderingLocationKey == null) {
                return null;
            }
            RenderingLocationModel renderingLocationModel = new RenderingLocationModel();
            RenderingLocation renderingLocation = (RenderingLocation)EnumUtils.getEnum(RenderingLocation.class, (String)renderingLocationKey);
            renderingLocationModel.setEnumName(renderingLocationKey);
            renderingLocationModel.setFriendlyName(this.getMessage(renderingLocation.getI18nKey()));
            return renderingLocationModel;
        };
    }

    private Function<Record, CustomFieldBindingModel> getCustomFieldModelTransformer(Map<Long, CustomFieldModel<?>> cufMap) {
        return r -> {
            CustomFieldBindingModel customFieldBindingModel = new CustomFieldBindingModel();
            customFieldBindingModel.setId((Long)r.get((Field)Tables.CUSTOM_FIELD_BINDING.CFB_ID));
            customFieldBindingModel.setProjectId((Long)r.get((Field)Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID));
            customFieldBindingModel.setPosition((Integer)r.get((Field)Tables.CUSTOM_FIELD_BINDING.POSITION));
            String boundEntityKey = (String)r.get((Field)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY);
            BindableEntity bindableEntity = (BindableEntity)EnumUtils.getEnum(BindableEntity.class, (String)boundEntityKey);
            BindableEntityModel bindableEntityModel = new BindableEntityModel();
            bindableEntityModel.setEnumName(boundEntityKey);
            bindableEntityModel.setFriendlyName(this.getMessage(bindableEntity.getI18nKey()));
            customFieldBindingModel.setBoundEntity(bindableEntityModel);
            customFieldBindingModel.setCustomField((CustomFieldModel)cufMap.get(r.get((Field)Tables.CUSTOM_FIELD_BINDING.CF_ID)));
            return customFieldBindingModel;
        };
    }

    private String getMessage(String key) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.messageSource.getMessage(key, null, locale);
    }
}

