/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.bugtracker.adapter;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.squashtest.csp.core.bugtracker.core.BugTrackerManagerException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.core.ProjectNotFoundException;
import org.squashtest.csp.core.bugtracker.domain.BTIssue;
import org.squashtest.csp.core.bugtracker.domain.BTProject;
import org.squashtest.csp.core.bugtracker.domain.Priority;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchRequest;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchTerm;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.bugtracker.definition.RemoteProject;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.core.foundation.lang.CollectionUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.service.internal.bugtracker.adapter.AbstractInternalConnectorAdapter;
import org.squashtest.tm.service.spi.BugTrackerConnector;

public class SimpleBugtrackerConnectorAdapter
extends AbstractInternalConnectorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleBugtrackerConnectorAdapter.class);
    private BugTrackerConnector connector;

    public SimpleBugtrackerConnectorAdapter() {
    }

    public SimpleBugtrackerConnectorAdapter(BugTrackerConnector connector) {
        this.connector = connector;
    }

    public void setConnector(BugTrackerConnector connector) {
        this.connector = connector;
    }

    @Override
    public BugTrackerConnector getConnector() {
        return this.connector;
    }

    @Override
    public RemoteProject findProject(String projectName) throws ProjectNotFoundException, BugTrackerRemoteException {
        return this.connector.findProject(projectName);
    }

    @Override
    public RemoteProject findProjectById(String projectId) throws ProjectNotFoundException, BugTrackerRemoteException {
        return this.connector.findProject(projectId);
    }

    @Override
    public RemoteIssue createIssue(RemoteIssue issue) throws BugTrackerRemoteException {
        return this.connector.createIssue((BTIssue)issue);
    }

    @Override
    public RemoteIssue findIssue(String key) {
        return this.connector.findIssue(key);
    }

    @Override
    public List<RemoteIssue> findIssues(Collection<String> issueKeys) {
        return this.connector.findIssues(this.coerceToList(issueKeys));
    }

    private List<String> coerceToList(Collection<String> issueKeys) {
        return CollectionUtils.coerceToList(issueKeys);
    }

    @Override
    public RemoteIssue createReportIssueTemplate(String projectName, RemoteIssueContext context) {
        BTProject project = this.connector.findProject(projectName);
        BTIssue emptyIssue = new BTIssue();
        BTProject btProject = project;
        emptyIssue.setProject(btProject);
        Priority defaultPriority = btProject.getDefaultIssuePriority();
        if (!defaultPriority.equals(Priority.NO_PRIORITY)) {
            emptyIssue.setPriority(defaultPriority);
        }
        return emptyIssue;
    }

    @Override
    public Optional<? extends RemoteIssue> searchIssue(RemoteIssueSearchRequest searchRequest) {
        if (searchRequest.getSearchTerms().isEmpty()) {
            throw new IllegalArgumentException("You should provide at least one search term.");
        }
        RemoteIssueSearchTerm firstSearchTerm = (RemoteIssueSearchTerm)searchRequest.getSearchTerms().get(0);
        return Optional.ofNullable(this.connector.findIssue(firstSearchTerm.getStringValue()));
    }

    @Override
    public URL makeViewIssueUrl(BugTracker bugTracker, String issueId) {
        URL url = null;
        try {
            URI baseUri = new URI(bugTracker.getUrl());
            String suffix = this.connector.makeViewIssueUrlSuffix(issueId);
            url = new URI(String.valueOf(baseUri) + suffix).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return url;
    }

    @Override
    public void forwardAttachments(String remoteIssueKey, List<Attachment> attachments) {
        throw new BugTrackerManagerException("Technical error : impossible to post attachments for issue '" + remoteIssueKey + "' . This issue is managed by a simple connector that cannot handle such operation. As such yhis is likely a a programming error : file uploads should never have been available in the GUI in the first place. Please submit your attachments using the bugtracker itself.");
    }

    @Override
    public Object executeDelegateCommand(DelegateCommand command) {
        throw new BugTrackerManagerException("Technical error : impossible to execute a delegate command. This issue is managed by a simple connector that cannot handle such operation. As such yhis is likely a a programming error : file uploads should never have been available in the GUI in the first place");
    }

    @Override
    public void linkIssues(String remoteIssueKey, List<String> remoteReqIds) {
    }
}

