/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.concurrent;

import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;

public final class EntityLockManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityLockManager.class);
    private static final Map<EntityRef, WeakReference<ReentrantLock>> locks = new ConcurrentHashMap<EntityRef, WeakReference<ReentrantLock>>();

    private EntityLockManager() {
    }

    public static synchronized ReentrantLock getLock(EntityRef ref) {
        ReentrantLock lock;
        WeakReference<ReentrantLock> wr = locks.get(ref);
        if (wr == null) {
            lock = EntityLockManager.createLock(ref);
        } else {
            LOGGER.trace("Retrieved lock for entity {}", new Object[]{ref});
            lock = (ReentrantLock)wr.get();
            if (lock == null) {
                LOGGER.trace("Previous lock was GC'd", new Object[0]);
                lock = EntityLockManager.createLock(ref);
            }
        }
        LOGGER.debug("Gotten lock for {}", new Object[]{ref});
        return lock;
    }

    private static ReentrantLock createLock(EntityRef ref) {
        LOGGER.trace("Creating new weak reference and lock for entity {}", new Object[]{ref});
        ReentrantLock lock = new ReentrantLock();
        locks.put(ref, new WeakReference<ReentrantLock>(lock));
        return lock;
    }

    public static synchronized Collection<Lock> lock(Collection<EntityRef> refs) {
        LOGGER.trace("Batch locking entities {}", new Object[]{refs});
        ArrayList<Lock> locksList = new ArrayList<Lock>(refs.size());
        for (EntityRef ref : refs) {
            ReentrantLock lock = EntityLockManager.getLock(ref);
            lock.lock();
            locksList.add(lock);
        }
        return locksList;
    }

    public static void release(Collection<Lock> locks) {
        LOGGER.trace("Batch unlocking entities", new Object[0]);
        for (Lock lock : locks) {
            if (lock == null) continue;
            lock.unlock();
        }
    }

    public static final class EntityRef {
        private final Class<?> type;
        private final Serializable id;

        public EntityRef(@NotNull Class<?> type, Serializable id) {
            this.type = type;
            this.id = id;
        }

        public String toString() {
            return "EntityRef{type=" + String.valueOf(this.type) + ", id=" + String.valueOf(this.id) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntityRef entityRef = (EntityRef)o;
            if (!this.type.equals(entityRef.type)) {
                return false;
            }
            return this.id.equals(entityRef.id);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.id.hashCode();
            return result;
        }
    }
}

