/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service;

import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Role;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.StandardReflectionParameterNameDiscoverer;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.acls.domain.AclAuthorizationStrategy;
import org.springframework.security.acls.domain.AclAuthorizationStrategyImpl;
import org.springframework.security.acls.domain.AuditLogger;
import org.springframework.security.acls.domain.DefaultPermissionGrantingStrategy;
import org.springframework.security.acls.domain.PermissionFactory;
import org.springframework.security.acls.domain.SpringCacheBasedAclCache;
import org.springframework.security.acls.jdbc.BasicLookupStrategy;
import org.springframework.security.acls.model.AclCache;
import org.springframework.security.acls.model.AclService;
import org.springframework.security.acls.model.ObjectIdentityGenerator;
import org.springframework.security.acls.model.ObjectIdentityRetrievalStrategy;
import org.springframework.security.acls.model.PermissionGrantingStrategy;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.DelegatingPasswordEncoder;
import org.springframework.security.crypto.password.MessageDigestPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.squashtest.tm.security.acls.CustomPermissionFactory;
import org.squashtest.tm.security.acls.Slf4jAuditLogger;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.security.AffirmativeBasedCompositePermissionEvaluator;
import org.squashtest.tm.service.internal.security.SquashUserDetailsManager;
import org.squashtest.tm.service.internal.security.SquashUserDetailsManagerImpl;
import org.squashtest.tm.service.internal.security.SquashUserDetailsManagerProxyFactory;
import org.squashtest.tm.service.internal.spring.ArgumentPositionParameterNameDiscoverer;
import org.squashtest.tm.service.internal.spring.CompositeDelegatingParameterNameDiscoverer;
import org.squashtest.tm.service.security.acls.ExtraPermissionEvaluator;
import org.squashtest.tm.service.security.acls.domain.DatabaseBackedObjectIdentityGeneratorStrategy;
import org.squashtest.tm.service.security.acls.domain.InheritableAclsObjectIdentityRetrievalStrategy;
import org.squashtest.tm.service.security.acls.domain.objectidentity.OptimizedObjectIdentityRetrievalStrategy;

@Configuration
@EnableMethodSecurity(securedEnabled=true)
public class SecurityConfig {
    private static final String BCRYPT_ALG = "bcrypt";
    private static final String SHA1_ALG = "sha-1";
    private static final String DBTYPE_POSTGRES = "POSTGRES";
    public static final String CURRENT_USER_PASSWORD_HASH_SCHEME = "bcrypt";
    @Inject
    @Lazy
    private FeatureManager featureManager;
    @Autowired(required=false)
    private Collection<ExtraPermissionEvaluator> extraPermissionEvaluators = Collections.emptyList();
    @Value(value="${jooq.sql.dialect:'MARIADB'}")
    private String dbType;

    @Bean
    @Order(value=-2147483548)
    public MethodSecurityExpressionHandler methodSecurityExpressionHandler(@Named(value="squashtest.core.security.AclService") AclService aclService, @Named(value="squashtest.core.security.ObjectIdentityGeneratorStrategy") ObjectIdentityGenerator objectIdentityGenerator) {
        DefaultMethodSecurityExpressionHandler expressionHandler = new DefaultMethodSecurityExpressionHandler();
        expressionHandler.setParameterNameDiscoverer((ParameterNameDiscoverer)new CompositeDelegatingParameterNameDiscoverer(Arrays.asList(new StandardReflectionParameterNameDiscoverer(), new ArgumentPositionParameterNameDiscoverer())));
        expressionHandler.setPermissionEvaluator((PermissionEvaluator)this.permissionEvaluator(aclService, objectIdentityGenerator));
        return expressionHandler;
    }

    @Bean
    public PermissionFactory permissionFactory() {
        return new CustomPermissionFactory();
    }

    @Bean
    public GrantedAuthority aclAdminAuthority() {
        return new SimpleGrantedAuthority("ROLE_ADMIN");
    }

    @Bean(value={"squashtest.core.security.ObjectIdentityRetrievalStrategy"})
    public ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy() {
        return new InheritableAclsObjectIdentityRetrievalStrategy();
    }

    @Bean(value={"squashtest.core.security.ObjectIdentityGeneratorStrategy"})
    public ObjectIdentityGenerator objectIdentityGenerator(OptimizedObjectIdentityRetrievalStrategy optimizedObjectIdentityRetrievalStrategy) {
        return new DatabaseBackedObjectIdentityGeneratorStrategy(this.objectIdentityRetrievalStrategy(), optimizedObjectIdentityRetrievalStrategy);
    }

    @Bean
    public BasicLookupStrategy lookupStrategy(DataSource dataSource, CacheManager cacheManager) {
        BasicLookupStrategy strategy = new BasicLookupStrategy(dataSource, this.aclCache(cacheManager), this.aclAuthorizationStrategy(), (PermissionGrantingStrategy)this.grantingStrategy());
        strategy.setSelectClause("select oid.IDENTITY as object_id_identity,\n  gp.PERMISSION_ORDER,\n  oid.ID as acl_id,\n  null as parent_object, /* oid.parent */\n  true as entries_inheriting, /* oid.entries_inheriting*/\n  rse.ID as ace_id,\n  gp.PERMISSION_MASK as mask,\n  gp.GRANTING as granting,\n  true as audit_success, /* audit success */\n  false as audit_failure, /* audit failure */\n  true as ace_principal, /* sid is principal */\n  u.LOGIN as ace_sid,\n  true as acl_principal, /* owner is prinipal */\n  u.LOGIN as acl_sid, /* owner sid */\n  ocl.CLASSNAME as class\nfrom ACL_OBJECT_IDENTITY oid\n  left join ACL_CLASS ocl on ocl.ID = oid.CLASS_ID\n  left join ACL_GROUP_PERMISSION gp on gp.CLASS_ID = ocl.ID\n  left join ACL_GROUP g on g.ID = gp.ACL_GROUP_ID\n  left join ACL_RESPONSIBILITY_SCOPE_ENTRY rse on rse.ACL_GROUP_ID = g.ID and rse.OBJECT_IDENTITY_ID = oid.ID\n  inner join CORE_PARTY party on party.PARTY_ID = rse.PARTY_ID\n  left join CORE_TEAM team on team.PARTY_ID = party.PARTY_ID\n  left join CORE_TEAM_MEMBER tmemb on tmemb.TEAM_ID = team.PARTY_ID,\n  CORE_USER u \nwhere((u.PARTY_ID = tmemb.USER_ID) or (u.PARTY_ID = party.PARTY_ID)) and u.ACTIVE = true and (\n");
        String oIDWhereClause = null;
        oIDWhereClause = DBTYPE_POSTGRES.equals(this.dbType) ? "(oid.IDENTITY::varchar(36) = ? and ocl.CLASSNAME = ?)" : "(oid.IDENTITY = ? and ocl.CLASSNAME = ?)";
        strategy.setLookupObjectIdentitiesWhereClause(oIDWhereClause);
        strategy.setLookupPrimaryKeysWhereClause("(oid.ID = ?)");
        strategy.setOrderByClause(") order by oid.IDENTITY asc, gp.PERMISSION_ORDER asc");
        strategy.setPermissionFactory(this.permissionFactory());
        return strategy;
    }

    @Bean
    public DefaultPermissionGrantingStrategy grantingStrategy() {
        return new DefaultPermissionGrantingStrategy((AuditLogger)new Slf4jAuditLogger());
    }

    @Bean
    public AclAuthorizationStrategy aclAuthorizationStrategy() {
        return new AclAuthorizationStrategyImpl(new GrantedAuthority[]{this.aclAdminAuthority(), this.aclAdminAuthority(), this.aclAdminAuthority()});
    }

    @Bean(name={"squashtest.core.security.JdbcUserDetailsManager"})
    @Primary
    public SquashUserDetailsManagerProxyFactory userDetailsManager(DataSource dataSource) {
        SquashUserDetailsManagerProxyFactory factoryBean = new SquashUserDetailsManagerProxyFactory();
        factoryBean.setCaseInsensitiveManager(this.caseInensitiveUserDetailsManager(dataSource));
        factoryBean.setCaseSensitiveManager(this.caseSensitiveUserDetailsManager(dataSource));
        factoryBean.setFeatures(this.featureManager);
        return factoryBean;
    }

    @Bean
    @Role(value=2)
    @Order(value=0)
    public PasswordEncoder passwordEncoder() {
        MessageDigestPasswordEncoder legacyEncoder = new MessageDigestPasswordEncoder("SHA-1");
        BCryptPasswordEncoder bcryptEncoder = new BCryptPasswordEncoder();
        ImmutableMap encodersMap = new ImmutableMap.Builder().put((Object)SHA1_ALG, (Object)legacyEncoder).put((Object)"bcrypt", (Object)bcryptEncoder).build();
        DelegatingPasswordEncoder compositeEncoder = new DelegatingPasswordEncoder("bcrypt", (Map)encodersMap);
        compositeEncoder.setDefaultPasswordEncoderForMatches((PasswordEncoder)legacyEncoder);
        return compositeEncoder;
    }

    @Bean(name={"userDetailsManager.caseSensitive"})
    public SquashUserDetailsManager caseSensitiveUserDetailsManager(DataSource dataSource) {
        SquashUserDetailsManagerImpl manager = this.newSquashUserDetailsManager(dataSource);
        manager.setUsersByUsernameQuery("select LOGIN, PASSWORD, ACTIVE from AUTH_USER where LOGIN = ?");
        manager.setUserExistsSql("select LOGIN from AUTH_USER where LOGIN = ?");
        manager.setGroupAuthoritiesByUsernameQuery("select g.ID, g.QUALIFIED_NAME, ga.AUTHORITY \nfrom CORE_GROUP g \n  inner join CORE_GROUP_AUTHORITY ga on ga.GROUP_ID = g.ID\n  inner join CORE_GROUP_MEMBER gm on gm.GROUP_ID = g.ID\n  inner join CORE_PARTY party on party.PARTY_ID = gm.PARTY_ID\n  left join CORE_TEAM team on team.PARTY_ID = party.PARTY_ID\n  left join CORE_TEAM_MEMBER tmemb on tmemb.TEAM_ID = team.PARTY_ID,\n  CORE_USER u \nwhere( (u.PARTY_ID = tmemb.USER_ID AND u.ACTIVE = true) or (u.PARTY_ID = party.PARTY_ID) ) and ( u.LOGIN = ?)");
        manager.setAuthoritiesByUsernameQuery("select cpa.PARTY_ID,  cpa.AUTHORITY from CORE_PARTY_AUTHORITY cpa\n  inner join CORE_PARTY party on party.PARTY_ID = cpa.PARTY_ID\n  left join CORE_TEAM team on team.PARTY_ID = party.PARTY_ID\n  left join CORE_TEAM_MEMBER tmemb on tmemb.TEAM_ID = team.PARTY_ID,\n  CORE_USER u \nwhere( (u.PARTY_ID = tmemb.USER_ID AND u.ACTIVE = true) or (u.PARTY_ID = party.PARTY_ID) ) and ( u.LOGIN = ?)");
        return manager;
    }

    @Bean(name={"userDetailsManager.caseInsensitive"})
    public SquashUserDetailsManager caseInensitiveUserDetailsManager(DataSource dataSource) {
        SquashUserDetailsManagerImpl manager = this.newSquashUserDetailsManager(dataSource);
        manager.setUsersByUsernameQuery("select LOGIN, PASSWORD, ACTIVE from AUTH_USER where lower(LOGIN) = lower(?)");
        manager.setUserExistsSql("select LOGIN from AUTH_USER where lower(LOGIN) = lower(?)");
        manager.setGroupAuthoritiesByUsernameQuery("select g.ID, g.QUALIFIED_NAME, ga.AUTHORITY \nfrom CORE_GROUP g \n  inner join CORE_GROUP_AUTHORITY ga on ga.GROUP_ID = g.ID\n  inner join CORE_GROUP_MEMBER gm on gm.GROUP_ID = g.ID\n  inner join CORE_PARTY party on party.PARTY_ID = gm.PARTY_ID\n  left join CORE_TEAM team on team.PARTY_ID = party.PARTY_ID\n  left join CORE_TEAM_MEMBER tmemb on tmemb.TEAM_ID = team.PARTY_ID,\n  CORE_USER u \nwhere ((u.PARTY_ID = tmemb.USER_ID AND u.ACTIVE = true) or (u.PARTY_ID = party.PARTY_ID)) \n  and (lower(u.LOGIN) = lower(?))");
        manager.setAuthoritiesByUsernameQuery("select cpa.PARTY_ID,  cpa.AUTHORITY \nfrom CORE_PARTY_AUTHORITY cpa\n  inner join CORE_PARTY party on party.PARTY_ID = cpa.PARTY_ID\n  left join CORE_TEAM team on team.PARTY_ID = party.PARTY_ID\n  left join CORE_TEAM_MEMBER tmemb on tmemb.TEAM_ID = team.PARTY_ID,\n  CORE_USER u \nwhere ((u.PARTY_ID = tmemb.USER_ID AND u.ACTIVE = true) or (u.PARTY_ID = party.PARTY_ID) ) \n  and (lower(u.LOGIN) = lower(?))");
        return manager;
    }

    private SquashUserDetailsManagerImpl newSquashUserDetailsManager(DataSource dataSource) {
        SquashUserDetailsManagerImpl manager = new SquashUserDetailsManagerImpl();
        manager.setDataSource(dataSource);
        manager.setChangePasswordSql("update AUTH_USER set PASSWORD = ? where LOGIN = ?");
        manager.setUpdateUserSql("update AUTH_USER set PASSWORD = ?, ACTIVE = ? where LOGIN = ?");
        manager.setDeleteUserSql("delete from AUTH_USER where LOGIN = ?");
        manager.setCreateUserSql("insert into AUTH_USER (LOGIN, PASSWORD, ACTIVE) values (?,?,?)");
        manager.setCreateAuthoritySql("insert into CORE_PARTY_AUTHORITY (PARTY_ID, AUTHORITY) values ((select cu.PARTY_ID from CORE_USER cu where cu.LOGIN = ?), ?)");
        manager.setDeleteUserAuthoritiesSql("delete from CORE_PARTY_AUTHORITY\nwhere PARTY_ID in (\n  select cu.PARTY_ID from CORE_USER cu\n  where cu.LOGIN = ?\n)");
        manager.setEnableAuthorities(true);
        manager.setEnableGroups(true);
        return manager;
    }

    @Bean
    public AffirmativeBasedCompositePermissionEvaluator permissionEvaluator(@Named(value="squashtest.core.security.AclService") AclService aclService, @Named(value="squashtest.core.security.ObjectIdentityGeneratorStrategy") ObjectIdentityGenerator objectIdentityGenerator) {
        AffirmativeBasedCompositePermissionEvaluator evaluator = new AffirmativeBasedCompositePermissionEvaluator(aclService, this.extraPermissionEvaluators);
        evaluator.setObjectIdentityRetrievalStrategy(this.objectIdentityRetrievalStrategy());
        evaluator.setObjectIdentityGenerator(objectIdentityGenerator);
        evaluator.setPermissionFactory(this.permissionFactory());
        return evaluator;
    }

    @Bean
    public AclCache aclCache(CacheManager cacheManager) {
        Cache cache = cacheManager.getCache("aclCache");
        return new SpringCacheBasedAclCache(cache, (PermissionGrantingStrategy)this.grantingStrategy(), this.aclAuthorizationStrategy());
    }
}

