/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.requirement;

import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.internal.dto.SynchronizedRequirementVersionsExceptionSummary;
import org.squashtest.tm.service.requirement.RequirementBulkUpdate;

public interface RequirementVersionManagerService {
    @UsedInPlugin(value="rest-api")
    public Requirement findRequirementById(long var1);

    public RequirementVersion findById(long var1);

    public List<String> retrieveFullNameByRequirementLibraryNodeIds(List<Long> var1, List<Long> var2);

    public void createNewVersion(long var1, boolean var3, boolean var4);

    public void createNewVersion(long var1, boolean var3, boolean var4, AuditableMixin var5);

    public void createNewVersion(long var1, Collection<Long> var3, boolean var4, boolean var5);

    public void rename(long var1, String var3);

    public void changeCriticality(long var1, @NotNull RequirementCriticality var3);

    public void changeCategory(long var1, String var3);

    public void changeCategory(long var1, Long var3);

    public void changeReference(long var1, @NotNull String var3);

    public void changeDescription(long var1, @NotNull String var3);

    public void changeStatus(@Id long var1, @NotNull RequirementStatus var3);

    public SynchronizedRequirementVersionsExceptionSummary bulkUpdate(List<Long> var1, RequirementBulkUpdate var2);

    public Page<RequirementVersion> findAllByRequirement(long var1, @NotNull Pageable var3);

    public List<RequirementVersion> findAllByRequirement(long var1);

    public Long findReqVersionIdByRequirementAndVersionNumber(long var1, Integer var3);

    public RequirementVersion findByRequirementIdAndVersionNumber(long var1, int var3);

    public void bindMilestones(long var1, Collection<Long> var3);

    public void unbindMilestones(long var1, Collection<Long> var3);

    public Collection<Milestone> findAssociableMilestones(long var1);

    public Collection<Milestone> findAllMilestones(long var1);

    public Collection<Milestone> findAssociableMilestonesForMassModif(List<Long> var1);

    public Collection<Long> findBindedMilestonesIdForMassModif(List<Long> var1);

    public boolean haveSamePerimeter(List<Long> var1);

    public boolean isOneMilestoneAlreadyBindToAnotherRequirementVersion(List<Long> var1, List<Long> var2);

    public Long findLatestRequirementVersionByRequirementIdAndVerifyingTestCaseId(long var1, long var3);
}

