/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.user;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jooq.DSLContext;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.UnauthorizedPasswordChange;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.WrongPasswordException;
import org.squashtest.tm.exception.WrongStringSizeException;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.bugtracker.BugTrackersService;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.useraccount.PersonalApiTokenGrid;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.repository.ApiTokenDao;
import org.squashtest.tm.service.internal.repository.BugTrackerDao;
import org.squashtest.tm.service.internal.repository.TeamDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.project.CustomGenericProjectManager;
import org.squashtest.tm.service.project.CustomProjectFinder;
import org.squashtest.tm.service.project.ProjectsPermissionManagementService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.UserAuthenticationService;
import org.squashtest.tm.service.security.UserContextService;
import org.squashtest.tm.service.security.acls.model.ObjectAclService;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.user.TeamModificationService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.service.user.UserManagerService;

@Service(value="squashtest.tm.service.UserAccountService")
@Transactional
public class UserAccountServiceImpl
implements UserAccountService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAccountServiceImpl.class);
    private static final List<String> JIRA_BUGTRACKER_KINDS = Arrays.asList("jira.xsquash", "jira.rest", "jira.cloud");
    @Inject
    private UserDao userDao;
    @Inject
    private UserContextService userContextService;
    @Inject
    private UserAuthenticationService authService;
    @Inject
    private CustomGenericProjectManager customGenericProjectManager;
    @Inject
    private TeamModificationService teamModificationService;
    @Inject
    private ProjectsPermissionManagementService projectsPermissionManagementService;
    @Inject
    private UserManagerService userManager;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private TeamDao teamDao;
    @Inject
    private BugTrackerFinderService bugTrackerFinder;
    @Inject
    private StoredCredentialsManager storedCredentialsManager;
    @Inject
    private BugTrackerDao bugTrackerDao;
    @Inject
    private BugTrackersService bugTrackerService;
    @Inject
    private ObjectAclService aclService;
    @Inject
    private CustomProjectFinder customProjectFinder;
    @Inject
    private ApiTokenDao apiTokenDao;
    @Inject
    private DSLContext dsl;

    @Override
    public void modifyUserFirstName(long userId, String newName) {
        User user = (User)this.userDao.getReferenceById(userId);
        this.checkPermissions(user);
        user.setFirstName(newName);
    }

    @Override
    public void modifyUserLastName(long userId, String newName) {
        User user = (User)this.userDao.getReferenceById(userId);
        this.checkPermissions(user);
        user.setLastName(newName);
    }

    @Override
    public void modifyUserLogin(long userId, String newLogin) {
        User user;
        String newtrimedLogin = newLogin.trim();
        if (!newtrimedLogin.equals((user = (User)this.userDao.getReferenceById(userId)).getLogin())) {
            LOGGER.debug("Change login for user {} to {}", new Object[]{user.getLogin(), newtrimedLogin});
            this.checkPermissions(user);
            this.userManager.checkLoginAvailability(newtrimedLogin);
            this.checkMaxLength(newtrimedLogin);
            this.authService.changeUserlogin(newtrimedLogin, user.getLogin());
            user.setLogin(newtrimedLogin);
            this.aclService.refreshAcls();
        } else {
            LOGGER.trace("no change of user login because old and new are the same", new Object[0]);
        }
    }

    private void checkMaxLength(String login) {
        if (login.length() > 100) {
            throw new WrongStringSizeException("login", 0, 100);
        }
    }

    @Override
    public void modifyUserEmail(long userId, String newEmail) {
        User user = (User)this.userDao.getReferenceById(userId);
        this.checkPermissions(user);
        user.setEmail(newEmail);
    }

    @Override
    @Transactional(readOnly=true)
    public User findCurrentUser() {
        String username = UserContextHolder.getUsername();
        return this.userDao.findUserByLogin(username);
    }

    @Override
    public UserDto findCurrentUserDto() {
        String username = UserContextHolder.getUsername();
        Long userId = this.userDao.findUserId(username);
        boolean isAdmin = this.permissionEvaluationService.hasRole("ROLE_ADMIN");
        List partyIds = this.teamDao.findTeamIds(userId);
        return new UserDto(username, userId, new ArrayList<Long>(partyIds), isAdmin);
    }

    @Override
    public void setCurrentUserEmail(String newEmail) {
        String username = this.userContextService.getUsername();
        User user = this.userDao.findUserByLogin(username);
        user.setEmail(newEmail);
    }

    @Override
    @Transactional(readOnly=true)
    public Party getParty(Long id) {
        return this.customGenericProjectManager.findPartyById(id);
    }

    @Override
    public void setCurrentUserPassword(String oldPass, String newPass) {
        this.internalSetCurrentUserPassword(() -> this.authService.changeAuthenticatedUserPassword(oldPass, newPass));
    }

    @Override
    public void setCurrentUserPassword(String newPasswd) {
        this.internalSetCurrentUserPassword(() -> this.authService.resetAuthenticatedUserPassword(newPasswd));
    }

    private void internalSetCurrentUserPassword(Runnable action) {
        if (!this.authService.canModifyUser()) {
            throw new UnauthorizedPasswordChange("The authentication service do not allow users to change their passwords using Squash");
        }
        try {
            action.run();
        }
        catch (BadCredentialsException bce) {
            throw new WrongPasswordException("wrong password", (Throwable)bce);
        }
    }

    @Override
    public boolean hasCurrentUserPasswordDefined() {
        return this.authService.hasAuthenticatedUserLocalPassword();
    }

    @Override
    public void updateUserLastConnectionDate() {
        User user;
        User audit = user = this.findCurrentUser();
        audit.setSkipModifyAudit(true);
        user.setLastConnectedOn(new Date());
    }

    @Override
    public List<BugTracker> findAllUserBugTracker() {
        List<Long> readableProjectIds = this.customProjectFinder.findAllReadableIds();
        return this.bugTrackerFinder.findDistinctBugTrackersForProjectWithOtherJiraBt(readableProjectIds, JIRA_BUGTRACKER_KINDS);
    }

    @Override
    public void saveCurrentUserCredentials(long serverId, ManageableCredentials credentials) {
        if (!credentials.allowsUserLevelStorage()) {
            throw new IllegalArgumentException("Refused to store credentials of type '" + String.valueOf(credentials.getImplementedProtocol()) + "' : business rules forbid to store such credentials as application-level credentials");
        }
        this.storedCredentialsManager.storeCurrentUserCredentials(serverId, credentials);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deactivateUser(long userId) {
        User user = (User)this.userDao.getReferenceById(userId);
        user.setActive(Boolean.valueOf(false));
        this.deleteAllApiTokens(userId);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void activateUser(long userId) {
        User user = (User)this.userDao.getReferenceById(userId);
        user.setActive(Boolean.valueOf(true));
    }

    @Override
    public void deleteUser(long userId) {
        this.unassignUserFromAllTestPlan(userId);
        this.teamModificationService.removeMemberFromAllTeams(userId);
        this.projectsPermissionManagementService.removeProjectPermissionForAllProjects(userId);
        this.storedCredentialsManager.deleteAllUserCredentials(userId);
        this.deleteAllApiTokens(userId);
    }

    private void unassignUserFromAllTestPlan(long userId) {
        this.userDao.unassignFromAllCampaignTestPlan(userId);
        this.userDao.unassignFromAllIterationTestPlan(userId);
        this.userDao.unassignFromAllExploratoryExecutions(userId);
    }

    private void deleteAllApiTokens(long userId) {
        this.apiTokenDao.deleteAllByUserId(userId);
    }

    @Override
    public Collection<Milestone> findAllMilestonesForUser(long userId) {
        return Collections.emptyList();
    }

    private void checkPermissions(User user) {
        user.checkIsNotFromInfrastructureAdminGroup();
        String currentLogin = this.userContextService.getUsername();
        if (!user.getLogin().equals(currentLogin) && !this.userContextService.hasRole("ROLE_ADMIN")) {
            throw new AccessDeniedException("Access is denied");
        }
    }

    @Override
    public void testCurrentUserCredentials(long bugtrackerId, ManageableCredentials credentials) {
        String currentLogin = this.userContextService.getUsername();
        BugTracker bt = (BugTracker)this.bugTrackerDao.getReferenceById(bugtrackerId);
        Credentials usableCredentials = credentials.build(this.storedCredentialsManager, (ThirdPartyServer)bt, currentLogin);
        if (usableCredentials == null) {
            throw new BugTrackerNoCredentialsException("credentials could not be built, either because the credentials themselves are not suitable, or because the protocol configuration is incomplete/invalid", null);
        }
        this.bugTrackerService.testCredentials(bt, usableCredentials);
    }

    @Override
    public void deleteCurrentUserCredentials(long serverId) {
        String username = this.userContextService.getUsername();
        this.storedCredentialsManager.deleteUserCredentials(serverId, username);
    }

    @Override
    public GridResponse findPersonalApiTokens(GridRequest request) {
        return new PersonalApiTokenGrid(this.findCurrentUser().getId()).getRows(request, this.dsl);
    }
}

