/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.httpclient;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicHeader;
import org.opentestfactory.messages.OTFMessage;
import org.squashtest.tm.core.foundation.lang.UrlUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.internal.testautomation.codec.ObjectMapperFactory;
import org.squashtest.tm.service.internal.testautomation.httpclient.ClientRuntimeException;
import org.squashtest.tm.service.internal.testautomation.httpclient.HttpPostRequest;
import org.squashtest.tm.service.internal.testautomation.httpclient.MessageRefusedException;
import org.squashtest.tm.service.internal.testautomation.httpclient.Request;
import org.squashtest.tm.service.internal.testautomation.httpclient.RequestConfigurationFactory;
import org.squashtest.tm.service.internal.testautomation.httpclient.Response;
import org.squashtest.tm.service.internal.testautomation.httpclient.SquashAutomBusClient;
import org.squashtest.tm.service.internal.testautomation.httpclient.UnexpectedServerResponseException;
import org.squashtest.tm.service.internal.testautomation.model.messages.PublicationStatus;

public class SquashAutomBusClientImpl
implements SquashAutomBusClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SquashAutomBusClientImpl.class);
    private static final String GENERIC_REST_CALL_ERROR_MESSAGE = "Failed to manage REST call for technical reasons";
    private final String busEndpoint;
    private final String authToken;
    private final int requestTimeoutSeconds;

    public SquashAutomBusClientImpl(String busEndpoint, String authToken, int requestTimeoutSeconds) {
        this.busEndpoint = busEndpoint;
        this.authToken = authToken;
        this.requestTimeoutSeconds = requestTimeoutSeconds;
    }

    @Override
    public PublicationStatus publish(OTFMessage event) throws MessageRefusedException {
        String publicationUrl = UrlUtils.appendPath((String)this.busEndpoint, (String)"./publications").toExternalForm();
        return this.performJsonRESTCall(event, publicationUrl);
    }

    /*
     * Loose catch block
     */
    protected PublicationStatus performJsonRESTCall(OTFMessage event, String endpoint) throws MessageRefusedException {
        try {
            URI methodURI = new URI(endpoint);
            Request request = this.createRequest(methodURI, event);
            if (StringUtils.isEmpty((CharSequence)this.authToken)) {
                LOGGER.debug("No authentication token, sending anonymously", new Object[0]);
            } else {
                request.addHeader((Header)new BasicHeader("Authorization", (Object)("Bearer " + this.authToken)));
            }
            Throwable throwable = null;
            Object var6_8 = null;
            try (CloseableHttpClient client = HttpClients.createSystem();){
                PublicationStatus publicationStatus;
                ClassicHttpResponse classicHttpResponse;
                Throwable throwable2;
                block23: {
                    throwable2 = null;
                    Object var9_13 = null;
                    classicHttpResponse = request.execute(client);
                    Response response = new Response(classicHttpResponse);
                    publicationStatus = this.handleResponse(response, methodURI);
                    if (classicHttpResponse == null) break block23;
                    classicHttpResponse.close();
                }
                return publicationStatus;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (classicHttpResponse != null) {
                                classicHttpResponse.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (IOException | URISyntaxException ex) {
            throw new ClientRuntimeException(GENERIC_REST_CALL_ERROR_MESSAGE, ex, endpoint);
        }
    }

    private Request createRequest(URI endpoint, OTFMessage event) throws JsonProcessingException {
        String payload = ObjectMapperFactory.getJsonObjectMapper().writeValueAsString((Object)event);
        HttpPost request = new HttpPost(endpoint);
        request.setConfig(new RequestConfigurationFactory().getRequestConfig(this.requestTimeoutSeconds));
        request.setEntity((HttpEntity)new StringEntity(payload, ContentType.APPLICATION_JSON));
        return new HttpPostRequest(request);
    }

    private PublicationStatus handleResponse(Response resp, URI endPoint) throws IOException, MessageRefusedException {
        try {
            if (resp.getCode() >= 400) {
                if (this.sameMimeType(resp)) {
                    throw new MessageRefusedException(endPoint, resp.getCode());
                }
                throw new UnexpectedServerResponseException(endPoint, resp.getCode(), resp.getReasonPhrase());
            }
            PublicationStatus publicationStatus = (PublicationStatus)((Object)ObjectMapperFactory.getJsonObjectMapper().readValue(resp.getEntity().getContent(), PublicationStatus.class));
            return publicationStatus;
        }
        finally {
            resp.getEntity().getContent().close();
        }
    }

    private boolean sameMimeType(Response resp) {
        String refCtString = ContentType.APPLICATION_JSON.getMimeType();
        String actualCTString = resp.mimeType();
        return refCtString.equals(actualCTString);
    }
}

