/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.List;
import java.util.Objects;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.AiServerAdminViewDto;
import org.squashtest.tm.service.internal.display.dto.AiServerDto;
import org.squashtest.tm.service.internal.repository.display.AiServerDisplayDao;

@Repository
public class AiServerDisplayDaoImpl
implements AiServerDisplayDao {
    private final DSLContext dslContext;

    public AiServerDisplayDaoImpl(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public AiServerAdminViewDto findAiServerById(Long aiServerId) {
        AiServerAdminViewDto result = (AiServerAdminViewDto)this.dslContext.select((SelectField)Tables.AI_SERVER.SERVER_ID.as("ID"), (SelectField)Tables.THIRD_PARTY_SERVER.DESCRIPTION, (SelectField)Tables.THIRD_PARTY_SERVER.LAST_MODIFIED_ON, (SelectField)Tables.THIRD_PARTY_SERVER.LAST_MODIFIED_BY, (SelectField)Tables.THIRD_PARTY_SERVER.CREATED_ON, (SelectField)Tables.THIRD_PARTY_SERVER.CREATED_BY, (SelectField)Tables.AI_SERVER.PAYLOAD_TEMPLATE, (SelectField)Tables.AI_SERVER.JSON_PATH, (SelectField)Tables.THIRD_PARTY_SERVER.NAME, (SelectField)Tables.THIRD_PARTY_SERVER.URL, (SelectField)Tables.THIRD_PARTY_SERVER.AUTH_POLICY, (SelectField)Tables.THIRD_PARTY_SERVER.AUTH_PROTOCOL).from((TableLike)Tables.AI_SERVER).innerJoin((TableLike)Tables.THIRD_PARTY_SERVER).on(Tables.AI_SERVER.SERVER_ID.eq((Field)Tables.THIRD_PARTY_SERVER.SERVER_ID)).where(Tables.AI_SERVER.SERVER_ID.eq((Object)aiServerId)).fetchOneInto(AiServerAdminViewDto.class);
        return Objects.requireNonNull(result, String.format("Could not find AI server with ID %d.", aiServerId));
    }

    @Override
    public List<AiServerDto> findAll() {
        return this.dslContext.select((SelectField)Tables.AI_SERVER.SERVER_ID.as("ID"), (SelectField)Tables.THIRD_PARTY_SERVER.DESCRIPTION, (SelectField)Tables.AI_SERVER.PAYLOAD_TEMPLATE, (SelectField)Tables.THIRD_PARTY_SERVER.LAST_MODIFIED_BY, (SelectField)Tables.THIRD_PARTY_SERVER.LAST_MODIFIED_ON, (SelectField)Tables.THIRD_PARTY_SERVER.CREATED_BY, (SelectField)Tables.THIRD_PARTY_SERVER.CREATED_ON, (SelectField)Tables.AI_SERVER.JSON_PATH, (SelectField)Tables.THIRD_PARTY_SERVER.URL, (SelectField)Tables.THIRD_PARTY_SERVER.NAME).from((TableLike)Tables.AI_SERVER).innerJoin((TableLike)Tables.THIRD_PARTY_SERVER).on(Tables.THIRD_PARTY_SERVER.SERVER_ID.eq((Field)Tables.AI_SERVER.SERVER_ID)).orderBy((OrderField)Tables.THIRD_PARTY_SERVER.NAME).fetchInto(AiServerDto.class);
    }
}

