/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.remotesynchronisation;

import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.exception.RequiredFieldException;
import org.squashtest.tm.exception.sync.PathAlreadyInUseException;
import org.squashtest.tm.exception.sync.PathContainsASprintGroupException;
import org.squashtest.tm.exception.sync.PathValidationDomainException;
import org.squashtest.tm.service.internal.repository.CustomRemoteSynchronisationDao;
import org.squashtest.tm.service.internal.repository.LibraryNodeDao;
import org.squashtest.tm.service.internal.repository.RequirementLibraryNodeDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateSprintGroupDao;
import org.squashtest.tm.service.internal.utils.JSONUtils;
import org.squashtest.tm.service.remotesynchronisation.RemoteSynchronisationService;

@Service(value="RemoteSynchronisationService")
public class RemoteSynchronisationServiceImpl
implements RemoteSynchronisationService {
    public static final String SYNCHRONISATION_PATH = "synchronisationPath";
    public static final String SPRINT_SYNCHRONISATION_PATH = "sprintSynchronisationPath";
    @Inject
    @Qualifier(value="squashtest.tm.repository.CampaignLibraryNodeDao")
    private LibraryNodeDao<CampaignLibraryNode> campaignLibraryNodeDao;
    @Inject
    private HibernateSprintGroupDao sprintGroupDao;
    @Inject
    private CustomRemoteSynchronisationDao customRemoteSynchronisationDao;
    @Inject
    private RequirementLibraryNodeDao requirementLibraryNodeDao;

    @Override
    public void checkPathAvailability(String projectName, String synchronisationPath) {
        Set<String> existingPaths = this.getExistingPaths(projectName, SYNCHRONISATION_PATH);
        synchronisationPath = PathUtils.removeAllUnnecessarySpaces((String)synchronisationPath);
        for (String existingPath : existingPaths) {
            if (!synchronisationPath.equals(existingPath)) continue;
            throw new PathAlreadyInUseException(SYNCHRONISATION_PATH);
        }
    }

    @Override
    public void checkSprintPathAvailability(String projectName, String sprintSynchronisationPath) {
        Set<String> existingPaths = this.getExistingPaths(projectName, SPRINT_SYNCHRONISATION_PATH);
        sprintSynchronisationPath = PathUtils.removeAllUnnecessarySpaces((String)sprintSynchronisationPath);
        for (String existingPath : existingPaths) {
            if (sprintSynchronisationPath.equals(existingPath)) {
                throw new PathAlreadyInUseException(SPRINT_SYNCHRONISATION_PATH);
            }
            if (!(sprintSynchronisationPath + "/").startsWith(existingPath + "/")) continue;
            throw new PathContainsASprintGroupException(SPRINT_SYNCHRONISATION_PATH);
        }
    }

    private Set<String> getExistingPaths(String projectName, String key) {
        List<String> allOptions = this.customRemoteSynchronisationDao.findAllRemoteSynchronisationOptionsFromProjectName(projectName);
        return allOptions.stream().map(json -> this.getCleanPath((String)json, key)).collect(Collectors.toSet());
    }

    private String getCleanPath(String json, String key) {
        String valueFromKey = JSONUtils.getValueFromKey(json, key);
        return PathUtils.removeAllUnnecessarySpaces((String)valueFromKey);
    }

    @Override
    @UsedInPlugin(value="Xsquash4Jira & Xsquash4GitLab")
    public void validatePathForRequirementSync(String projectName, String synchronisationPath) throws RequiredFieldException, PathValidationDomainException, PathAlreadyInUseException {
        Long id;
        if (StringUtils.isBlank((CharSequence)synchronisationPath)) {
            throw new RequiredFieldException("path");
        }
        if (!PathUtils.isPathSyntaxValid((String)synchronisationPath)) {
            throw new PathValidationDomainException(SYNCHRONISATION_PATH);
        }
        this.checkPathAvailability(projectName, synchronisationPath);
        String fullSynchronisationPath = PathUtils.appendPathToProjectName((String)projectName, (String)synchronisationPath);
        Long l = id = StringUtils.isBlank((CharSequence)fullSynchronisationPath) ? null : this.requirementLibraryNodeDao.findNodeIdByPath(fullSynchronisationPath);
        if (id != null) {
            throw new PathAlreadyInUseException(SYNCHRONISATION_PATH);
        }
    }

    @Override
    @UsedInPlugin(value="Xsquash4Jira & Xsquash4GitLab")
    public void validatePathForSprintSync(String projectName, String sprintSynchronisationPath) {
        boolean pathContainsASprintGroup;
        if (StringUtils.isBlank((CharSequence)sprintSynchronisationPath)) {
            throw new RequiredFieldException("path");
        }
        if (!PathUtils.isPathSyntaxValid((String)sprintSynchronisationPath)) {
            throw new PathValidationDomainException(SPRINT_SYNCHRONISATION_PATH);
        }
        this.checkSprintPathAvailability(projectName, sprintSynchronisationPath);
        String fullSprintSynchronisationPath = PathUtils.appendPathToProjectName((String)projectName, (String)sprintSynchronisationPath);
        List<Long> nodeIds = this.campaignLibraryNodeDao.findNodeIdsByPath(Collections.singletonList(fullSprintSynchronisationPath));
        boolean bl = pathContainsASprintGroup = !this.sprintGroupDao.findIdsByClnIds(nodeIds).isEmpty();
        if (pathContainsASprintGroup) {
            throw new PathContainsASprintGroupException(SPRINT_SYNCHRONISATION_PATH);
        }
    }
}

