/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListProjectBindingType;
import org.squashtest.tm.domain.infolist.SystemInfoListCode;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.exception.pivotformatimport.CouldNotBindInfoListDuringImportException;
import org.squashtest.tm.exception.projectimport.MultipleInfoListProjectBindingTypeException;
import org.squashtest.tm.service.infolist.InfoListBindingManagerService;
import org.squashtest.tm.service.infolist.InfoListManagerService;
import org.squashtest.tm.service.internal.dto.pivotdefinition.InfoListPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotMetaDataModel;
import org.squashtest.tm.service.internal.dto.projectimporter.ProjectIdsReferences;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AbstractPivotImport;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotImportStrategy;
import org.squashtest.tm.service.internal.repository.InfoListDao;
import org.squashtest.tm.service.internal.repository.hibernate.InfoListDaoImpl;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.InfoListPivotImporterService;

@Service
public class InfoListPivotImporterServiceImpl
extends AbstractPivotImport
implements InfoListPivotImporterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoListPivotImporterService.class);
    private final InfoListDao infoListDao;
    private final AdminPivotConverterService adminPivotConverterService;
    private final InfoListManagerService infoListManagerService;
    private final InfoListBindingManagerService infoListBindingManagerService;
    @PersistenceContext
    private EntityManager entityManager;

    public InfoListPivotImporterServiceImpl(InfoListDao infoListDao, AdminPivotConverterService adminPivotConverterService, InfoListManagerService infoListManagerService, InfoListBindingManagerService infoListBindingManagerService) {
        super(LOGGER);
        this.infoListDao = infoListDao;
        this.adminPivotConverterService = adminPivotConverterService;
        this.infoListManagerService = infoListManagerService;
        this.infoListBindingManagerService = infoListBindingManagerService;
    }

    @Override
    public List<InfoListPivot> getInfoListPivotListFromZis(ZipInputStream zis) throws IOException {
        ArrayList<InfoListPivot> infoListPivotList = new ArrayList<InfoListPivot>();
        this.parseEntities(zis, JsonImportFile.INFO_LISTS, JsonImportFile.INFO_LISTS.getJsonFieldKind(), InfoListPivot.class, infoListPivotList::add);
        return infoListPivotList;
    }

    @Override
    public void checkUsedInfoList(List<InfoListPivot> infoListPivotList, Long projectId, PivotMetaDataModel pivotMetaDataModel) {
        Map<InfoListProjectBindingType, List<String>> infoListPivotCodeByType = this.getInfoListCodesByBindingType(infoListPivotList);
        this.checkMultipleInfoListProjectBindingType(infoListPivotCodeByType);
        Map infoListCodeByType = this.infoListDao.findAllUsedInfoListCodeByProjectId(projectId);
        infoListCodeByType.entrySet().stream().filter(entry -> {
            String code = ((InfoListDaoImpl.InfoListInfo)entry.getValue()).code();
            InfoListProjectBindingType type = (InfoListProjectBindingType)entry.getKey();
            return infoListPivotCodeByType.containsKey(type) && !((String)((List)infoListPivotCodeByType.get(type)).getFirst()).equals(code);
        }).forEach(entry -> {
            boolean isSystem = SystemInfoListCode.isSystem((String)((InfoListDaoImpl.InfoListInfo)entry.getValue()).code());
            pivotMetaDataModel.addPivotReportInfoList((InfoListProjectBindingType)entry.getKey(), ((InfoListDaoImpl.InfoListInfo)entry.getValue()).label(), ((InfoListDaoImpl.InfoListInfo)entry.getValue()).code(), isSystem);
        });
    }

    private Map<InfoListProjectBindingType, List<String>> getInfoListCodesByBindingType(List<InfoListPivot> infoListPivotList) {
        Map<InfoListProjectBindingType, List<String>> infoListCodesByBindingType = infoListPivotList.stream().flatMap(pivot -> pivot.getBoundProjectInfoLists().stream().map(type -> new AbstractMap.SimpleEntry<InfoListProjectBindingType, InfoListPivot>((InfoListProjectBindingType)type, (InfoListPivot)pivot))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(entry -> ((InfoListPivot)entry.getValue()).getCode(), Collectors.toList())));
        this.provideSystemInfoList(infoListCodesByBindingType, InfoListProjectBindingType.REQUIREMENT_CATEGORY);
        this.provideSystemInfoList(infoListCodesByBindingType, InfoListProjectBindingType.TEST_CASE_NATURE);
        this.provideSystemInfoList(infoListCodesByBindingType, InfoListProjectBindingType.TEST_CASE_TYPE);
        return infoListCodesByBindingType;
    }

    private void provideSystemInfoList(Map<InfoListProjectBindingType, List<String>> infoListCodesByBindingType, InfoListProjectBindingType bindingType) {
        infoListCodesByBindingType.computeIfAbsent(bindingType, k -> List.of(bindingType.getSystemInfoListCode().getCode()));
    }

    private void checkMultipleInfoListProjectBindingType(Map<InfoListProjectBindingType, List<String>> infoListPivotCodeByType) {
        infoListPivotCodeByType.forEach((type, infoListPivots) -> {
            if (infoListPivots.size() > 1) {
                throw new MultipleInfoListProjectBindingTypeException(String.format("Multiple info list found on project binding type \"%s\"", type));
            }
        });
    }

    @Override
    public void importInfoListsFromZipArchive(ZipFile zipFile, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        PivotImportStrategy<InfoListPivot> infoListPivotStrategy = this.getInfoListPivotImporterStrategy(projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.INFO_LISTS, pivotFormatImport, pivotImportMetadata, "info lists", "info list", infoListPivotStrategy);
    }

    private PivotImportStrategy<InfoListPivot> getInfoListPivotImporterStrategy(final ProjectIdsReferences projectIdsReferences, final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<InfoListPivot>(){

            @Override
            public Class<InfoListPivot> getPivotClazz() {
                return InfoListPivot.class;
            }

            @Override
            public void create(List<InfoListPivot> entities) {
                List<InfoListPivot> newInfoListPivot = InfoListPivotImporterServiceImpl.this.getNewInfoListPivots(entities, pivotImportMetadata, projectIdsReferences, pivotFormatImport);
                InfoListPivotImporterServiceImpl.this.createInfoLists(newInfoListPivot, projectIdsReferences, pivotFormatImport, pivotImportMetadata);
            }

            @Override
            public void postCreate() {
                InfoListPivotImporterServiceImpl.this.checkMissingBindingOnInfoListConflict(pivotImportMetadata, projectIdsReferences, pivotFormatImport);
            }

            @Override
            public void onMissingFile() {
                InfoListPivotImporterServiceImpl.this.bindSystemInfoListOnInfoListConflicts(pivotImportMetadata.getInfoListsToOverride(), projectIdsReferences, pivotFormatImport, pivotImportMetadata);
            }
        };
    }

    private List<InfoListPivot> getNewInfoListPivots(List<InfoListPivot> infoListPivots, PivotImportMetadata pivotImportMetadata, ProjectIdsReferences projectIdsReferences, PivotFormatImport pivotFormatImport) {
        List<String> codes = infoListPivots.stream().map(InfoListPivot::getCode).toList();
        List<InfoList> infoLists = this.infoListDao.findByCodes(codes);
        ArrayList<InfoListPivot> newInfoList = new ArrayList<InfoListPivot>();
        for (InfoListPivot infoListPivot : infoListPivots) {
            InfoList existingInfoList = infoLists.stream().filter(infoList -> infoList.getCode().equals(infoListPivot.getCode())).findFirst().orElse(null);
            if (Objects.nonNull(existingInfoList)) {
                InfoListPivotImporterServiceImpl.logInfoListAlreadyExistsInSquash(infoListPivot, pivotFormatImport);
                this.addInfoListBindingsToProject(existingInfoList, projectIdsReferences, infoListPivot.getBoundProjectInfoLists(), pivotFormatImport, pivotImportMetadata);
                continue;
            }
            newInfoList.add(infoListPivot);
        }
        return newInfoList;
    }

    private void createInfoLists(List<InfoListPivot> infoListPivotList, ProjectIdsReferences projectIdsReferences, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        HashMap<InfoListPivot, InfoList> createdInfoListByInfoListPivot = new HashMap<InfoListPivot, InfoList>();
        for (InfoListPivot infoListPivot2 : infoListPivotList) {
            this.createInfoList(pivotFormatImport, infoListPivot2, createdInfoListByInfoListPivot);
        }
        createdInfoListByInfoListPivot.forEach((infoListPivot, infoList) -> this.addInfoListBindingsToProject((InfoList)infoList, projectIdsReferences, infoListPivot.getBoundProjectInfoLists(), pivotFormatImport, pivotImportMetadata));
        infoListPivotList.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void createInfoList(PivotFormatImport pivotFormatImport, InfoListPivot infoListPivot, Map<InfoListPivot, InfoList> createdInfoListByInfoListPivot) {
        PivotFormatLoggerHelper.logEntityCreationStarted(LOGGER, "info list", infoListPivot.getPivotId(), pivotFormatImport);
        try {
            InfoList convertedInfoList = this.adminPivotConverterService.pivotToInfoList(infoListPivot);
            InfoList infoList = this.infoListManagerService.persistUnsecured(convertedInfoList);
            createdInfoListByInfoListPivot.put(infoListPivot, infoList);
            PivotFormatLoggerHelper.logEntityCreatedSuccessfully(LOGGER, "info list", infoListPivot.getLabel(), infoListPivot.getPivotId(), pivotFormatImport);
        }
        catch (Exception e) {
            PivotFormatLoggerHelper.handleEntityCreationFailed(LOGGER, "info list", infoListPivot.getLabel(), infoListPivot.getPivotId(), pivotFormatImport, e);
        }
    }

    private void addInfoListBindingsToProject(InfoList infoList, ProjectIdsReferences projectIdsReferences, List<InfoListProjectBindingType> infoListProjectBindingTypes, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        InfoListPivotImporterServiceImpl.logAddInfoListBindings(infoList, projectIdsReferences, pivotFormatImport);
        if (infoListProjectBindingTypes.isEmpty()) {
            return;
        }
        infoListProjectBindingTypes.forEach(infoListProjectBindingType -> this.addAddInfoListBidingToProject(infoList, projectIdsReferences, pivotFormatImport, (InfoListProjectBindingType)infoListProjectBindingType, pivotImportMetadata));
    }

    private void addAddInfoListBidingToProject(InfoList infoList, ProjectIdsReferences projectIdsReferences, PivotFormatImport pivotFormatImport, InfoListProjectBindingType infoListProjectBindingType, PivotImportMetadata pivotImportMetadata) {
        if (pivotImportMetadata.getCurrentInfoListBinding().contains(infoListProjectBindingType)) {
            String message = String.format("Import Id: %s - Project id: %s - an info list is already bound to project to %s", pivotFormatImport.getId(), projectIdsReferences.getId(), infoListProjectBindingType.name());
            throw new CouldNotBindInfoListDuringImportException(message);
        }
        try {
            switch (infoListProjectBindingType) {
                case REQUIREMENT_CATEGORY: {
                    this.infoListBindingManagerService.bindListToProjectReqCategory(infoList.getId(), projectIdsReferences.getId());
                    break;
                }
                case TEST_CASE_NATURE: {
                    this.infoListBindingManagerService.bindListToProjectTcNature(infoList.getId(), projectIdsReferences.getId());
                    break;
                }
                case TEST_CASE_TYPE: {
                    this.infoListBindingManagerService.bindListToProjectTcType(infoList.getId(), projectIdsReferences.getId());
                }
            }
            pivotImportMetadata.addCurrentInfoListBinding(infoListProjectBindingType);
        }
        catch (Exception e) {
            String message = String.format("Import Id: %s - Project id: %s - Failed to add info list binding \"%s\" for the info list \"%s\"", pivotFormatImport.getId(), projectIdsReferences.getId(), infoListProjectBindingType, infoList.getLabel());
            LOGGER.error(message, new Object[0]);
            throw new CouldNotBindInfoListDuringImportException(message, (Throwable)e);
        }
    }

    private static void logAddInfoListBindings(InfoList infoList, ProjectIdsReferences projectIdsReferences, PivotFormatImport pivotFormatImport) {
        LOGGER.info("Import Id: {} - Adding info list bindings to project (id: {}) for the info list \"{}\"", new Object[]{pivotFormatImport.getId(), projectIdsReferences.getId(), infoList.getLabel()});
    }

    private void checkMissingBindingOnInfoListConflict(PivotImportMetadata pivotImportMetadata, ProjectIdsReferences projectIdsReferences, PivotFormatImport pivotFormatImport) {
        if (pivotImportMetadata.getCurrentInfoListBinding().size() == 3) {
            return;
        }
        List<InfoListProjectBindingType> missingInfoListBinding = pivotImportMetadata.getInfoListsToOverride().stream().filter(infoListType -> !pivotImportMetadata.getCurrentInfoListBinding().contains(infoListType)).toList();
        this.bindSystemInfoListOnInfoListConflicts(missingInfoListBinding, projectIdsReferences, pivotFormatImport, pivotImportMetadata);
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void bindSystemInfoListOnInfoListConflicts(List<InfoListProjectBindingType> infoListTypesToOverride, ProjectIdsReferences projectIdsReferences, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        if (infoListTypesToOverride.isEmpty()) {
            return;
        }
        Map<InfoListProjectBindingType, InfoList> systemInfoListByBindingType = this.infoListDao.findAllInfoListSystem().stream().collect(Collectors.toMap(infoList -> InfoListProjectBindingType.fromSystemInfoListCode((String)infoList.getCode()), infoList -> infoList));
        infoListTypesToOverride.forEach(infoListType -> this.addAddInfoListBidingToProject((InfoList)systemInfoListByBindingType.get(infoListType), projectIdsReferences, pivotFormatImport, (InfoListProjectBindingType)infoListType, pivotImportMetadata));
    }

    private static void logInfoListAlreadyExistsInSquash(InfoListPivot infoListPivot, PivotFormatImport pivotFormatImport) {
        LOGGER.info("InfoListPivotImporterService - Import id {} - Info list \"{}\" with internal id {} already exists in Squash. Import will use the existing info list for entity bindings", new Object[]{pivotFormatImport.getId(), infoListPivot.getLabel(), infoListPivot.getPivotId()});
    }
}

