/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter;

import java.util.Arrays;
import org.squashtest.tm.domain.EntityType;

public enum AttachmentPivotType {
    TEST_CASE_FOLDER("test_case_folders", "test case folder"),
    TEST_CASE("test_cases", "test case"),
    REQUIREMENT_FOLDER("requirement_folders", "requirement folder"),
    REQUIREMENT_VERSION("requirement_versions", "requirement version"),
    CAMPAIGN_FOLDER("campaign_folders", "campaign folder"),
    SPRINT("sprints", "sprint"),
    SPRINT_GROUP("sprint_groups", "sprint group"),
    CAMPAIGN("campaigns", "campaign"),
    ITERATION("iterations", "iteration"),
    TEST_SUITE("test_suites", "test suite"),
    EXECUTION("executions", "execution"),
    EXECUTION_STEP("executions", "execution step"),
    ACTION_TEST_STEP("test_cases", "action test step");

    private final String directoryName;
    private final String simpleName;

    private AttachmentPivotType(String directoryName, String simpleName) {
        this.directoryName = directoryName;
        this.simpleName = simpleName;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public static AttachmentPivotType getAttachmentPivotTypeFromEntityType(EntityType entityType) {
        return Arrays.stream(AttachmentPivotType.values()).filter(directory -> directory.name().equalsIgnoreCase(entityType.name())).findFirst().orElseThrow(() -> new IllegalArgumentException("This entity has an entity type that is not handled " + String.valueOf(entityType)));
    }
}

