/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record7;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotEntity;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.CustomFieldValuePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.TestSuitePivot;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.PivotSubElementRecordProcessor;
import org.squashtest.tm.service.pivot.converters.ExecutionWorkspaceConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.CustomFieldPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.TestSuitePivotDao;

@Repository
public class TestSuitePivotDaoImpl
implements TestSuitePivotDao {
    private final DSLContext dsl;
    private final CustomFieldPivotDao customFieldPivotDao;
    private final ExecutionWorkspaceConverterService executionWorkspaceConverterService;

    public TestSuitePivotDaoImpl(DSLContext dsl, CustomFieldPivotDao customFieldPivotDao, ExecutionWorkspaceConverterService executionWorkspaceConverterService) {
        this.dsl = dsl;
        this.customFieldPivotDao = customFieldPivotDao;
        this.executionWorkspaceConverterService = executionWorkspaceConverterService;
    }

    @Override
    public boolean hasTestSuiteByProjectId(Long projectId) {
        return this.dsl.fetchExists((Select)this.dsl.selectOne().from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).join((TableLike)Tables.ITERATION_TEST_SUITE).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION_TEST_SUITE.ITERATION_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)));
    }

    private ResultQuery<? extends Record> getCustomFieldValueTestSuiteByProjectIdQuery(Long projectId) {
        Table<Record7<Long, Long, String, String, String, String, String>> customFieldValuesTable = this.customFieldPivotDao.getCustomFieldValuesTableByProjectIdAndBindableEntity(projectId, BindableEntity.TEST_SUITE);
        return this.dsl.select((SelectField)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID, CustomFieldPivotDao.CFV_TABLE_CF_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).join((TableLike)Tables.ITERATION_TEST_SUITE).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION_TEST_SUITE.ITERATION_ID)).join(customFieldValuesTable).on(Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID.eq(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy((OrderField)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID);
    }

    @Override
    public void getTestSuiteByProjectId(Long projectId, Consumer<TestSuitePivot> objectConsumer) {
        ResultQuery<? extends Record> cufQuery = this.getCustomFieldValueTestSuiteByProjectIdQuery(projectId);
        ResultQuery resultQuery = this.dsl.select((SelectField)Tables.TEST_SUITE.ID, (SelectField)Tables.TEST_SUITE.NAME, (SelectField)Tables.TEST_SUITE.DESCRIPTION, (SelectField)Tables.TEST_SUITE.EXECUTION_STATUS, (SelectField)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID, (SelectField)Tables.ITERATION_TEST_SUITE.ITERATION_ID).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).join((TableLike)Tables.ITERATION_TEST_SUITE).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION_TEST_SUITE.ITERATION_ID)).join((TableLike)Tables.TEST_SUITE).on(Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID.eq((Field)Tables.TEST_SUITE.ID)).leftJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE.ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy((OrderField)Tables.TEST_SUITE.ID, (OrderField)Tables.TEST_SUITE_TEST_PLAN_ITEM.TEST_PLAN_ORDER).fetchSize(50);
        this.consumeTestSuites(resultQuery, cufQuery, objectConsumer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T extends Record, C extends Record> void consumeTestSuites(ResultQuery<T> resultQuery, ResultQuery<C> testSuiteCufQuery, Consumer<TestSuitePivot> writingToJsonConsumer) {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            Stream stream = resultQuery.fetchStream();
            try {
                try (Stream cufStream = testSuiteCufQuery.fetchStream();){
                    Iterator iterator = stream.iterator();
                    AbstractPivotObject testSuitePivot = null;
                    PivotSubElementRecordProcessor<CustomFieldValuePivot> cufHandler = this.getCufPivotContainer(cufStream.iterator());
                    while (iterator.hasNext()) {
                        Record record = (Record)iterator.next();
                        if (testSuitePivot == null) {
                            testSuitePivot = this.executionWorkspaceConverterService.testSuiteRecordToTestSuitePivot(record);
                            this.appendTestPlanItemToTestSuitePivot((TestSuitePivot)testSuitePivot, record);
                            continue;
                        }
                        Long mainEntityId = testSuitePivot.pivotIdToSquashId();
                        if (!mainEntityId.equals(record.get((Field)Tables.TEST_SUITE.ID))) {
                            ((AbstractPivotEntity)testSuitePivot).addAllCustomFields(cufHandler.getPivotSubElements(mainEntityId));
                            writingToJsonConsumer.accept((TestSuitePivot)testSuitePivot);
                            testSuitePivot = this.executionWorkspaceConverterService.testSuiteRecordToTestSuitePivot(record);
                            this.appendTestPlanItemToTestSuitePivot((TestSuitePivot)testSuitePivot, record);
                            continue;
                        }
                        this.appendTestPlanItemToTestSuitePivot((TestSuitePivot)testSuitePivot, record);
                    }
                    if (testSuitePivot != null) {
                        ((AbstractPivotEntity)testSuitePivot).addAllCustomFields(cufHandler.getPivotSubElements(testSuitePivot.pivotIdToSquashId()));
                        writingToJsonConsumer.accept((TestSuitePivot)testSuitePivot);
                    }
                }
                if (stream == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (stream == null) throw throwable;
                stream.close();
                throw throwable;
            }
            stream.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void appendTestPlanItemToTestSuitePivot(TestSuitePivot testSuitePivot, Record record) {
        if (record.get((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID) != null) {
            testSuitePivot.addTestPlanItemBinding((Long)record.get((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID));
        }
    }

    private <R extends Record> PivotSubElementRecordProcessor<CustomFieldValuePivot> getCufPivotContainer(Iterator<R> iterator) {
        return new PivotSubElementRecordProcessor<CustomFieldValuePivot>(iterator, (Field<Long>)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID, CustomFieldPivotDao.CFV_TABLE_CF_ID, this.customFieldPivotDao::cufValueRecordToCufValuePivot);
    }
}

