/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jooq.Field;
import org.jooq.Record;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;

public class PivotSubElementRecordProcessor<T extends AbstractPivotObject> {
    private PivotSubElementContainer<T> pivotSubElementContainer;
    private final Iterator<? extends Record> recordIterator;
    private final Field<Long> mainPivotEntityIdField;
    private final Field<Long> subElementIdField;
    private final Function<Record, T> converterToPivot;
    private final BiConsumer<T, Record> appendSubElementToPivotSubElement;

    public PivotSubElementRecordProcessor(Iterator<? extends Record> recordIterator, Field<Long> mainPivotEntityIdField, Field<Long> subElementIdField, Function<Record, T> converterToPivot) {
        this.recordIterator = recordIterator;
        this.mainPivotEntityIdField = mainPivotEntityIdField;
        this.subElementIdField = subElementIdField;
        this.converterToPivot = converterToPivot;
        this.appendSubElementToPivotSubElement = (a, b) -> {};
        this.pivotSubElementContainer = this.getNewPivotSubElementContainerFromRecord();
    }

    public PivotSubElementRecordProcessor(Iterator<? extends Record> recordIterator, Field<Long> mainPivotEntityIdField, Field<Long> subElementIdField, Function<Record, T> converterToPivot, BiConsumer<T, Record> appendSubElementToPivotSubElement) {
        this.recordIterator = recordIterator;
        this.mainPivotEntityIdField = mainPivotEntityIdField;
        this.subElementIdField = subElementIdField;
        this.converterToPivot = converterToPivot;
        this.appendSubElementToPivotSubElement = appendSubElementToPivotSubElement;
        this.pivotSubElementContainer = this.getNewPivotSubElementContainerFromRecord();
    }

    public List<T> getPivotSubElements(Long mainPivotEntityIdField, boolean isLast) {
        if (this.pivotSubElementContainer != null && mainPivotEntityIdField.equals(this.pivotSubElementContainer.mainPivotEntityId())) {
            ArrayList<T> elements = new ArrayList<T>(this.pivotSubElementContainer.pivotSubElements());
            this.pivotSubElementContainer.pivotSubElements().clear();
            if (!isLast) {
                this.pivotSubElementContainer = this.getNewPivotSubElementContainerFromRecord();
            }
            return elements;
        }
        return Collections.emptyList();
    }

    public List<T> getPivotSubElements(Long mainPivotEntityIdField) {
        return this.getPivotSubElements(mainPivotEntityIdField, false);
    }

    public PivotSubElementContainer<T> getNewPivotSubElementContainerFromRecord() {
        ArrayList<AbstractPivotObject> pivotSubElements = new ArrayList<AbstractPivotObject>();
        AbstractPivotObject pivotSubElement = null;
        Long mainPivotEntityId = null;
        Record record = null;
        while (this.recordIterator.hasNext()) {
            if (this.pivotSubElementContainer == null && pivotSubElements.isEmpty()) {
                record = this.recordIterator.next();
                pivotSubElement = (AbstractPivotObject)this.converterToPivot.apply(record);
                mainPivotEntityId = (Long)record.get(this.mainPivotEntityIdField);
                this.appendSubElementToPivotSubElement.accept(pivotSubElement, record);
                pivotSubElements.add(pivotSubElement);
                continue;
            }
            if (pivotSubElements.isEmpty()) {
                pivotSubElement = (AbstractPivotObject)this.converterToPivot.apply(this.pivotSubElementContainer.record);
                mainPivotEntityId = (Long)this.pivotSubElementContainer.record.get(this.mainPivotEntityIdField);
                this.appendSubElementToPivotSubElement.accept(pivotSubElement, this.pivotSubElementContainer.record);
                pivotSubElements.add(pivotSubElement);
                continue;
            }
            record = this.recordIterator.next();
            if (((Long)record.get(this.subElementIdField)).equals(pivotSubElement.pivotIdToSquashId())) {
                this.appendSubElementToPivotSubElement.accept(pivotSubElement, record);
                continue;
            }
            if (mainPivotEntityId.equals(record.get(this.mainPivotEntityIdField))) {
                pivotSubElement = (AbstractPivotObject)this.converterToPivot.apply(record);
                this.appendSubElementToPivotSubElement.accept(pivotSubElement, record);
                pivotSubElements.add(pivotSubElement);
                continue;
            }
            return new PivotSubElementContainer(pivotSubElements, mainPivotEntityId, record);
        }
        if (this.pivotSubElementContainer != null && pivotSubElements.isEmpty() && this.pivotSubElementContainer.record != null) {
            pivotSubElement = (AbstractPivotObject)this.converterToPivot.apply(this.pivotSubElementContainer.record);
            mainPivotEntityId = (Long)this.pivotSubElementContainer.record.get(this.mainPivotEntityIdField);
            this.appendSubElementToPivotSubElement.accept(pivotSubElement, this.pivotSubElementContainer.record);
            pivotSubElements.add(pivotSubElement);
        }
        return new PivotSubElementContainer(pivotSubElements, mainPivotEntityId, record);
    }

    public record PivotSubElementContainer<T>(List<T> pivotSubElements, Long mainPivotEntityId, Record record) {
    }
}

