/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.Record7;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectSeekStep1;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.CampaignFolder;
import org.squashtest.tm.jooq.domain.tables.SprintGroup;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotEntity;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.FolderPivot;
import org.squashtest.tm.service.pivot.converters.FolderPivotConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.CustomFieldPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.FolderPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.TestCasePivotDao;

@Repository
public class FolderPivotDaoImpl
implements FolderPivotDao {
    private static final Field<Short> MAX_DEPTH = DSL.field((String)"max_depth", Short.class);
    private static final int BATCH_SIZE = 50;
    private final DSLContext dsl;
    private final CustomFieldPivotDao customFieldPivotDao;
    private final TestCasePivotDao testCasePivotDao;
    private final FolderPivotConverterService folderPivotConverterService;

    public FolderPivotDaoImpl(CustomFieldPivotDao customFieldPivotDao, DSLContext dsl, TestCasePivotDao testCasePivotDao, FolderPivotConverterService folderPivotConverterService) {
        this.customFieldPivotDao = customFieldPivotDao;
        this.dsl = dsl;
        this.testCasePivotDao = testCasePivotDao;
        this.folderPivotConverterService = folderPivotConverterService;
    }

    @Override
    public boolean hasRequirementFolders(Long projectId) {
        return this.dsl.fetchExists((Select)DSL.selectOne().from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).join((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RLN_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)));
    }

    @Override
    public boolean hasTestCaseFolders(Long projectId) {
        boolean hasTestCaseFolder = this.dsl.fetchExists((Select)DSL.selectOne().from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join((TableLike)Tables.TEST_CASE_FOLDER).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE_FOLDER.TCLN_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)));
        if (hasTestCaseFolder) {
            return true;
        }
        return this.testCasePivotDao.hasTestCaseOutsideProject(projectId);
    }

    @Override
    public boolean hasCampaignFolders(Long projectId) {
        return this.dsl.fetchExists((Select)DSL.selectOne().from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN_FOLDER).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_FOLDER.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)));
    }

    @Override
    public void getRequirementFoldersByProjectId(Long projectId, Consumer<FolderPivot> consumer) {
        Table<Record7<Long, Long, String, String, String, String, String>> customFieldValuesTable = this.customFieldPivotDao.getCustomFieldValuesTableByProjectIdAndBindableEntity(projectId, BindableEntity.REQUIREMENT_FOLDER);
        Table<Record2<Long, Short>> maxDepthDescendantTable = this.getMaxDepthRequirementRelationshipClosure(projectId);
        ResultQuery resultQuery = this.dsl.select((SelectField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, (SelectField)Tables.RESOURCE.NAME, (SelectField)Tables.RESOURCE.DESCRIPTION, (SelectField)Tables.RLN_RELATIONSHIP.ANCESTOR_ID, CustomFieldPivotDao.CFV_TABLE_CF_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE).from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).join((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RLN_ID)).join((TableLike)Tables.RESOURCE).on(Tables.REQUIREMENT_FOLDER.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).leftJoin((TableLike)Tables.RLN_RELATIONSHIP).on(Tables.RLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RLN_ID)).join(maxDepthDescendantTable).on(Tables.REQUIREMENT_FOLDER.RLN_ID.eq(maxDepthDescendantTable.field((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID))).leftJoin(customFieldValuesTable).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy(MAX_DEPTH, (OrderField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID).fetchSize(50);
        this.consumeFolders(resultQuery, consumer, (Field<Long>)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, EntityType.REQUIREMENT_FOLDER);
    }

    @Override
    public void getTestCaseFoldersByProjectId(Long projectId, Consumer<FolderPivot> consumer) {
        Table<Record7<Long, Long, String, String, String, String, String>> customFieldValuesTable = this.customFieldPivotDao.getCustomFieldValuesTableByProjectIdAndBindableEntity(projectId, BindableEntity.TESTCASE_FOLDER);
        Table<Record2<Long, Short>> maxDepthDescendantTable = this.getMaxDepthTestCaseRelationshipClosure(projectId);
        ResultQuery resultQuery = this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.DESCRIPTION, (SelectField)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID, CustomFieldPivotDao.CFV_TABLE_CF_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join((TableLike)Tables.TEST_CASE_FOLDER).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE_FOLDER.TCLN_ID)).leftJoin((TableLike)Tables.TCLN_RELATIONSHIP).on(Tables.TCLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_FOLDER.TCLN_ID)).join(maxDepthDescendantTable).on(Tables.TEST_CASE_FOLDER.TCLN_ID.eq(maxDepthDescendantTable.field((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID))).leftJoin(customFieldValuesTable).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy(MAX_DEPTH, (OrderField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).fetchSize(50);
        this.generateTestCaseFolderOfCalledTestCase(projectId, consumer);
        this.consumeFolders(resultQuery, consumer, (Field<Long>)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, EntityType.TEST_CASE_FOLDER);
    }

    private void generateTestCaseFolderOfCalledTestCase(Long projectId, Consumer<FolderPivot> writingToJsonConsumer) {
        CommonTableExpression<Record1<Long>> cteTestCaseWithCalledByProjectId = this.testCasePivotDao.getCteTestCaseWithCalledByProjectId(projectId);
        SelectSeekStep1 resultQuery = this.dsl.withRecursive(new CommonTableExpression[]{cteTestCaseWithCalledByProjectId}).select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID, (SelectField)Tables.PROJECT.NAME).from(cteTestCaseWithCalledByProjectId).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).join((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.notEqual((Object)projectId)).groupBy(new GroupField[]{Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID, Tables.PROJECT.PROJECT_ID, Tables.PROJECT.NAME}).orderBy((OrderField)Tables.PROJECT.PROJECT_ID);
        Throwable throwable = null;
        Object var6_7 = null;
        try (Stream stream = resultQuery.fetchStream();){
            Iterator iterator = stream.iterator();
            if (iterator.hasNext()) {
                writingToJsonConsumer.accept(this.folderPivotConverterService.mainCalledTestCaseToFolderPivot());
            }
            while (iterator.hasNext()) {
                Record record = (Record)iterator.next();
                FolderPivot folderPivot = this.folderPivotConverterService.calledTestCaseRecordToFolderPivot(record);
                writingToJsonConsumer.accept(folderPivot);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void getCampaignFoldersAndSprintGroupsByProjectId(Long projectId, Consumer<FolderPivot> consumer) {
        Table<Record7<Long, Long, String, String, String, String, String>> customFieldValuesTable = this.customFieldPivotDao.getCustomFieldValuesTableByProjectIdAndBindableEntity(projectId, BindableEntity.CAMPAIGN_FOLDER, BindableEntity.SPRINT_GROUP);
        Table<Record2<Long, Short>> maxDepthDescendantTable = this.getMaxDepthCampaignRelationshipClosure(projectId);
        CampaignFolder parentTypeCampaignFolder = Tables.CAMPAIGN_FOLDER.as("PARENT_TYPE_CAMPAIGN_FOLDER");
        SprintGroup parentTypeSprintGroup = Tables.SPRINT_GROUP.as("PARENT_TYPE_SPRINT_GROUP");
        ResultQuery resultQuery = this.dsl.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.DESCRIPTION, (SelectField)Tables.CLN_RELATIONSHIP.ANCESTOR_ID, (SelectField)DSL.when((Condition)Tables.CAMPAIGN_FOLDER.CLN_ID.isNotNull(), (Object)EntityType.CAMPAIGN_FOLDER.name()).otherwise((Object)EntityType.SPRINT_GROUP.name()).as(FolderPivotDao.CAMPAIGN_KIND), (SelectField)DSL.when((Condition)parentTypeCampaignFolder.CLN_ID.isNotNull(), (Object)EntityType.CAMPAIGN_FOLDER.name()).when(parentTypeSprintGroup.CLN_ID.isNotNull(), (Object)EntityType.SPRINT_GROUP.name()).otherwise((Object)EntityType.CAMPAIGN_LIBRARY.name()).as(FolderPivotDao.CAMPAIGN_PARENT_TYPE), CustomFieldPivotDao.CFV_TABLE_CF_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join(maxDepthDescendantTable).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq(maxDepthDescendantTable.field((Field)Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID))).leftJoin((TableLike)Tables.CAMPAIGN_FOLDER).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_FOLDER.CLN_ID)).leftJoin((TableLike)Tables.SPRINT_GROUP).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.SPRINT_GROUP.CLN_ID)).leftJoin((TableLike)Tables.CLN_RELATIONSHIP).on(Tables.CLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)parentTypeCampaignFolder).on(Tables.CLN_RELATIONSHIP.ANCESTOR_ID.eq((Field)parentTypeCampaignFolder.CLN_ID)).leftJoin((TableLike)parentTypeSprintGroup).on(Tables.CLN_RELATIONSHIP.ANCESTOR_ID.eq((Field)parentTypeSprintGroup.CLN_ID)).leftJoin(customFieldValuesTable).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).and(Tables.CAMPAIGN_FOLDER.CLN_ID.isNotNull().or(Tables.SPRINT_GROUP.CLN_ID.isNotNull())).orderBy(MAX_DEPTH, (OrderField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID).fetchSize(50);
        this.consumeFolders(resultQuery, consumer, (Field<Long>)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, EntityType.CAMPAIGN_FOLDER);
    }

    private Table<Record2<Long, Short>> getMaxDepthRequirementRelationshipClosure(Long projectId) {
        return DSL.select((SelectField)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, (SelectField)DSL.max((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH).as(MAX_DEPTH)).from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).groupBy(new GroupField[]{Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID}).asTable();
    }

    private Table<Record2<Long, Short>> getMaxDepthTestCaseRelationshipClosure(Long projectId) {
        return DSL.select((SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, (SelectField)DSL.max((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH).as(MAX_DEPTH)).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).groupBy(new GroupField[]{Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID}).asTable();
    }

    private Table<Record2<Long, Short>> getMaxDepthCampaignRelationshipClosure(Long projectId) {
        return DSL.select((SelectField)Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, (SelectField)DSL.max((Field)Tables.CLN_RELATIONSHIP_CLOSURE.DEPTH).as(MAX_DEPTH)).from((TableLike)Tables.CLN_RELATIONSHIP_CLOSURE).join((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).groupBy(new GroupField[]{Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID}).asTable();
    }

    private <T extends Record> void consumeFolders(ResultQuery<T> resultQuery, Consumer<FolderPivot> writingToJsonConsumer, Field<Long> folderIdField, EntityType entityType) {
        Throwable throwable = null;
        Object var6_7 = null;
        try (Stream stream = resultQuery.fetchStream();){
            Iterator iterator = stream.iterator();
            AbstractPivotObject folderPivot = null;
            while (iterator.hasNext()) {
                Record record = (Record)iterator.next();
                if (folderPivot == null) {
                    folderPivot = this.folderPivotConverterService.folderRecordToFolderPivot(record, entityType);
                    this.customFieldPivotDao.appendCustomFieldValuesFromRecord(((AbstractPivotEntity)folderPivot).getCustomFields(), record);
                    continue;
                }
                if (!folderPivot.pivotIdToSquashId().equals(record.get(folderIdField))) {
                    writingToJsonConsumer.accept((FolderPivot)folderPivot);
                    folderPivot = this.folderPivotConverterService.folderRecordToFolderPivot(record, entityType);
                    this.customFieldPivotDao.appendCustomFieldValuesFromRecord(((AbstractPivotEntity)folderPivot).getCustomFields(), record);
                    continue;
                }
                this.customFieldPivotDao.appendCustomFieldValuesFromRecord(((AbstractPivotEntity)folderPivot).getCustomFields(), record);
            }
            if (folderPivot != null) {
                writingToJsonConsumer.accept((FolderPivot)folderPivot);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

