/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jooq.AggregateFunction;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record7;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.pivotdefinition.CustomFieldPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.CustomFieldValuePivot;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.CustomFieldPivotDao;

@Repository
public class CustomFieldPivotDaoImpl
implements CustomFieldPivotDao {
    private static final String SEPARATOR = ",";
    private static final Field<String> BOUND_ENTITIES = Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY.as("boundEntities");
    private final DSLContext dslContext;
    private final AdminPivotConverterService adminPivotConverterService;

    public CustomFieldPivotDaoImpl(DSLContext dsl, AdminPivotConverterService adminPivotConverterService) {
        this.dslContext = dsl;
        this.adminPivotConverterService = adminPivotConverterService;
    }

    @Override
    public List<CustomFieldPivot> getCustomFieldsByProjectId(Long projectId) {
        Map resultAsMap = this.dslContext.select((SelectField)Tables.CUSTOM_FIELD.CF_ID, (SelectField)Tables.CUSTOM_FIELD.NAME, (SelectField)Tables.CUSTOM_FIELD.OPTIONAL, (SelectField)Tables.CUSTOM_FIELD.LABEL, (SelectField)Tables.CUSTOM_FIELD.INPUT_TYPE, (SelectField)Tables.CUSTOM_FIELD.CODE, (SelectField)Tables.CUSTOM_FIELD.DEFAULT_VALUE, (SelectField)Tables.CUSTOM_FIELD.LARGE_DEFAULT_VALUE, (SelectField)Tables.CUSTOM_FIELD.NUMERIC_DEFAULT_VALUE, (SelectField)Tables.CUSTOM_FIELD_OPTION.CF_ID, (SelectField)Tables.CUSTOM_FIELD_OPTION.LABEL, (SelectField)Tables.CUSTOM_FIELD_OPTION.CODE, (SelectField)Tables.CUSTOM_FIELD_OPTION.COLOUR, (SelectField)DSL.groupConcat((Field)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY).orderBy(new OrderField[]{Tables.CUSTOM_FIELD_BINDING.POSITION}).separator(SEPARATOR).as(BOUND_ENTITIES)).from((TableLike)Tables.CUSTOM_FIELD).join((TableLike)Tables.CUSTOM_FIELD_BINDING).on(Tables.CUSTOM_FIELD.CF_ID.eq((Field)Tables.CUSTOM_FIELD_BINDING.CF_ID)).leftJoin((TableLike)Tables.CUSTOM_FIELD_OPTION).on(Tables.CUSTOM_FIELD.CF_ID.eq((Field)Tables.CUSTOM_FIELD_OPTION.CF_ID).and(Tables.CUSTOM_FIELD.INPUT_TYPE.notEqual((Object)InputType.TAG.name()))).where(Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID.eq((Object)projectId)).groupBy(new GroupField[]{Tables.CUSTOM_FIELD.CF_ID, Tables.CUSTOM_FIELD_OPTION.CF_ID, Tables.CUSTOM_FIELD_OPTION.LABEL, Tables.CUSTOM_FIELD_OPTION.POSITION, Tables.CUSTOM_FIELD_OPTION.CODE, Tables.CUSTOM_FIELD_OPTION.COLOUR}).fetch().intoGroups(Arrays.asList(Tables.CUSTOM_FIELD.CF_ID, Tables.CUSTOM_FIELD.NAME, Tables.CUSTOM_FIELD.OPTIONAL, Tables.CUSTOM_FIELD.LABEL, Tables.CUSTOM_FIELD.INPUT_TYPE, Tables.CUSTOM_FIELD.CODE, Tables.CUSTOM_FIELD.DEFAULT_VALUE, Tables.CUSTOM_FIELD.LARGE_DEFAULT_VALUE, Tables.CUSTOM_FIELD.NUMERIC_DEFAULT_VALUE).toArray(new Field[0]));
        return this.toCustomFieldPivotList(resultAsMap);
    }

    @Override
    public Table<Record7<Long, Long, String, String, String, String, String>> getCustomFieldValuesTableByProjectIdAndBindableEntity(Long projectId, BindableEntity ... bindableEntity) {
        List<String> bindableEntityNames = Arrays.stream(bindableEntity).map(Enum::name).toList();
        AggregateFunction tagValue = DSL.groupConcat((Field)Tables.CUSTOM_FIELD_VALUE_OPTION.LABEL).orderBy(new OrderField[]{Tables.CUSTOM_FIELD_VALUE_OPTION.POSITION}).separator("|");
        return DSL.select((SelectField)Tables.CUSTOM_FIELD.CF_ID.as(CustomFieldPivotDao.CFV_TABLE_CF_ID), (SelectField)Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.as(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID), (SelectField)DSL.when((Condition)Tables.CUSTOM_FIELD.INPUT_TYPE.eq((Object)InputType.RICH_TEXT.name()), (Field)Tables.CUSTOM_FIELD_VALUE.LARGE_VALUE).when(Tables.CUSTOM_FIELD.INPUT_TYPE.eq((Object)InputType.TAG.name()), (Field)tagValue).otherwise((Field)Tables.CUSTOM_FIELD_VALUE.VALUE).as(CustomFieldPivotDao.CFV_TABLE_CF_VALUE), (SelectField)Tables.CUSTOM_FIELD.DEFAULT_VALUE, (SelectField)Tables.CUSTOM_FIELD.LARGE_DEFAULT_VALUE, (SelectField)Tables.CUSTOM_FIELD_VALUE.LARGE_VALUE, (SelectField)Tables.CUSTOM_FIELD_VALUE.VALUE).from((TableLike)Tables.CUSTOM_FIELD_VALUE).join((TableLike)Tables.CUSTOM_FIELD_BINDING).on(Tables.CUSTOM_FIELD_VALUE.CFB_ID.eq((Field)Tables.CUSTOM_FIELD_BINDING.CFB_ID)).join((TableLike)Tables.CUSTOM_FIELD).on(Tables.CUSTOM_FIELD_BINDING.CF_ID.eq((Field)Tables.CUSTOM_FIELD.CF_ID)).leftJoin((TableLike)Tables.CUSTOM_FIELD_VALUE_OPTION).on(Tables.CUSTOM_FIELD_VALUE.CFV_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE_OPTION.CFV_ID)).where(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE.in(bindableEntityNames)).and(Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID.eq((Object)projectId)).groupBy(new GroupField[]{Tables.CUSTOM_FIELD_VALUE.CFV_ID, Tables.CUSTOM_FIELD.INPUT_TYPE, Tables.CUSTOM_FIELD.CF_ID}).having(DSL.when((Condition)Tables.CUSTOM_FIELD.INPUT_TYPE.eq((Object)InputType.RICH_TEXT.name()), (Field)Tables.CUSTOM_FIELD.LARGE_DEFAULT_VALUE.notEqual((Field)Tables.CUSTOM_FIELD_VALUE.LARGE_VALUE)).when(Tables.CUSTOM_FIELD.INPUT_TYPE.eq((Object)InputType.TAG.name()), (Field)Tables.CUSTOM_FIELD.DEFAULT_VALUE.notEqual((Field)tagValue)).otherwise((Field)Tables.CUSTOM_FIELD.DEFAULT_VALUE.notEqual((Field)Tables.CUSTOM_FIELD_VALUE.VALUE))).asTable();
    }

    private List<CustomFieldPivot> toCustomFieldPivotList(Map<Record, ? extends Result<?>> resultAsMap) {
        ArrayList<CustomFieldPivot> customFieldPivotList = new ArrayList<CustomFieldPivot>();
        resultAsMap.entrySet().forEach(cufAttributes -> {
            CustomFieldPivot customFieldPivot = this.toCustomFieldPivot((Map.Entry<Record, ? extends Result<?>>)cufAttributes);
            customFieldPivotList.add(customFieldPivot);
        });
        return customFieldPivotList;
    }

    private CustomFieldPivot toCustomFieldPivot(Map.Entry<Record, ? extends Result<?>> cufAttributes) {
        CustomFieldPivot customFieldPivot = new CustomFieldPivot();
        customFieldPivot.setPivotId((Long)cufAttributes.getKey().get((Field)Tables.CUSTOM_FIELD.CF_ID));
        customFieldPivot.setName((String)cufAttributes.getKey().get((Field)Tables.CUSTOM_FIELD.NAME));
        customFieldPivot.setLabel((String)cufAttributes.getKey().get((Field)Tables.CUSTOM_FIELD.LABEL));
        customFieldPivot.setCode((String)cufAttributes.getKey().get((Field)Tables.CUSTOM_FIELD.CODE));
        customFieldPivot.setDefaultValue(this.getDefaultValue(cufAttributes));
        customFieldPivot.setOptional((Boolean)cufAttributes.getKey().get((Field)Tables.CUSTOM_FIELD.OPTIONAL));
        customFieldPivot.setInputType(InputType.valueOf((String)((String)cufAttributes.getKey().get((Field)Tables.CUSTOM_FIELD.INPUT_TYPE))));
        customFieldPivot.setBoundEntities(this.getBoundEntities(cufAttributes));
        customFieldPivot.setOptions(this.getCufOptions(cufAttributes));
        return customFieldPivot;
    }

    private String getDefaultValue(Map.Entry<Record, ? extends Result<?>> cufAttributes) {
        if (InputType.RICH_TEXT.name().equals(cufAttributes.getKey().get((Field)Tables.CUSTOM_FIELD.INPUT_TYPE))) {
            return (String)cufAttributes.getKey().get((Field)Tables.CUSTOM_FIELD.LARGE_DEFAULT_VALUE);
        }
        return (String)cufAttributes.getKey().get((Field)Tables.CUSTOM_FIELD.DEFAULT_VALUE);
    }

    private List<BindableEntity> getBoundEntities(Map.Entry<Record, ? extends Result<?>> cufAttributes) {
        return Arrays.stream(((String)((Record)cufAttributes.getValue().getFirst()).get(BOUND_ENTITIES)).split(SEPARATOR)).map(BindableEntity::valueOf).toList();
    }

    private List<CustomFieldPivot.Option> getCufOptions(Map.Entry<Record, ? extends Result<?>> cufAttributes) {
        return cufAttributes.getValue().stream().filter(value -> Objects.nonNull(value.get((Field)Tables.CUSTOM_FIELD_OPTION.CF_ID))).map(value -> {
            CustomFieldPivot.Option option = new CustomFieldPivot.Option();
            option.setName((String)value.get((Field)Tables.CUSTOM_FIELD_OPTION.LABEL));
            option.setCode((String)value.get((Field)Tables.CUSTOM_FIELD_OPTION.CODE));
            option.setColor((String)value.get((Field)Tables.CUSTOM_FIELD_OPTION.COLOUR));
            return option;
        }).toList();
    }

    @Override
    public void appendCustomFieldValuesFromRecord(List<CustomFieldValuePivot> customFieldValues, Record record) {
        if (record.get(CustomFieldPivotDao.CFV_TABLE_CF_ID) == null) {
            return;
        }
        customFieldValues.add(this.adminPivotConverterService.customFieldValueRecordToCustomFieldValuePivot(record));
    }

    @Override
    public CustomFieldValuePivot cufValueRecordToCufValuePivot(Record record) {
        return this.adminPivotConverterService.customFieldValueRecordToCustomFieldValuePivot(record);
    }
}

