/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.springframework.stereotype.Service;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.pivot.PivotFileManager;
import org.squashtest.tm.service.pivot.projectexporter.InfoListPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.InfoListPivotDao;

@Service
public class InfoListPivotExporterServiceImpl
implements InfoListPivotExporterService {
    private final InfoListPivotDao infoListPivotDao;
    private final PivotFileManager pivotFileManager;

    public InfoListPivotExporterServiceImpl(InfoListPivotDao infoListPivotDao, PivotFileManager pivotFileManager) {
        this.infoListPivotDao = infoListPivotDao;
        this.pivotFileManager = pivotFileManager;
    }

    @Override
    public void generateInfoListsJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, Long projectId) throws IOException {
        if (!this.infoListPivotDao.hasCustomInfoListBindingByProjectId(projectId)) {
            return;
        }
        this.pivotFileManager.writeJson(jsonFactory, jsonGenerator -> this.handleInfoLists((JsonGenerator)jsonGenerator, projectId), JsonImportFile.INFO_LISTS.getFileName(), archive);
    }

    private void handleInfoLists(JsonGenerator jsonGenerator, Long projectId) throws IOException {
        jsonGenerator.writeFieldName("info_lists");
        jsonGenerator.writeStartArray();
        this.infoListPivotDao.getCustomInfoListByProjectId(projectId, this.pivotFileManager.consumerThrowingIOException(arg_0 -> ((JsonGenerator)jsonGenerator).writeObject(arg_0)));
        jsonGenerator.writeEndArray();
    }
}

