/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter;

import com.fasterxml.jackson.core.JsonFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.service.internal.pivot.projectexporter.exception.ExportPivotException;
import org.squashtest.tm.service.pivot.projectexporter.CustomFieldPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.ExecutionWsPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.FolderPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.GlobalProjectPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.InfoListPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.RequirementPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.TestCasePivotExporterService;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service
@Transactional
public class GlobalProjectPivotExporterServiceImpl
implements GlobalProjectPivotExporterService {
    private final CustomFieldPivotExporterService customFieldPivotExporterService;
    private final PermissionEvaluationService permissionEvaluationService;
    private final FolderPivotExporterService folderPivotExporterService;
    private final RequirementPivotExporterService requirementPivotExporterService;
    private final TestCasePivotExporterService testCasePivotExporterService;
    private final ExecutionWsPivotExporterService executionWsPivotExporterService;
    private final InfoListPivotExporterService infoListPivotExporterService;

    public GlobalProjectPivotExporterServiceImpl(CustomFieldPivotExporterService customFieldPivotExporterService, PermissionEvaluationService permissionEvaluationService, FolderPivotExporterService folderPivotExporterService, RequirementPivotExporterService requirementPivotExporterService, TestCasePivotExporterService testCasePivotExporterService, ExecutionWsPivotExporterService executionWsPivotExporterService, InfoListPivotExporterService infoListPivotExporterService) {
        this.customFieldPivotExporterService = customFieldPivotExporterService;
        this.permissionEvaluationService = permissionEvaluationService;
        this.folderPivotExporterService = folderPivotExporterService;
        this.requirementPivotExporterService = requirementPivotExporterService;
        this.testCasePivotExporterService = testCasePivotExporterService;
        this.executionWsPivotExporterService = executionWsPivotExporterService;
        this.infoListPivotExporterService = infoListPivotExporterService;
    }

    @Override
    public File exportFile(Long projectId) {
        File exportZipFile;
        this.checkCanExportPermission(projectId);
        try {
            int idTransaction = TransactionAspectSupport.currentTransactionStatus().hashCode();
            exportZipFile = File.createTempFile("project_export_" + idTransaction, ".zip");
            exportZipFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new ExportPivotException("Pivot format export - Error while creating the temporary file for export in the temp directory: ", e);
        }
        JsonFactory jsonFactory = new JsonFactory();
        try {
            Throwable throwable = null;
            Object var5_9 = null;
            try (ArchiveOutputStream archive = new ArchiveStreamFactory().createArchiveOutputStream("zip", (OutputStream)new FileOutputStream(exportZipFile));){
                this.customFieldPivotExporterService.generateCustomFieldsJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, projectId);
                this.infoListPivotExporterService.generateInfoListsJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, projectId);
                this.folderPivotExporterService.generateRequirementFolderJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, projectId);
                this.folderPivotExporterService.generateTestCaseFolderJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, projectId);
                this.folderPivotExporterService.generateCampaignFolderWithSprintGroupJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, projectId);
                this.requirementPivotExporterService.generateRequirementJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, projectId);
                this.testCasePivotExporterService.generateTestCaseJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, projectId);
                this.testCasePivotExporterService.generateCalledTestCaseJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, projectId);
                this.executionWsPivotExporterService.generateSprintJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, projectId);
                this.executionWsPivotExporterService.generateCampaignJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, projectId);
                this.executionWsPivotExporterService.generateIterationJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, projectId);
                this.executionWsPivotExporterService.generateTestSuiteJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, projectId);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ArchiveException e) {
            throw new ExportPivotException("Error during the generation the export ZIP file: ", e);
        }
        return exportZipFile;
    }

    private void checkCanExportPermission(long projectId) {
        this.permissionEvaluationService.checkPermission(Collections.singletonList(projectId), Permissions.EXPORT.name(), Project.class.getName());
    }
}

