/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;

public class DatasetPivot
extends AbstractPivotObject {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="param_values")
    private List<ParamValue> paramValues = new ArrayList<ParamValue>();

    @Override
    public String getBasePivotId() {
        return "DS";
    }

    public void setPivotId(String testCasePivotId, Integer id) {
        this.pivotId = String.format("%s_%s%s", testCasePivotId, this.getBasePivotId(), id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isParametersPresent(Map<String, String> parameters) {
        if (parameters.size() != this.paramValues.size()) {
            return false;
        }
        return this.paramValues.stream().allMatch(paramValue -> parameters.containsKey(paramValue.getName()) && ((String)parameters.get(paramValue.getName())).equals(paramValue.getValue()));
    }

    public List<ParamValue> getParamValues() {
        return this.paramValues;
    }

    public void setParamValues(List<ParamValue> paramValues) {
        this.paramValues = paramValues;
    }

    public void addParamValues(ParamValue paramValue) {
        this.paramValues.add(paramValue);
    }

    public static class ParamValue {
        @JsonProperty(value="param_id")
        private String id;
        @JsonProperty(value="value")
        private String value;
        @JsonIgnore
        private String name;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setId(Long id) {
            this.id = String.format("%s%s", "DS_P", id);
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

