/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search.filter;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.search.filter.FilterValueHandler;

@Component
public class TextFilterValueHandler
implements FilterValueHandler {
    private final Set<String> handledPrototypes = Sets.newHashSet((Object[])new String[]{"TEST_CASE_NAME", "TEST_CASE_REFERENCE", "TEST_CASE_CUF_TEXT", "REQUIREMENT_VERSION_NAME", "REQUIREMENT_VERSION_REFERENCE", "REQUIREMENT_VERSION_CUF_TEXT"});

    @Override
    public boolean canHandleGridFilterValue(GridFilterValue filter) {
        return this.handledPrototypes.contains(filter.getColumnPrototype());
    }

    @Override
    public void handleGridFilterValue(GridFilterValue filter) {
        List<String> value = filter.getValues();
        List<String> newValues = value.stream().map(this::formatValue).toList();
        filter.setValues(newValues);
    }

    private String formatValue(String value) {
        String newValue = "%" + value + "%";
        return newValue.replace(" ", "%");
    }
}

