/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.requirement;

import java.util.Arrays;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;

public class RequirementVersionModificationHistoryGrid
extends AbstractGrid {
    private final Long requirementVersionId;

    public RequirementVersionModificationHistoryGrid(Long requirementVersionId) {
        this.requirementVersionId = requirementVersionId;
    }

    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn((Field<?>)Tables.REQUIREMENT_AUDIT_EVENT.EVENT_ID), new GridColumn(Tables.REQUIREMENT_AUDIT_EVENT.EVENT_DATE.as("DATE")), new GridColumn(Tables.REQUIREMENT_AUDIT_EVENT.AUTHOR.as("USER")), new GridColumn(this.getEventTarget().as("EVENT")), new GridColumn(this.getOldValue().as("OLD_VALUE")), new GridColumn(this.getNewValue().as("NEW_VALUE")), new GridColumn(Tables.SYNC_REQUIREMENT_CREATION.SOURCE.as("SYNC_REQ_CREATION_SOURCE")), new GridColumn(Tables.SYNC_REQUIREMENT_UPDATE.SOURCE.as("SYNC_REQ_UPDATE_SOURCE")));
    }

    private Field<?> getNewValue() {
        return DSL.ifnull((Field)Tables.REQUIREMENT_PROPERTY_CHANGE.NEW_VALUE, (Field)Tables.REQUIREMENT_LARGE_PROPERTY_CHANGE.NEW_VALUE);
    }

    private Field<?> getOldValue() {
        return DSL.ifnull((Field)Tables.REQUIREMENT_PROPERTY_CHANGE.OLD_VALUE, (Field)Tables.REQUIREMENT_LARGE_PROPERTY_CHANGE.OLD_VALUE);
    }

    private Field<?> getEventTarget() {
        return DSL.ifnull((Field)Tables.REQUIREMENT_PROPERTY_CHANGE.PROPERTY_NAME, (Field)Tables.REQUIREMENT_LARGE_PROPERTY_CHANGE.PROPERTY_NAME);
    }

    @Override
    protected Table<?> getTable() {
        return Tables.REQUIREMENT_AUDIT_EVENT.leftJoin((TableLike)Tables.REQUIREMENT_PROPERTY_CHANGE).on(Tables.REQUIREMENT_PROPERTY_CHANGE.EVENT_ID.eq((Field)Tables.REQUIREMENT_AUDIT_EVENT.EVENT_ID)).leftJoin((TableLike)Tables.REQUIREMENT_LARGE_PROPERTY_CHANGE).on(Tables.REQUIREMENT_LARGE_PROPERTY_CHANGE.EVENT_ID.eq((Field)Tables.REQUIREMENT_AUDIT_EVENT.EVENT_ID)).leftJoin((TableLike)Tables.SYNC_REQUIREMENT_CREATION).on(Tables.SYNC_REQUIREMENT_CREATION.EVENT_ID.eq((Field)Tables.REQUIREMENT_AUDIT_EVENT.EVENT_ID)).leftJoin((TableLike)Tables.SYNC_REQUIREMENT_UPDATE).on(Tables.SYNC_REQUIREMENT_UPDATE.EVENT_ID.eq((Field)Tables.REQUIREMENT_AUDIT_EVENT.EVENT_ID));
    }

    @Override
    protected Field<?> getIdentifier() {
        return Tables.REQUIREMENT_AUDIT_EVENT.EVENT_ID;
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return null;
    }

    @Override
    protected Condition craftInvariantFilter() {
        return Tables.REQUIREMENT_AUDIT_EVENT.REQ_VERSION_ID.eq((Object)this.requirementVersionId);
    }
}

