/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.deletion.Node;
import org.squashtest.tm.service.deletion.NodeMovement;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.internal.campaign.LockedRequirementNodeDetectionService;
import org.squashtest.tm.service.internal.deletion.AbstractNodeDeletionHandler;
import org.squashtest.tm.service.internal.deletion.JdbcRequirementNodeDeletionHandlerFactory;
import org.squashtest.tm.service.internal.deletion.LockedRequirementNodeInferenceTree;
import org.squashtest.tm.service.internal.deletion.RequirementDeletionNode;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcRequirementNodeDeletionHandler;
import org.squashtest.tm.service.internal.repository.FolderDao;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.RequirementDeletionDao;
import org.squashtest.tm.service.internal.repository.RequirementFolderDao;
import org.squashtest.tm.service.internal.repository.RequirementLibraryDao;
import org.squashtest.tm.service.internal.repository.RequirementLibraryNodeDao;
import org.squashtest.tm.service.internal.requirement.RequirementNodeDeletionHandler;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.testcase.TestCaseImportanceManagerService;

@Component(value="squashtest.tm.service.deletion.RequirementNodeDeletionHandler")
public class RequirementDeletionHandlerImpl
extends AbstractNodeDeletionHandler<RequirementLibraryNode, RequirementFolder>
implements RequirementNodeDeletionHandler {
    private static final String REQUIREMENT = "requirement";
    private final LockedRequirementNodeDetectionService lockedNodeDetectionService;
    private final RequirementLibraryNodeDao requirementLibraryNodeDao;
    private final RequirementFolderDao folderDao;
    private final TestCaseImportanceManagerService testCaseImportanceManagerService;
    private final RequirementDao requirementDao;
    private final RequirementLibraryDao requirementLibraryDao;
    private final RequirementDeletionDao deletionDao;
    private final ActiveMilestoneHolder activeMilestoneHolder;
    private final JdbcRequirementNodeDeletionHandlerFactory requirementNodeDeletionHandler;

    public RequirementDeletionHandlerImpl(LockedRequirementNodeDetectionService lockedNodeDetectionService, RequirementLibraryNodeDao requirementLibraryNodeDao, RequirementFolderDao folderDao, TestCaseImportanceManagerService testCaseImportanceManagerService, RequirementDao requirementDao, RequirementLibraryDao requirementLibraryDao, RequirementDeletionDao deletionDao, ActiveMilestoneHolder activeMilestoneHolder, JdbcRequirementNodeDeletionHandlerFactory requirementNodeDeletionHandler, AttachmentManagerService attachmentManagerService) {
        super(attachmentManagerService);
        this.lockedNodeDetectionService = lockedNodeDetectionService;
        this.requirementLibraryNodeDao = requirementLibraryNodeDao;
        this.folderDao = folderDao;
        this.testCaseImportanceManagerService = testCaseImportanceManagerService;
        this.requirementDao = requirementDao;
        this.requirementLibraryDao = requirementLibraryDao;
        this.deletionDao = deletionDao;
        this.activeMilestoneHolder = activeMilestoneHolder;
        this.requirementNodeDeletionHandler = requirementNodeDeletionHandler;
    }

    @Override
    protected FolderDao<RequirementFolder, RequirementLibraryNode> getFolderDao() {
        return this.folderDao;
    }

    @Override
    protected List<SuppressionPreviewReport> diagnoseSuppression(List<Long> nodeIds) {
        LinkedList<SuppressionPreviewReport> preview = new LinkedList<SuppressionPreviewReport>();
        preview.addAll(this.lockedNodeDetectionService.detectLockedByMilestone(nodeIds));
        preview.addAll(this.lockedNodeDetectionService.detectLockedWithActiveMilestone(nodeIds));
        return preview;
    }

    @Override
    protected List<Long> detectLockedNodes(List<Long> nodeIds) {
        return this.diagnoseSuppression(nodeIds).stream().flatMap(report -> report.getLockedNodes().stream()).distinct().toList();
    }

    private OperationReport fixOrphans(LockedRequirementNodeInferenceTree tree) {
        OperationReport report = new OperationReport();
        Map<Long, List<Long>> requirementContents = this.requirementLibraryNodeDao.findRequirementContentIds(tree.getRequirementSources());
        Map<RequirementDeletionNode, List<Long>> orphansByNewParents = tree.identifyNewParentForOrphans(requirementContents);
        if (orphansByNewParents.isEmpty()) {
            return report;
        }
        List<Long> orphans = orphansByNewParents.values().stream().flatMap(Collection::stream).toList();
        this.deletionDao.deleteOrphanLinks(orphans);
        Map<EntityType, List<RequirementDeletionNode>> parents = orphansByNewParents.keySet().stream().collect(Collectors.groupingBy(RequirementDeletionNode::getType));
        Map<Long, Requirement> requirements = this.requirementDao.load(orphans).stream().collect(Collectors.toMap(RequirementLibraryNode::getId, Function.identity()));
        this.newFolderParent(parents, orphansByNewParents, requirements);
        this.newLibraryParent(parents, orphansByNewParents, requirements);
        this.newRequirementParent(parents, orphansByNewParents, requirements);
        for (Map.Entry<RequirementDeletionNode, List<Long>> entry : orphansByNewParents.entrySet()) {
            RequirementDeletionNode newParent = entry.getKey();
            String parentType = switch (newParent.getType()) {
                case EntityType.REQUIREMENT_LIBRARY -> "drive";
                case EntityType.REQUIREMENT_FOLDER -> "folder";
                default -> REQUIREMENT;
            };
            List<Node> movedNodesLog = entry.getValue().stream().map(child -> new Node((Long)child, REQUIREMENT)).toList();
            NodeMovement nodeMovement = new NodeMovement(new Node(newParent.getId(), parentType), movedNodesLog);
            report.addMoved(nodeMovement);
        }
        return report;
    }

    private void newRequirementParent(Map<EntityType, List<RequirementDeletionNode>> parents, Map<RequirementDeletionNode, List<Long>> orphansByNewParents, Map<Long, Requirement> requirements) {
        List requirementParents = parents.getOrDefault(EntityType.REQUIREMENT, Collections.emptyList());
        if (requirementParents.isEmpty()) {
            return;
        }
        Map parentRequirements = this.requirementDao.load(requirementParents.stream().map(RequirementDeletionNode::getId).toList()).stream().collect(Collectors.toMap(RequirementLibraryNode::getId, Function.identity()));
        for (RequirementDeletionNode requirementNode : requirementParents) {
            List<Requirement> orphans = orphansByNewParents.getOrDefault(requirementNode, Collections.emptyList()).stream().map(requirements::get).toList();
            ((Requirement)parentRequirements.get(requirementNode.getId())).getContent().addAll(orphans);
        }
    }

    private void newLibraryParent(Map<EntityType, List<RequirementDeletionNode>> parents, Map<RequirementDeletionNode, List<Long>> orphansByNewParents, Map<Long, Requirement> requirements) {
        List libraryParents = parents.getOrDefault(EntityType.REQUIREMENT_LIBRARY, Collections.emptyList());
        if (libraryParents.isEmpty()) {
            return;
        }
        Long libraryId = libraryParents.stream().map(RequirementDeletionNode::getId).toList().get(0);
        RequirementLibrary library = this.requirementLibraryDao.loadForNodeAddition(libraryId);
        List<Requirement> libraryContents = orphansByNewParents.getOrDefault(libraryParents.get(0), Collections.emptyList()).stream().map(requirements::get).toList();
        library.getContent().addAll(libraryContents);
    }

    private void newFolderParent(Map<EntityType, List<RequirementDeletionNode>> parents, Map<RequirementDeletionNode, List<Long>> orphansByNewParents, Map<Long, Requirement> requirements) {
        List folderParents = parents.getOrDefault(EntityType.REQUIREMENT_FOLDER, Collections.emptyList());
        if (folderParents.isEmpty()) {
            return;
        }
        Map folders = this.folderDao.loadForNodeAddition(folderParents.stream().map(RequirementDeletionNode::getId).toList()).stream().collect(Collectors.toMap(RequirementLibraryNode::getId, Function.identity()));
        for (RequirementDeletionNode folderNode : folderParents) {
            List<Requirement> folderContents = orphansByNewParents.getOrDefault(folderNode, Collections.emptyList()).stream().map(requirements::get).toList();
            ((RequirementFolder)folders.get(folderNode.getId())).getContent().addAll(folderContents);
        }
    }

    private LockedRequirementNodeInferenceTree buildTree(List<Long> nodeIds) {
        List<RequirementDeletionNode> nodes = this.deletionDao.findParentNode(nodeIds);
        LockedRequirementNodeInferenceTree tree = new LockedRequirementNodeInferenceTree(nodes);
        Map<Long, List<EntityReference>> folderContents = this.deletionDao.findRecursiveContentsIdsByNodeIds(tree.getFolderSources());
        tree.addFolderContents(folderContents);
        List<Long> ids = tree.collectKeys();
        List<Long> lockedIds = this.detectLockedNodes(ids);
        tree.markLockedNodes(lockedIds);
        return tree;
    }

    @Override
    public OperationReport deleteNodes(List<Long> targetIds) {
        OperationReport globalReport = new OperationReport();
        LockedRequirementNodeInferenceTree tree = this.buildTree(targetIds);
        OperationReport movedReport = this.fixOrphans(tree);
        globalReport.mergeWith(movedReport);
        OperationReport deletionReport = this.performDeletion(tree);
        globalReport.mergeWith(deletionReport);
        return globalReport;
    }

    private OperationReport performDeletion(LockedRequirementNodeInferenceTree tree) {
        JdbcRequirementNodeDeletionHandler deletionHandler;
        if (this.isMilestoneMode()) {
            Long milestoneId = this.getActiveMilestoneId();
            deletionHandler = this.requirementNodeDeletionHandler.build(tree.collectDeletableIds(), milestoneId, tree.collectLockedRequirementIds());
        } else {
            deletionHandler = this.requirementNodeDeletionHandler.build(tree.collectDeletableIds());
        }
        OperationReport deletionReport = deletionHandler.delete();
        Map<Long, TestCaseImportance> concernedTestCases = deletionHandler.getConcernedTestCases();
        if (!concernedTestCases.isEmpty()) {
            this.testCaseImportanceManagerService.changeImportanceIfRelationRemoved(concernedTestCases);
        }
        return deletionReport;
    }

    @Override
    protected OperationReport batchUnbindFromMilestone(List<Long> requirementIds) {
        OperationReport report = new OperationReport();
        if (requirementIds.isEmpty()) {
            return report;
        }
        return report;
    }

    @Override
    protected OperationReport batchDeleteNodes(List<Long> ids) {
        return null;
    }

    @Override
    protected boolean isMilestoneMode() {
        return this.activeMilestoneHolder.getActiveMilestone().isPresent();
    }

    private Long getActiveMilestoneId() {
        return this.activeMilestoneHolder.getActiveMilestone().get().getId();
    }
}

