/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.copier;

import com.google.common.collect.Lists;
import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.copier.CampaignWorkspaceCopierService;
import org.squashtest.tm.service.copier.StrategyCopierService;
import org.squashtest.tm.service.internal.copier.ChildEntityDtoResult;
import org.squashtest.tm.service.internal.repository.CampaignDao;
import org.squashtest.tm.service.internal.repository.CampaignFolderDao;
import org.squashtest.tm.service.internal.repository.CampaignLibraryDao;
import org.squashtest.tm.service.internal.repository.EntityDao;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.SprintDao;
import org.squashtest.tm.service.internal.repository.TestSuiteDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateSprintGroupDao;
import org.squashtest.tm.service.internal.repository.hibernate.utils.HibernateConfig;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service
@Transactional
public class CampaignWorkspaceStrategyCopierServiceImpl
implements StrategyCopierService {
    private static final Integer MAX_BATCH_SIZE = 50;
    private final PermissionEvaluationService permissionService;
    private final CampaignWorkspaceCopierService copierService;
    private final EntityManager entityManager;
    private final CampaignLibraryDao campaignLibraryDao;
    private final CampaignFolderDao campaignFolderDao;
    private final CampaignDao campaignDao;
    private final IterationDao iterationDao;
    private final TestSuiteDao testSuiteDao;
    private final SprintDao sprintDao;
    private final HibernateSprintGroupDao sprintGroupDao;

    public CampaignWorkspaceStrategyCopierServiceImpl(PermissionEvaluationService permissionService, CampaignWorkspaceCopierService copierService, EntityManager entityManager, CampaignLibraryDao campaignLibraryDao, CampaignFolderDao campaignFolderDao, CampaignDao campaignDao, IterationDao iterationDao, TestSuiteDao testSuiteDao, SprintDao sprintDao, HibernateSprintGroupDao sprintGroupDao) {
        this.permissionService = permissionService;
        this.copierService = copierService;
        this.entityManager = entityManager;
        this.campaignLibraryDao = campaignLibraryDao;
        this.campaignFolderDao = campaignFolderDao;
        this.campaignDao = campaignDao;
        this.iterationDao = iterationDao;
        this.testSuiteDao = testSuiteDao;
        this.sprintDao = sprintDao;
        this.sprintGroupDao = sprintGroupDao;
    }

    @Override
    public NodeType verifyPermissionAndGetNodePaste(ClipboardPayload clipboardPayload) {
        List<NodeType> nodeTypes = clipboardPayload.getSelectedNode().stream().map(NodeReference::getNodeType).distinct().toList();
        if (nodeTypes.size() > 1) {
            throw new IllegalArgumentException("Only one type of node can be copied at a time");
        }
        NodeType nodeType = nodeTypes.get(0);
        this.permissionService.checkPermission(clipboardPayload.getSelectedNodeIds(), Permissions.READ.name(), nodeType.toEntityType().getEntityClass().getName());
        return nodeType;
    }

    @Override
    public void copyNodeToCampaign(Long destinationId, ClipboardPayload clipboardPayload, NodeType nodePaste) {
        if (!NodeType.ITERATION.equals((Object)nodePaste)) {
            throw new IllegalArgumentException(String.format("Cannot paste %s in a campaign", nodePaste.getTypeName()));
        }
        this.copyNodeToContainer(Campaign.class, Iteration.class, destinationId, clipboardPayload);
    }

    @Override
    public void copyNodeToIteration(Long destinationId, ClipboardPayload clipboardPayload, NodeType nodePaste) {
        if (!NodeType.TEST_SUITE.equals((Object)nodePaste)) {
            throw new IllegalArgumentException(String.format("Cannot paste %s in an iteration", nodePaste.getTypeName()));
        }
        this.copyNodeToContainer(Iteration.class, this.testSuiteDao::loadNodeForPaste, destinationId, clipboardPayload);
    }

    @Override
    public void copyNodeToSpringGroup(Long destinationId, ClipboardPayload clipboardPayload, NodeType nodePaste) {
        switch (nodePaste) {
            case SPRINT: {
                this.copyNodeToContainer(SprintGroup.class, Sprint.class, destinationId, clipboardPayload);
                break;
            }
            case CAMPAIGN_FOLDER: {
                this.copyNodeToContainer(SprintGroup.class, CampaignFolder.class, destinationId, clipboardPayload);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Cannot paste %s in a sprint group", nodePaste.getTypeName()));
            }
        }
    }

    @Override
    public void copyNodeToCampaignFolder(Long destinationId, ClipboardPayload clipboardPayload, NodeType nodePaste) {
        switch (nodePaste) {
            case SPRINT: {
                this.copyNodeToContainer(CampaignFolder.class, Sprint.class, destinationId, clipboardPayload);
                break;
            }
            case SPRINT_GROUP: {
                this.copyNodeToContainer(CampaignFolder.class, SprintGroup.class, destinationId, clipboardPayload);
                break;
            }
            case CAMPAIGN: {
                this.copyNodeToContainer(CampaignFolder.class, Campaign.class, destinationId, clipboardPayload);
                break;
            }
            case CAMPAIGN_FOLDER: {
                this.copyNodeToContainer(CampaignFolder.class, CampaignFolder.class, destinationId, clipboardPayload);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Cannot paste %s in a campaign folder", nodePaste.getTypeName()));
            }
        }
    }

    @Override
    public void copyNodeToCampaignLibrary(Long destinationId, ClipboardPayload clipboardPayload, NodeType nodePaste) {
        switch (nodePaste) {
            case SPRINT: {
                this.copyNodeToContainer(CampaignLibrary.class, Sprint.class, destinationId, clipboardPayload);
                break;
            }
            case SPRINT_GROUP: {
                this.copyNodeToContainer(CampaignLibrary.class, SprintGroup.class, destinationId, clipboardPayload);
                break;
            }
            case CAMPAIGN: {
                this.copyNodeToContainer(CampaignLibrary.class, Campaign.class, destinationId, clipboardPayload);
                break;
            }
            case CAMPAIGN_FOLDER: {
                this.copyNodeToContainer(CampaignLibrary.class, CampaignFolder.class, destinationId, clipboardPayload);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Cannot paste %s in a campaign folder", nodePaste.getTypeName()));
            }
        }
    }

    private <CONTAINER, NODE extends TreeNode> void copyNodeToContainer(Class<CONTAINER> containerClass, Class<NODE> nodeClass, Long destinationId, ClipboardPayload clipboardPayload) {
        EntityDao<NODE> dao = this.getDaoFromNodeClass(nodeClass.getSimpleName());
        this.copyNodeToContainer(containerClass, dao::loadNodeForPaste, destinationId, clipboardPayload);
    }

    private <CONTAINER, NODE extends TreeNode> void copyNodeToContainer(Class<CONTAINER> containerClass, Function<List<Long>, List<NODE>> loadNodeForPaste, Long destinationId, ClipboardPayload clipboardPayload) {
        HibernateConfig.enableBatch(this.entityManager, MAX_BATCH_SIZE);
        EntityDao<NODE> daoContainer = this.getDaoFromNodeClass(containerClass.getSimpleName());
        HashMap<String, Map<Long, Long>> pairingIdsSourceCopyNode = new HashMap<String, Map<Long, Long>>();
        NODE container = daoContainer.loadContainerForPaste(destinationId);
        int countIds = 0;
        for (List ids : Lists.partition(clipboardPayload.getSelectedNodeIds(), (int)MAX_BATCH_SIZE)) {
            if (countIds > 200) {
                this.entityManager.clear();
                container = daoContainer.loadContainerForPaste(destinationId);
                countIds = 0;
            }
            List<NODE> nodes = loadNodeForPaste.apply(ids);
            this.copierService.copyNodeToContainer((NodeContainer)container, nodes, pairingIdsSourceCopyNode);
            countIds += MAX_BATCH_SIZE.intValue();
        }
        this.entityManager.clear();
        this.copyAllChildren(pairingIdsSourceCopyNode, clipboardPayload);
    }

    private <ENTITY extends NodeContainer<TreeNode>> void copyAllChildren(Map<String, Map<Long, Long>> pairingIdsSourceCopyNode, ClipboardPayload clipboardPayload) {
        if (pairingIdsSourceCopyNode.isEmpty()) {
            return;
        }
        HashMap<String, Map<Long, Long>> pairingIdsSourceCopyNodeChild = new HashMap<String, Map<Long, Long>>();
        for (Map.Entry<String, Map<Long, Long>> entry : pairingIdsSourceCopyNode.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            EntityDao dao = this.getDaoFromNodeClass(entry.getKey());
            Lists.partition(new ArrayList<Map.Entry<Long, Long>>(entry.getValue().entrySet()), (int)1000).forEach(entries -> {
                Map<Long, Long> pairs = entries.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                this.copyChildByEntities(dao, pairs, clipboardPayload, pairingIdsSourceCopyNodeChild);
            });
            entry.getValue().clear();
        }
        pairingIdsSourceCopyNode.clear();
        this.copyAllChildren(pairingIdsSourceCopyNodeChild, clipboardPayload);
    }

    private <ENTITY extends NodeContainer<TreeNode>> void copyChildByEntities(EntityDao<ENTITY> dao, Map<Long, Long> pairs, ClipboardPayload clipboardPayload, Map<String, Map<Long, Long>> pairingIdsSourceCopyNodeChild) {
        ChildEntityDtoResult childEntityDtoResult;
        int offset = 0;
        do {
            childEntityDtoResult = dao.loadChildForPaste(pairs.keySet(), MAX_BATCH_SIZE, offset, clipboardPayload);
            List<Long> ids = childEntityDtoResult.childEntityDtos().stream().map(childEntityDto -> {
                Long targetContainerId = (Long)pairs.get(childEntityDto.getParentId());
                childEntityDto.setTargetContainerId(targetContainerId);
                return targetContainerId;
            }).toList();
            Map<Long, NodeContainer> containers = dao.loadContainersForPaste(ids).stream().collect(Collectors.toMap(Identified::getId, container -> container));
            childEntityDtoResult.childEntityDtos().forEach(childEntityDto -> childEntityDto.setTargetContainer((NodeContainer<TreeNode>)((NodeContainer)containers.get(childEntityDto.getTargetContainerId()))));
            this.copierService.copyNodeToMultipleContainers(childEntityDtoResult.childEntityDtos(), pairingIdsSourceCopyNodeChild);
            offset += MAX_BATCH_SIZE.intValue();
            this.entityManager.clear();
        } while (childEntityDtoResult.hasMore());
        pairs.clear();
    }

    private <NODE> EntityDao<NODE> getDaoFromNodeClass(String clazzSimpleName) {
        EntityType entityType = EntityType.fromSimpleName((String)clazzSimpleName);
        return switch (entityType) {
            case EntityType.CAMPAIGN_LIBRARY -> this.campaignLibraryDao;
            case EntityType.CAMPAIGN_FOLDER -> this.campaignFolderDao;
            case EntityType.CAMPAIGN -> this.campaignDao;
            case EntityType.ITERATION -> this.iterationDao;
            case EntityType.SPRINT -> this.sprintDao;
            case EntityType.SPRINT_GROUP -> this.sprintGroupDao;
            default -> throw new IllegalArgumentException("Unsupported node type");
        };
    }
}

