/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import java.util.List;
import org.jooq.DSLContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.exception.execution.IterationTestPlanHasDeletedTestCaseException;
import org.squashtest.tm.service.campaign.ExecutionCreationService;
import org.squashtest.tm.service.internal.campaign.AbstractTestPlanExecutionProcessingService;
import org.squashtest.tm.service.internal.campaign.CampaignNodeDeletionHandler;
import org.squashtest.tm.service.internal.display.dto.execution.TestPlanResume;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.campaign.IterationTestPlanGrid;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.TestPlanItemDao;
import org.squashtest.tm.service.internal.repository.display.IterationDisplayDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service(value="squashtest.tm.service.IterationExecutionProcessingService")
@Transactional
public class IterationExecutionProcessingServiceImpl
extends AbstractTestPlanExecutionProcessingService<Iteration, TestPlanResume.IterationTestPlanResume> {
    private static final String CAN_EXECUTE_BY_ITERATION_ID = "hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'EXECUTE') or hasRole('ROLE_ADMIN')";
    private final IterationDao iterationDao;
    private final IterationDisplayDao iterationDisplayDao;

    IterationExecutionProcessingServiceImpl(CampaignNodeDeletionHandler campaignDeletionHandler, PermissionEvaluationService permissionEvaluationService, TestPlanItemDao testPlanItemDao, DSLContext dslContext, IterationDao iterationDao, IterationDisplayDao iterationDisplayDao, ExecutionCreationService executionCreationService) {
        super(campaignDeletionHandler, permissionEvaluationService, testPlanItemDao, dslContext, executionCreationService);
        this.iterationDao = iterationDao;
        this.iterationDisplayDao = iterationDisplayDao;
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public TestPlanResume.IterationTestPlanResume startResume(long iterationId) {
        return (TestPlanResume.IterationTestPlanResume)this.commonStartResume(iterationId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public TestPlanResume.IterationTestPlanResume relaunch(long iterationId) {
        return (TestPlanResume.IterationTestPlanResume)super.relaunch(iterationId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public TestPlanResume relaunchFilteredTestPlan(long iterationId, List<GridFilterValue> filters) {
        return super.relaunchFilteredTestPlan(iterationId, filters);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public TestPlanResume.IterationTestPlanResume startResumeNextExecution(long iterationId, long testPlanItemId) {
        return (TestPlanResume.IterationTestPlanResume)super.startResumeNextExecution(iterationId, testPlanItemId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public void deleteAllExecutions(long iterationId) {
        super.deleteAllExecutions(iterationId);
    }

    @Override
    protected Iteration getTestPlanOwner(long iterationId) {
        return this.iterationDao.loadForExecutionResume(iterationId);
    }

    @Override
    Iteration createTransientTestPlanOwnerWithFilteredTestPlan(long iterationId, List<TestPlanItem> filteredTestPLan) {
        Iteration iteration = this.getTestPlanOwner(iterationId);
        Iteration copyIteration = iteration.createCopy();
        copyIteration.getTestPlan().clear();
        copyIteration.getTestPlan().addTransientItems(filteredTestPLan);
        return copyIteration;
    }

    @Override
    public List<TestPlanItem> getFilteredTestPlan(long iterationId, List<GridFilterValue> filters) {
        Long testPlanId = this.iterationDisplayDao.findTestPlanId(iterationId);
        IterationTestPlanGrid testPlanGrid = new IterationTestPlanGrid(testPlanId, null, this.iterationDisplayDao, this.permissionEvaluationService);
        GridRequest gridRequest = this.prepareNonPaginatedGridRequest(filters);
        GridResponse gridResponse = testPlanGrid.getRows(gridRequest, this.dslContext);
        List<Long> itemIds = this.extractItemIdsFromGridResponse(gridResponse);
        return this.testPlanItemDao.findAllById(itemIds);
    }

    @Override
    public ActionException getTestPlanHasDeletedTestCaseException() {
        return new IterationTestPlanHasDeletedTestCaseException();
    }

    @Override
    protected TestPlanResume createNewTestPlanResume(long testPlanOwnerId, Execution execution, boolean hasNextTestCase, List<Long> partialTestPlanItemIds) {
        return new TestPlanResume.IterationTestPlanResume(testPlanOwnerId, execution, hasNextTestCase, partialTestPlanItemIds);
    }

    @Override
    protected TestPlanResume.IterationTestPlanResume createNewTestPlanResume(long testPlanOwnerId, Execution execution, boolean hasNextTestCase) {
        return new TestPlanResume.IterationTestPlanResume(testPlanOwnerId, execution, hasNextTestCase);
    }

    @Override
    public boolean hasDeletedTestCaseInTestPlan(long testPlanOwnerId) {
        return this.iterationDao.hasDeletedTestCaseInTestPlan(testPlanOwnerId);
    }
}

