/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.bugtracker.knownissues.local;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jooq.SortField;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.core.foundation.collection.SortOrder;
import org.squashtest.tm.jooq.domain.Tables;

public final class LocalKnownIssueFinderHelper {
    private LocalKnownIssueFinderHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static List<Long> parseLongsAndSortAsc(String s) {
        ArrayList<Long> longs = new ArrayList<Long>(LocalKnownIssueFinderHelper.parseLongs(s));
        longs.sort(Long::compare);
        return longs;
    }

    public static List<Long> parseLongsAndSortDesc(String s) {
        List<Long> longs = LocalKnownIssueFinderHelper.parseLongsAndSortAsc(s);
        Collections.reverse(longs);
        return longs;
    }

    public static List<Long> parseLongs(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return Collections.emptyList();
        }
        return Arrays.stream(StringUtils.split((String)s, (String)",")).map(Long::parseLong).toList();
    }

    public static SortField<String> getOrderField(PagingAndSorting paging) {
        return paging.getSortOrder().equals((Object)SortOrder.ASCENDING) ? Tables.ISSUE.REMOTE_ISSUE_ID.asc() : Tables.ISSUE.REMOTE_ISSUE_ID.desc();
    }
}

