/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.MultiValueMap;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.library.structures.LibraryGraph;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.ParameterAssignationMode;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.importer.WithPath;
import org.squashtest.tm.service.internal.batchimport.CallStepParamsInfo;
import org.squashtest.tm.service.internal.batchimport.Existence;
import org.squashtest.tm.service.internal.batchimport.ProjectLibrariesIds;
import org.squashtest.tm.service.internal.batchimport.ProjectTargetStatus;
import org.squashtest.tm.service.internal.batchimport.StepType;
import org.squashtest.tm.service.internal.batchimport.TargetStatus;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.DatasetTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.ParameterTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementVersionTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.TestCaseTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.TestStepTarget;
import org.squashtest.tm.service.internal.batchimport.requirement.dto.ImportRequirementFinder;
import org.squashtest.tm.service.internal.batchimport.requirement.tree.ImportedRequirementNode;
import org.squashtest.tm.service.internal.batchimport.requirement.tree.ImportedRequirementTree;
import org.squashtest.tm.service.internal.batchimport.testcase.TestCaseCallGraph;
import org.squashtest.tm.service.internal.dto.ReqVersionMilestone;
import org.squashtest.tm.service.internal.repository.CustomCustomFieldDao;
import org.squashtest.tm.service.internal.repository.DatasetDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.RequirementImportDao;
import org.squashtest.tm.service.internal.repository.TestStepDao;
import org.squashtest.tm.service.internal.repository.display.EntityPathHeaderDao;
import org.squashtest.tm.service.internal.testcase.TestCaseCallTreeFinder;
import org.squashtest.tm.service.milestone.MilestoneMembershipFinder;
import org.squashtest.tm.service.requirement.LinkedRequirementVersionManagerService;
import org.squashtest.tm.service.testcase.ParameterFinder;
import org.squashtest.tm.service.testcase.TestCaseFinder;
import org.squashtest.tm.service.testcase.TestCaseLibraryFinderService;

@Component
@Scope(value="prototype")
public class Model {
    private static final Logger LOGGER = LoggerFactory.getLogger(Model.class);
    private static final String UNCHECKED = "unchecked";
    private final CustomCustomFieldDao customFieldDao;
    private final TestCaseLibraryFinderService finderService;
    private final RequirementImportDao requirementImportDao;
    private final TestCaseCallTreeFinder calltreeFinder;
    private final TestCaseFinder testCaseFinder;
    private final ParameterFinder paramFinder;
    private final MilestoneMembershipFinder milestoneMemberFinder;
    private final DatasetDao dsDao;
    private final LinkedRequirementVersionManagerService reqlinkService;
    private final EntityPathHeaderDao pathHeaderDao;
    private final TestStepDao testStepDao;
    private final ProjectDao projectDao;
    private final Map<TestCaseTarget, TargetStatus> testCaseStatusByTarget = new HashMap<TestCaseTarget, TargetStatus>();
    private final Map<TestCaseTarget, List<InternalStepModel>> testCaseStepsByTarget = new HashMap<TestCaseTarget, List<InternalStepModel>>();
    private final Map<Target, Boolean> isTargetMilestoneLocked = new HashMap<Target, Boolean>();
    private final Map<String, ProjectTargetStatus> projectStatusByName = new HashMap<String, ProjectTargetStatus>();
    private final MultiValueMap tcCufsPerProjectname = new MultiValueMap();
    private Set<String> requirementLinkRoles;
    private final MultiValueMap stepCufsPerProjectname = new MultiValueMap();
    private final MultiValueMap reqCufsPerProjectname = new MultiValueMap();
    private final Map<TestCaseTarget, Collection<ParameterTarget>> parametersByTestCase = new HashMap<TestCaseTarget, Collection<ParameterTarget>>();
    private final Map<TestCaseTarget, Set<DatasetTarget>> datasetsByTestCase = new HashMap<TestCaseTarget, Set<DatasetTarget>>();
    private final TestCaseCallGraph callGraph = new TestCaseCallGraph();
    private final ImportedRequirementTree requirementTree = new ImportedRequirementTree();

    public Model(CustomCustomFieldDao customFieldDao, TestCaseLibraryFinderService finderService, RequirementImportDao requirementImportDao, TestCaseCallTreeFinder calltreeFinder, TestCaseFinder testCaseFinder, ParameterFinder paramFinder, MilestoneMembershipFinder milestoneMemberFinder, DatasetDao dsDao, LinkedRequirementVersionManagerService reqlinkService, EntityPathHeaderDao pathHeaderDao, TestStepDao testStepDao, ProjectDao projectDao) {
        this.customFieldDao = customFieldDao;
        this.finderService = finderService;
        this.requirementImportDao = requirementImportDao;
        this.calltreeFinder = calltreeFinder;
        this.testCaseFinder = testCaseFinder;
        this.paramFinder = paramFinder;
        this.milestoneMemberFinder = milestoneMemberFinder;
        this.dsDao = dsDao;
        this.reqlinkService = reqlinkService;
        this.pathHeaderDao = pathHeaderDao;
        this.testStepDao = testStepDao;
        this.projectDao = projectDao;
    }

    public ProjectTargetStatus getProjectStatus(String projectName) {
        if (!this.projectStatusByName.containsKey(projectName = PathUtils.unescapePathPartSlashes((String)projectName))) {
            this.initProject(projectName);
        }
        return this.projectStatusByName.get(projectName);
    }

    public void initStatuses(Set<TestCaseTarget> targets) {
        Set<TestCaseTarget> targetList = targets.stream().filter(target -> !this.testCaseStatusByTarget.containsKey(target)).collect(Collectors.toSet());
        if (!targetList.isEmpty()) {
            this.mainInitTestCase(targetList);
        }
    }

    public TargetStatus getStatus(TestCaseTarget target) {
        LOGGER.debug("searching status for test case target : '{}'", new Object[]{target});
        if (!this.testCaseStatusByTarget.containsKey(target)) {
            this.mainInitTestCase(target);
        }
        TargetStatus status = this.testCaseStatusByTarget.get(target);
        LOGGER.trace("status for test case target '{}' : {}", new Object[]{target, status});
        return status;
    }

    public Map<TestCaseTarget, Long> getTargetIds(Set<TestCaseTarget> targets) {
        this.initStatuses(targets);
        return targets.stream().map(target -> Map.entry(target, this.testCaseStatusByTarget.get(target))).filter(entry -> entry.getValue() != null && ((TargetStatus)entry.getValue()).id != null).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((TargetStatus)entry.getValue()).id));
    }

    public void setExists(TestCaseTarget target, Long id) {
        LOGGER.trace("setting test case target '{}' to ", new Object[0]);
        target.setId(id);
        this.testCaseStatusByTarget.put(target, new TargetStatus(Existence.EXISTS, id));
    }

    public void setToBeCreated(TestCaseTarget target) {
        this.testCaseStatusByTarget.put(target, new TargetStatus(Existence.TO_BE_CREATED));
        this.clearSteps(target);
    }

    public void setToBeDeleted(TestCaseTarget target) {
        this.testCaseStatusByTarget.computeIfPresent(target, (k, oldStatus) -> new TargetStatus(Existence.TO_BE_DELETED, oldStatus.id));
        this.clearSteps(target);
        this.callGraph.removeNode(target);
    }

    public void setDeleted(TestCaseTarget target) {
        this.testCaseStatusByTarget.put(target, new TargetStatus(Existence.NOT_EXISTS, null));
        this.clearSteps(target);
        this.callGraph.removeNode(target);
    }

    public void setNotExists(TestCaseTarget target) {
        this.testCaseStatusByTarget.put(target, new TargetStatus(Existence.NOT_EXISTS, null));
        this.clearSteps(target);
    }

    private void clearSteps(TestCaseTarget target) {
        if (this.testCaseStepsByTarget.containsKey(target)) {
            this.testCaseStepsByTarget.get(target).clear();
        }
    }

    public Long getId(TestCaseTarget target) {
        return this.getStatus((TestCaseTarget)target).id;
    }

    public TestCase get(TestCaseTarget target) {
        Long id = this.getId(target);
        if (id == null) {
            return null;
        }
        return this.testCaseFinder.findById(id);
    }

    public boolean isTestCaseLockedByMilestones(TestCaseTarget target) {
        if (!this.testCaseStatusByTarget.containsKey(target)) {
            this.mainInitTestCase(target);
        }
        return this.isTargetMilestoneLocked.get(target);
    }

    public boolean isCalled(TestCaseTarget target) {
        if (!this.callGraph.knowsNode(target)) {
            this.initCallGraph(target);
        }
        return this.callGraph.isCalled(target);
    }

    public boolean wouldCreateCycle(TestCaseTarget srcTestCase, TestCaseTarget destTestCase) {
        if (!this.callGraph.knowsNode(srcTestCase)) {
            this.initCallGraph(srcTestCase);
        }
        if (!this.callGraph.knowsNode(destTestCase)) {
            this.initCallGraph(destTestCase);
        }
        return this.callGraph.wouldCreateCycle(srcTestCase, destTestCase);
    }

    public boolean wouldCreateCycle(TestStepTarget step, TestCaseTarget destTestCase) {
        return this.wouldCreateCycle(step.getTestCase(), destTestCase);
    }

    private void initCallGraph(TestCaseTarget target) {
        Long id = this.finderService.findNodeIdByPath(target.getPath());
        if (id == null) {
            this.callGraph.addNode(target);
            return;
        }
        LibraryGraph<NamedReference, LibraryGraph.SimpleNode<NamedReference>> targetCallers = this.calltreeFinder.getExtendedGraph(Collections.singletonList(id));
        Collection refs = targetCallers.getNodes();
        this.swapNameForPath(refs);
        this.callGraph.addGraph(targetCallers);
    }

    public void initCallGraph(Collection<TestCaseTarget> targets) {
        Set<Long> testCaseIds = targets.stream().filter(target -> !this.callGraph.knowsNode((TestCaseTarget)target)).map(target -> {
            Long id = this.getId((TestCaseTarget)target);
            if (id == null) {
                this.callGraph.addNode((TestCaseTarget)target);
            }
            return id;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!testCaseIds.isEmpty()) {
            this.initRecursiveCallGraph(testCaseIds);
        }
    }

    public void initRecursiveCallGraph(Collection<Long> testCaseIds) {
        LibraryGraph<NamedReference, LibraryGraph.SimpleNode<NamedReference>> targetCallers = this.calltreeFinder.getExtendedGraph(testCaseIds);
        Collection refs = targetCallers.getNodes();
        this.swapNameForPath(refs);
        this.callGraph.addGraph(targetCallers);
    }

    private void addCallGraphEdge(TestCaseTarget src, TestCaseTarget dest) {
        if (!this.callGraph.knowsNode(src)) {
            this.initCallGraph(src);
        }
        if (!this.callGraph.knowsNode(dest)) {
            this.initCallGraph(dest);
        }
        this.callGraph.addEdge(src, dest);
    }

    public void addActionStep(TestStepTarget target) {
        List<InternalStepModel> steps = this.findInternalStepModels(target);
        Integer index = target.getIndex();
        if (index == null || index >= steps.size() || index < 0) {
            index = steps.size();
        }
        steps.add(index, new InternalStepModel(StepType.ACTION, null));
    }

    public Integer addCallStep(TestStepTarget target, TestCaseTarget calledTestCase, ParameterAssignationMode parameterMode) {
        boolean delegates = ParameterAssignationMode.DELEGATE.equals((Object)parameterMode);
        this.addCallGraphEdge(target.getTestCase(), calledTestCase);
        List<InternalStepModel> steps = this.findInternalStepModels(target);
        Integer index = target.getIndex();
        if (index == null || index >= steps.size() || index < 0) {
            index = steps.size();
        }
        steps.add(index, new InternalStepModel(StepType.CALL, calledTestCase, delegates));
        return index;
    }

    public void updateCallStepTarget(TestStepTarget step, TestCaseTarget newTarget, CallStepParamsInfo paramInfo) {
        if (!this.stepExists(step)) {
            throw new IllegalArgumentException("cannot update non existant step '" + String.valueOf(step) + "'");
        }
        if (this.getType(step) != StepType.CALL) {
            throw new IllegalArgumentException("cannot update the called test case for step '" + String.valueOf(step) + "' because that step is not a call step");
        }
        InternalStepModel model = this.findInternalStepModel(step);
        boolean delegates = ParameterAssignationMode.DELEGATE.equals((Object)paramInfo.getParamMode());
        model.setDelegates(delegates);
        TestCaseTarget src = step.getTestCase();
        TestCaseTarget oldDest = model.getCalledTC();
        model.setCalledTC(newTarget);
        this.callGraph.removeEdge(src, oldDest);
        this.callGraph.addEdge(src, newTarget);
    }

    public void remove(TestStepTarget target) {
        if (!this.stepExists(target)) {
            throw new IllegalArgumentException("cannot remove non existant step '" + String.valueOf(target) + "'");
        }
        List<InternalStepModel> steps = this.findInternalStepModels(target);
        Integer index = target.getIndex();
        InternalStepModel step = steps.remove(index);
        if (step.type == StepType.CALL) {
            this.callGraph.removeEdge(target.getTestCase(), step.getCalledTC());
        }
    }

    public boolean stepExists(TestStepTarget target) {
        InternalStepModel model = this.findInternalStepModel(target);
        return model != null;
    }

    public boolean indexIsFirstAvailable(TestStepTarget target) {
        Integer index = target.getIndex();
        TestCaseTarget tc = target.getTestCase();
        if (!this.testCaseStatusByTarget.containsKey(tc)) {
            this.mainInitTestCase(tc);
        }
        List<InternalStepModel> steps = this.testCaseStepsByTarget.get(tc);
        if (index == null || steps == null) {
            return false;
        }
        return index.intValue() == steps.size();
    }

    public StepType getType(TestStepTarget target) {
        InternalStepModel model = this.findInternalStepModel(target);
        if (model != null) {
            return model.getType();
        }
        return null;
    }

    public TestStep getStep(TestStepTarget target) {
        Long tcId = this.getStatus((TestCaseTarget)target.getTestCase()).id;
        Integer index = target.getIndex();
        if (!this.stepExists(target) || tcId == null || index == null) {
            return null;
        }
        return this.testStepDao.findByTestCaseAndPosition(tcId, index);
    }

    private List<InternalStepModel> findInternalStepModels(TestStepTarget step) {
        TestCaseTarget tc = step.getTestCase();
        if (!this.testCaseStatusByTarget.containsKey(tc)) {
            this.mainInitTestCase(tc);
        }
        return this.testCaseStepsByTarget.get(tc);
    }

    private InternalStepModel findInternalStepModel(TestStepTarget step) {
        Integer index = step.getIndex();
        List<InternalStepModel> steps = this.findInternalStepModels(step);
        if (index != null && steps.size() > index && index >= 0) {
            return steps.get(index);
        }
        return null;
    }

    public boolean doesParameterExists(ParameterTarget target) {
        TestCaseTarget tc = target.getOwner();
        if (!this.parametersByTestCase.containsKey(tc)) {
            this.initParameters(Collections.singleton(tc));
        }
        return this.parametersByTestCase.get(tc).contains(target);
    }

    public void addParameter(ParameterTarget target) {
        TestCaseTarget tc = target.getOwner();
        if (!this.parametersByTestCase.containsKey(tc)) {
            this.initParameters(Collections.singleton(tc));
        }
        this.parametersByTestCase.get(tc).add(target);
    }

    public void removeParameter(ParameterTarget target) {
        TestCaseTarget tc = target.getOwner();
        if (!this.parametersByTestCase.containsKey(tc)) {
            this.initParameters(Collections.singleton(tc));
        }
        this.parametersByTestCase.get(tc).remove(target);
    }

    public Collection<ParameterTarget> getOwnParameters(TestCaseTarget testCase) {
        if (!this.parametersByTestCase.containsKey(testCase)) {
            this.initParameters(Collections.singleton(testCase));
        }
        return this.parametersByTestCase.get(testCase);
    }

    public Collection<ParameterTarget> getAllParameters(TestCaseTarget testCase) {
        if (!this.callGraph.knowsNode(testCase)) {
            this.initCallGraph(testCase);
        }
        HashSet<ParameterTarget> result = new HashSet<ParameterTarget>();
        LinkedList<TestCaseCallGraph.Node> processing = new LinkedList<TestCaseCallGraph.Node>();
        processing.add((TestCaseCallGraph.Node)this.callGraph.getNode(testCase));
        while (!processing.isEmpty()) {
            TestCaseCallGraph.Node current = (TestCaseCallGraph.Node)((Object)processing.pop());
            result.addAll(this.getOwnParameters((TestCaseTarget)current.getKey()));
            for (TestCaseCallGraph.Node child : current.getOutbounds()) {
                List<InternalStepModel> steps = this.testCaseStepsByTarget.get(current.getKey());
                this.extractParametersFromSteps(processing, child, steps);
            }
        }
        return result;
    }

    private void extractParametersFromSteps(Collection<TestCaseCallGraph.Node> processing, TestCaseCallGraph.Node child, List<InternalStepModel> steps) {
        if (steps != null) {
            for (InternalStepModel step : steps) {
                if (step.type != StepType.CALL || !step.calledTC.equals(child.getKey()) || !step.getDeleguates()) continue;
                processing.add(child);
            }
        }
    }

    public boolean isParamInDataset(ParameterTarget param, DatasetTarget ds) {
        Collection<ParameterTarget> allparams = this.getAllParameters(ds.getTestCase());
        return allparams.contains(param);
    }

    public boolean datasetNotExist(DatasetTarget target) {
        TestCaseTarget tc = target.getTestCase();
        if (!this.datasetsByTestCase.containsKey(tc)) {
            this.initDatasets(Collections.singletonList(tc));
        }
        return !this.datasetsByTestCase.get(tc).contains(target);
    }

    public void addDataset(DatasetTarget target) {
        TestCaseTarget tc = target.getTestCase();
        if (!this.datasetsByTestCase.containsKey(tc)) {
            this.initDatasets(Collections.singletonList(tc));
        }
        this.datasetsByTestCase.get(tc).add(target);
    }

    public void addDatasets(List<DatasetTarget> datasetTargets) {
        Set<TestCaseTarget> targetList = datasetTargets.stream().map(DatasetTarget::getTestCase).filter(target -> !this.datasetsByTestCase.containsKey(target)).collect(Collectors.toSet());
        if (!targetList.isEmpty()) {
            this.initDatasets(targetList);
        }
    }

    public void removeDataset(DatasetTarget target) {
        TestCaseTarget tc = target.getTestCase();
        if (!this.datasetsByTestCase.containsKey(tc)) {
            this.initDatasets(Collections.singletonList(tc));
        }
        this.datasetsByTestCase.get(tc).remove(target);
    }

    public Collection<DatasetTarget> getDatasets(TestCaseTarget testCase) {
        if (!this.datasetsByTestCase.containsKey(testCase)) {
            this.initDatasets(Collections.singletonList(testCase));
        }
        return this.datasetsByTestCase.get(testCase);
    }

    public Collection<CustomField> getTestCaseCufs(TestCaseTarget target) {
        if (!this.testCaseStatusByTarget.containsKey(target)) {
            this.mainInitTestCase(target);
        }
        String projectName = PathUtils.extractProjectName((String)target.getPath());
        Collection cufs = this.tcCufsPerProjectname.getCollection((Object)projectName);
        return Objects.requireNonNullElse(cufs, Collections.emptyList());
    }

    public Collection<CustomField> getRequirementVersionCufs(RequirementVersionTarget target) {
        if (this.requirementTree.targetNotLoaded(target)) {
            this.initRequirementVersion(target);
        }
        String projectName = PathUtils.extractProjectName((String)target.getPath());
        Collection cufs = this.reqCufsPerProjectname.getCollection((Object)projectName);
        return Objects.requireNonNullElse(cufs, Collections.emptyList());
    }

    private void initRequirementVersion(RequirementVersionTarget target) {
        ImportedRequirementNode req = this.requirementTree.getNode(target.getRequirement());
        if (req == null) {
            this.mainInitRequirements(target);
        } else {
            this.requirementTree.addVersion(target, TargetStatus.NOT_EXISTS);
        }
    }

    public Collection<CustomField> getTestStepCufs(TestStepTarget target) {
        TestCaseTarget tc = target.getTestCase();
        if (!this.testCaseStatusByTarget.containsKey(tc)) {
            this.mainInitTestCase(tc);
        }
        String projectName = PathUtils.extractProjectName((String)tc.getPath());
        Collection cufs = this.stepCufsPerProjectname.getCollection((Object)projectName);
        return Objects.requireNonNullElse(cufs, Collections.emptyList());
    }

    public TargetStatus getStatus(RequirementTarget target) {
        if (this.requirementTree.targetNotLoaded(target)) {
            this.loadRequirements(Collections.singleton(target), true);
        }
        return this.requirementTree.getStatus(target);
    }

    public TargetStatus getStatus(RequirementVersionTarget target) {
        if (this.requirementTree.targetNotLoaded(target)) {
            this.mainInitRequirements(target);
        }
        return this.requirementTree.getStatus(target);
    }

    public Set<String> getRequirementLinkRoles() {
        if (this.requirementLinkRoles == null) {
            this.requirementLinkRoles = Collections.unmodifiableSet(this.reqlinkService.findAllRoleCodes());
        }
        return this.requirementLinkRoles;
    }

    public void mainInitTestCase(TestCaseTarget target) {
        this.mainInitTestCase(Collections.singleton(target));
    }

    public void mainInitTestCase(Set<TestCaseTarget> targets) {
        this.initTestCases(targets);
        this.initTestSteps(targets);
        this.initProjects(targets);
    }

    private void initTestCases(Set<TestCaseTarget> initialTargets) {
        List<TestCaseTarget> targets = initialTargets.stream().filter(target -> !this.testCaseStatusByTarget.containsKey(target)).toList();
        if (targets.isEmpty()) {
            return;
        }
        Map<String, List<TestCaseTarget>> targetsByProjectName = initialTargets.stream().collect(Collectors.groupingBy(TestCaseTarget::getProject));
        targetsByProjectName.forEach(this::initTestCaseInProject);
    }

    private void initTestCaseInProject(String projectName, List<TestCaseTarget> targetList) {
        HashMap<Long, TestCaseTarget> existingTargets = new HashMap<Long, TestCaseTarget>();
        TreeMap<String, Long> testCasePathsInProject = this.finderService.buildTestCasePathsTree(projectName);
        for (TestCaseTarget target : targetList) {
            String path = PathUtils.asSquashPath((String)target.getPath());
            Long id = testCasePathsInProject.get(path);
            Existence existence = id == null ? Existence.NOT_EXISTS : Existence.EXISTS;
            TargetStatus status = new TargetStatus(existence, id);
            this.testCaseStatusByTarget.put(target, status);
            if (existence == Existence.EXISTS) {
                target.setId(id);
                existingTargets.put(id, target);
                continue;
            }
            this.isTargetMilestoneLocked.put(target, false);
        }
        if (existingTargets.isEmpty()) {
            return;
        }
        List<Long> testIdsBoundToBlockingMilestone = this.milestoneMemberFinder.findTestCaseIdsBoundToBlockingMilestone(existingTargets.keySet());
        existingTargets.forEach((testCaseId, existingTarget) -> {
            Boolean bl = this.isTargetMilestoneLocked.put((Target)existingTarget, testIdsBoundToBlockingMilestone.contains(testCaseId));
        });
    }

    public void initParameters(Set<TestCaseTarget> testCaseTargets) {
        Map<Long, TestCaseTarget> testCaseTargetById = this.collectExistingTestCaseTargetById(testCaseTargets);
        testCaseTargets.stream().filter(target -> !this.parametersByTestCase.containsKey(target)).forEach(target -> {
            HashSet hashSet = this.parametersByTestCase.putIfAbsent((TestCaseTarget)target, new HashSet());
        });
        if (testCaseTargetById.isEmpty()) {
            return;
        }
        Map<Long, List<Parameter>> parametersByTestCaseId = this.paramFinder.findOwnParametersByTestCaseIds(testCaseTargetById.keySet());
        for (Map.Entry<Long, TestCaseTarget> entry : testCaseTargetById.entrySet()) {
            List parameters = parametersByTestCaseId.getOrDefault(entry.getKey(), List.of());
            Set parameterTargets = parameters.stream().map(p -> new ParameterTarget((TestCaseTarget)entry.getValue(), p.getName())).collect(Collectors.toSet());
            this.parametersByTestCase.putIfAbsent(entry.getValue(), parameterTargets);
        }
    }

    private Map<Long, TestCaseTarget> getTestCaseTargetById(Collection<TestCaseTarget> testCaseTargets, Map<TestCaseTarget, ?> testCasePartByTestCaseTarget) {
        return testCaseTargets.stream().filter(target -> !testCasePartByTestCaseTarget.containsKey(target)).map(target -> Map.entry(target, this.getStatus((TestCaseTarget)target))).filter(entry -> ((TargetStatus)entry.getValue()).id != null && ((TargetStatus)entry.getValue()).status != Existence.TO_BE_DELETED).collect(Collectors.toMap(entry -> ((TargetStatus)entry.getValue()).id, Map.Entry::getKey, (a, b) -> a));
    }

    private Map<Long, TestCaseTarget> collectExistingTestCaseTargetById(Set<TestCaseTarget> testCaseTargets) {
        this.initStatuses(testCaseTargets);
        return this.getTestCaseTargetById(testCaseTargets, this.parametersByTestCase);
    }

    private void initDatasets(Collection<TestCaseTarget> testCaseTargets) {
        Map<Long, TestCaseTarget> testCaseTargetById = this.getTestCaseTargetById(testCaseTargets, this.datasetsByTestCase);
        Map datasetsByTestCaseId = this.dsDao.findOwnDatasetNamesByTestCaseIds(testCaseTargetById.keySet());
        for (Map.Entry<Long, TestCaseTarget> entry : testCaseTargetById.entrySet()) {
            List datasetsNames = datasetsByTestCaseId.getOrDefault(entry.getKey(), Collections.emptyList());
            TestCaseTarget target2 = entry.getValue();
            HashSet<DatasetTarget> datasetTarget = new HashSet<DatasetTarget>(datasetsNames.size());
            for (String name : datasetsNames) {
                datasetTarget.add(new DatasetTarget(target2, name));
            }
            this.datasetsByTestCase.put(target2, datasetTarget);
        }
        testCaseTargets.stream().filter(target -> !this.datasetsByTestCase.containsKey(target)).forEach(target -> {
            HashSet hashSet = this.datasetsByTestCase.putIfAbsent((TestCaseTarget)target, new HashSet());
        });
    }

    private void initTestSteps(Set<TestCaseTarget> targets) {
        Map targetsByTestCaseId = targets.stream().filter(target -> !this.testCaseStepsByTarget.containsKey(target)).filter(target -> {
            TargetStatus status = this.testCaseStatusByTarget.get(target);
            return status.id != null && status.status != Existence.TO_BE_DELETED;
        }).collect(Collectors.groupingBy(target -> this.testCaseStatusByTarget.get((Object)target).id, HashMap::new, Collectors.toList()));
        targets.stream().filter(target -> !this.testCaseStepsByTarget.containsKey(target)).forEach(target -> {
            ArrayList arrayList = this.testCaseStepsByTarget.putIfAbsent((TestCaseTarget)target, new ArrayList());
        });
        if (targetsByTestCaseId.isEmpty()) {
            return;
        }
        Map<Long, List<InternalStepModel>> stepModelsByTestCaseId = this.loadStepsModel(targetsByTestCaseId.keySet());
        stepModelsByTestCaseId.forEach((id, steps) -> {
            List testCaseTargets = targetsByTestCaseId.getOrDefault(id, List.of());
            testCaseTargets.forEach(target -> {
                List<InternalStepModel> list2 = this.testCaseStepsByTarget.put((TestCaseTarget)target, (List<InternalStepModel>)steps);
            });
        });
    }

    public boolean isHighLevelRequirement(RequirementTarget target) {
        return this.requirementTree.isHighLevelRequirement(target);
    }

    public boolean isImportable(RequirementTarget target) {
        return this.requirementTree.getNode(target).isImportable();
    }

    public void flagNonImportable(RequirementTarget target) {
        this.requirementTree.getNode(target).flagNonImportableRecursively();
    }

    public Map<ImportedRequirementNode, Set<ImportedRequirementNode>> getMissingNodes() {
        return this.requirementTree.collectMissingNode();
    }

    public boolean isCurrentVersion(RequirementVersionTarget version) {
        return this.requirementTree.getNode(version.getRequirement()).isCurrentVersion(version.getVersion());
    }

    public void fixRequirementVersion(RequirementVersionTarget target) {
        this.requirementTree.fixVersion(target);
    }

    public boolean existPriorVersion(RequirementVersionTarget target) {
        return this.requirementTree.existPriorVersion(target);
    }

    public Long getRequirementVersionId(RequirementVersionTarget versionTarget) {
        Long id = versionTarget.getId();
        if (id == null) {
            id = this.requirementTree.getVersionId(versionTarget.getRequirement(), versionTarget.getVersion());
            versionTarget.setId(id);
        }
        return id;
    }

    public Long getTestCaseId(TestCaseTarget testCase) {
        TargetStatus status = this.getStatus(testCase);
        return status.getId();
    }

    public void setExists(RequirementVersionTarget target, Long id) {
        this.requirementTree.updateVersionStatus(target, new TargetStatus(Existence.EXISTS, id));
    }

    public void setExists(RequirementTarget target, Long id) {
        target.setId(id);
        this.requirementTree.updateStatus(target, new TargetStatus(Existence.EXISTS, id));
    }

    private Map<Long, List<InternalStepModel>> loadStepsModel(Collection<Long> tcIds) {
        List<Object[]> stepsData = this.testStepDao.findTestStepsDetails(tcIds);
        Map stepDetailsByTestCaseId = stepsData.stream().map(this::createStepDetail).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        Map calledTestCasePath = stepsData.stream().map(data -> (Long)data[2]).filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toSet(), this::getTestCasePathByIds));
        return stepDetailsByTestCaseId.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.createInternalStepModels((List)entry.getValue(), calledTestCasePath)));
    }

    private Map<Long, String> getTestCasePathByIds(Set<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.pathHeaderDao.buildTestCasePathByIds(ids, "/").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> "/" + (String)entry.getValue()));
    }

    private Map.Entry<Long, StepDetail> createStepDetail(Object[] data) {
        Long testCaseId = (Long)data[0];
        String stepType = (String)data[1];
        Long calledTC = (Long)data[2];
        Boolean delegates = (Boolean)data[3];
        StepDetail stepDetail = new StepDetail(stepType, calledTC, delegates);
        return Map.entry(testCaseId, stepDetail);
    }

    private List<InternalStepModel> createInternalStepModels(List<StepDetail> stepDetails, Map<Long, String> calledTestCasePath) {
        return stepDetails.stream().map(stepDetail -> {
            StepType type = StepType.valueOf(stepDetail.stepType);
            TestCaseTarget calledTC = null;
            boolean delegates = false;
            if (type == StepType.CALL) {
                if (stepDetail.calledTestCase != null) {
                    String path = (String)calledTestCasePath.get(stepDetail.calledTestCase);
                    calledTC = new TestCaseTarget(path);
                }
                delegates = stepDetail.delegate;
            }
            return new InternalStepModel(type, calledTC, delegates);
        }).collect(Collectors.toList());
    }

    private void initProject(String projectName) {
        this.initProjectsByName(Collections.singletonList(projectName));
    }

    private void initProjects(Set<TestCaseTarget> targets) {
        this.initProjectsByName(this.collectProjects(targets));
    }

    private void initProjectsByName(Collection<String> allNames) {
        List allUnescapedNames = PathUtils.unescapePathPartSlashes(allNames);
        LinkedList<String> projectNames = new LinkedList<String>();
        for (String name2 : allUnescapedNames) {
            if (this.projectStatusByName.containsKey(name2)) continue;
            projectNames.add(name2);
        }
        if (projectNames.isEmpty()) {
            return;
        }
        List<ProjectLibrariesIds> projects = this.projectDao.getLibrariesIdsByNames(projectNames);
        for (ProjectLibrariesIds p : projects) {
            Long projectId = p.projectId();
            LOGGER.debug("ReqImport - Trying to import project in model {}", new Object[]{projectId});
            ProjectTargetStatus status = new ProjectTargetStatus(Existence.EXISTS, projectId, p.testCaseLibraryId(), p.requirementLibraryId());
            this.projectStatusByName.put(p.name(), status);
        }
        this.initCustomFields(projects.stream().map(ProjectLibrariesIds::projectId).toList());
        projectNames.stream().filter(name -> !this.projectStatusByName.containsKey(name)).forEach(name -> {
            ProjectTargetStatus projectTargetStatus = this.projectStatusByName.put((String)name, new ProjectTargetStatus(Existence.NOT_EXISTS));
        });
    }

    private void initCustomFields(List<Long> projectIds) {
        List<BindableEntity> bindableEntities = List.of(BindableEntity.TEST_CASE, BindableEntity.TEST_STEP, BindableEntity.REQUIREMENT_VERSION);
        Map<String, Map<BindableEntity, List<CustomField>>> customFieldsByProjectNames = this.customFieldDao.findByProjectIdsAndEntities(projectIds, bindableEntities);
        customFieldsByProjectNames.forEach((projectName, customFieldsByEntity) -> {
            Optional.ofNullable((List)customFieldsByEntity.get(BindableEntity.TEST_CASE)).ifPresent(customFields -> {
                boolean bl = this.tcCufsPerProjectname.putAll(projectName, (Collection)customFields);
            });
            Optional.ofNullable((List)customFieldsByEntity.get(BindableEntity.TEST_STEP)).ifPresent(customFields -> {
                boolean bl = this.stepCufsPerProjectname.putAll(projectName, (Collection)customFields);
            });
            Optional.ofNullable((List)customFieldsByEntity.get(BindableEntity.REQUIREMENT_VERSION)).ifPresent(customFields -> {
                boolean bl = this.reqCufsPerProjectname.putAll(projectName, (Collection)customFields);
            });
        });
    }

    public void mainInitRequirements(RequirementVersionTarget target) {
        this.mainInitRequirements(Collections.singleton(target));
    }

    public void mainInitRequirements(Set<RequirementVersionTarget> targets) {
        this.mainInitRequirementVersions(targets);
        this.initRequirementProjects(targets);
    }

    private void initRequirementProjects(Collection<RequirementVersionTarget> uniqueTargets) {
        Set<String> projectPaths = this.collectRequirementProjects(uniqueTargets);
        LOGGER.debug("ReqImport - Looking for project {}", new Object[]{projectPaths});
        this.initProjectsByName(projectPaths);
    }

    public void initRequirements(Set<RequirementVersionTarget> targets, boolean checkHighLevel) {
        this.initRequirementVersions(targets, checkHighLevel);
        this.initRequirementProjects(targets);
    }

    private void initRequirementVersions(Set<RequirementVersionTarget> versionTargets, boolean checkHighLevel) {
        List<RequirementVersionTarget> targets = versionTargets.stream().filter(this.requirementTree::targetNotLoaded).toList();
        if (targets.isEmpty()) {
            return;
        }
        Set<RequirementTarget> requirementTargets = versionTargets.stream().map(RequirementVersionTarget::getRequirement).filter(this.requirementTree::targetNotLoaded).collect(Collectors.toSet());
        this.loadRequirements(requirementTargets, checkHighLevel);
        this.loadRequirementVersions(targets);
    }

    public void loadRequirements(Set<RequirementTarget> targets, boolean checkHighLevel) {
        if (targets.isEmpty()) {
            return;
        }
        Set<String> projects = this.collectProjects(targets);
        ImportRequirementFinder finder = new ImportRequirementFinder(this.requirementImportDao, Collections.emptySet(), checkHighLevel);
        finder.fetch(targets, projects);
        this.requirementTree.addNodes(targets, finder);
    }

    public void mainInitRequirementVersions(Collection<RequirementVersionTarget> versionTargets) {
        LOGGER.debug("ReqImport - Initialize targets", new Object[0]);
        List<RequirementVersionTarget> targets = versionTargets.stream().filter(this.requirementTree::targetNotLoaded).toList();
        if (targets.isEmpty()) {
            return;
        }
        this.mainLoadRequirements(targets);
        this.loadRequirementVersions(targets);
    }

    private void loadRequirementVersions(List<RequirementVersionTarget> targets) {
        Map versionsByTarget = targets.stream().collect(Collectors.groupingBy(RequirementVersionTarget::getRequirement, Collectors.toMap(RequirementVersionTarget::getVersion, Function.identity())));
        Map<Long, Map<Integer, ReqVersionMilestone>> versionMilestonesByRequirementId = this.getVersionsMilestones(targets);
        versionsByTarget.forEach((requirement, versions) -> {
            Map<Integer, ReqVersionMilestone> versionNumberMilestones = versionMilestonesByRequirementId.getOrDefault(this.getRequirementId((RequirementTarget)requirement), Collections.emptyMap());
            versions.entrySet().stream().filter(entry -> !versionNumberMilestones.containsKey(entry.getKey())).forEach(entry -> this.requirementTree.addVersion((RequirementVersionTarget)entry.getValue(), new TargetStatus(Existence.NOT_EXISTS)));
            this.initializeExistingVersions((RequirementTarget)requirement, (Map<Integer, RequirementVersionTarget>)versions, versionNumberMilestones);
        });
    }

    private Map<Long, Map<Integer, ReqVersionMilestone>> getVersionsMilestones(Collection<RequirementVersionTarget> versionTargets) {
        Set<Long> requirementIds = versionTargets.stream().filter(this::isRequirementExisting).map(this.requirementTree::getNodeId).collect(Collectors.toSet());
        return this.requirementImportDao.findReqVersionAndMilestonesByReqId(requirementIds);
    }

    private void mainLoadRequirements(List<RequirementVersionTarget> versionTargets) {
        Set<RequirementTarget> targets = versionTargets.stream().map(RequirementVersionTarget::getRequirement).filter(this.requirementTree::targetNotLoaded).collect(Collectors.toSet());
        if (targets.isEmpty()) {
            return;
        }
        String projectName = ((RequirementTarget)targets.stream().findFirst().orElseThrow()).getProject();
        Long requirementLibraryId = this.projectDao.findRequirementLibraryIdByName(projectName);
        ImportRequirementFinder finder = new ImportRequirementFinder(this.requirementImportDao, targets, true);
        finder.fetch(targets, projectName);
        this.requirementTree.addNodes(targets, finder, projectName, requirementLibraryId);
    }

    private boolean isRequirementExisting(RequirementVersionTarget target) {
        return this.isRequirementExisting(target.getRequirement());
    }

    private boolean isRequirementExisting(RequirementTarget target) {
        return this.getStatus(target).getStatus() == Existence.EXISTS;
    }

    private void initializeExistingVersions(RequirementTarget requirementTarget, Map<Integer, RequirementVersionTarget> versions, Map<Integer, ReqVersionMilestone> milestonesByVersionNum) {
        milestonesByVersionNum.forEach((versionNumber, reqVersionMilestones) -> {
            RequirementVersionTarget targetVersion = versions.getOrDefault(versionNumber, new RequirementVersionTarget(requirementTarget, (Integer)versionNumber));
            this.requirementTree.addVersion(targetVersion, new TargetStatus(Existence.EXISTS, reqVersionMilestones.getReqVersionId()));
            this.bindMilestones((ReqVersionMilestone)reqVersionMilestones, targetVersion);
        });
    }

    private void bindMilestones(ReqVersionMilestone reqVersionMilestones, RequirementVersionTarget targetVersion) {
        reqVersionMilestones.getMilestoneStatusByLabel().forEach((label, status) -> {
            this.requirementTree.bindMilestone(targetVersion, (String)label);
            if (MilestoneStatus.LOCKED.equals(status) || MilestoneStatus.PLANNED.equals(status)) {
                this.requirementTree.milestoneLock(targetVersion);
            }
        });
    }

    public void updateRequirementVersionStatus(RequirementVersionTarget target, TargetStatus targetStatus, List<String> milestones) {
        this.requirementTree.updateVersionStatus(target, targetStatus);
        this.requirementTree.bindMilestone(target, milestones);
    }

    public void updateRequirementStatus(RequirementTarget target, TargetStatus status) {
        this.requirementTree.updateStatus(target, status);
    }

    public Long getRequirementId(RequirementVersionTarget target) {
        return this.getRequirementId(target.getRequirement());
    }

    public Long getRequirementId(RequirementTarget target) {
        Long id = target.getId();
        if (id == null) {
            id = this.requirementTree.getNodeId(target);
            target.setId(id);
        }
        return id;
    }

    public void setNotExists(RequirementVersionTarget target) {
        this.requirementTree.setNotExists(target);
    }

    public boolean checkMilestonesAlreadyUsedInRequirement(String milestone, RequirementVersionTarget target) {
        return this.requirementTree.isMilestoneUsedByOneVersion(target, milestone);
    }

    public boolean isRequirementFolder(RequirementVersionTarget target) {
        return this.requirementTree.isRequirementFolder(target);
    }

    public boolean isRequirementFolder(RequirementTarget target) {
        return this.requirementTree.isRequirementFolder(target);
    }

    public void bindMilestonesToRequirementVersion(RequirementVersionTarget target, List<String> milestones) {
        this.requirementTree.bindMilestone(target, milestones);
    }

    public boolean isRequirementVersionLockedByMilestones(RequirementVersionTarget target) {
        if (this.requirementTree.targetNotLoaded(target)) {
            this.mainInitRequirements(target);
        }
        return this.requirementTree.isMilestoneLocked(target);
    }

    private Set<String> collectProjects(Collection<? extends WithPath> targets) {
        Set<String> paths = this.collectPaths(targets);
        return PathUtils.extractProjectNames(paths);
    }

    private Set<String> collectRequirementProjects(Collection<RequirementVersionTarget> targets) {
        Set<String> paths = this.collectRequirementPaths(targets);
        return PathUtils.extractProjectNames(paths);
    }

    private Set<String> collectPaths(Collection<? extends WithPath> targets) {
        return targets.stream().map(WithPath::getPath).collect(Collectors.toSet());
    }

    private Set<String> collectRequirementPaths(Collection<RequirementVersionTarget> targets) {
        return targets.stream().map(target -> target.getRequirement().getPath()).collect(Collectors.toSet());
    }

    private void swapNameForPath(Collection<LibraryGraph.SimpleNode<NamedReference>> references) {
        ArrayList<LibraryGraph.SimpleNode<NamedReference>> listedRefs = new ArrayList<LibraryGraph.SimpleNode<NamedReference>>(references);
        List<Long> ids = listedRefs.stream().map(ref -> ((NamedReference)ref.getKey()).getId()).toList();
        List<String> paths = this.finderService.getPathsAsString(ids);
        int i = 0;
        while (i < paths.size()) {
            LibraryGraph.SimpleNode currentNode = (LibraryGraph.SimpleNode)listedRefs.get(i);
            Long id = ids.get(i);
            String path = paths.get(i);
            currentNode.setKey((Object)new NamedReference(id, path));
            ++i;
        }
    }

    public boolean isRequirementChild(RequirementTarget requirementTarget) {
        return this.requirementTree.isRequirementChild(requirementTarget);
    }

    private static final class InternalStepModel {
        private final StepType type;
        private TestCaseTarget calledTC;
        private Boolean delegates = null;

        public InternalStepModel(StepType type, TestCaseTarget calledTC) {
            this.type = type;
            this.calledTC = calledTC;
        }

        public InternalStepModel(StepType type, TestCaseTarget calledTC, boolean delegates) {
            this.type = type;
            this.calledTC = calledTC;
            this.delegates = delegates;
        }

        public void setDelegates(boolean delegates) {
            this.delegates = delegates;
        }

        public boolean getDeleguates() {
            return this.delegates;
        }

        public TestCaseTarget getCalledTC() {
            return this.calledTC;
        }

        public void setCalledTC(TestCaseTarget calledTC) {
            this.calledTC = calledTC;
        }

        public StepType getType() {
            return this.type;
        }
    }

    private record StepDetail(String stepType, Long calledTestCase, boolean delegate) {
    }
}

