/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.bugtracker;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.scheduling.annotation.Async;
import org.springframework.security.core.context.SecurityContext;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerProviderDescriptor;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchForm;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchRequest;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.bugtracker.definition.context.BugTrackerBindingInfo;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.exception.bugtracker.BadCredentialsException;
import org.squashtest.tm.service.servers.UserCredentialsCache;

public interface BugTrackersService {
    public Credentials getCredentials(BugTracker var1) throws BadCredentialsException;

    public boolean isCredentialsNeeded(BugTracker var1);

    public void testCredentials(BugTracker var1, Credentials var2);

    public BugTrackerInterfaceDescriptor getInterfaceDescriptor(BugTracker var1);

    public BugTrackerProviderDescriptor getProviderDescriptor(String var1);

    public URL getViewIssueUrl(String var1, BugTracker var2);

    public RemoteIssue createIssue(RemoteIssue var1, BugTracker var2);

    public RemoteIssue getIssue(String var1, BugTracker var2);

    @Async
    public Future<List<RemoteIssue>> getIssues(Long var1, Collection<String> var2, BugTracker var3, UserCredentialsCache var4, LocaleContext var5, SecurityContext var6);

    public RemoteIssue createReportIssueTemplate(String var1, BugTracker var2, RemoteIssueContext var3);

    public void forwardAttachments(String var1, BugTracker var2, List<Attachment> var3);

    public Object forwardDelegateCommand(DelegateCommand var1, BugTracker var2);

    public Set<String> getProviderKinds();

    public void linkIssueToRemoteRequirements(String var1, List<String> var2, BugTracker var3);

    public RemoteIssueSearchForm getRemoteIssueSearchForm(BugTracker var1, BugTrackerBindingInfo var2);

    public Optional<? extends RemoteIssue> searchIssue(RemoteIssueSearchRequest var1, BugTracker var2);

    public BugTrackerBindingInfo getBugTrackerBindingInfo(GenericProject var1);
}

