/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.annotation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.annotation.BatchPreventConcurrent;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.IdCoercer;
import org.squashtest.tm.service.annotation.Ids;
import org.squashtest.tm.service.annotation.IdsCoercer;
import org.squashtest.tm.service.annotation.PreventConcurrent;
import org.squashtest.tm.service.annotation.PreventConcurrents;
import org.squashtest.tm.service.concurrent.EntityLockManager;

@Component
@Aspect
public class PreventConcurrentAspect
implements Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreventConcurrentAspect.class);
    private static final String ANY_ARG_ANNOTATED = "I coult not find any arg annotated @";
    private static final String IN_PREVENT_CONCURRENT_METHOD = " in @PreventConcurrent method '";
    private static final String MUST_BE_A_STRUCTURAL_ERROR = "' This must be a structural programming error";
    private static final String UNCHECKED = "unchecked";

    public int getOrder() {
        return -2147483647;
    }

    @Around(value="execution(@org.squashtest.tm.service.annotation.PreventConcurrent * *(..)) && @annotation(pc)", argNames="pc")
    public Object lockEntity(ProceedingJoinPoint pjp, PreventConcurrent pc) throws Throwable {
        Object object;
        Serializable id = this.findEntityId(pjp);
        IdCoercer coercer = pc.coercer().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Serializable coercedId = coercer.coerce(id);
        EntityLockManager.EntityRef ref = new EntityLockManager.EntityRef(pc.entityType(), coercedId);
        ReentrantLock lock = EntityLockManager.getLock(ref);
        lock.lock();
        LOGGER.debug("Acquired lock on {}", new Object[]{lock});
        try {
            object = pjp.proceed();
        }
        catch (Throwable throwable) {
            LOGGER.debug("Releasing lock on {}", new Object[]{lock});
            lock.unlock();
            throw throwable;
        }
        LOGGER.debug("Releasing lock on {}", new Object[]{lock});
        lock.unlock();
        return object;
    }

    @Around(value="execution(@org.squashtest.tm.service.annotation.PreventConcurrents * *(..)) && @annotation(pc)", argNames="pc")
    public Object lockEntities(ProceedingJoinPoint pjp, PreventConcurrents pc) throws Throwable {
        Set<EntityLockManager.EntityRef> refs = this.findEntityRefs(pjp, pc);
        Collection<Lock> locks = EntityLockManager.lock(refs);
        try {
            Object object = pjp.proceed();
            return object;
        }
        finally {
            EntityLockManager.release(locks);
        }
    }

    @Around(value="execution(@org.squashtest.tm.service.annotation.BatchPreventConcurrent * *(..)) && @annotation(pc)", argNames="pc")
    public Object lockEntities(ProceedingJoinPoint pjp, BatchPreventConcurrent pc) throws Throwable {
        Collection<? extends Serializable> sourceIds = this.findEntityIds(pjp);
        IdsCoercer coercer = pc.coercer().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Collection<? extends Serializable> ids = coercer.coerce(sourceIds);
        HashSet<EntityLockManager.EntityRef> refs = new HashSet<EntityLockManager.EntityRef>();
        for (Serializable serializable : ids) {
            refs.add(new EntityLockManager.EntityRef(pc.entityType(), serializable));
        }
        Collection<Lock> collection = EntityLockManager.lock(refs);
        try {
            Object object = pjp.proceed();
            return object;
        }
        finally {
            EntityLockManager.release(collection);
        }
    }

    private Serializable findEntityId(ProceedingJoinPoint pjp) {
        return (Serializable)this.findAnnotatedParam(pjp, Id.class);
    }

    private Collection<? extends Serializable> findEntityIds(ProceedingJoinPoint pjp) {
        return (Collection)this.findAnnotatedParam(pjp, Ids.class);
    }

    private <T> T findAnnotatedParam(ProceedingJoinPoint pjp, Class<? extends Annotation> expected) {
        MethodSignature sig = (MethodSignature)pjp.getSignature();
        Method meth = sig.getMethod();
        Annotation[][] annotations = meth.getParameterAnnotations();
        LOGGER.trace("Advising method {}{}.", new Object[]{pjp.getSignature().getDeclaringTypeName(), meth.getName()});
        T annotatedParam = this.findAnnotatedParam(pjp, expected, annotations, meth);
        if (annotatedParam == null) {
            throw new IllegalArgumentException(ANY_ARG_ANNOTATED + expected.getSimpleName() + IN_PREVENT_CONCURRENT_METHOD + pjp.getSignature().getDeclaringTypeName() + "." + meth.getName() + MUST_BE_A_STRUCTURAL_ERROR);
        }
        return annotatedParam;
    }

    private <T> T findAnnotatedParam(ProceedingJoinPoint pjp, Class<? extends Annotation> expected, Annotation[][] annotations, Method meth) {
        int iArg = 0;
        while (iArg < annotations.length) {
            Annotation[] curArg;
            Annotation[] annotationArray = curArg = annotations[iArg];
            int n = curArg.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (annotation.annotationType().equals(expected)) {
                    LOGGER.trace("Found required @{} on arg #{} of method {}", new Object[]{expected.getSimpleName(), iArg, meth.getName()});
                    return (T)pjp.getArgs()[iArg];
                }
                ++n2;
            }
            ++iArg;
        }
        return null;
    }

    private Set<EntityLockManager.EntityRef> findEntityRefs(ProceedingJoinPoint pjp, PreventConcurrents pc) throws Throwable {
        HashSet<EntityLockManager.EntityRef> refs = new HashSet<EntityLockManager.EntityRef>();
        refs.addAll(this.findEntityIdsForSimpleLocks(pjp, pc.simplesLocks()));
        refs.addAll(this.findEntityIdsForBashLocks(pjp, pc.batchsLocks()));
        return refs;
    }

    private Collection<EntityLockManager.EntityRef> findEntityIdsForBashLocks(ProceedingJoinPoint pjp, BatchPreventConcurrent[] batchsLocks) throws Throwable {
        HashSet<EntityLockManager.EntityRef> refs = new HashSet<EntityLockManager.EntityRef>();
        BatchPreventConcurrent[] batchPreventConcurrentArray = batchsLocks;
        int n = batchsLocks.length;
        int n2 = 0;
        while (n2 < n) {
            BatchPreventConcurrent batchPreventConcurrent = batchPreventConcurrentArray[n2];
            refs.addAll(this.findEntityRefForNamedParam(pjp, batchPreventConcurrent));
            ++n2;
        }
        return refs;
    }

    private Collection<EntityLockManager.EntityRef> findEntityIdsForSimpleLocks(ProceedingJoinPoint pjp, PreventConcurrent[] simplesLocks) throws Throwable {
        HashSet<EntityLockManager.EntityRef> refs = new HashSet<EntityLockManager.EntityRef>();
        PreventConcurrent[] preventConcurrentArray = simplesLocks;
        int n = simplesLocks.length;
        int n2 = 0;
        while (n2 < n) {
            PreventConcurrent preventConcurrent = preventConcurrentArray[n2];
            refs.add(this.findEntityRefForNamedParam(pjp, preventConcurrent));
            ++n2;
        }
        return refs;
    }

    private EntityLockManager.EntityRef findEntityRefForNamedParam(ProceedingJoinPoint pjp, PreventConcurrent preventConcurrent) throws Throwable {
        Class<?> entityType = preventConcurrent.entityType();
        Serializable id = (Serializable)this.findIdForNamedParam(pjp, preventConcurrent.paramName(), Id.class);
        IdCoercer coercer = preventConcurrent.coercer().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        EntityLockManager.EntityRef entityRef = new EntityLockManager.EntityRef(entityType, coercer.coerce(id));
        LOGGER.debug("Prevent Concurency - Finded an entity to lock {}.", new Object[]{entityRef.toString()});
        return entityRef;
    }

    private Set<EntityLockManager.EntityRef> findEntityRefForNamedParam(ProceedingJoinPoint pjp, BatchPreventConcurrent batchPreventConcurrent) throws Throwable {
        Class<?> entityType = batchPreventConcurrent.entityType();
        Object sourceIds = this.findIdForNamedParam(pjp, batchPreventConcurrent.paramName(), Ids.class);
        IdsCoercer coercer = batchPreventConcurrent.coercer().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Collection<? extends Serializable> ids = coercer.coerce(sourceIds);
        HashSet<EntityLockManager.EntityRef> refs = new HashSet<EntityLockManager.EntityRef>();
        for (Serializable serializable : ids) {
            refs.add(new EntityLockManager.EntityRef(entityType, serializable));
        }
        LOGGER.debug("Prevent Concurency - Finded several entities to lock {}.", new Object[]{((Object)refs).toString()});
        return refs;
    }

    private <T> T findIdForNamedParam(ProceedingJoinPoint pjp, String paramName, Class<? extends Annotation> expected) {
        MethodSignature sig = (MethodSignature)pjp.getSignature();
        Method meth = sig.getMethod();
        Annotation[][] annotations = meth.getParameterAnnotations();
        LOGGER.debug("Prevent Concurency - Advising method {}{}.", new Object[]{pjp.getSignature().getDeclaringTypeName(), meth.getName()});
        T annotatedParam = this.findAnnotatedParam(pjp, paramName, expected, annotations, meth);
        if (annotatedParam == null) {
            throw new IllegalArgumentException(ANY_ARG_ANNOTATED + expected.getSimpleName() + IN_PREVENT_CONCURRENT_METHOD + pjp.getSignature().getDeclaringTypeName() + "." + meth.getName() + MUST_BE_A_STRUCTURAL_ERROR);
        }
        return annotatedParam;
    }

    private <T> T findAnnotatedParam(ProceedingJoinPoint pjp, String paramName, Class<? extends Annotation> expected, Annotation[][] annotations, Method meth) {
        int iArg = 0;
        while (iArg < annotations.length) {
            Annotation[] curArg;
            Annotation[] annotationArray = curArg = annotations[iArg];
            int n = curArg.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (this.annotationMatches(pjp, paramName, expected, meth, annotation, iArg)) {
                    return (T)pjp.getArgs()[iArg];
                }
                ++n2;
            }
            ++iArg;
        }
        return null;
    }

    private boolean annotationMatches(ProceedingJoinPoint pjp, String paramName, Class<? extends Annotation> expected, Method meth, Annotation annotation, int iArg) {
        if (annotation.annotationType().equals(expected)) {
            String annoValue = this.findAnnotationParamName(annotation);
            if (annoValue.equals(paramName)) {
                LOGGER.trace("Found required @{} on arg #{} of method {}", new Object[]{expected.getSimpleName(), iArg, meth.getName()});
                return true;
            }
            throw new IllegalArgumentException(ANY_ARG_ANNOTATED + expected.getSimpleName() + " with a value of " + paramName + IN_PREVENT_CONCURRENT_METHOD + pjp.getSignature().getDeclaringTypeName() + "." + meth.getName() + ". Instead an @Id was found with a value of " + annoValue + MUST_BE_A_STRUCTURAL_ERROR);
        }
        return false;
    }

    private String findAnnotationParamName(Annotation annotation) {
        if (annotation.annotationType().equals(Id.class)) {
            return ((Id)annotation).value();
        }
        if (annotation.annotationType().equals(Ids.class)) {
            return ((Ids)annotation).value();
        }
        return null;
    }
}

