ace.define("ace/mode/css_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules"],(function(e,t,n){"use strict";var r=e("../lib/oop");var a=e("../lib/lang");var o=e("./text_highlight_rules").TextHighlightRules;var i=t.supportType="align-content|align-items|align-self|all|animation|animation-delay|animation-direction|animation-duration|animation-fill-mode|animation-iteration-count|animation-name|animation-play-state|animation-timing-function|backface-visibility|background|background-attachment|background-blend-mode|background-clip|background-color|background-image|background-origin|background-position|background-repeat|background-size|border|border-bottom|border-bottom-color|border-bottom-left-radius|border-bottom-right-radius|border-bottom-style|border-bottom-width|border-collapse|border-color|border-image|border-image-outset|border-image-repeat|border-image-slice|border-image-source|border-image-width|border-left|border-left-color|border-left-style|border-left-width|border-radius|border-right|border-right-color|border-right-style|border-right-width|border-spacing|border-style|border-top|border-top-color|border-top-left-radius|border-top-right-radius|border-top-style|border-top-width|border-width|bottom|box-shadow|box-sizing|caption-side|clear|clip|color|column-count|column-fill|column-gap|column-rule|column-rule-color|column-rule-style|column-rule-width|column-span|column-width|columns|content|counter-increment|counter-reset|cursor|direction|display|empty-cells|filter|flex|flex-basis|flex-direction|flex-flow|flex-grow|flex-shrink|flex-wrap|float|font|font-family|font-size|font-size-adjust|font-stretch|font-style|font-variant|font-weight|hanging-punctuation|height|justify-content|left|letter-spacing|line-height|list-style|list-style-image|list-style-position|list-style-type|margin|margin-bottom|margin-left|margin-right|margin-top|max-height|max-width|max-zoom|min-height|min-width|min-zoom|nav-down|nav-index|nav-left|nav-right|nav-up|opacity|order|outline|outline-color|outline-offset|outline-style|outline-width|overflow|overflow-x|overflow-y|padding|padding-bottom|padding-left|padding-right|padding-top|page-break-after|page-break-before|page-break-inside|perspective|perspective-origin|position|quotes|resize|right|tab-size|table-layout|text-align|text-align-last|text-decoration|text-decoration-color|text-decoration-line|text-decoration-style|text-indent|text-justify|text-overflow|text-shadow|text-transform|top|transform|transform-origin|transform-style|transition|transition-delay|transition-duration|transition-property|transition-timing-function|unicode-bidi|user-select|user-zoom|vertical-align|visibility|white-space|width|word-break|word-spacing|word-wrap|z-index";var s=t.supportFunction="rgb|rgba|url|attr|counter|counters";var l=t.supportConstant="absolute|after-edge|after|all-scroll|all|alphabetic|always|antialiased|armenian|auto|avoid-column|avoid-page|avoid|balance|baseline|before-edge|before|below|bidi-override|block-line-height|block|bold|bolder|border-box|both|bottom|box|break-all|break-word|capitalize|caps-height|caption|center|central|char|circle|cjk-ideographic|clone|close-quote|col-resize|collapse|column|consider-shifts|contain|content-box|cover|crosshair|cubic-bezier|dashed|decimal-leading-zero|decimal|default|disabled|disc|disregard-shifts|distribute-all-lines|distribute-letter|distribute-space|distribute|dotted|double|e-resize|ease-in|ease-in-out|ease-out|ease|ellipsis|end|exclude-ruby|fill|fixed|georgian|glyphs|grid-height|groove|hand|hanging|hebrew|help|hidden|hiragana-iroha|hiragana|horizontal|icon|ideograph-alpha|ideograph-numeric|ideograph-parenthesis|ideograph-space|ideographic|inactive|include-ruby|inherit|initial|inline-block|inline-box|inline-line-height|inline-table|inline|inset|inside|inter-ideograph|inter-word|invert|italic|justify|katakana-iroha|katakana|keep-all|last|left|lighter|line-edge|line-through|line|linear|list-item|local|loose|lower-alpha|lower-greek|lower-latin|lower-roman|lowercase|lr-tb|ltr|mathematical|max-height|max-size|medium|menu|message-box|middle|move|n-resize|ne-resize|newspaper|no-change|no-close-quote|no-drop|no-open-quote|no-repeat|none|normal|not-allowed|nowrap|nw-resize|oblique|open-quote|outset|outside|overline|padding-box|page|pointer|pre-line|pre-wrap|pre|preserve-3d|progress|relative|repeat-x|repeat-y|repeat|replaced|reset-size|ridge|right|round|row-resize|rtl|s-resize|scroll|se-resize|separate|slice|small-caps|small-caption|solid|space|square|start|static|status-bar|step-end|step-start|steps|stretch|strict|sub|super|sw-resize|table-caption|table-cell|table-column-group|table-column|table-footer-group|table-header-group|table-row-group|table-row|table|tb-rl|text-after-edge|text-before-edge|text-bottom|text-size|text-top|text|thick|thin|transparent|underline|upper-alpha|upper-latin|upper-roman|uppercase|use-script|vertical-ideographic|vertical-text|visible|w-resize|wait|whitespace|z-index|zero|zoom";var u=t.supportConstantColor="aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkgrey|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkslategrey|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dimgrey|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|grey|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgray|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightslategrey|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|rebeccapurple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|slategrey|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|violet|wheat|white|whitesmoke|yellow|yellowgreen";var c=t.supportConstantFonts="arial|century|comic|courier|cursive|fantasy|garamond|georgia|helvetica|impact|lucida|symbol|system|tahoma|times|trebuchet|utopia|verdana|webdings|sans-serif|serif|monospace";var g=t.numRe="\\-?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))";var d=t.pseudoElements="(\\:+)\\b(after|before|first-letter|first-line|moz-selection|selection)\\b";var p=t.pseudoClasses="(:)\\b(active|checked|disabled|empty|enabled|first-child|first-of-type|focus|hover|indeterminate|invalid|last-child|last-of-type|link|not|nth-child|nth-last-child|nth-last-of-type|nth-of-type|only-child|only-of-type|required|root|target|valid|visited)\\b";var h=function(){var e=this.createKeywordMapper({"support.function":s,"support.constant":l,"support.type":i,"support.constant.color":u,"support.constant.fonts":c},"text",true);this.$rules={start:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"ruleset"},{token:"paren.rparen",regex:"\\}"},{token:"string",regex:"@(?!viewport)",next:"media"},{token:"keyword",regex:"#[a-z0-9-_]+"},{token:"keyword",regex:"%"},{token:"variable",regex:"\\.[a-z0-9-_]+"},{token:"string",regex:":[a-z0-9-_]+"},{token:"constant.numeric",regex:g},{token:"constant",regex:"[a-z0-9-_]+"},{caseInsensitive:true}],media:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"start"},{token:"paren.rparen",regex:"\\}",next:"start"},{token:"string",regex:";",next:"start"},{token:"keyword",regex:"(?:media|supports|document|charset|import|namespace|media|supports|document"+"|page|font|keyframes|viewport|counter-style|font-feature-values"+"|swash|ornaments|annotation|stylistic|styleset|character-variant)"}],comments:[{token:"comment",regex:"\\/\\*",push:[{token:"comment",regex:"\\*\\/",next:"pop"},{defaultToken:"comment"}]}],ruleset:[{regex:"-(webkit|ms|moz|o)-",token:"text"},{token:"punctuation.operator",regex:"[:;]"},{token:"paren.rparen",regex:"\\}",next:"start"},{include:["strings","url","comments"]},{token:["constant.numeric","keyword"],regex:"("+g+")(ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vmax|vmin|vm|vw|%)"},{token:"constant.numeric",regex:g},{token:"constant.numeric",regex:"#[a-f0-9]{6}"},{token:"constant.numeric",regex:"#[a-f0-9]{3}"},{token:["punctuation","entity.other.attribute-name.pseudo-element.css"],regex:d},{token:["punctuation","entity.other.attribute-name.pseudo-class.css"],regex:p},{include:"url"},{token:e,regex:"\\-?[a-zA-Z_][a-zA-Z0-9_\\-]*"},{caseInsensitive:true}],url:[{token:"support.function",regex:"(?:url(:?-prefix)?|domain|regexp)\\(",push:[{token:"support.function",regex:"\\)",next:"pop"},{defaultToken:"string"}]}],strings:[{token:"string.start",regex:"'",push:[{token:"string.end",regex:"'|$",next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:true},{defaultToken:"string"}]},{token:"string.start",regex:'"',push:[{token:"string.end",regex:'"|$',next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:true},{defaultToken:"string"}]}],escapes:[{token:"constant.language.escape",regex:/\\([a-fA-F\d]{1,6}|[^a-fA-F\d])/}]};this.normalizeRules()};r.inherits(h,o);t.CssHighlightRules=h}));ace.define("ace/mode/doc_comment_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],(function(e,t,n){"use strict";var r=e("../lib/oop");var a=e("./text_highlight_rules").TextHighlightRules;var o=function(){this.$rules={start:[{token:"comment.doc.tag",regex:"@[\\w\\d_]+"},o.getTagRule(),{defaultToken:"comment.doc",caseInsensitive:true}]}};r.inherits(o,a);o.getTagRule=function(e){return{token:"comment.doc.tag.storage.type",regex:"\\b(?:TODO|FIXME|XXX|HACK)\\b"}};o.getStartRule=function(e){return{token:"comment.doc",regex:"\\/\\*(?=\\*)",next:e}};o.getEndRule=function(e){return{token:"comment.doc",regex:"\\*\\/",next:e}};t.DocCommentHighlightRules=o}));ace.define("ace/mode/javascript_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/doc_comment_highlight_rules","ace/mode/text_highlight_rules"],(function(e,t,n){"use strict";var r=e("../lib/oop");var a=e("./doc_comment_highlight_rules").DocCommentHighlightRules;var o=e("./text_highlight_rules").TextHighlightRules;var i="[a-zA-Z\\$_¡-￿][a-zA-Z\\d\\$_¡-￿]*";var s=function(e){var t=this.createKeywordMapper({"variable.language":"Array|Boolean|Date|Function|Iterator|Number|Object|RegExp|String|Proxy|"+"Namespace|QName|XML|XMLList|"+"ArrayBuffer|Float32Array|Float64Array|Int16Array|Int32Array|Int8Array|"+"Uint16Array|Uint32Array|Uint8Array|Uint8ClampedArray|"+"Error|EvalError|InternalError|RangeError|ReferenceError|StopIteration|"+"SyntaxError|TypeError|URIError|"+"decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|eval|isFinite|"+"isNaN|parseFloat|parseInt|"+"JSON|Math|"+"this|arguments|prototype|window|document",keyword:"const|yield|import|get|set|async|await|"+"break|case|catch|continue|default|delete|do|else|finally|for|function|"+"if|in|of|instanceof|new|return|switch|throw|try|typeof|let|var|while|with|debugger|"+"__parent__|__count__|escape|unescape|with|__proto__|"+"class|enum|extends|super|export|implements|private|public|interface|package|protected|static","storage.type":"const|let|var|function","constant.language":"null|Infinity|NaN|undefined","support.function":"alert","constant.language.boolean":"true|false"},"identifier");var n="case|do|else|finally|in|instanceof|return|throw|try|typeof|yield|void";var r="\\\\(?:x[0-9a-fA-F]{2}|"+"u[0-9a-fA-F]{4}|"+"u{[0-9a-fA-F]{1,6}}|"+"[0-2][0-7]{0,2}|"+"3[0-7][0-7]?|"+"[4-7][0-7]?|"+".)";this.$rules={no_regex:[a.getStartRule("doc-start"),u("no_regex"),{token:"string",regex:"'(?=.)",next:"qstring"},{token:"string",regex:'"(?=.)',next:"qqstring"},{token:"constant.numeric",regex:/0(?:[xX][0-9a-fA-F]+|[oO][0-7]+|[bB][01]+)\b/},{token:"constant.numeric",regex:/(?:\d\d*(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+\b)?/},{token:["storage.type","punctuation.operator","support.function","punctuation.operator","entity.name.function","text","keyword.operator"],regex:"("+i+")(\\.)(prototype)(\\.)("+i+")(\\s*)(=)",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+i+")(\\.)("+i+")(\\s*)(=)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+i+")(\\s*)(=)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","entity.name.function","text","paren.lparen"],regex:"("+i+")(\\.)("+i+")(\\s*)(=)(\\s*)(function)(\\s+)(\\w+)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","text","entity.name.function","text","paren.lparen"],regex:"(function)(\\s+)("+i+")(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","punctuation.operator","text","storage.type","text","paren.lparen"],regex:"("+i+")(\\s*)(:)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["text","text","storage.type","text","paren.lparen"],regex:"(:)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:"keyword",regex:"from(?=\\s*('|\"))"},{token:"keyword",regex:"(?:"+n+")\\b",next:"start"},{token:["support.constant"],regex:/that\b/},{token:["storage.type","punctuation.operator","support.function.firebug"],regex:/(console)(\.)(warn|info|log|error|time|trace|timeEnd|assert)\b/},{token:t,regex:i},{token:"punctuation.operator",regex:/[.](?![.])/,next:"property"},{token:"storage.type",regex:/=>/,next:"start"},{token:"keyword.operator",regex:/--|\+\+|\.{3}|===|==|=|!=|!==|<+=?|>+=?|!|&&|\|\||\?:|[!$%&*+\-~\/^]=?/,next:"start"},{token:"punctuation.operator",regex:/[?:,;.]/,next:"start"},{token:"paren.lparen",regex:/[\[({]/,next:"start"},{token:"paren.rparen",regex:/[\])}]/},{token:"comment",regex:/^#!.*$/}],property:[{token:"text",regex:"\\s+"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","entity.name.function","text","paren.lparen"],regex:"("+i+")(\\.)("+i+")(\\s*)(=)(\\s*)(function)(?:(\\s+)(\\w+))?(\\s*)(\\()",next:"function_arguments"},{token:"punctuation.operator",regex:/[.](?![.])/},{token:"support.function",regex:/(s(?:h(?:ift|ow(?:Mod(?:elessDialog|alDialog)|Help))|croll(?:X|By(?:Pages|Lines)?|Y|To)?|t(?:op|rike)|i(?:n|zeToContent|debar|gnText)|ort|u(?:p|b(?:str(?:ing)?)?)|pli(?:ce|t)|e(?:nd|t(?:Re(?:sizable|questHeader)|M(?:i(?:nutes|lliseconds)|onth)|Seconds|Ho(?:tKeys|urs)|Year|Cursor|Time(?:out)?|Interval|ZOptions|Date|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Date|FullYear)|FullYear|Active)|arch)|qrt|lice|avePreferences|mall)|h(?:ome|andleEvent)|navigate|c(?:har(?:CodeAt|At)|o(?:s|n(?:cat|textual|firm)|mpile)|eil|lear(?:Timeout|Interval)?|a(?:ptureEvents|ll)|reate(?:StyleSheet|Popup|EventObject))|t(?:o(?:GMTString|S(?:tring|ource)|U(?:TCString|pperCase)|Lo(?:caleString|werCase))|est|a(?:n|int(?:Enabled)?))|i(?:s(?:NaN|Finite)|ndexOf|talics)|d(?:isableExternalCapture|ump|etachEvent)|u(?:n(?:shift|taint|escape|watch)|pdateCommands)|j(?:oin|avaEnabled)|p(?:o(?:p|w)|ush|lugins.refresh|a(?:ddings|rse(?:Int|Float)?)|r(?:int|ompt|eference))|e(?:scape|nableExternalCapture|val|lementFromPoint|x(?:p|ec(?:Script|Command)?))|valueOf|UTC|queryCommand(?:State|Indeterm|Enabled|Value)|f(?:i(?:nd|le(?:ModifiedDate|Size|CreatedDate|UpdatedDate)|xed)|o(?:nt(?:size|color)|rward)|loor|romCharCode)|watch|l(?:ink|o(?:ad|g)|astIndexOf)|a(?:sin|nchor|cos|t(?:tachEvent|ob|an(?:2)?)|pply|lert|b(?:s|ort))|r(?:ou(?:nd|teEvents)|e(?:size(?:By|To)|calc|turnValue|place|verse|l(?:oad|ease(?:Capture|Events)))|andom)|g(?:o|et(?:ResponseHeader|M(?:i(?:nutes|lliseconds)|onth)|Se(?:conds|lection)|Hours|Year|Time(?:zoneOffset)?|Da(?:y|te)|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Da(?:y|te)|FullYear)|FullYear|A(?:ttention|llResponseHeaders)))|m(?:in|ove(?:B(?:y|elow)|To(?:Absolute)?|Above)|ergeAttributes|a(?:tch|rgins|x))|b(?:toa|ig|o(?:ld|rderWidths)|link|ack))\b(?=\()/},{token:"support.function.dom",regex:/(s(?:ub(?:stringData|mit)|plitText|e(?:t(?:NamedItem|Attribute(?:Node)?)|lect))|has(?:ChildNodes|Feature)|namedItem|c(?:l(?:ick|o(?:se|neNode))|reate(?:C(?:omment|DATASection|aption)|T(?:Head|extNode|Foot)|DocumentFragment|ProcessingInstruction|E(?:ntityReference|lement)|Attribute))|tabIndex|i(?:nsert(?:Row|Before|Cell|Data)|tem)|open|delete(?:Row|C(?:ell|aption)|T(?:Head|Foot)|Data)|focus|write(?:ln)?|a(?:dd|ppend(?:Child|Data))|re(?:set|place(?:Child|Data)|move(?:NamedItem|Child|Attribute(?:Node)?)?)|get(?:NamedItem|Element(?:sBy(?:Name|TagName|ClassName)|ById)|Attribute(?:Node)?)|blur)\b(?=\()/},{token:"support.constant",regex:/(s(?:ystemLanguage|cr(?:ipts|ollbars|een(?:X|Y|Top|Left))|t(?:yle(?:Sheets)?|atus(?:Text|bar)?)|ibling(?:Below|Above)|ource|uffixes|e(?:curity(?:Policy)?|l(?:ection|f)))|h(?:istory|ost(?:name)?|as(?:h|Focus))|y|X(?:MLDocument|SLDocument)|n(?:ext|ame(?:space(?:s|URI)|Prop))|M(?:IN_VALUE|AX_VALUE)|c(?:haracterSet|o(?:n(?:structor|trollers)|okieEnabled|lorDepth|mp(?:onents|lete))|urrent|puClass|l(?:i(?:p(?:boardData)?|entInformation)|osed|asses)|alle(?:e|r)|rypto)|t(?:o(?:olbar|p)|ext(?:Transform|Indent|Decoration|Align)|ags)|SQRT(?:1_2|2)|i(?:n(?:ner(?:Height|Width)|put)|ds|gnoreCase)|zIndex|o(?:scpu|n(?:readystatechange|Line)|uter(?:Height|Width)|p(?:sProfile|ener)|ffscreenBuffering)|NEGATIVE_INFINITY|d(?:i(?:splay|alog(?:Height|Top|Width|Left|Arguments)|rectories)|e(?:scription|fault(?:Status|Ch(?:ecked|arset)|View)))|u(?:ser(?:Profile|Language|Agent)|n(?:iqueID|defined)|pdateInterval)|_content|p(?:ixelDepth|ort|ersonalbar|kcs11|l(?:ugins|atform)|a(?:thname|dding(?:Right|Bottom|Top|Left)|rent(?:Window|Layer)?|ge(?:X(?:Offset)?|Y(?:Offset)?))|r(?:o(?:to(?:col|type)|duct(?:Sub)?|mpter)|e(?:vious|fix)))|e(?:n(?:coding|abledPlugin)|x(?:ternal|pando)|mbeds)|v(?:isibility|endor(?:Sub)?|Linkcolor)|URLUnencoded|P(?:I|OSITIVE_INFINITY)|f(?:ilename|o(?:nt(?:Size|Family|Weight)|rmName)|rame(?:s|Element)|gColor)|E|whiteSpace|l(?:i(?:stStyleType|n(?:eHeight|kColor))|o(?:ca(?:tion(?:bar)?|lName)|wsrc)|e(?:ngth|ft(?:Context)?)|a(?:st(?:M(?:odified|atch)|Index|Paren)|yer(?:s|X)|nguage))|a(?:pp(?:MinorVersion|Name|Co(?:deName|re)|Version)|vail(?:Height|Top|Width|Left)|ll|r(?:ity|guments)|Linkcolor|bove)|r(?:ight(?:Context)?|e(?:sponse(?:XML|Text)|adyState))|global|x|m(?:imeTypes|ultiline|enubar|argin(?:Right|Bottom|Top|Left))|L(?:N(?:10|2)|OG(?:10E|2E))|b(?:o(?:ttom|rder(?:Width|RightWidth|BottomWidth|Style|Color|TopWidth|LeftWidth))|ufferDepth|elow|ackground(?:Color|Image)))\b/},{token:"identifier",regex:i},{regex:"",token:"empty",next:"no_regex"}],start:[a.getStartRule("doc-start"),u("start"),{token:"string.regexp",regex:"\\/",next:"regex"},{token:"text",regex:"\\s+|^$",next:"start"},{token:"empty",regex:"",next:"no_regex"}],regex:[{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp",regex:"/[sxngimy]*",next:"no_regex"},{token:"invalid",regex:/\{\d+\b,?\d*\}[+*]|[+*$^?][+*]|[$^][?]|\?{3,}/},{token:"constant.language.escape",regex:/\(\?[:=!]|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/},{token:"constant.language.delimiter",regex:/\|/},{token:"constant.language.escape",regex:/\[\^?/,next:"regex_character_class"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp"}],regex_character_class:[{token:"regexp.charclass.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"constant.language.escape",regex:"]",next:"regex"},{token:"constant.language.escape",regex:"-"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp.charachterclass"}],function_arguments:[{token:"variable.parameter",regex:i},{token:"punctuation.operator",regex:"[, ]+"},{token:"punctuation.operator",regex:"$"},{token:"empty",regex:"",next:"no_regex"}],qqstring:[{token:"constant.language.escape",regex:r},{token:"string",regex:"\\\\$",consumeLineEnd:true},{token:"string",regex:'"|$',next:"no_regex"},{defaultToken:"string"}],qstring:[{token:"constant.language.escape",regex:r},{token:"string",regex:"\\\\$",consumeLineEnd:true},{token:"string",regex:"'|$",next:"no_regex"},{defaultToken:"string"}]};if(!e||!e.noES6){this.$rules.no_regex.unshift({regex:"[{}]",onMatch:function(e,t,n){this.next=e=="{"?this.nextState:"";if(e=="{"&&n.length){n.unshift("start",t)}else if(e=="}"&&n.length){n.shift();this.next=n.shift();if(this.next.indexOf("string")!=-1||this.next.indexOf("jsx")!=-1)return"paren.quasi.end"}return e=="{"?"paren.lparen":"paren.rparen"},nextState:"start"},{token:"string.quasi.start",regex:/`/,push:[{token:"constant.language.escape",regex:r},{token:"paren.quasi.start",regex:/\${/,push:"start"},{token:"string.quasi.end",regex:/`/,next:"pop"},{defaultToken:"string.quasi"}]});if(!e||e.jsx!=false)l.call(this)}this.embedRules(a,"doc-",[a.getEndRule("no_regex")]);this.normalizeRules()};r.inherits(s,o);function l(){var e=i.replace("\\d","\\d\\-");var t={onMatch:function(e,t,n){var r=e.charAt(1)=="/"?2:1;if(r==1){if(t!=this.nextState)n.unshift(this.next,this.nextState,0);else n.unshift(this.next);n[2]++}else if(r==2){if(t==this.nextState){n[1]--;if(!n[1]||n[1]<0){n.shift();n.shift()}}}return[{type:"meta.tag.punctuation."+(r==1?"":"end-")+"tag-open.xml",value:e.slice(0,r)},{type:"meta.tag.tag-name.xml",value:e.substr(r)}]},regex:"</?"+e+"",next:"jsxAttributes",nextState:"jsx"};this.$rules.start.unshift(t);var n={regex:"{",token:"paren.quasi.start",push:"start"};this.$rules.jsx=[n,t,{include:"reference"},{defaultToken:"string"}];this.$rules.jsxAttributes=[{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",onMatch:function(e,t,n){if(t==n[0])n.shift();if(e.length==2){if(n[0]==this.nextState)n[1]--;if(!n[1]||n[1]<0){n.splice(0,2)}}this.next=n[0]||"start";return[{type:this.token,value:e}]},nextState:"jsx"},n,u("jsxAttributes"),{token:"entity.other.attribute-name.xml",regex:e},{token:"keyword.operator.attribute-equals.xml",regex:"="},{token:"text.tag-whitespace.xml",regex:"\\s+"},{token:"string.attribute-value.xml",regex:"'",stateName:"jsx_attr_q",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',stateName:"jsx_attr_qq",push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},t];this.$rules.reference=[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}]}function u(e){return[{token:"comment",regex:/\/\*/,next:[a.getTagRule(),{token:"comment",regex:"\\*\\/",next:e||"pop"},{defaultToken:"comment",caseInsensitive:true}]},{token:"comment",regex:"\\/\\/",next:[a.getTagRule(),{token:"comment",regex:"$|^",next:e||"pop"},{defaultToken:"comment",caseInsensitive:true}]}]}t.JavaScriptHighlightRules=s}));ace.define("ace/mode/xml_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],(function(e,t,n){"use strict";var r=e("../lib/oop");var a=e("./text_highlight_rules").TextHighlightRules;var o=function(e){var t="[_:a-zA-ZÀ-￿][-_:.a-zA-Z0-9À-￿]*";this.$rules={start:[{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\[",next:"cdata"},{token:["punctuation.instruction.xml","keyword.instruction.xml"],regex:"(<\\?)("+t+")",next:"processing_instruction"},{token:"comment.start.xml",regex:"<\\!--",next:"comment"},{token:["xml-pe.doctype.xml","xml-pe.doctype.xml"],regex:"(<\\!)(DOCTYPE)(?=[\\s])",next:"doctype",caseInsensitive:true},{include:"tag"},{token:"text.end-tag-open.xml",regex:"</"},{token:"text.tag-open.xml",regex:"<"},{include:"reference"},{defaultToken:"text.xml"}],processing_instruction:[{token:"entity.other.attribute-name.decl-attribute-name.xml",regex:t},{token:"keyword.operator.decl-attribute-equals.xml",regex:"="},{include:"whitespace"},{include:"string"},{token:"punctuation.xml-decl.xml",regex:"\\?>",next:"start"}],doctype:[{include:"whitespace"},{include:"string"},{token:"xml-pe.doctype.xml",regex:">",next:"start"},{token:"xml-pe.xml",regex:"[-_a-zA-Z0-9:]+"},{token:"punctuation.int-subset",regex:"\\[",push:"int_subset"}],int_subset:[{token:"text.xml",regex:"\\s+"},{token:"punctuation.int-subset.xml",regex:"]",next:"pop"},{token:["punctuation.markup-decl.xml","keyword.markup-decl.xml"],regex:"(<\\!)("+t+")",push:[{token:"text",regex:"\\s+"},{token:"punctuation.markup-decl.xml",regex:">",next:"pop"},{include:"string"}]}],cdata:[{token:"string.cdata.xml",regex:"\\]\\]>",next:"start"},{token:"text.xml",regex:"\\s+"},{token:"text.xml",regex:"(?:[^\\]]|\\](?!\\]>))+"}],comment:[{token:"comment.end.xml",regex:"--\x3e",next:"start"},{defaultToken:"comment.xml"}],reference:[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],attr_reference:[{token:"constant.language.escape.reference.attribute-value.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],tag:[{token:["meta.tag.punctuation.tag-open.xml","meta.tag.punctuation.end-tag-open.xml","meta.tag.tag-name.xml"],regex:"(?:(<)|(</))((?:"+t+":)?"+t+")",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]}],tag_whitespace:[{token:"text.tag-whitespace.xml",regex:"\\s+"}],whitespace:[{token:"text.whitespace.xml",regex:"\\s+"}],string:[{token:"string.xml",regex:"'",push:[{token:"string.xml",regex:"'",next:"pop"},{defaultToken:"string.xml"}]},{token:"string.xml",regex:'"',push:[{token:"string.xml",regex:'"',next:"pop"},{defaultToken:"string.xml"}]}],attributes:[{token:"entity.other.attribute-name.xml",regex:t},{token:"keyword.operator.attribute-equals.xml",regex:"="},{include:"tag_whitespace"},{include:"attribute_value"}],attribute_value:[{token:"string.attribute-value.xml",regex:"'",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]}]};if(this.constructor===o)this.normalizeRules()};(function(){this.embedTagRules=function(e,t,n){this.$rules.tag.unshift({token:["meta.tag.punctuation.tag-open.xml","meta.tag."+n+".tag-name.xml"],regex:"(<)("+n+"(?=\\s|>|$))",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:t+"start"}]});this.$rules[n+"-end"]=[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start",onMatch:function(e,t,n){n.splice(0);return this.token}}];this.embedRules(e,t,[{token:["meta.tag.punctuation.end-tag-open.xml","meta.tag."+n+".tag-name.xml"],regex:"(</)("+n+"(?=\\s|>|$))",next:n+"-end"},{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\["},{token:"string.cdata.xml",regex:"\\]\\]>"}])}}).call(a.prototype);r.inherits(o,a);t.XmlHighlightRules=o}));ace.define("ace/mode/html_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/css_highlight_rules","ace/mode/javascript_highlight_rules","ace/mode/xml_highlight_rules"],(function(e,t,n){"use strict";var r=e("../lib/oop");var a=e("../lib/lang");var o=e("./css_highlight_rules").CssHighlightRules;var i=e("./javascript_highlight_rules").JavaScriptHighlightRules;var s=e("./xml_highlight_rules").XmlHighlightRules;var l=a.createMap({a:"anchor",button:"form",form:"form",img:"image",input:"form",label:"form",option:"form",script:"script",select:"form",textarea:"form",style:"style",table:"table",tbody:"table",td:"table",tfoot:"table",th:"table",tr:"table"});var u=function(){s.call(this);this.addRules({attributes:[{include:"tag_whitespace"},{token:"entity.other.attribute-name.xml",regex:"[-_a-zA-Z0-9:.]+"},{token:"keyword.operator.attribute-equals.xml",regex:"=",push:[{include:"tag_whitespace"},{token:"string.unquoted.attribute-value.html",regex:"[^<>='\"`\\s]+",next:"pop"},{token:"empty",regex:"",next:"pop"}]},{include:"attribute_value"}],tag:[{token:function(e,t){var n=l[t];return["meta.tag.punctuation."+(e=="<"?"":"end-")+"tag-open.xml","meta.tag"+(n?"."+n:"")+".tag-name.xml"]},regex:"(</?)([-_a-zA-Z0-9:.]+)",next:"tag_stuff"}],tag_stuff:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]});this.embedTagRules(o,"css-","style");this.embedTagRules(new i({jsx:false}).getRules(),"js-","script");if(this.constructor===u)this.normalizeRules()};r.inherits(u,s);t.HtmlHighlightRules=u}));ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],(function(e,t,n){"use strict";var r=e("../range").Range;var a=function(){};(function(){this.checkOutdent=function(e,t){if(!/^\s+$/.test(e))return false;return/^\s*\}/.test(t)};this.autoOutdent=function(e,t){var n=e.getLine(t);var a=n.match(/^(\s*\})/);if(!a)return 0;var o=a[1].length;var i=e.findMatchingBracket({row:t,column:o});if(!i||i.row==t)return 0;var s=this.$getIndent(e.getLine(i.row));e.replace(new r(t,0,t,o-1),s)};this.$getIndent=function(e){return e.match(/^\s*/)[0]}}).call(a.prototype);t.MatchingBraceOutdent=a}));ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],(function(e,t,n){"use strict";var r=e("../../lib/oop");var a=e("../../range").Range;var o=e("./fold_mode").FoldMode;var i=t.FoldMode=function(e){if(e){this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+e.start));this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+e.end))}};r.inherits(i,o);(function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/;this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/;this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/;this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/;this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/;this._getFoldWidgetBase=this.getFoldWidget;this.getFoldWidget=function(e,t,n){var r=e.getLine(n);if(this.singleLineBlockCommentRe.test(r)){if(!this.startRegionRe.test(r)&&!this.tripleStarBlockCommentRe.test(r))return""}var a=this._getFoldWidgetBase(e,t,n);if(!a&&this.startRegionRe.test(r))return"start";return a};this.getFoldWidgetRange=function(e,t,n,r){var a=e.getLine(n);if(this.startRegionRe.test(a))return this.getCommentRegionBlock(e,a,n);var o=a.match(this.foldingStartMarker);if(o){var i=o.index;if(o[1])return this.openingBracketBlock(e,o[1],n,i);var s=e.getCommentFoldRange(n,i+o[0].length,1);if(s&&!s.isMultiLine()){if(r){s=this.getSectionRange(e,n)}else if(t!="all")s=null}return s}if(t==="markbegin")return;var o=a.match(this.foldingStopMarker);if(o){var i=o.index+o[0].length;if(o[1])return this.closingBracketBlock(e,o[1],n,i);return e.getCommentFoldRange(n,i,-1)}};this.getSectionRange=function(e,t){var n=e.getLine(t);var r=n.search(/\S/);var o=t;var i=n.length;t=t+1;var s=t;var l=e.getLength();while(++t<l){n=e.getLine(t);var u=n.search(/\S/);if(u===-1)continue;if(r>u)break;var c=this.getFoldWidgetRange(e,"all",t);if(c){if(c.start.row<=o){break}else if(c.isMultiLine()){t=c.end.row}else if(r==u){break}}s=t}return new a(o,i,s,e.getLine(s).length)};this.getCommentRegionBlock=function(e,t,n){var r=t.search(/\s*$/);var o=e.getLength();var i=n;var s=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/;var l=1;while(++n<o){t=e.getLine(n);var u=s.exec(t);if(!u)continue;if(u[1])l--;else l++;if(!l)break}var c=n;if(c>i){return new a(i,r,c,t.length)}}}).call(i.prototype)}));ace.define("ace/mode/javascript",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/javascript_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle"],(function(e,t,n){"use strict";var r=e("../lib/oop");var a=e("./text").Mode;var o=e("./javascript_highlight_rules").JavaScriptHighlightRules;var i=e("./matching_brace_outdent").MatchingBraceOutdent;var s=e("../worker/worker_client").WorkerClient;var l=e("./behaviour/cstyle").CstyleBehaviour;var u=e("./folding/cstyle").FoldMode;var c=function(){this.HighlightRules=o;this.$outdent=new i;this.$behaviour=new l;this.foldingRules=new u};r.inherits(c,a);(function(){this.lineCommentStart="//";this.blockComment={start:"/*",end:"*/"};this.$quotes={'"':'"',"'":"'","`":"`"};this.getNextLineIndent=function(e,t,n){var r=this.$getIndent(t);var a=this.getTokenizer().getLineTokens(t,e);var o=a.tokens;var i=a.state;if(o.length&&o[o.length-1].type=="comment"){return r}if(e=="start"||e=="no_regex"){var s=t.match(/^.*(?:\bcase\b.*:|[\{\(\[])\s*$/);if(s){r+=n}}else if(e=="doc-start"){if(i=="start"||i=="no_regex"){return""}var s=t.match(/^\s*(\/?)\*/);if(s){if(s[1]){r+=" "}r+="* "}}return r};this.checkOutdent=function(e,t,n){return this.$outdent.checkOutdent(t,n)};this.autoOutdent=function(e,t,n){this.$outdent.autoOutdent(t,n)};this.createWorker=function(e){var t=new s(["ace"],"ace/mode/javascript_worker","JavaScriptWorker");t.attachToDocument(e.getDocument());t.on("annotate",(function(t){e.setAnnotations(t.data)}));t.on("terminate",(function(){e.clearAnnotations()}));return t};this.$id="ace/mode/javascript";this.snippetFileId="ace/snippets/javascript"}).call(c.prototype);t.Mode=c}));ace.define("ace/mode/css_completions",["require","exports","module"],(function(e,t,n){"use strict";var r={background:{"#$0":1},"background-color":{"#$0":1,transparent:1,fixed:1},"background-image":{"url('/$0')":1},"background-repeat":{repeat:1,"repeat-x":1,"repeat-y":1,"no-repeat":1,inherit:1},"background-position":{bottom:2,center:2,left:2,right:2,top:2,inherit:2},"background-attachment":{scroll:1,fixed:1},"background-size":{cover:1,contain:1},"background-clip":{"border-box":1,"padding-box":1,"content-box":1},"background-origin":{"border-box":1,"padding-box":1,"content-box":1},border:{"solid $0":1,"dashed $0":1,"dotted $0":1,"#$0":1},"border-color":{"#$0":1},"border-style":{solid:2,dashed:2,dotted:2,double:2,groove:2,hidden:2,inherit:2,inset:2,none:2,outset:2,ridged:2},"border-collapse":{collapse:1,separate:1},bottom:{px:1,em:1,"%":1},clear:{left:1,right:1,both:1,none:1},color:{"#$0":1,"rgb(#$00,0,0)":1},cursor:{default:1,pointer:1,move:1,text:1,wait:1,help:1,progress:1,"n-resize":1,"ne-resize":1,"e-resize":1,"se-resize":1,"s-resize":1,"sw-resize":1,"w-resize":1,"nw-resize":1},display:{none:1,block:1,inline:1,"inline-block":1,"table-cell":1},"empty-cells":{show:1,hide:1},float:{left:1,right:1,none:1},"font-family":{Arial:2,"Comic Sans MS":2,Consolas:2,"Courier New":2,Courier:2,Georgia:2,Monospace:2,"Sans-Serif":2,"Segoe UI":2,Tahoma:2,"Times New Roman":2,"Trebuchet MS":2,Verdana:1},"font-size":{px:1,em:1,"%":1},"font-weight":{bold:1,normal:1},"font-style":{italic:1,normal:1},"font-variant":{normal:1,"small-caps":1},height:{px:1,em:1,"%":1},left:{px:1,em:1,"%":1},"letter-spacing":{normal:1},"line-height":{normal:1},"list-style-type":{none:1,disc:1,circle:1,square:1,decimal:1,"decimal-leading-zero":1,"lower-roman":1,"upper-roman":1,"lower-greek":1,"lower-latin":1,"upper-latin":1,georgian:1,"lower-alpha":1,"upper-alpha":1},margin:{px:1,em:1,"%":1},"margin-right":{px:1,em:1,"%":1},"margin-left":{px:1,em:1,"%":1},"margin-top":{px:1,em:1,"%":1},"margin-bottom":{px:1,em:1,"%":1},"max-height":{px:1,em:1,"%":1},"max-width":{px:1,em:1,"%":1},"min-height":{px:1,em:1,"%":1},"min-width":{px:1,em:1,"%":1},overflow:{hidden:1,visible:1,auto:1,scroll:1},"overflow-x":{hidden:1,visible:1,auto:1,scroll:1},"overflow-y":{hidden:1,visible:1,auto:1,scroll:1},padding:{px:1,em:1,"%":1},"padding-top":{px:1,em:1,"%":1},"padding-right":{px:1,em:1,"%":1},"padding-bottom":{px:1,em:1,"%":1},"padding-left":{px:1,em:1,"%":1},"page-break-after":{auto:1,always:1,avoid:1,left:1,right:1},"page-break-before":{auto:1,always:1,avoid:1,left:1,right:1},position:{absolute:1,relative:1,fixed:1,static:1},right:{px:1,em:1,"%":1},"table-layout":{fixed:1,auto:1},"text-decoration":{none:1,underline:1,"line-through":1,blink:1},"text-align":{left:1,right:1,center:1,justify:1},"text-transform":{capitalize:1,uppercase:1,lowercase:1,none:1},top:{px:1,em:1,"%":1},"vertical-align":{top:1,bottom:1},visibility:{hidden:1,visible:1},"white-space":{nowrap:1,normal:1,pre:1,"pre-line":1,"pre-wrap":1},width:{px:1,em:1,"%":1},"word-spacing":{normal:1},filter:{"alpha(opacity=$0100)":1},"text-shadow":{"$02px 2px 2px #777":1},"text-overflow":{"ellipsis-word":1,clip:1,ellipsis:1},"-moz-border-radius":1,"-moz-border-radius-topright":1,"-moz-border-radius-bottomright":1,"-moz-border-radius-topleft":1,"-moz-border-radius-bottomleft":1,"-webkit-border-radius":1,"-webkit-border-top-right-radius":1,"-webkit-border-top-left-radius":1,"-webkit-border-bottom-right-radius":1,"-webkit-border-bottom-left-radius":1,"-moz-box-shadow":1,"-webkit-box-shadow":1,transform:{"rotate($00deg)":1,"skew($00deg)":1},"-moz-transform":{"rotate($00deg)":1,"skew($00deg)":1},"-webkit-transform":{"rotate($00deg)":1,"skew($00deg)":1}};var a=function(){};(function(){this.completionsDefined=false;this.defineCompletions=function(){if(document){var e=document.createElement("c").style;for(var t in e){if(typeof e[t]!=="string")continue;var n=t.replace(/[A-Z]/g,(function(e){return"-"+e.toLowerCase()}));if(!r.hasOwnProperty(n))r[n]=1}}this.completionsDefined=true};this.getCompletions=function(e,t,n,r){if(!this.completionsDefined){this.defineCompletions()}if(e==="ruleset"||t.$mode.$id=="ace/mode/scss"){var a=t.getLine(n.row).substr(0,n.column);if(/:[^;]+$/.test(a)){/([\w\-]+):[^:]*$/.test(a);return this.getPropertyValueCompletions(e,t,n,r)}else{return this.getPropertyCompletions(e,t,n,r)}}return[]};this.getPropertyCompletions=function(e,t,n,a){var o=Object.keys(r);return o.map((function(e){return{caption:e,snippet:e+": $0;",meta:"property",score:1e6}}))};this.getPropertyValueCompletions=function(e,t,n,a){var o=t.getLine(n.row).substr(0,n.column);var i=(/([\w\-]+):[^:]*$/.exec(o)||{})[1];if(!i)return[];var s=[];if(i in r&&typeof r[i]==="object"){s=Object.keys(r[i])}return s.map((function(e){return{caption:e,snippet:e,meta:"property value",score:1e6}}))}}).call(a.prototype);t.CssCompletions=a}));ace.define("ace/mode/behaviour/css",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/mode/behaviour/cstyle","ace/token_iterator"],(function(e,t,n){"use strict";var r=e("../../lib/oop");var a=e("../behaviour").Behaviour;var o=e("./cstyle").CstyleBehaviour;var i=e("../../token_iterator").TokenIterator;var s=function(){this.inherit(o);this.add("colon","insertion",(function(e,t,n,r,a){if(a===":"&&n.selection.isEmpty()){var o=n.getCursorPosition();var s=new i(r,o.row,o.column);var l=s.getCurrentToken();if(l&&l.value.match(/\s+/)){l=s.stepBackward()}if(l&&l.type==="support.type"){var u=r.doc.getLine(o.row);var c=u.substring(o.column,o.column+1);if(c===":"){return{text:"",selection:[1,1]}}if(/^(\s+[^;]|\s*$)/.test(u.substring(o.column))){return{text:":;",selection:[1,1]}}}}}));this.add("colon","deletion",(function(e,t,n,r,a){var o=r.doc.getTextRange(a);if(!a.isMultiLine()&&o===":"){var s=n.getCursorPosition();var l=new i(r,s.row,s.column);var u=l.getCurrentToken();if(u&&u.value.match(/\s+/)){u=l.stepBackward()}if(u&&u.type==="support.type"){var c=r.doc.getLine(a.start.row);var g=c.substring(a.end.column,a.end.column+1);if(g===";"){a.end.column++;return a}}}}));this.add("semicolon","insertion",(function(e,t,n,r,a){if(a===";"&&n.selection.isEmpty()){var o=n.getCursorPosition();var i=r.doc.getLine(o.row);var s=i.substring(o.column,o.column+1);if(s===";"){return{text:"",selection:[1,1]}}}}));this.add("!important","insertion",(function(e,t,n,r,a){if(a==="!"&&n.selection.isEmpty()){var o=n.getCursorPosition();var i=r.doc.getLine(o.row);if(/^\s*(;|}|$)/.test(i.substring(o.column))){return{text:"!important",selection:[10,10]}}}}))};r.inherits(s,o);t.CssBehaviour=s}));ace.define("ace/mode/css",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/css_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/css_completions","ace/mode/behaviour/css","ace/mode/folding/cstyle"],(function(e,t,n){"use strict";var r=e("../lib/oop");var a=e("./text").Mode;var o=e("./css_highlight_rules").CssHighlightRules;var i=e("./matching_brace_outdent").MatchingBraceOutdent;var s=e("../worker/worker_client").WorkerClient;var l=e("./css_completions").CssCompletions;var u=e("./behaviour/css").CssBehaviour;var c=e("./folding/cstyle").FoldMode;var g=function(){this.HighlightRules=o;this.$outdent=new i;this.$behaviour=new u;this.$completer=new l;this.foldingRules=new c};r.inherits(g,a);(function(){this.foldingRules="cStyle";this.blockComment={start:"/*",end:"*/"};this.getNextLineIndent=function(e,t,n){var r=this.$getIndent(t);var a=this.getTokenizer().getLineTokens(t,e).tokens;if(a.length&&a[a.length-1].type=="comment"){return r}var o=t.match(/^.*\{\s*$/);if(o){r+=n}return r};this.checkOutdent=function(e,t,n){return this.$outdent.checkOutdent(t,n)};this.autoOutdent=function(e,t,n){this.$outdent.autoOutdent(t,n)};this.getCompletions=function(e,t,n,r){return this.$completer.getCompletions(e,t,n,r)};this.createWorker=function(e){var t=new s(["ace"],"ace/mode/css_worker","Worker");t.attachToDocument(e.getDocument());t.on("annotate",(function(t){e.setAnnotations(t.data)}));t.on("terminate",(function(){e.clearAnnotations()}));return t};this.$id="ace/mode/css";this.snippetFileId="ace/snippets/css"}).call(g.prototype);t.Mode=g}));ace.define("ace/mode/behaviour/xml",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],(function(e,t,n){"use strict";var r=e("../../lib/oop");var a=e("../behaviour").Behaviour;var o=e("../../token_iterator").TokenIterator;var i=e("../../lib/lang");function s(e,t){return e&&e.type.lastIndexOf(t+".xml")>-1}var l=function(){this.add("string_dquotes","insertion",(function(e,t,n,r,a){if(a=='"'||a=="'"){var i=a;var l=r.doc.getTextRange(n.getSelectionRange());if(l!==""&&l!=="'"&&l!='"'&&n.getWrapBehavioursEnabled()){return{text:i+l+i,selection:false}}var u=n.getCursorPosition();var c=r.doc.getLine(u.row);var g=c.substring(u.column,u.column+1);var d=new o(r,u.row,u.column);var p=d.getCurrentToken();if(g==i&&(s(p,"attribute-value")||s(p,"string"))){return{text:"",selection:[1,1]}}if(!p)p=d.stepBackward();if(!p)return;while(s(p,"tag-whitespace")||s(p,"whitespace")){p=d.stepBackward()}var h=!g||g.match(/\s/);if(s(p,"attribute-equals")&&(h||g==">")||s(p,"decl-attribute-equals")&&(h||g=="?")){return{text:i+i,selection:[1,1]}}}}));this.add("string_dquotes","deletion",(function(e,t,n,r,a){var o=r.doc.getTextRange(a);if(!a.isMultiLine()&&(o=='"'||o=="'")){var i=r.doc.getLine(a.start.row);var s=i.substring(a.start.column+1,a.start.column+2);if(s==o){a.end.column++;return a}}}));this.add("autoclosing","insertion",(function(e,t,n,r,a){if(a==">"){var i=n.getSelectionRange().start;var l=new o(r,i.row,i.column);var u=l.getCurrentToken()||l.stepBackward();if(!u||!(s(u,"tag-name")||s(u,"tag-whitespace")||s(u,"attribute-name")||s(u,"attribute-equals")||s(u,"attribute-value")))return;if(s(u,"reference.attribute-value"))return;if(s(u,"attribute-value")){var c=l.getCurrentTokenColumn()+u.value.length;if(i.column<c)return;if(i.column==c){var g=l.stepForward();if(g&&s(g,"attribute-value"))return;l.stepBackward()}}if(/^\s*>/.test(r.getLine(i.row).slice(i.column)))return;while(!s(u,"tag-name")){u=l.stepBackward();if(u.value=="<"){u=l.stepForward();break}}var d=l.getCurrentTokenRow();var p=l.getCurrentTokenColumn();if(s(l.stepBackward(),"end-tag-open"))return;var h=u.value;if(d==i.row)h=h.substring(0,i.column-p);if(this.voidElements.hasOwnProperty(h.toLowerCase()))return;return{text:">"+"</"+h+">",selection:[1,1]}}}));this.add("autoindent","insertion",(function(e,t,n,r,a){if(a=="\n"){var i=n.getCursorPosition();var s=r.getLine(i.row);var l=new o(r,i.row,i.column);var u=l.getCurrentToken();if(u&&u.type.indexOf("tag-close")!==-1){if(u.value=="/>")return;while(u&&u.type.indexOf("tag-name")===-1){u=l.stepBackward()}if(!u){return}var c=u.value;var g=l.getCurrentTokenRow();u=l.stepBackward();if(!u||u.type.indexOf("end-tag")!==-1){return}if(this.voidElements&&!this.voidElements[c]){var d=r.getTokenAt(i.row,i.column+1);var s=r.getLine(g);var p=this.$getIndent(s);var h=p+r.getTabString();if(d&&d.value==="</"){return{text:"\n"+h+"\n"+p,selection:[1,h.length,1,h.length]}}else{return{text:"\n"+h}}}}}}))};r.inherits(l,a);t.XmlBehaviour=l}));ace.define("ace/mode/folding/mixed",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode"],(function(e,t,n){"use strict";var r=e("../../lib/oop");var a=e("./fold_mode").FoldMode;var o=t.FoldMode=function(e,t){this.defaultMode=e;this.subModes=t};r.inherits(o,a);(function(){this.$getMode=function(e){if(typeof e!="string")e=e[0];for(var t in this.subModes){if(e.indexOf(t)===0)return this.subModes[t]}return null};this.$tryMode=function(e,t,n,r){var a=this.$getMode(e);return a?a.getFoldWidget(t,n,r):""};this.getFoldWidget=function(e,t,n){return this.$tryMode(e.getState(n-1),e,t,n)||this.$tryMode(e.getState(n),e,t,n)||this.defaultMode.getFoldWidget(e,t,n)};this.getFoldWidgetRange=function(e,t,n){var r=this.$getMode(e.getState(n-1));if(!r||!r.getFoldWidget(e,t,n))r=this.$getMode(e.getState(n));if(!r||!r.getFoldWidget(e,t,n))r=this.defaultMode;return r.getFoldWidgetRange(e,t,n)}}).call(o.prototype)}));ace.define("ace/mode/folding/xml",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/range","ace/mode/folding/fold_mode","ace/token_iterator"],(function(e,t,n){"use strict";var r=e("../../lib/oop");var a=e("../../lib/lang");var o=e("../../range").Range;var i=e("./fold_mode").FoldMode;var s=e("../../token_iterator").TokenIterator;var l=t.FoldMode=function(e,t){i.call(this);this.voidElements=e||{};this.optionalEndTags=r.mixin({},this.voidElements);if(t)r.mixin(this.optionalEndTags,t)};r.inherits(l,i);var u=function(){this.tagName="";this.closing=false;this.selfClosing=false;this.start={row:0,column:0};this.end={row:0,column:0}};function c(e,t){return e.type.lastIndexOf(t+".xml")>-1}(function(){this.getFoldWidget=function(e,t,n){var r=this._getFirstTagInLine(e,n);if(!r)return this.getCommentFoldWidget(e,n);if(r.closing||!r.tagName&&r.selfClosing)return t=="markbeginend"?"end":"";if(!r.tagName||r.selfClosing||this.voidElements.hasOwnProperty(r.tagName.toLowerCase()))return"";if(this._findEndTagInLine(e,n,r.tagName,r.end.column))return"";return"start"};this.getCommentFoldWidget=function(e,t){if(/comment/.test(e.getState(t))&&/<!-/.test(e.getLine(t)))return"start";return""};this._getFirstTagInLine=function(e,t){var n=e.getTokens(t);var r=new u;for(var a=0;a<n.length;a++){var o=n[a];if(c(o,"tag-open")){r.end.column=r.start.column+o.value.length;r.closing=c(o,"end-tag-open");o=n[++a];if(!o)return null;r.tagName=o.value;r.end.column+=o.value.length;for(a++;a<n.length;a++){o=n[a];r.end.column+=o.value.length;if(c(o,"tag-close")){r.selfClosing=o.value=="/>";break}}return r}else if(c(o,"tag-close")){r.selfClosing=o.value=="/>";return r}r.start.column+=o.value.length}return null};this._findEndTagInLine=function(e,t,n,r){var a=e.getTokens(t);var o=0;for(var i=0;i<a.length;i++){var s=a[i];o+=s.value.length;if(o<r)continue;if(c(s,"end-tag-open")){s=a[i+1];if(s&&s.value==n)return true}}return false};this._readTagForward=function(e){var t=e.getCurrentToken();if(!t)return null;var n=new u;do{if(c(t,"tag-open")){n.closing=c(t,"end-tag-open");n.start.row=e.getCurrentTokenRow();n.start.column=e.getCurrentTokenColumn()}else if(c(t,"tag-name")){n.tagName=t.value}else if(c(t,"tag-close")){n.selfClosing=t.value=="/>";n.end.row=e.getCurrentTokenRow();n.end.column=e.getCurrentTokenColumn()+t.value.length;e.stepForward();return n}}while(t=e.stepForward());return null};this._readTagBackward=function(e){var t=e.getCurrentToken();if(!t)return null;var n=new u;do{if(c(t,"tag-open")){n.closing=c(t,"end-tag-open");n.start.row=e.getCurrentTokenRow();n.start.column=e.getCurrentTokenColumn();e.stepBackward();return n}else if(c(t,"tag-name")){n.tagName=t.value}else if(c(t,"tag-close")){n.selfClosing=t.value=="/>";n.end.row=e.getCurrentTokenRow();n.end.column=e.getCurrentTokenColumn()+t.value.length}}while(t=e.stepBackward());return null};this._pop=function(e,t){while(e.length){var n=e[e.length-1];if(!t||n.tagName==t.tagName){return e.pop()}else if(this.optionalEndTags.hasOwnProperty(n.tagName)){e.pop();continue}else{return null}}};this.getFoldWidgetRange=function(e,t,n){var r=this._getFirstTagInLine(e,n);if(!r){return this.getCommentFoldWidget(e,n)&&e.getCommentFoldRange(n,e.getLine(n).length)}var a=r.closing||r.selfClosing;var i=[];var l;if(!a){var u=new s(e,n,r.start.column);var c={row:n,column:r.start.column+r.tagName.length+2};if(r.start.row==r.end.row)c.column=r.end.column;while(l=this._readTagForward(u)){if(l.selfClosing){if(!i.length){l.start.column+=l.tagName.length+2;l.end.column-=2;return o.fromPoints(l.start,l.end)}else continue}if(l.closing){this._pop(i,l);if(i.length==0)return o.fromPoints(c,l.start)}else{i.push(l)}}}else{var u=new s(e,n,r.end.column);var g={row:n,column:r.start.column};while(l=this._readTagBackward(u)){if(l.selfClosing){if(!i.length){l.start.column+=l.tagName.length+2;l.end.column-=2;return o.fromPoints(l.start,l.end)}else continue}if(!l.closing){this._pop(i,l);if(i.length==0){l.start.column+=l.tagName.length+2;if(l.start.row==l.end.row&&l.start.column<l.end.column)l.start.column=l.end.column;return o.fromPoints(l.start,g)}}else{i.push(l)}}}}}).call(l.prototype)}));ace.define("ace/mode/folding/html",["require","exports","module","ace/lib/oop","ace/mode/folding/mixed","ace/mode/folding/xml","ace/mode/folding/cstyle"],(function(e,t,n){"use strict";var r=e("../../lib/oop");var a=e("./mixed").FoldMode;var o=e("./xml").FoldMode;var i=e("./cstyle").FoldMode;var s=t.FoldMode=function(e,t){a.call(this,new o(e,t),{"js-":new i,"css-":new i})};r.inherits(s,a)}));ace.define("ace/mode/html_completions",["require","exports","module","ace/token_iterator"],(function(e,t,n){"use strict";var r=e("../token_iterator").TokenIterator;var a=["accesskey","class","contenteditable","contextmenu","dir","draggable","dropzone","hidden","id","inert","itemid","itemprop","itemref","itemscope","itemtype","lang","spellcheck","style","tabindex","title","translate"];var o=["onabort","onblur","oncancel","oncanplay","oncanplaythrough","onchange","onclick","onclose","oncontextmenu","oncuechange","ondblclick","ondrag","ondragend","ondragenter","ondragleave","ondragover","ondragstart","ondrop","ondurationchange","onemptied","onended","onerror","onfocus","oninput","oninvalid","onkeydown","onkeypress","onkeyup","onload","onloadeddata","onloadedmetadata","onloadstart","onmousedown","onmousemove","onmouseout","onmouseover","onmouseup","onmousewheel","onpause","onplay","onplaying","onprogress","onratechange","onreset","onscroll","onseeked","onseeking","onselect","onshow","onstalled","onsubmit","onsuspend","ontimeupdate","onvolumechange","onwaiting"];var i=a.concat(o);var s={a:{href:1,target:{_blank:1,top:1},ping:1,rel:{nofollow:1,alternate:1,author:1,bookmark:1,help:1,license:1,next:1,noreferrer:1,prefetch:1,prev:1,search:1,tag:1},media:1,hreflang:1,type:1},abbr:{},address:{},area:{shape:1,coords:1,href:1,hreflang:1,alt:1,target:1,media:1,rel:1,ping:1,type:1},article:{pubdate:1},aside:{},audio:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},muted:{muted:1},preload:{auto:1,metadata:1,none:1}},b:{},base:{href:1,target:1},bdi:{},bdo:{},blockquote:{cite:1},body:{onafterprint:1,onbeforeprint:1,onbeforeunload:1,onhashchange:1,onmessage:1,onoffline:1,onpopstate:1,onredo:1,onresize:1,onstorage:1,onundo:1,onunload:1},br:{},button:{autofocus:1,disabled:{disabled:1},form:1,formaction:1,formenctype:1,formmethod:1,formnovalidate:1,formtarget:1,name:1,value:1,type:{button:1,submit:1}},canvas:{width:1,height:1},caption:{},cite:{},code:{},col:{span:1},colgroup:{span:1},command:{type:1,label:1,icon:1,disabled:1,checked:1,radiogroup:1,command:1},data:{},datalist:{},dd:{},del:{cite:1,datetime:1},details:{open:1},dfn:{},dialog:{open:1},div:{},dl:{},dt:{},em:{},embed:{src:1,height:1,width:1,type:1},fieldset:{disabled:1,form:1,name:1},figcaption:{},figure:{},footer:{},form:{"accept-charset":1,action:1,autocomplete:1,enctype:{"multipart/form-data":1,"application/x-www-form-urlencoded":1},method:{get:1,post:1},name:1,novalidate:1,target:{_blank:1,top:1}},h1:{},h2:{},h3:{},h4:{},h5:{},h6:{},head:{},header:{},hr:{},html:{manifest:1},i:{},iframe:{name:1,src:1,height:1,width:1,sandbox:{"allow-same-origin":1,"allow-top-navigation":1,"allow-forms":1,"allow-scripts":1},seamless:{seamless:1}},img:{alt:1,src:1,height:1,width:1,usemap:1,ismap:1},input:{type:{text:1,password:1,hidden:1,checkbox:1,submit:1,radio:1,file:1,button:1,reset:1,image:31,color:1,date:1,datetime:1,"datetime-local":1,email:1,month:1,number:1,range:1,search:1,tel:1,time:1,url:1,week:1},accept:1,alt:1,autocomplete:{on:1,off:1},autofocus:{autofocus:1},checked:{checked:1},disabled:{disabled:1},form:1,formaction:1,formenctype:{"application/x-www-form-urlencoded":1,"multipart/form-data":1,"text/plain":1},formmethod:{get:1,post:1},formnovalidate:{formnovalidate:1},formtarget:{_blank:1,_self:1,_parent:1,_top:1},height:1,list:1,max:1,maxlength:1,min:1,multiple:{multiple:1},name:1,pattern:1,placeholder:1,readonly:{readonly:1},required:{required:1},size:1,src:1,step:1,width:1,files:1,value:1},ins:{cite:1,datetime:1},kbd:{},keygen:{autofocus:1,challenge:{challenge:1},disabled:{disabled:1},form:1,keytype:{rsa:1,dsa:1,ec:1},name:1},label:{form:1,for:1},legend:{},li:{value:1},link:{href:1,hreflang:1,rel:{stylesheet:1,icon:1},media:{all:1,screen:1,print:1},type:{"text/css":1,"image/png":1,"image/jpeg":1,"image/gif":1},sizes:1},main:{},map:{name:1},mark:{},math:{},menu:{type:1,label:1},meta:{"http-equiv":{"content-type":1},name:{description:1,keywords:1},content:{"text/html; charset=UTF-8":1},charset:1},meter:{value:1,min:1,max:1,low:1,high:1,optimum:1},nav:{},noscript:{href:1},object:{param:1,data:1,type:1,height:1,width:1,usemap:1,name:1,form:1,classid:1},ol:{start:1,reversed:1},optgroup:{disabled:1,label:1},option:{disabled:1,selected:1,label:1,value:1},output:{for:1,form:1,name:1},p:{},param:{name:1,value:1},pre:{},progress:{value:1,max:1},q:{cite:1},rp:{},rt:{},ruby:{},s:{},samp:{},script:{charset:1,type:{"text/javascript":1},src:1,defer:1,async:1},select:{autofocus:1,disabled:1,form:1,multiple:{multiple:1},name:1,size:1,readonly:{readonly:1}},small:{},source:{src:1,type:1,media:1},span:{},strong:{},style:{type:1,media:{all:1,screen:1,print:1},scoped:1},sub:{},sup:{},svg:{},table:{summary:1},tbody:{},td:{headers:1,rowspan:1,colspan:1},textarea:{autofocus:{autofocus:1},disabled:{disabled:1},form:1,maxlength:1,name:1,placeholder:1,readonly:{readonly:1},required:{required:1},rows:1,cols:1,wrap:{on:1,off:1,hard:1,soft:1}},tfoot:{},th:{headers:1,rowspan:1,colspan:1,scope:1},thead:{},time:{datetime:1},title:{},tr:{},track:{kind:1,src:1,srclang:1,label:1,default:1},section:{},summary:{},u:{},ul:{},var:{},video:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},width:1,height:1,poster:1,muted:{muted:1},preload:{auto:1,metadata:1,none:1}},wbr:{}};var l=Object.keys(s);function u(e,t){return e.type.lastIndexOf(t+".xml")>-1}function c(e,t){var n=new r(e,t.row,t.column);var a=n.getCurrentToken();while(a&&!u(a,"tag-name")){a=n.stepBackward()}if(a)return a.value}function g(e,t){var n=new r(e,t.row,t.column);var a=n.getCurrentToken();while(a&&!u(a,"attribute-name")){a=n.stepBackward()}if(a)return a.value}var d=function(){};(function(){this.getCompletions=function(e,t,n,r){var a=t.getTokenAt(n.row,n.column);if(!a)return[];if(u(a,"tag-name")||u(a,"tag-open")||u(a,"end-tag-open"))return this.getTagCompletions(e,t,n,r);if(u(a,"tag-whitespace")||u(a,"attribute-name"))return this.getAttributeCompletions(e,t,n,r);if(u(a,"attribute-value"))return this.getAttributeValueCompletions(e,t,n,r);var o=t.getLine(n.row).substr(0,n.column);if(/&[a-z]*$/i.test(o))return this.getHTMLEntityCompletions(e,t,n,r);return[]};this.getTagCompletions=function(e,t,n,r){return l.map((function(e){return{value:e,meta:"tag",score:1e6}}))};this.getAttributeCompletions=function(e,t,n,r){var a=c(t,n);if(!a)return[];var o=i;if(a in s){o=o.concat(Object.keys(s[a]))}return o.map((function(e){return{caption:e,snippet:e+'="$0"',meta:"attribute",score:1e6}}))};this.getAttributeValueCompletions=function(e,t,n,r){var a=c(t,n);var o=g(t,n);if(!a)return[];var i=[];if(a in s&&o in s[a]&&typeof s[a][o]==="object"){i=Object.keys(s[a][o])}return i.map((function(e){return{caption:e,snippet:e,meta:"attribute value",score:1e6}}))};this.getHTMLEntityCompletions=function(e,t,n,r){var a=["Aacute;","aacute;","Acirc;","acirc;","acute;","AElig;","aelig;","Agrave;","agrave;","alefsym;","Alpha;","alpha;","amp;","and;","ang;","Aring;","aring;","asymp;","Atilde;","atilde;","Auml;","auml;","bdquo;","Beta;","beta;","brvbar;","bull;","cap;","Ccedil;","ccedil;","cedil;","cent;","Chi;","chi;","circ;","clubs;","cong;","copy;","crarr;","cup;","curren;","Dagger;","dagger;","dArr;","darr;","deg;","Delta;","delta;","diams;","divide;","Eacute;","eacute;","Ecirc;","ecirc;","Egrave;","egrave;","empty;","emsp;","ensp;","Epsilon;","epsilon;","equiv;","Eta;","eta;","ETH;","eth;","Euml;","euml;","euro;","exist;","fnof;","forall;","frac12;","frac14;","frac34;","frasl;","Gamma;","gamma;","ge;","gt;","hArr;","harr;","hearts;","hellip;","Iacute;","iacute;","Icirc;","icirc;","iexcl;","Igrave;","igrave;","image;","infin;","int;","Iota;","iota;","iquest;","isin;","Iuml;","iuml;","Kappa;","kappa;","Lambda;","lambda;","lang;","laquo;","lArr;","larr;","lceil;","ldquo;","le;","lfloor;","lowast;","loz;","lrm;","lsaquo;","lsquo;","lt;","macr;","mdash;","micro;","middot;","minus;","Mu;","mu;","nabla;","nbsp;","ndash;","ne;","ni;","not;","notin;","nsub;","Ntilde;","ntilde;","Nu;","nu;","Oacute;","oacute;","Ocirc;","ocirc;","OElig;","oelig;","Ograve;","ograve;","oline;","Omega;","omega;","Omicron;","omicron;","oplus;","or;","ordf;","ordm;","Oslash;","oslash;","Otilde;","otilde;","otimes;","Ouml;","ouml;","para;","part;","permil;","perp;","Phi;","phi;","Pi;","pi;","piv;","plusmn;","pound;","Prime;","prime;","prod;","prop;","Psi;","psi;","quot;","radic;","rang;","raquo;","rArr;","rarr;","rceil;","rdquo;","real;","reg;","rfloor;","Rho;","rho;","rlm;","rsaquo;","rsquo;","sbquo;","Scaron;","scaron;","sdot;","sect;","shy;","Sigma;","sigma;","sigmaf;","sim;","spades;","sub;","sube;","sum;","sup;","sup1;","sup2;","sup3;","supe;","szlig;","Tau;","tau;","there4;","Theta;","theta;","thetasym;","thinsp;","THORN;","thorn;","tilde;","times;","trade;","Uacute;","uacute;","uArr;","uarr;","Ucirc;","ucirc;","Ugrave;","ugrave;","uml;","upsih;","Upsilon;","upsilon;","Uuml;","uuml;","weierp;","Xi;","xi;","Yacute;","yacute;","yen;","Yuml;","yuml;","Zeta;","zeta;","zwj;","zwnj;"];return a.map((function(e){return{caption:e,snippet:e,meta:"html entity",score:1e6}}))}}).call(d.prototype);t.HtmlCompletions=d}));ace.define("ace/mode/html",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text","ace/mode/javascript","ace/mode/css","ace/mode/html_highlight_rules","ace/mode/behaviour/xml","ace/mode/folding/html","ace/mode/html_completions","ace/worker/worker_client"],(function(e,t,n){"use strict";var r=e("../lib/oop");var a=e("../lib/lang");var o=e("./text").Mode;var i=e("./javascript").Mode;var s=e("./css").Mode;var l=e("./html_highlight_rules").HtmlHighlightRules;var u=e("./behaviour/xml").XmlBehaviour;var c=e("./folding/html").FoldMode;var g=e("./html_completions").HtmlCompletions;var d=e("../worker/worker_client").WorkerClient;var p=["area","base","br","col","embed","hr","img","input","keygen","link","meta","menuitem","param","source","track","wbr"];var h=["li","dt","dd","p","rt","rp","optgroup","option","colgroup","td","th"];var m=function(e){this.fragmentContext=e&&e.fragmentContext;this.HighlightRules=l;this.$behaviour=new u;this.$completer=new g;this.createModeDelegates({"js-":i,"css-":s});this.foldingRules=new c(this.voidElements,a.arrayToMap(h))};r.inherits(m,o);(function(){this.blockComment={start:"\x3c!--",end:"--\x3e"};this.voidElements=a.arrayToMap(p);this.getNextLineIndent=function(e,t,n){return this.$getIndent(t)};this.checkOutdent=function(e,t,n){return false};this.getCompletions=function(e,t,n,r){return this.$completer.getCompletions(e,t,n,r)};this.createWorker=function(e){if(this.constructor!=m)return;var t=new d(["ace"],"ace/mode/html_worker","Worker");t.attachToDocument(e.getDocument());if(this.fragmentContext)t.call("setOptions",[{context:this.fragmentContext}]);t.on("error",(function(t){e.setAnnotations(t.data)}));t.on("terminate",(function(){e.clearAnnotations()}));return t};this.$id="ace/mode/html";this.snippetFileId="ace/snippets/html"}).call(m.prototype);t.Mode=m}));ace.define("ace/mode/ruby_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],(function(e,t,n){"use strict";var r=e("../lib/oop");var a=e("./text_highlight_rules").TextHighlightRules;var o=t.constantOtherSymbol={token:"constant.other.symbol.ruby",regex:"[:](?:[A-Za-z_]|[@$](?=[a-zA-Z0-9_]))[a-zA-Z0-9_]*[!=?]?"};t.qString={token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"};t.qqString={token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'};t.tString={token:"string",regex:"[`](?:(?:\\\\.)|(?:[^'\\\\]))*?[`]"};var i=t.constantNumericHex={token:"constant.numeric",regex:"0[xX][0-9a-fA-F](?:[0-9a-fA-F]|_(?=[0-9a-fA-F]))*\\b"};var s=t.constantNumericBinary={token:"constant.numeric",regex:/\b(0[bB][01](?:[01]|_(?=[01]))*)\b/};var l=t.constantNumericDecimal={token:"constant.numeric",regex:/\b(0[dD](?:[1-9](?:[\d]|_(?=[\d]))*|0))\b/};var u=t.constantNumericDecimal={token:"constant.numeric",regex:/\b(0[oO]?(?:[1-7](?:[0-7]|_(?=[0-7]))*|0))\b/};var c=t.constantNumericRational={token:"constant.numeric",regex:/\b([\d]+(?:[./][\d]+)?ri?)\b/};var g=t.constantNumericComplex={token:"constant.numeric",regex:/\b([\d]i)\b/};var d=t.constantNumericFloat={token:"constant.numeric",regex:"[+-]?\\d(?:\\d|_(?=\\d))*(?:(?:\\.\\d(?:\\d|_(?=\\d))*)?(?:[eE][+-]?\\d+)?)?i?\\b"};var p=t.instanceVariable={token:"variable.instance",regex:"@{1,2}[a-zA-Z_\\d]+"};var h=function(){var e="abort|Array|assert|assert_equal|assert_not_equal|assert_same|assert_not_same|"+"assert_nil|assert_not_nil|assert_match|assert_no_match|assert_in_delta|assert_throws|"+"assert_raise|assert_nothing_raised|assert_instance_of|assert_kind_of|assert_respond_to|"+"assert_operator|assert_send|assert_difference|assert_no_difference|assert_recognizes|"+"assert_generates|assert_response|assert_redirected_to|assert_template|assert_select|"+"assert_select_email|assert_select_rjs|assert_select_encoded|css_select|at_exit|"+"attr|attr_writer|attr_reader|attr_accessor|attr_accessible|autoload|binding|block_given?|callcc|"+"caller|catch|chomp|chomp!|chop|chop!|defined?|delete_via_redirect|eval|exec|exit|"+"exit!|fail|Float|flunk|follow_redirect!|fork|form_for|form_tag|format|gets|global_variables|gsub|"+"gsub!|get_via_redirect|host!|https?|https!|include|Integer|lambda|link_to|"+"link_to_unless_current|link_to_function|link_to_remote|load|local_variables|loop|open|open_session|"+"p|print|printf|proc|putc|puts|post_via_redirect|put_via_redirect|raise|rand|"+"raw|readline|readlines|redirect?|request_via_redirect|require|scan|select|"+"set_trace_func|sleep|split|sprintf|srand|String|stylesheet_link_tag|syscall|system|sub|sub!|test|"+"throw|trace_var|trap|untrace_var|atan2|cos|exp|frexp|ldexp|log|log10|sin|sqrt|tan|"+"render|javascript_include_tag|csrf_meta_tag|label_tag|text_field_tag|submit_tag|check_box_tag|"+"content_tag|radio_button_tag|text_area_tag|password_field_tag|hidden_field_tag|"+"fields_for|select_tag|options_for_select|options_from_collection_for_select|collection_select|"+"time_zone_select|select_date|select_time|select_datetime|date_select|time_select|datetime_select|"+"select_year|select_month|select_day|select_hour|select_minute|select_second|file_field_tag|"+"file_field|respond_to|skip_before_filter|around_filter|after_filter|verify|"+"protect_from_forgery|rescue_from|helper_method|redirect_to|before_filter|"+"send_data|send_file|validates_presence_of|validates_uniqueness_of|validates_length_of|"+"validates_format_of|validates_acceptance_of|validates_associated|validates_exclusion_of|"+"validates_inclusion_of|validates_numericality_of|validates_with|validates_each|"+"authenticate_or_request_with_http_basic|authenticate_or_request_with_http_digest|"+"filter_parameter_logging|match|get|post|resources|redirect|scope|assert_routing|"+"translate|localize|extract_locale_from_tld|caches_page|expire_page|caches_action|expire_action|"+"cache|expire_fragment|expire_cache_for|observe|cache_sweeper|"+"has_many|has_one|belongs_to|has_and_belongs_to_many|p|warn|refine|using|module_function|extend|alias_method|"+"private_class_method|remove_method|undef_method";var t="alias|and|BEGIN|begin|break|case|class|def|defined|do|else|elsif|END|end|ensure|"+"__FILE__|finally|for|gem|if|in|__LINE__|module|next|not|or|private|protected|public|"+"redo|rescue|retry|return|super|then|undef|unless|until|when|while|yield|__ENCODING__|prepend";var n="true|TRUE|false|FALSE|nil|NIL|ARGF|ARGV|DATA|ENV|RUBY_PLATFORM|RUBY_RELEASE_DATE|"+"RUBY_VERSION|STDERR|STDIN|STDOUT|TOPLEVEL_BINDING|RUBY_PATCHLEVEL|RUBY_REVISION|RUBY_COPYRIGHT|RUBY_ENGINE|RUBY_ENGINE_VERSION|RUBY_DESCRIPTION";var r="$DEBUG|$defout|$FILENAME|$LOAD_PATH|$SAFE|$stdin|$stdout|$stderr|$VERBOSE|"+"$!|root_url|flash|session|cookies|params|request|response|logger|self";var a=this.$keywords=this.createKeywordMapper({keyword:t,"constant.language":n,"variable.language":r,"support.function":e,"invalid.deprecated":"debugger"},"identifier");var h="\\\\(?:n(?:[1-7][0-7]{0,2}|0)|[nsrtvfbae'\"\\\\]|c(?:\\\\M-)?.|M-(?:\\\\C-|\\\\c)?.|C-(?:\\\\M-)?.|[0-7]{3}|x[\\da-fA-F]{2}|u[\\da-fA-F]{4}|u{[\\da-fA-F]{1,6}(?:\\s[\\da-fA-F]{1,6})*})";var m={"(":")","[":"]","{":"}","<":">","^":"^","|":"|","%":"%"};this.$rules={start:[{token:"comment",regex:"#.*$"},{token:"comment.multiline",regex:"^=begin(?=$|\\s.*$)",next:"comment"},{token:"string.regexp",regex:/[/](?=.*\/)/,next:"regex"},[{token:["constant.other.symbol.ruby","string.start"],regex:/(:)?(")/,push:[{token:"constant.language.escape",regex:h},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/"/,next:"pop"},{defaultToken:"string"}]},{token:"string.start",regex:/`/,push:[{token:"constant.language.escape",regex:h},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/`/,next:"pop"},{defaultToken:"string"}]},{token:["constant.other.symbol.ruby","string.start"],regex:/(:)?(')/,push:[{token:"constant.language.escape",regex:/\\['\\]/},{token:"string.end",regex:/'/,next:"pop"},{defaultToken:"string"}]},{token:"string.start",regex:/%[qwx]([(\[<{^|%])/,onMatch:function(e,t,n){if(n.length)n=[];var r=e[e.length-1];n.unshift(r,t);this.next="qStateWithoutInterpolation";return this.token}},{token:"string.start",regex:/%[QWX]?([(\[<{^|%])/,onMatch:function(e,t,n){if(n.length)n=[];var r=e[e.length-1];n.unshift(r,t);this.next="qStateWithInterpolation";return this.token}},{token:"constant.other.symbol.ruby",regex:/%[si]([(\[<{^|%])/,onMatch:function(e,t,n){if(n.length)n=[];var r=e[e.length-1];n.unshift(r,t);this.next="sStateWithoutInterpolation";return this.token}},{token:"constant.other.symbol.ruby",regex:/%[SI]([(\[<{^|%])/,onMatch:function(e,t,n){if(n.length)n=[];var r=e[e.length-1];n.unshift(r,t);this.next="sStateWithInterpolation";return this.token}},{token:"string.regexp",regex:/%[r]([(\[<{^|%])/,onMatch:function(e,t,n){if(n.length)n=[];var r=e[e.length-1];n.unshift(r,t);this.next="rState";return this.token}}],{token:"punctuation",regex:"::"},p,{token:"variable.global",regex:"[$][a-zA-Z_\\d]+"},{token:"support.class",regex:"[A-Z][a-zA-Z_\\d]*"},{token:["punctuation.operator","support.function"],regex:/(\.)([a-zA-Z_\d]+)(?=\()/},{token:["punctuation.operator","identifier"],regex:/(\.)([a-zA-Z_][a-zA-Z_\d]*)/},{token:"string.character",regex:"\\B\\?(?:"+h+"|\\S)"},{token:"punctuation.operator",regex:/\?(?=.+:)/},c,g,o,i,d,s,l,u,{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:a,regex:"[a-zA-Z_$][a-zA-Z0-9_$]*\\b"},{token:"punctuation.separator.key-value",regex:"=>"},{stateName:"heredoc",onMatch:function(e,t,n){var r=e[2]=="-"||e[2]=="~"?"indentedHeredoc":"heredoc";var a=e.split(this.splitRegex);n.push(r,a[3]);return[{type:"constant",value:a[1]},{type:"string",value:a[2]},{type:"support.class",value:a[3]},{type:"string",value:a[4]}]},regex:"(<<[-~]?)(['\"`]?)([\\w]+)(['\"`]?)",rules:{heredoc:[{onMatch:function(e,t,n){if(e===n[1]){n.shift();n.shift();this.next=n[0]||"start";return"support.class"}this.next="";return"string"},regex:".*$",next:"start"}],indentedHeredoc:[{token:"string",regex:"^ +"},{onMatch:function(e,t,n){if(e===n[1]){n.shift();n.shift();this.next=n[0]||"start";return"support.class"}this.next="";return"string"},regex:".*$",next:"start"}]}},{regex:"$",token:"empty",next:function(e,t){if(t[0]==="heredoc"||t[0]==="indentedHeredoc")return t[0];return e}},{token:"keyword.operator",regex:"!|\\$|%|&|\\*|/|\\-\\-|\\-|\\+\\+|\\+|~|===|==|=|!=|!==|<=|>=|<<=|>>=|>>>=|<>|<|>|!|&&|\\|\\||\\?\\:|\\*=|%=|\\+=|\\-=|&=|\\^=|\\||\\b(?:in|instanceof|new|delete|typeof|void)"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]",onMatch:function(e,t,n){this.next="";if(e=="}"&&n.length>1&&n[1]!="start"){n.shift();this.next=n.shift()}return this.token}},{token:"text",regex:"\\s+"},{token:"punctuation.operator",regex:/[?:,;.]/}],comment:[{token:"comment.multiline",regex:"^=end(?=$|\\s.*$)",next:"start"},{token:"comment",regex:".+"}],qStateWithInterpolation:[{token:"string.start",regex:/[(\[<{]/,onMatch:function(e,t,n){if(n.length&&e===n[0]){n.unshift(e,t);return this.token}return"string"}},{token:"constant.language.escape",regex:h},{token:"constant.language.escape",regex:/\\./},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/[)\]>}^|%]/,onMatch:function(e,t,n){if(n.length&&e===m[n[0]]){n.shift();this.next=n.shift();return this.token}this.next="";return"string"}},{defaultToken:"string"}],qStateWithoutInterpolation:[{token:"string.start",regex:/[(\[<{]/,onMatch:function(e,t,n){if(n.length&&e===n[0]){n.unshift(e,t);return this.token}return"string"}},{token:"constant.language.escape",regex:/\\['\\]/},{token:"constant.language.escape",regex:/\\./},{token:"string.end",regex:/[)\]>}^|%]/,onMatch:function(e,t,n){if(n.length&&e===m[n[0]]){n.shift();this.next=n.shift();return this.token}this.next="";return"string"}},{defaultToken:"string"}],sStateWithoutInterpolation:[{token:"constant.other.symbol.ruby",regex:/[(\[<{]/,onMatch:function(e,t,n){if(n.length&&e===n[0]){n.unshift(e,t);return this.token}return"constant.other.symbol.ruby"}},{token:"constant.other.symbol.ruby",regex:/[)\]>}^|%]/,onMatch:function(e,t,n){if(n.length&&e===m[n[0]]){n.shift();this.next=n.shift();return this.token}this.next="";return"constant.other.symbol.ruby"}},{defaultToken:"constant.other.symbol.ruby"}],sStateWithInterpolation:[{token:"constant.other.symbol.ruby",regex:/[(\[<{]/,onMatch:function(e,t,n){if(n.length&&e===n[0]){n.unshift(e,t);return this.token}return"constant.other.symbol.ruby"}},{token:"constant.language.escape",regex:h},{token:"constant.language.escape",regex:/\\./},{token:"paren.start",regex:/#{/,push:"start"},{token:"constant.other.symbol.ruby",regex:/[)\]>}^|%]/,onMatch:function(e,t,n){if(n.length&&e===m[n[0]]){n.shift();this.next=n.shift();return this.token}this.next="";return"constant.other.symbol.ruby"}},{defaultToken:"constant.other.symbol.ruby"}],rState:[{token:"string.regexp",regex:/[(\[<{]/,onMatch:function(e,t,n){if(n.length&&e===n[0]){n.unshift(e,t);return this.token}return"constant.language.escape"}},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.regexp",regex:/\//},{token:"string.regexp",regex:/[)\]>}^|%][imxouesn]*/,onMatch:function(e,t,n){if(n.length&&e[0]===m[n[0]]){n.shift();this.next=n.shift();return this.token}this.next="";return"constant.language.escape"}},{include:"regex"},{defaultToken:"string.regexp"}],regex:[{token:"regexp.keyword",regex:/\\[wWdDhHsS]/},{token:"constant.language.escape",regex:/\\[AGbBzZ]/},{token:"constant.language.escape",regex:/\\g<[a-zA-Z0-9]*>/},{token:["constant.language.escape","regexp.keyword","constant.language.escape"],regex:/(\\p{\^?)(Alnum|Alpha|Blank|Cntrl|Digit|Graph|Lower|Print|Punct|Space|Upper|XDigit|Word|ASCII|Any|Assigned|Arabic|Armenian|Balinese|Bengali|Bopomofo|Braille|Buginese|Buhid|Canadian_Aboriginal|Carian|Cham|Cherokee|Common|Coptic|Cuneiform|Cypriot|Cyrillic|Deseret|Devanagari|Ethiopic|Georgian|Glagolitic|Gothic|Greek|Gujarati|Gurmukhi|Han|Hangul|Hanunoo|Hebrew|Hiragana|Inherited|Kannada|Katakana|Kayah_Li|Kharoshthi|Khmer|Lao|Latin|Lepcha|Limbu|Linear_B|Lycian|Lydian|Malayalam|Mongolian|Myanmar|New_Tai_Lue|Nko|Ogham|Ol_Chiki|Old_Italic|Old_Persian|Oriya|Osmanya|Phags_Pa|Phoenician|Rejang|Runic|Saurashtra|Shavian|Sinhala|Sundanese|Syloti_Nagri|Syriac|Tagalog|Tagbanwa|Tai_Le|Tamil|Telugu|Thaana|Thai|Tibetan|Tifinagh|Ugaritic|Vai|Yi|Ll|Lm|Lt|Lu|Lo|Mn|Mc|Me|Nd|Nl|Pc|Pd|Ps|Pe|Pi|Pf|Po|No|Sm|Sc|Sk|So|Zs|Zl|Zp|Cc|Cf|Cn|Co|Cs|N|L|M|P|S|Z|C)(})/},{token:["constant.language.escape","invalid","constant.language.escape"],regex:/(\\p{\^?)([^/]*)(})/},{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp",regex:/[/][imxouesn]*/,next:"start"},{token:"invalid",regex:/\{\d+\b,?\d*\}[+*]|[+*$^?][+*]|[$^][?]|\?{3,}/},{token:"constant.language.escape",regex:/\(\?(?:[:=!>]|<'?[a-zA-Z]*'?>|<[=!])|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/},{token:"constant.language.delimiter",regex:/\|/},{token:"regexp.keyword",regex:/\[\[:(?:alnum|alpha|blank|cntrl|digit|graph|lower|print|punct|space|upper|xdigit|word|ascii):\]\]/},{token:"constant.language.escape",regex:/\[\^?/,push:"regex_character_class"},{defaultToken:"string.regexp"}],regex_character_class:[{token:"regexp.keyword",regex:/\\[wWdDhHsS]/},{token:"regexp.charclass.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"constant.language.escape",regex:/&?&?\[\^?/,push:"regex_character_class"},{token:"constant.language.escape",regex:"]",next:"pop"},{token:"constant.language.escape",regex:"-"},{defaultToken:"string.regexp.characterclass"}]};this.normalizeRules()};r.inherits(h,a);t.RubyHighlightRules=h}));ace.define("ace/mode/folding/ruby",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range","ace/token_iterator"],(function(e,t,n){"use strict";var r=e("../../lib/oop");var a=e("./fold_mode").FoldMode;var o=e("../../range").Range;var i=e("../../token_iterator").TokenIterator;var s=t.FoldMode=function(){};r.inherits(s,a);(function(){this.indentKeywords={class:1,def:1,module:1,do:1,unless:1,if:1,while:1,for:1,until:1,begin:1,else:0,elsif:0,rescue:0,ensure:0,when:0,end:-1,case:1,"=begin":1,"=end":-1};this.foldingStartMarker=/(?:\s|^)(def|do|while|class|unless|module|if|for|until|begin|else|elsif|case|rescue|ensure|when)\b|({\s*$)|(=begin)/;this.foldingStopMarker=/(=end(?=$|\s.*$))|(^\s*})|\b(end)\b/;this.getFoldWidget=function(e,t,n){var r=e.getLine(n);var a=this.foldingStartMarker.test(r);var o=this.foldingStopMarker.test(r);if(a&&!o){var i=r.match(this.foldingStartMarker);if(i[1]){if(i[1]=="if"||i[1]=="else"||i[1]=="while"||i[1]=="until"||i[1]=="unless"){if(i[1]=="else"&&/^\s*else\s*$/.test(r)===false){return}if(/^\s*(?:if|else|while|until|unless)\s*/.test(r)===false){return}}if(i[1]=="when"){if(/\sthen\s/.test(r)===true){return}}if(e.getTokenAt(n,i.index+2).type==="keyword")return"start"}else if(i[3]){if(e.getTokenAt(n,i.index+1).type==="comment.multiline")return"start"}else{return"start"}}if(t!="markbeginend"||!o||a&&o)return"";var i=r.match(this.foldingStopMarker);if(i[3]==="end"){if(e.getTokenAt(n,i.index+1).type==="keyword")return"end"}else if(i[1]){if(e.getTokenAt(n,i.index+1).type==="comment.multiline")return"end"}else return"end"};this.getFoldWidgetRange=function(e,t,n){var r=e.doc.getLine(n);var a=this.foldingStartMarker.exec(r);if(a){if(a[1]||a[3])return this.rubyBlock(e,n,a.index+2);return this.openingBracketBlock(e,"{",n,a.index)}var a=this.foldingStopMarker.exec(r);if(a){if(a[3]==="end"){if(e.getTokenAt(n,a.index+1).type==="keyword")return this.rubyBlock(e,n,a.index+1)}if(a[1]==="=end"){if(e.getTokenAt(n,a.index+1).type==="comment.multiline")return this.rubyBlock(e,n,a.index+1)}return this.closingBracketBlock(e,"}",n,a.index+a[0].length)}};this.rubyBlock=function(e,t,n,r){var a=new i(e,t,n);var s=a.getCurrentToken();if(!s||s.type!="keyword"&&s.type!="comment.multiline")return;var l=s.value;var u=e.getLine(t);switch(s.value){case"if":case"unless":case"while":case"until":var c=new RegExp("^\\s*"+s.value);if(!c.test(u)){return}var g=this.indentKeywords[l];break;case"when":if(/\sthen\s/.test(u)){return}case"elsif":case"rescue":case"ensure":var g=1;break;case"else":var c=new RegExp("^\\s*"+s.value+"\\s*$");if(!c.test(u)){return}var g=1;break;default:var g=this.indentKeywords[l];break}var d=[l];if(!g)return;var p=g===-1?e.getLine(t-1).length:e.getLine(t).length;var h=t;var m=[];m.push(a.getCurrentTokenRange());a.step=g===-1?a.stepBackward:a.stepForward;if(s.type=="comment.multiline"){while(s=a.step()){if(s.type!=="comment.multiline")continue;if(g==1){p=6;if(s.value=="=end"){break}}else{if(s.value=="=begin"){break}}}}else{while(s=a.step()){var f=false;if(s.type!=="keyword")continue;var x=g*this.indentKeywords[s.value];u=e.getLine(a.getCurrentTokenRow());switch(s.value){case"do":for(var b=a.$tokenIndex-1;b>=0;b--){var k=a.$rowTokens[b];if(k&&(k.value=="while"||k.value=="until"||k.value=="for")){x=0;break}}break;case"else":var c=new RegExp("^\\s*"+s.value+"\\s*$");if(!c.test(u)||l=="case"){x=0;f=true}break;case"if":case"unless":case"while":case"until":var c=new RegExp("^\\s*"+s.value);if(!c.test(u)){x=0;f=true}break;case"when":if(/\sthen\s/.test(u)||l=="case"){x=0;f=true}break}if(x>0){d.unshift(s.value)}else if(x<=0&&f===false){d.shift();if(!d.length){if((l=="while"||l=="until"||l=="for")&&s.value!="do"){break}if(s.value=="do"&&g==-1&&x!=0)break;if(s.value!="do")break}if(x===0){d.unshift(s.value)}}}}if(!s)return null;if(r){m.push(a.getCurrentTokenRange());return m}var t=a.getCurrentTokenRow();if(g===-1){if(s.type==="comment.multiline"){var v=6}else{var v=e.getLine(t).length}return new o(t,v,h-1,p)}else return new o(h,p,t-1,e.getLine(t-1).length)}}).call(s.prototype)}));ace.define("ace/mode/ruby",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/ruby_highlight_rules","ace/mode/matching_brace_outdent","ace/range","ace/mode/behaviour/cstyle","ace/mode/folding/ruby"],(function(e,t,n){"use strict";var r=e("../lib/oop");var a=e("./text").Mode;var o=e("./ruby_highlight_rules").RubyHighlightRules;var i=e("./matching_brace_outdent").MatchingBraceOutdent;var s=e("../range").Range;var l=e("./behaviour/cstyle").CstyleBehaviour;var u=e("./folding/ruby").FoldMode;var c=function(){this.HighlightRules=o;this.$outdent=new i;this.$behaviour=new l;this.foldingRules=new u;this.indentKeywords=this.foldingRules.indentKeywords};r.inherits(c,a);(function(){this.lineCommentStart="#";this.getNextLineIndent=function(e,t,n){var r=this.$getIndent(t);var a=this.getTokenizer().getLineTokens(t,e);var o=a.tokens;if(o.length&&o[o.length-1].type=="comment"){return r}if(e=="start"){var i=t.match(/^.*[\{\(\[]\s*$/);var s=t.match(/^\s*(class|def|module)\s.*$/);var l=t.match(/.*do(\s*|\s+\|.*\|\s*)$/);var u=t.match(/^\s*(if|else|when|elsif|unless|while|for|begin|rescue|ensure)\s*/);if(i||s||l||u){r+=n}}return r};this.checkOutdent=function(e,t,n){return/^\s+(end|else|rescue|ensure)$/.test(t+n)||this.$outdent.checkOutdent(t,n)};this.autoOutdent=function(e,t,n){var r=t.getLine(n);if(/}/.test(r))return this.$outdent.autoOutdent(t,n);var a=this.$getIndent(r);var o=t.getLine(n-1);var i=this.$getIndent(o);var l=t.getTabString();if(i.length<=a.length){if(a.slice(-l.length)==l)t.remove(new s(n,a.length-l.length,n,a.length))}};this.getMatching=function(e,t,n){if(t==undefined){var r=e.selection.lead;n=r.column;t=r.row}var a=e.getTokenAt(t,n);if(a&&a.value in this.indentKeywords)return this.foldingRules.rubyBlock(e,t,n,true)};this.$id="ace/mode/ruby";this.snippetFileId="ace/snippets/ruby"}).call(c.prototype);t.Mode=c}));ace.define("ace/mode/ejs",["require","exports","module","ace/lib/oop","ace/mode/html_highlight_rules","ace/mode/javascript_highlight_rules","ace/lib/oop","ace/mode/html","ace/mode/javascript","ace/mode/css","ace/mode/ruby"],(function(e,t,n){"use strict";var r=e("../lib/oop");var a=e("./html_highlight_rules").HtmlHighlightRules;var o=e("./javascript_highlight_rules").JavaScriptHighlightRules;var i=function(e,t){a.call(this);if(!e)e="(?:<%|<\\?|{{)";if(!t)t="(?:%>|\\?>|}})";for(var n in this.$rules){this.$rules[n].unshift({token:"markup.list.meta.tag",regex:e+"(?![>}])[-=]?",push:"ejs-start"})}this.embedRules(new o({jsx:false}).getRules(),"ejs-",[{token:"markup.list.meta.tag",regex:"-?"+t,next:"pop"},{token:"comment",regex:"//.*?"+t,next:"pop"}]);this.normalizeRules()};r.inherits(i,a);t.EjsHighlightRules=i;var r=e("../lib/oop");var s=e("./html").Mode;var l=e("./javascript").Mode;var u=e("./css").Mode;var c=e("./ruby").Mode;var g=function(){s.call(this);this.HighlightRules=i;this.createModeDelegates({"js-":l,"css-":u,"ejs-":l})};r.inherits(g,s);(function(){this.$id="ace/mode/ejs"}).call(g.prototype);t.Mode=g}));(function(){ace.require(["ace/mode/ejs"],(function(e){if(typeof module=="object"&&typeof exports=="object"&&module){module.exports=e}}))})();