ace.define("ace/mode/perl_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],(function(e,t,n){"use strict";var r=e("../lib/oop");var i=e("./text_highlight_rules").TextHighlightRules;var o=function(){var e="base|constant|continue|else|elsif|for|foreach|format|goto|if|last|local|my|next|"+"no|package|parent|redo|require|scalar|sub|unless|until|while|use|vars";var t="ARGV|ENV|INC|SIG";var n="getprotobynumber|getprotobyname|getservbyname|gethostbyaddr|"+"gethostbyname|getservbyport|getnetbyaddr|getnetbyname|getsockname|"+"getpeername|setpriority|getprotoent|setprotoent|getpriority|"+"endprotoent|getservent|setservent|endservent|sethostent|socketpair|"+"getsockopt|gethostent|endhostent|setsockopt|setnetent|quotemeta|"+"localtime|prototype|getnetent|endnetent|rewinddir|wantarray|getpwuid|"+"closedir|getlogin|readlink|endgrent|getgrgid|getgrnam|shmwrite|"+"shutdown|readline|endpwent|setgrent|readpipe|formline|truncate|"+"dbmclose|syswrite|setpwent|getpwnam|getgrent|getpwent|ucfirst|sysread|"+"setpgrp|shmread|sysseek|sysopen|telldir|defined|opendir|connect|"+"lcfirst|getppid|binmode|syscall|sprintf|getpgrp|readdir|seekdir|"+"waitpid|reverse|unshift|symlink|dbmopen|semget|msgrcv|rename|listen|"+"chroot|msgsnd|shmctl|accept|unpack|exists|fileno|shmget|system|"+"unlink|printf|gmtime|msgctl|semctl|values|rindex|substr|splice|"+"length|msgget|select|socket|return|caller|delete|alarm|ioctl|index|"+"undef|lstat|times|srand|chown|fcntl|close|write|umask|rmdir|study|"+"sleep|chomp|untie|print|utime|mkdir|atan2|split|crypt|flock|chmod|"+"BEGIN|bless|chdir|semop|shift|reset|link|stat|chop|grep|fork|dump|"+"join|open|tell|pipe|exit|glob|warn|each|bind|sort|pack|eval|push|"+"keys|getc|kill|seek|sqrt|send|wait|rand|tied|read|time|exec|recv|"+"eof|chr|int|ord|exp|pos|pop|sin|log|abs|oct|hex|tie|cos|vec|END|ref|"+"map|die|uc|lc|do";var r=this.createKeywordMapper({keyword:e,"constant.language":t,"support.function":n},"identifier");this.$rules={start:[{token:"comment.doc",regex:"^=(?:begin|item)\\b",next:"block_comment"},{token:"string.regexp",regex:"[/](?:(?:\\[(?:\\\\]|[^\\]])+\\])|(?:\\\\/|[^\\]/]))*[/]\\w*\\s*(?=[).,;]|$)"},{token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'},{token:"string",regex:'["].*\\\\$',next:"qqstring"},{token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"string",regex:"['].*\\\\$",next:"qstring"},{token:"constant.numeric",regex:"0x[0-9a-fA-F]+\\b"},{token:"constant.numeric",regex:"[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"},{token:r,regex:"[a-zA-Z_$][a-zA-Z0-9_$]*\\b"},{token:"keyword.operator",regex:"%#|\\$#|\\.\\.\\.|\\|\\|=|>>=|<<=|<=>|&&=|=>|!~|\\^=|&=|\\|=|\\.=|x=|%=|\\/=|\\*=|\\-=|\\+=|=~|\\*\\*|\\-\\-|\\.\\.|\\|\\||&&|\\+\\+|\\->|!=|==|>=|<=|>>|<<|,|=|\\?\\:|\\^|\\||x|%|\\/|\\*|<|&|\\\\|~|!|>|\\.|\\-|\\+|\\-C|\\-b|\\-S|\\-u|\\-t|\\-p|\\-l|\\-d|\\-f|\\-g|\\-s|\\-z|\\-k|\\-e|\\-O|\\-T|\\-B|\\-M|\\-A|\\-X|\\-W|\\-c|\\-R|\\-o|\\-x|\\-w|\\-r|\\b(?:and|cmp|eq|ge|gt|le|lt|ne|not|or|xor)"},{token:"comment",regex:"#.*$"},{token:"lparen",regex:"[[({]"},{token:"rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"}],qqstring:[{token:"string",regex:'(?:(?:\\\\.)|(?:[^"\\\\]))*?"',next:"start"},{token:"string",regex:".+"}],qstring:[{token:"string",regex:"(?:(?:\\\\.)|(?:[^'\\\\]))*?'",next:"start"},{token:"string",regex:".+"}],block_comment:[{token:"comment.doc",regex:"^=cut\\b",next:"start"},{defaultToken:"comment.doc"}]}};r.inherits(o,i);t.PerlHighlightRules=o}));ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],(function(e,t,n){"use strict";var r=e("../range").Range;var i=function(){};(function(){this.checkOutdent=function(e,t){if(!/^\s+$/.test(e))return false;return/^\s*\}/.test(t)};this.autoOutdent=function(e,t){var n=e.getLine(t);var i=n.match(/^(\s*\})/);if(!i)return 0;var o=i[1].length;var s=e.findMatchingBracket({row:t,column:o});if(!s||s.row==t)return 0;var a=this.$getIndent(e.getLine(s.row));e.replace(new r(t,0,t,o-1),a)};this.$getIndent=function(e){return e.match(/^\s*/)[0]}}).call(i.prototype);t.MatchingBraceOutdent=i}));ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],(function(e,t,n){"use strict";var r=e("../../lib/oop");var i=e("../../range").Range;var o=e("./fold_mode").FoldMode;var s=t.FoldMode=function(e){if(e){this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+e.start));this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+e.end))}};r.inherits(s,o);(function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/;this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/;this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/;this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/;this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/;this._getFoldWidgetBase=this.getFoldWidget;this.getFoldWidget=function(e,t,n){var r=e.getLine(n);if(this.singleLineBlockCommentRe.test(r)){if(!this.startRegionRe.test(r)&&!this.tripleStarBlockCommentRe.test(r))return""}var i=this._getFoldWidgetBase(e,t,n);if(!i&&this.startRegionRe.test(r))return"start";return i};this.getFoldWidgetRange=function(e,t,n,r){var i=e.getLine(n);if(this.startRegionRe.test(i))return this.getCommentRegionBlock(e,i,n);var o=i.match(this.foldingStartMarker);if(o){var s=o.index;if(o[1])return this.openingBracketBlock(e,o[1],n,s);var a=e.getCommentFoldRange(n,s+o[0].length,1);if(a&&!a.isMultiLine()){if(r){a=this.getSectionRange(e,n)}else if(t!="all")a=null}return a}if(t==="markbegin")return;var o=i.match(this.foldingStopMarker);if(o){var s=o.index+o[0].length;if(o[1])return this.closingBracketBlock(e,o[1],n,s);return e.getCommentFoldRange(n,s,-1)}};this.getSectionRange=function(e,t){var n=e.getLine(t);var r=n.search(/\S/);var o=t;var s=n.length;t=t+1;var a=t;var g=e.getLength();while(++t<g){n=e.getLine(t);var l=n.search(/\S/);if(l===-1)continue;if(r>l)break;var c=this.getFoldWidgetRange(e,"all",t);if(c){if(c.start.row<=o){break}else if(c.isMultiLine()){t=c.end.row}else if(r==l){break}}a=t}return new i(o,s,a,e.getLine(a).length)};this.getCommentRegionBlock=function(e,t,n){var r=t.search(/\s*$/);var o=e.getLength();var s=n;var a=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/;var g=1;while(++n<o){t=e.getLine(n);var l=a.exec(t);if(!l)continue;if(l[1])g--;else g++;if(!g)break}var c=n;if(c>s){return new i(s,r,c,t.length)}}}).call(s.prototype)}));ace.define("ace/mode/perl",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/perl_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/folding/cstyle"],(function(e,t,n){"use strict";var r=e("../lib/oop");var i=e("./text").Mode;var o=e("./perl_highlight_rules").PerlHighlightRules;var s=e("./matching_brace_outdent").MatchingBraceOutdent;var a=e("./folding/cstyle").FoldMode;var g=function(){this.HighlightRules=o;this.$outdent=new s;this.foldingRules=new a({start:"^=(begin|item)\\b",end:"^=(cut)\\b"});this.$behaviour=this.$defaultBehaviour};r.inherits(g,i);(function(){this.lineCommentStart="#";this.blockComment=[{start:"=begin",end:"=cut",lineStartOnly:true},{start:"=item",end:"=cut",lineStartOnly:true}];this.getNextLineIndent=function(e,t,n){var r=this.$getIndent(t);var i=this.getTokenizer().getLineTokens(t,e);var o=i.tokens;if(o.length&&o[o.length-1].type=="comment"){return r}if(e=="start"){var s=t.match(/^.*[\{\(\[:]\s*$/);if(s){r+=n}}return r};this.checkOutdent=function(e,t,n){return this.$outdent.checkOutdent(t,n)};this.autoOutdent=function(e,t,n){this.$outdent.autoOutdent(t,n)};this.$id="ace/mode/perl";this.snippetFileId="ace/snippets/perl"}).call(g.prototype);t.Mode=g}));(function(){ace.require(["ace/mode/perl"],(function(e){if(typeof module=="object"&&typeof exports=="object"&&module){module.exports=e}}))})();