ace.define("ace/mode/slim_highlight_rules",["require","exports","module","ace/config","ace/lib/oop","ace/mode/text_highlight_rules"],(function(e,t,n){"use strict";var r=e("../config").$modes;var o=e("../lib/oop");var a=e("./text_highlight_rules").TextHighlightRules;var i=function(){this.$rules={start:[{token:"keyword",regex:/^(\s*)(\w+):\s*/,onMatch:function(e,t,n,r){var o=/^\s*/.exec(r)[0];var a=e.match(/^(\s*)(\w+):/);var i=a[2];if(!/^(javascript|ruby|coffee|markdown|css|scss|sass|less)$/.test(i))i="";n.unshift("language-embed",[],[o,i],t);return this.token},stateName:"language-embed",next:[{token:"string",regex:/^(\s*)/,onMatch:function(e,t,n,r){var o=n[2][0];if(o.length>=e.length){n.splice(0,3);this.next=n.shift();return this.token}this.next="";return[{type:"text",value:o}]},next:""},{token:"string",regex:/.+/,onMatch:function(e,t,n,o){var a=n[2][0];var i=n[2][1];var s=n[1];if(r[i]){var l=r[i].getTokenizer().getLineTokens(o.slice(a.length),s.slice(0));n[1]=l.state;return l.tokens}return this.token}}]},{token:"constant.begin.javascript.filter.slim",regex:"^(\\s*)():$"},{token:"constant.begin..filter.slim",regex:"^(\\s*)(ruby):$"},{token:"constant.begin.coffeescript.filter.slim",regex:"^(\\s*)():$"},{token:"constant.begin..filter.slim",regex:"^(\\s*)(markdown):$"},{token:"constant.begin.css.filter.slim",regex:"^(\\s*)():$"},{token:"constant.begin.scss.filter.slim",regex:"^(\\s*)():$"},{token:"constant.begin..filter.slim",regex:"^(\\s*)(sass):$"},{token:"constant.begin..filter.slim",regex:"^(\\s*)(less):$"},{token:"constant.begin..filter.slim",regex:"^(\\s*)(erb):$"},{token:"keyword.html.tags.slim",regex:"^(\\s*)((:?\\*(\\w)+)|doctype html|abbr|acronym|address|applet|area|article|aside|audio|base|basefont|bdo|big|blockquote|body|br|button|canvas|caption|center|cite|code|col|colgroup|command|datalist|dd|del|details|dialog|dfn|dir|div|dl|dt|embed|fieldset|figure|font|footer|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|header|hgroup|hr|html|i|iframe|img|input|ins|keygen|kbd|label|legend|link|li|map|mark|menu|meta|meter|nav|noframes|noscript|object|ol|optgroup|option|output|p|param|pre|progress|q|rp|rt|ruby|samp|script|section|select|small|source|span|strike|strong|style|sub|sup|table|tbody|td|textarea|tfoot|th|thead|time|title|tr|tt|ul|var|video|xmp|b|u|s|em|a)(?:([.#](\\w|\\.)+)+\\s?)?\\b"},{token:"keyword.slim",regex:"^(\\s*)(?:([.#](\\w|\\.)+)+\\s?)"},{token:"string",regex:/^(\s*)('|\||\/|(\/!))\s*/,onMatch:function(e,t,n,r){var o=/^\s*/.exec(r)[0];if(n.length<1){n.push(this.next)}else{n[0]="mlString"}if(n.length<2){n.push(o.length)}else{n[1]=o.length}return this.token},next:"mlString"},{token:"keyword.control.slim",regex:"^(\\s*)(\\-|==|=)",push:[{token:"control.end.slim",regex:"$",next:"pop"},{include:"rubyline"},{include:"misc"}]},{token:"paren",regex:"\\(",push:[{token:"paren",regex:"\\)",next:"pop"},{include:"misc"}]},{token:"paren",regex:"\\[",push:[{token:"paren",regex:"\\]",next:"pop"},{include:"misc"}]},{include:"misc"}],mlString:[{token:"indent",regex:/^\s*/,onMatch:function(e,t,n){var r=n[1];if(r>=e.length){this.next="start";n.splice(0)}else{this.next="mlString"}return this.token},next:"start"},{defaultToken:"string"}],rubyline:[{token:"keyword.operator.ruby.embedded.slim",regex:"(==|=)(<>|><|<'|'<|<|>)?|-"},{token:"list.ruby.operators.slim",regex:"(\\b)(for|in|do|if|else|elsif|unless|while|yield|not|and|or)\\b"},{token:"string",regex:"['](.)*?[']"},{token:"string",regex:'["](.)*?["]'}],misc:[{token:"class.variable.slim",regex:"\\@([a-zA-Z_][a-zA-Z0-9_]*)\\b"},{token:"list.meta.slim",regex:"(\\b)(true|false|nil)(\\b)"},{token:"keyword.operator.equals.slim",regex:"="},{token:"string",regex:"['](.)*?[']"},{token:"string",regex:'["](.)*?["]'}]};this.normalizeRules()};o.inherits(i,a);t.SlimHighlightRules=i}));ace.define("ace/mode/doc_comment_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],(function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("./text_highlight_rules").TextHighlightRules;var a=function(){this.$rules={start:[{token:"comment.doc.tag",regex:"@[\\w\\d_]+"},a.getTagRule(),{defaultToken:"comment.doc",caseInsensitive:true}]}};r.inherits(a,o);a.getTagRule=function(e){return{token:"comment.doc.tag.storage.type",regex:"\\b(?:TODO|FIXME|XXX|HACK)\\b"}};a.getStartRule=function(e){return{token:"comment.doc",regex:"\\/\\*(?=\\*)",next:e}};a.getEndRule=function(e){return{token:"comment.doc",regex:"\\*\\/",next:e}};t.DocCommentHighlightRules=a}));ace.define("ace/mode/javascript_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/doc_comment_highlight_rules","ace/mode/text_highlight_rules"],(function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("./doc_comment_highlight_rules").DocCommentHighlightRules;var a=e("./text_highlight_rules").TextHighlightRules;var i="[a-zA-Z\\$_¡-￿][a-zA-Z\\d\\$_¡-￿]*";var s=function(e){var t=this.createKeywordMapper({"variable.language":"Array|Boolean|Date|Function|Iterator|Number|Object|RegExp|String|Proxy|"+"Namespace|QName|XML|XMLList|"+"ArrayBuffer|Float32Array|Float64Array|Int16Array|Int32Array|Int8Array|"+"Uint16Array|Uint32Array|Uint8Array|Uint8ClampedArray|"+"Error|EvalError|InternalError|RangeError|ReferenceError|StopIteration|"+"SyntaxError|TypeError|URIError|"+"decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|eval|isFinite|"+"isNaN|parseFloat|parseInt|"+"JSON|Math|"+"this|arguments|prototype|window|document",keyword:"const|yield|import|get|set|async|await|"+"break|case|catch|continue|default|delete|do|else|finally|for|function|"+"if|in|of|instanceof|new|return|switch|throw|try|typeof|let|var|while|with|debugger|"+"__parent__|__count__|escape|unescape|with|__proto__|"+"class|enum|extends|super|export|implements|private|public|interface|package|protected|static","storage.type":"const|let|var|function","constant.language":"null|Infinity|NaN|undefined","support.function":"alert","constant.language.boolean":"true|false"},"identifier");var n="case|do|else|finally|in|instanceof|return|throw|try|typeof|yield|void";var r="\\\\(?:x[0-9a-fA-F]{2}|"+"u[0-9a-fA-F]{4}|"+"u{[0-9a-fA-F]{1,6}}|"+"[0-2][0-7]{0,2}|"+"3[0-7][0-7]?|"+"[4-7][0-7]?|"+".)";this.$rules={no_regex:[o.getStartRule("doc-start"),c("no_regex"),{token:"string",regex:"'(?=.)",next:"qstring"},{token:"string",regex:'"(?=.)',next:"qqstring"},{token:"constant.numeric",regex:/0(?:[xX][0-9a-fA-F]+|[oO][0-7]+|[bB][01]+)\b/},{token:"constant.numeric",regex:/(?:\d\d*(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+\b)?/},{token:["storage.type","punctuation.operator","support.function","punctuation.operator","entity.name.function","text","keyword.operator"],regex:"("+i+")(\\.)(prototype)(\\.)("+i+")(\\s*)(=)",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+i+")(\\.)("+i+")(\\s*)(=)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+i+")(\\s*)(=)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","entity.name.function","text","paren.lparen"],regex:"("+i+")(\\.)("+i+")(\\s*)(=)(\\s*)(function)(\\s+)(\\w+)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","text","entity.name.function","text","paren.lparen"],regex:"(function)(\\s+)("+i+")(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","punctuation.operator","text","storage.type","text","paren.lparen"],regex:"("+i+")(\\s*)(:)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["text","text","storage.type","text","paren.lparen"],regex:"(:)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:"keyword",regex:"from(?=\\s*('|\"))"},{token:"keyword",regex:"(?:"+n+")\\b",next:"start"},{token:["support.constant"],regex:/that\b/},{token:["storage.type","punctuation.operator","support.function.firebug"],regex:/(console)(\.)(warn|info|log|error|time|trace|timeEnd|assert)\b/},{token:t,regex:i},{token:"punctuation.operator",regex:/[.](?![.])/,next:"property"},{token:"storage.type",regex:/=>/,next:"start"},{token:"keyword.operator",regex:/--|\+\+|\.{3}|===|==|=|!=|!==|<+=?|>+=?|!|&&|\|\||\?:|[!$%&*+\-~\/^]=?/,next:"start"},{token:"punctuation.operator",regex:/[?:,;.]/,next:"start"},{token:"paren.lparen",regex:/[\[({]/,next:"start"},{token:"paren.rparen",regex:/[\])}]/},{token:"comment",regex:/^#!.*$/}],property:[{token:"text",regex:"\\s+"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","entity.name.function","text","paren.lparen"],regex:"("+i+")(\\.)("+i+")(\\s*)(=)(\\s*)(function)(?:(\\s+)(\\w+))?(\\s*)(\\()",next:"function_arguments"},{token:"punctuation.operator",regex:/[.](?![.])/},{token:"support.function",regex:/(s(?:h(?:ift|ow(?:Mod(?:elessDialog|alDialog)|Help))|croll(?:X|By(?:Pages|Lines)?|Y|To)?|t(?:op|rike)|i(?:n|zeToContent|debar|gnText)|ort|u(?:p|b(?:str(?:ing)?)?)|pli(?:ce|t)|e(?:nd|t(?:Re(?:sizable|questHeader)|M(?:i(?:nutes|lliseconds)|onth)|Seconds|Ho(?:tKeys|urs)|Year|Cursor|Time(?:out)?|Interval|ZOptions|Date|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Date|FullYear)|FullYear|Active)|arch)|qrt|lice|avePreferences|mall)|h(?:ome|andleEvent)|navigate|c(?:har(?:CodeAt|At)|o(?:s|n(?:cat|textual|firm)|mpile)|eil|lear(?:Timeout|Interval)?|a(?:ptureEvents|ll)|reate(?:StyleSheet|Popup|EventObject))|t(?:o(?:GMTString|S(?:tring|ource)|U(?:TCString|pperCase)|Lo(?:caleString|werCase))|est|a(?:n|int(?:Enabled)?))|i(?:s(?:NaN|Finite)|ndexOf|talics)|d(?:isableExternalCapture|ump|etachEvent)|u(?:n(?:shift|taint|escape|watch)|pdateCommands)|j(?:oin|avaEnabled)|p(?:o(?:p|w)|ush|lugins.refresh|a(?:ddings|rse(?:Int|Float)?)|r(?:int|ompt|eference))|e(?:scape|nableExternalCapture|val|lementFromPoint|x(?:p|ec(?:Script|Command)?))|valueOf|UTC|queryCommand(?:State|Indeterm|Enabled|Value)|f(?:i(?:nd|le(?:ModifiedDate|Size|CreatedDate|UpdatedDate)|xed)|o(?:nt(?:size|color)|rward)|loor|romCharCode)|watch|l(?:ink|o(?:ad|g)|astIndexOf)|a(?:sin|nchor|cos|t(?:tachEvent|ob|an(?:2)?)|pply|lert|b(?:s|ort))|r(?:ou(?:nd|teEvents)|e(?:size(?:By|To)|calc|turnValue|place|verse|l(?:oad|ease(?:Capture|Events)))|andom)|g(?:o|et(?:ResponseHeader|M(?:i(?:nutes|lliseconds)|onth)|Se(?:conds|lection)|Hours|Year|Time(?:zoneOffset)?|Da(?:y|te)|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Da(?:y|te)|FullYear)|FullYear|A(?:ttention|llResponseHeaders)))|m(?:in|ove(?:B(?:y|elow)|To(?:Absolute)?|Above)|ergeAttributes|a(?:tch|rgins|x))|b(?:toa|ig|o(?:ld|rderWidths)|link|ack))\b(?=\()/},{token:"support.function.dom",regex:/(s(?:ub(?:stringData|mit)|plitText|e(?:t(?:NamedItem|Attribute(?:Node)?)|lect))|has(?:ChildNodes|Feature)|namedItem|c(?:l(?:ick|o(?:se|neNode))|reate(?:C(?:omment|DATASection|aption)|T(?:Head|extNode|Foot)|DocumentFragment|ProcessingInstruction|E(?:ntityReference|lement)|Attribute))|tabIndex|i(?:nsert(?:Row|Before|Cell|Data)|tem)|open|delete(?:Row|C(?:ell|aption)|T(?:Head|Foot)|Data)|focus|write(?:ln)?|a(?:dd|ppend(?:Child|Data))|re(?:set|place(?:Child|Data)|move(?:NamedItem|Child|Attribute(?:Node)?)?)|get(?:NamedItem|Element(?:sBy(?:Name|TagName|ClassName)|ById)|Attribute(?:Node)?)|blur)\b(?=\()/},{token:"support.constant",regex:/(s(?:ystemLanguage|cr(?:ipts|ollbars|een(?:X|Y|Top|Left))|t(?:yle(?:Sheets)?|atus(?:Text|bar)?)|ibling(?:Below|Above)|ource|uffixes|e(?:curity(?:Policy)?|l(?:ection|f)))|h(?:istory|ost(?:name)?|as(?:h|Focus))|y|X(?:MLDocument|SLDocument)|n(?:ext|ame(?:space(?:s|URI)|Prop))|M(?:IN_VALUE|AX_VALUE)|c(?:haracterSet|o(?:n(?:structor|trollers)|okieEnabled|lorDepth|mp(?:onents|lete))|urrent|puClass|l(?:i(?:p(?:boardData)?|entInformation)|osed|asses)|alle(?:e|r)|rypto)|t(?:o(?:olbar|p)|ext(?:Transform|Indent|Decoration|Align)|ags)|SQRT(?:1_2|2)|i(?:n(?:ner(?:Height|Width)|put)|ds|gnoreCase)|zIndex|o(?:scpu|n(?:readystatechange|Line)|uter(?:Height|Width)|p(?:sProfile|ener)|ffscreenBuffering)|NEGATIVE_INFINITY|d(?:i(?:splay|alog(?:Height|Top|Width|Left|Arguments)|rectories)|e(?:scription|fault(?:Status|Ch(?:ecked|arset)|View)))|u(?:ser(?:Profile|Language|Agent)|n(?:iqueID|defined)|pdateInterval)|_content|p(?:ixelDepth|ort|ersonalbar|kcs11|l(?:ugins|atform)|a(?:thname|dding(?:Right|Bottom|Top|Left)|rent(?:Window|Layer)?|ge(?:X(?:Offset)?|Y(?:Offset)?))|r(?:o(?:to(?:col|type)|duct(?:Sub)?|mpter)|e(?:vious|fix)))|e(?:n(?:coding|abledPlugin)|x(?:ternal|pando)|mbeds)|v(?:isibility|endor(?:Sub)?|Linkcolor)|URLUnencoded|P(?:I|OSITIVE_INFINITY)|f(?:ilename|o(?:nt(?:Size|Family|Weight)|rmName)|rame(?:s|Element)|gColor)|E|whiteSpace|l(?:i(?:stStyleType|n(?:eHeight|kColor))|o(?:ca(?:tion(?:bar)?|lName)|wsrc)|e(?:ngth|ft(?:Context)?)|a(?:st(?:M(?:odified|atch)|Index|Paren)|yer(?:s|X)|nguage))|a(?:pp(?:MinorVersion|Name|Co(?:deName|re)|Version)|vail(?:Height|Top|Width|Left)|ll|r(?:ity|guments)|Linkcolor|bove)|r(?:ight(?:Context)?|e(?:sponse(?:XML|Text)|adyState))|global|x|m(?:imeTypes|ultiline|enubar|argin(?:Right|Bottom|Top|Left))|L(?:N(?:10|2)|OG(?:10E|2E))|b(?:o(?:ttom|rder(?:Width|RightWidth|BottomWidth|Style|Color|TopWidth|LeftWidth))|ufferDepth|elow|ackground(?:Color|Image)))\b/},{token:"identifier",regex:i},{regex:"",token:"empty",next:"no_regex"}],start:[o.getStartRule("doc-start"),c("start"),{token:"string.regexp",regex:"\\/",next:"regex"},{token:"text",regex:"\\s+|^$",next:"start"},{token:"empty",regex:"",next:"no_regex"}],regex:[{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp",regex:"/[sxngimy]*",next:"no_regex"},{token:"invalid",regex:/\{\d+\b,?\d*\}[+*]|[+*$^?][+*]|[$^][?]|\?{3,}/},{token:"constant.language.escape",regex:/\(\?[:=!]|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/},{token:"constant.language.delimiter",regex:/\|/},{token:"constant.language.escape",regex:/\[\^?/,next:"regex_character_class"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp"}],regex_character_class:[{token:"regexp.charclass.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"constant.language.escape",regex:"]",next:"regex"},{token:"constant.language.escape",regex:"-"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp.charachterclass"}],function_arguments:[{token:"variable.parameter",regex:i},{token:"punctuation.operator",regex:"[, ]+"},{token:"punctuation.operator",regex:"$"},{token:"empty",regex:"",next:"no_regex"}],qqstring:[{token:"constant.language.escape",regex:r},{token:"string",regex:"\\\\$",consumeLineEnd:true},{token:"string",regex:'"|$',next:"no_regex"},{defaultToken:"string"}],qstring:[{token:"constant.language.escape",regex:r},{token:"string",regex:"\\\\$",consumeLineEnd:true},{token:"string",regex:"'|$",next:"no_regex"},{defaultToken:"string"}]};if(!e||!e.noES6){this.$rules.no_regex.unshift({regex:"[{}]",onMatch:function(e,t,n){this.next=e=="{"?this.nextState:"";if(e=="{"&&n.length){n.unshift("start",t)}else if(e=="}"&&n.length){n.shift();this.next=n.shift();if(this.next.indexOf("string")!=-1||this.next.indexOf("jsx")!=-1)return"paren.quasi.end"}return e=="{"?"paren.lparen":"paren.rparen"},nextState:"start"},{token:"string.quasi.start",regex:/`/,push:[{token:"constant.language.escape",regex:r},{token:"paren.quasi.start",regex:/\${/,push:"start"},{token:"string.quasi.end",regex:/`/,next:"pop"},{defaultToken:"string.quasi"}]});if(!e||e.jsx!=false)l.call(this)}this.embedRules(o,"doc-",[o.getEndRule("no_regex")]);this.normalizeRules()};r.inherits(s,a);function l(){var e=i.replace("\\d","\\d\\-");var t={onMatch:function(e,t,n){var r=e.charAt(1)=="/"?2:1;if(r==1){if(t!=this.nextState)n.unshift(this.next,this.nextState,0);else n.unshift(this.next);n[2]++}else if(r==2){if(t==this.nextState){n[1]--;if(!n[1]||n[1]<0){n.shift();n.shift()}}}return[{type:"meta.tag.punctuation."+(r==1?"":"end-")+"tag-open.xml",value:e.slice(0,r)},{type:"meta.tag.tag-name.xml",value:e.substr(r)}]},regex:"</?"+e+"",next:"jsxAttributes",nextState:"jsx"};this.$rules.start.unshift(t);var n={regex:"{",token:"paren.quasi.start",push:"start"};this.$rules.jsx=[n,t,{include:"reference"},{defaultToken:"string"}];this.$rules.jsxAttributes=[{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",onMatch:function(e,t,n){if(t==n[0])n.shift();if(e.length==2){if(n[0]==this.nextState)n[1]--;if(!n[1]||n[1]<0){n.splice(0,2)}}this.next=n[0]||"start";return[{type:this.token,value:e}]},nextState:"jsx"},n,c("jsxAttributes"),{token:"entity.other.attribute-name.xml",regex:e},{token:"keyword.operator.attribute-equals.xml",regex:"="},{token:"text.tag-whitespace.xml",regex:"\\s+"},{token:"string.attribute-value.xml",regex:"'",stateName:"jsx_attr_q",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',stateName:"jsx_attr_qq",push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},t];this.$rules.reference=[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}]}function c(e){return[{token:"comment",regex:/\/\*/,next:[o.getTagRule(),{token:"comment",regex:"\\*\\/",next:e||"pop"},{defaultToken:"comment",caseInsensitive:true}]},{token:"comment",regex:"\\/\\/",next:[o.getTagRule(),{token:"comment",regex:"$|^",next:e||"pop"},{defaultToken:"comment",caseInsensitive:true}]}]}t.JavaScriptHighlightRules=s}));ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],(function(e,t,n){"use strict";var r=e("../range").Range;var o=function(){};(function(){this.checkOutdent=function(e,t){if(!/^\s+$/.test(e))return false;return/^\s*\}/.test(t)};this.autoOutdent=function(e,t){var n=e.getLine(t);var o=n.match(/^(\s*\})/);if(!o)return 0;var a=o[1].length;var i=e.findMatchingBracket({row:t,column:a});if(!i||i.row==t)return 0;var s=this.$getIndent(e.getLine(i.row));e.replace(new r(t,0,t,a-1),s)};this.$getIndent=function(e){return e.match(/^\s*/)[0]}}).call(o.prototype);t.MatchingBraceOutdent=o}));ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],(function(e,t,n){"use strict";var r=e("../../lib/oop");var o=e("../../range").Range;var a=e("./fold_mode").FoldMode;var i=t.FoldMode=function(e){if(e){this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+e.start));this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+e.end))}};r.inherits(i,a);(function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/;this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/;this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/;this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/;this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/;this._getFoldWidgetBase=this.getFoldWidget;this.getFoldWidget=function(e,t,n){var r=e.getLine(n);if(this.singleLineBlockCommentRe.test(r)){if(!this.startRegionRe.test(r)&&!this.tripleStarBlockCommentRe.test(r))return""}var o=this._getFoldWidgetBase(e,t,n);if(!o&&this.startRegionRe.test(r))return"start";return o};this.getFoldWidgetRange=function(e,t,n,r){var o=e.getLine(n);if(this.startRegionRe.test(o))return this.getCommentRegionBlock(e,o,n);var a=o.match(this.foldingStartMarker);if(a){var i=a.index;if(a[1])return this.openingBracketBlock(e,a[1],n,i);var s=e.getCommentFoldRange(n,i+a[0].length,1);if(s&&!s.isMultiLine()){if(r){s=this.getSectionRange(e,n)}else if(t!="all")s=null}return s}if(t==="markbegin")return;var a=o.match(this.foldingStopMarker);if(a){var i=a.index+a[0].length;if(a[1])return this.closingBracketBlock(e,a[1],n,i);return e.getCommentFoldRange(n,i,-1)}};this.getSectionRange=function(e,t){var n=e.getLine(t);var r=n.search(/\S/);var a=t;var i=n.length;t=t+1;var s=t;var l=e.getLength();while(++t<l){n=e.getLine(t);var c=n.search(/\S/);if(c===-1)continue;if(r>c)break;var u=this.getFoldWidgetRange(e,"all",t);if(u){if(u.start.row<=a){break}else if(u.isMultiLine()){t=u.end.row}else if(r==c){break}}s=t}return new o(a,i,s,e.getLine(s).length)};this.getCommentRegionBlock=function(e,t,n){var r=t.search(/\s*$/);var a=e.getLength();var i=n;var s=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/;var l=1;while(++n<a){t=e.getLine(n);var c=s.exec(t);if(!c)continue;if(c[1])l--;else l++;if(!l)break}var u=n;if(u>i){return new o(i,r,u,t.length)}}}).call(i.prototype)}));ace.define("ace/mode/javascript",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/javascript_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle"],(function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("./text").Mode;var a=e("./javascript_highlight_rules").JavaScriptHighlightRules;var i=e("./matching_brace_outdent").MatchingBraceOutdent;var s=e("../worker/worker_client").WorkerClient;var l=e("./behaviour/cstyle").CstyleBehaviour;var c=e("./folding/cstyle").FoldMode;var u=function(){this.HighlightRules=a;this.$outdent=new i;this.$behaviour=new l;this.foldingRules=new c};r.inherits(u,o);(function(){this.lineCommentStart="//";this.blockComment={start:"/*",end:"*/"};this.$quotes={'"':'"',"'":"'","`":"`"};this.getNextLineIndent=function(e,t,n){var r=this.$getIndent(t);var o=this.getTokenizer().getLineTokens(t,e);var a=o.tokens;var i=o.state;if(a.length&&a[a.length-1].type=="comment"){return r}if(e=="start"||e=="no_regex"){var s=t.match(/^.*(?:\bcase\b.*:|[\{\(\[])\s*$/);if(s){r+=n}}else if(e=="doc-start"){if(i=="start"||i=="no_regex"){return""}var s=t.match(/^\s*(\/?)\*/);if(s){if(s[1]){r+=" "}r+="* "}}return r};this.checkOutdent=function(e,t,n){return this.$outdent.checkOutdent(t,n)};this.autoOutdent=function(e,t,n){this.$outdent.autoOutdent(t,n)};this.createWorker=function(e){var t=new s(["ace"],"ace/mode/javascript_worker","JavaScriptWorker");t.attachToDocument(e.getDocument());t.on("annotate",(function(t){e.setAnnotations(t.data)}));t.on("terminate",(function(){e.clearAnnotations()}));return t};this.$id="ace/mode/javascript";this.snippetFileId="ace/snippets/javascript"}).call(u.prototype);t.Mode=u}));ace.define("ace/mode/xml_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],(function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("./text_highlight_rules").TextHighlightRules;var a=function(e){var t="[_:a-zA-ZÀ-￿][-_:.a-zA-Z0-9À-￿]*";this.$rules={start:[{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\[",next:"cdata"},{token:["punctuation.instruction.xml","keyword.instruction.xml"],regex:"(<\\?)("+t+")",next:"processing_instruction"},{token:"comment.start.xml",regex:"<\\!--",next:"comment"},{token:["xml-pe.doctype.xml","xml-pe.doctype.xml"],regex:"(<\\!)(DOCTYPE)(?=[\\s])",next:"doctype",caseInsensitive:true},{include:"tag"},{token:"text.end-tag-open.xml",regex:"</"},{token:"text.tag-open.xml",regex:"<"},{include:"reference"},{defaultToken:"text.xml"}],processing_instruction:[{token:"entity.other.attribute-name.decl-attribute-name.xml",regex:t},{token:"keyword.operator.decl-attribute-equals.xml",regex:"="},{include:"whitespace"},{include:"string"},{token:"punctuation.xml-decl.xml",regex:"\\?>",next:"start"}],doctype:[{include:"whitespace"},{include:"string"},{token:"xml-pe.doctype.xml",regex:">",next:"start"},{token:"xml-pe.xml",regex:"[-_a-zA-Z0-9:]+"},{token:"punctuation.int-subset",regex:"\\[",push:"int_subset"}],int_subset:[{token:"text.xml",regex:"\\s+"},{token:"punctuation.int-subset.xml",regex:"]",next:"pop"},{token:["punctuation.markup-decl.xml","keyword.markup-decl.xml"],regex:"(<\\!)("+t+")",push:[{token:"text",regex:"\\s+"},{token:"punctuation.markup-decl.xml",regex:">",next:"pop"},{include:"string"}]}],cdata:[{token:"string.cdata.xml",regex:"\\]\\]>",next:"start"},{token:"text.xml",regex:"\\s+"},{token:"text.xml",regex:"(?:[^\\]]|\\](?!\\]>))+"}],comment:[{token:"comment.end.xml",regex:"--\x3e",next:"start"},{defaultToken:"comment.xml"}],reference:[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],attr_reference:[{token:"constant.language.escape.reference.attribute-value.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],tag:[{token:["meta.tag.punctuation.tag-open.xml","meta.tag.punctuation.end-tag-open.xml","meta.tag.tag-name.xml"],regex:"(?:(<)|(</))((?:"+t+":)?"+t+")",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]}],tag_whitespace:[{token:"text.tag-whitespace.xml",regex:"\\s+"}],whitespace:[{token:"text.whitespace.xml",regex:"\\s+"}],string:[{token:"string.xml",regex:"'",push:[{token:"string.xml",regex:"'",next:"pop"},{defaultToken:"string.xml"}]},{token:"string.xml",regex:'"',push:[{token:"string.xml",regex:'"',next:"pop"},{defaultToken:"string.xml"}]}],attributes:[{token:"entity.other.attribute-name.xml",regex:t},{token:"keyword.operator.attribute-equals.xml",regex:"="},{include:"tag_whitespace"},{include:"attribute_value"}],attribute_value:[{token:"string.attribute-value.xml",regex:"'",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]}]};if(this.constructor===a)this.normalizeRules()};(function(){this.embedTagRules=function(e,t,n){this.$rules.tag.unshift({token:["meta.tag.punctuation.tag-open.xml","meta.tag."+n+".tag-name.xml"],regex:"(<)("+n+"(?=\\s|>|$))",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:t+"start"}]});this.$rules[n+"-end"]=[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start",onMatch:function(e,t,n){n.splice(0);return this.token}}];this.embedRules(e,t,[{token:["meta.tag.punctuation.end-tag-open.xml","meta.tag."+n+".tag-name.xml"],regex:"(</)("+n+"(?=\\s|>|$))",next:n+"-end"},{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\["},{token:"string.cdata.xml",regex:"\\]\\]>"}])}}).call(o.prototype);r.inherits(a,o);t.XmlHighlightRules=a}));ace.define("ace/mode/behaviour/xml",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],(function(e,t,n){"use strict";var r=e("../../lib/oop");var o=e("../behaviour").Behaviour;var a=e("../../token_iterator").TokenIterator;var i=e("../../lib/lang");function s(e,t){return e&&e.type.lastIndexOf(t+".xml")>-1}var l=function(){this.add("string_dquotes","insertion",(function(e,t,n,r,o){if(o=='"'||o=="'"){var i=o;var l=r.doc.getTextRange(n.getSelectionRange());if(l!==""&&l!=="'"&&l!='"'&&n.getWrapBehavioursEnabled()){return{text:i+l+i,selection:false}}var c=n.getCursorPosition();var u=r.doc.getLine(c.row);var g=u.substring(c.column,c.column+1);var d=new a(r,c.row,c.column);var h=d.getCurrentToken();if(g==i&&(s(h,"attribute-value")||s(h,"string"))){return{text:"",selection:[1,1]}}if(!h)h=d.stepBackward();if(!h)return;while(s(h,"tag-whitespace")||s(h,"whitespace")){h=d.stepBackward()}var p=!g||g.match(/\s/);if(s(h,"attribute-equals")&&(p||g==">")||s(h,"decl-attribute-equals")&&(p||g=="?")){return{text:i+i,selection:[1,1]}}}}));this.add("string_dquotes","deletion",(function(e,t,n,r,o){var a=r.doc.getTextRange(o);if(!o.isMultiLine()&&(a=='"'||a=="'")){var i=r.doc.getLine(o.start.row);var s=i.substring(o.start.column+1,o.start.column+2);if(s==a){o.end.column++;return o}}}));this.add("autoclosing","insertion",(function(e,t,n,r,o){if(o==">"){var i=n.getSelectionRange().start;var l=new a(r,i.row,i.column);var c=l.getCurrentToken()||l.stepBackward();if(!c||!(s(c,"tag-name")||s(c,"tag-whitespace")||s(c,"attribute-name")||s(c,"attribute-equals")||s(c,"attribute-value")))return;if(s(c,"reference.attribute-value"))return;if(s(c,"attribute-value")){var u=l.getCurrentTokenColumn()+c.value.length;if(i.column<u)return;if(i.column==u){var g=l.stepForward();if(g&&s(g,"attribute-value"))return;l.stepBackward()}}if(/^\s*>/.test(r.getLine(i.row).slice(i.column)))return;while(!s(c,"tag-name")){c=l.stepBackward();if(c.value=="<"){c=l.stepForward();break}}var d=l.getCurrentTokenRow();var h=l.getCurrentTokenColumn();if(s(l.stepBackward(),"end-tag-open"))return;var p=c.value;if(d==i.row)p=p.substring(0,i.column-h);if(this.voidElements.hasOwnProperty(p.toLowerCase()))return;return{text:">"+"</"+p+">",selection:[1,1]}}}));this.add("autoindent","insertion",(function(e,t,n,r,o){if(o=="\n"){var i=n.getCursorPosition();var s=r.getLine(i.row);var l=new a(r,i.row,i.column);var c=l.getCurrentToken();if(c&&c.type.indexOf("tag-close")!==-1){if(c.value=="/>")return;while(c&&c.type.indexOf("tag-name")===-1){c=l.stepBackward()}if(!c){return}var u=c.value;var g=l.getCurrentTokenRow();c=l.stepBackward();if(!c||c.type.indexOf("end-tag")!==-1){return}if(this.voidElements&&!this.voidElements[u]){var d=r.getTokenAt(i.row,i.column+1);var s=r.getLine(g);var h=this.$getIndent(s);var p=h+r.getTabString();if(d&&d.value==="</"){return{text:"\n"+p+"\n"+h,selection:[1,p.length,1,p.length]}}else{return{text:"\n"+p}}}}}}))};r.inherits(l,o);t.XmlBehaviour=l}));ace.define("ace/mode/folding/xml",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/range","ace/mode/folding/fold_mode","ace/token_iterator"],(function(e,t,n){"use strict";var r=e("../../lib/oop");var o=e("../../lib/lang");var a=e("../../range").Range;var i=e("./fold_mode").FoldMode;var s=e("../../token_iterator").TokenIterator;var l=t.FoldMode=function(e,t){i.call(this);this.voidElements=e||{};this.optionalEndTags=r.mixin({},this.voidElements);if(t)r.mixin(this.optionalEndTags,t)};r.inherits(l,i);var c=function(){this.tagName="";this.closing=false;this.selfClosing=false;this.start={row:0,column:0};this.end={row:0,column:0}};function u(e,t){return e.type.lastIndexOf(t+".xml")>-1}(function(){this.getFoldWidget=function(e,t,n){var r=this._getFirstTagInLine(e,n);if(!r)return this.getCommentFoldWidget(e,n);if(r.closing||!r.tagName&&r.selfClosing)return t=="markbeginend"?"end":"";if(!r.tagName||r.selfClosing||this.voidElements.hasOwnProperty(r.tagName.toLowerCase()))return"";if(this._findEndTagInLine(e,n,r.tagName,r.end.column))return"";return"start"};this.getCommentFoldWidget=function(e,t){if(/comment/.test(e.getState(t))&&/<!-/.test(e.getLine(t)))return"start";return""};this._getFirstTagInLine=function(e,t){var n=e.getTokens(t);var r=new c;for(var o=0;o<n.length;o++){var a=n[o];if(u(a,"tag-open")){r.end.column=r.start.column+a.value.length;r.closing=u(a,"end-tag-open");a=n[++o];if(!a)return null;r.tagName=a.value;r.end.column+=a.value.length;for(o++;o<n.length;o++){a=n[o];r.end.column+=a.value.length;if(u(a,"tag-close")){r.selfClosing=a.value=="/>";break}}return r}else if(u(a,"tag-close")){r.selfClosing=a.value=="/>";return r}r.start.column+=a.value.length}return null};this._findEndTagInLine=function(e,t,n,r){var o=e.getTokens(t);var a=0;for(var i=0;i<o.length;i++){var s=o[i];a+=s.value.length;if(a<r)continue;if(u(s,"end-tag-open")){s=o[i+1];if(s&&s.value==n)return true}}return false};this._readTagForward=function(e){var t=e.getCurrentToken();if(!t)return null;var n=new c;do{if(u(t,"tag-open")){n.closing=u(t,"end-tag-open");n.start.row=e.getCurrentTokenRow();n.start.column=e.getCurrentTokenColumn()}else if(u(t,"tag-name")){n.tagName=t.value}else if(u(t,"tag-close")){n.selfClosing=t.value=="/>";n.end.row=e.getCurrentTokenRow();n.end.column=e.getCurrentTokenColumn()+t.value.length;e.stepForward();return n}}while(t=e.stepForward());return null};this._readTagBackward=function(e){var t=e.getCurrentToken();if(!t)return null;var n=new c;do{if(u(t,"tag-open")){n.closing=u(t,"end-tag-open");n.start.row=e.getCurrentTokenRow();n.start.column=e.getCurrentTokenColumn();e.stepBackward();return n}else if(u(t,"tag-name")){n.tagName=t.value}else if(u(t,"tag-close")){n.selfClosing=t.value=="/>";n.end.row=e.getCurrentTokenRow();n.end.column=e.getCurrentTokenColumn()+t.value.length}}while(t=e.stepBackward());return null};this._pop=function(e,t){while(e.length){var n=e[e.length-1];if(!t||n.tagName==t.tagName){return e.pop()}else if(this.optionalEndTags.hasOwnProperty(n.tagName)){e.pop();continue}else{return null}}};this.getFoldWidgetRange=function(e,t,n){var r=this._getFirstTagInLine(e,n);if(!r){return this.getCommentFoldWidget(e,n)&&e.getCommentFoldRange(n,e.getLine(n).length)}var o=r.closing||r.selfClosing;var i=[];var l;if(!o){var c=new s(e,n,r.start.column);var u={row:n,column:r.start.column+r.tagName.length+2};if(r.start.row==r.end.row)u.column=r.end.column;while(l=this._readTagForward(c)){if(l.selfClosing){if(!i.length){l.start.column+=l.tagName.length+2;l.end.column-=2;return a.fromPoints(l.start,l.end)}else continue}if(l.closing){this._pop(i,l);if(i.length==0)return a.fromPoints(u,l.start)}else{i.push(l)}}}else{var c=new s(e,n,r.end.column);var g={row:n,column:r.start.column};while(l=this._readTagBackward(c)){if(l.selfClosing){if(!i.length){l.start.column+=l.tagName.length+2;l.end.column-=2;return a.fromPoints(l.start,l.end)}else continue}if(!l.closing){this._pop(i,l);if(i.length==0){l.start.column+=l.tagName.length+2;if(l.start.row==l.end.row&&l.start.column<l.end.column)l.start.column=l.end.column;return a.fromPoints(l.start,g)}}else{i.push(l)}}}}}).call(l.prototype)}));ace.define("ace/mode/xml",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text","ace/mode/xml_highlight_rules","ace/mode/behaviour/xml","ace/mode/folding/xml","ace/worker/worker_client"],(function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("../lib/lang");var a=e("./text").Mode;var i=e("./xml_highlight_rules").XmlHighlightRules;var s=e("./behaviour/xml").XmlBehaviour;var l=e("./folding/xml").FoldMode;var c=e("../worker/worker_client").WorkerClient;var u=function(){this.HighlightRules=i;this.$behaviour=new s;this.foldingRules=new l};r.inherits(u,a);(function(){this.voidElements=o.arrayToMap([]);this.blockComment={start:"\x3c!--",end:"--\x3e"};this.createWorker=function(e){var t=new c(["ace"],"ace/mode/xml_worker","Worker");t.attachToDocument(e.getDocument());t.on("error",(function(t){e.setAnnotations(t.data)}));t.on("terminate",(function(){e.clearAnnotations()}));return t};this.$id="ace/mode/xml"}).call(u.prototype);t.Mode=u}));ace.define("ace/mode/css_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules"],(function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("../lib/lang");var a=e("./text_highlight_rules").TextHighlightRules;var i=t.supportType="align-content|align-items|align-self|all|animation|animation-delay|animation-direction|animation-duration|animation-fill-mode|animation-iteration-count|animation-name|animation-play-state|animation-timing-function|backface-visibility|background|background-attachment|background-blend-mode|background-clip|background-color|background-image|background-origin|background-position|background-repeat|background-size|border|border-bottom|border-bottom-color|border-bottom-left-radius|border-bottom-right-radius|border-bottom-style|border-bottom-width|border-collapse|border-color|border-image|border-image-outset|border-image-repeat|border-image-slice|border-image-source|border-image-width|border-left|border-left-color|border-left-style|border-left-width|border-radius|border-right|border-right-color|border-right-style|border-right-width|border-spacing|border-style|border-top|border-top-color|border-top-left-radius|border-top-right-radius|border-top-style|border-top-width|border-width|bottom|box-shadow|box-sizing|caption-side|clear|clip|color|column-count|column-fill|column-gap|column-rule|column-rule-color|column-rule-style|column-rule-width|column-span|column-width|columns|content|counter-increment|counter-reset|cursor|direction|display|empty-cells|filter|flex|flex-basis|flex-direction|flex-flow|flex-grow|flex-shrink|flex-wrap|float|font|font-family|font-size|font-size-adjust|font-stretch|font-style|font-variant|font-weight|hanging-punctuation|height|justify-content|left|letter-spacing|line-height|list-style|list-style-image|list-style-position|list-style-type|margin|margin-bottom|margin-left|margin-right|margin-top|max-height|max-width|max-zoom|min-height|min-width|min-zoom|nav-down|nav-index|nav-left|nav-right|nav-up|opacity|order|outline|outline-color|outline-offset|outline-style|outline-width|overflow|overflow-x|overflow-y|padding|padding-bottom|padding-left|padding-right|padding-top|page-break-after|page-break-before|page-break-inside|perspective|perspective-origin|position|quotes|resize|right|tab-size|table-layout|text-align|text-align-last|text-decoration|text-decoration-color|text-decoration-line|text-decoration-style|text-indent|text-justify|text-overflow|text-shadow|text-transform|top|transform|transform-origin|transform-style|transition|transition-delay|transition-duration|transition-property|transition-timing-function|unicode-bidi|user-select|user-zoom|vertical-align|visibility|white-space|width|word-break|word-spacing|word-wrap|z-index";var s=t.supportFunction="rgb|rgba|url|attr|counter|counters";var l=t.supportConstant="absolute|after-edge|after|all-scroll|all|alphabetic|always|antialiased|armenian|auto|avoid-column|avoid-page|avoid|balance|baseline|before-edge|before|below|bidi-override|block-line-height|block|bold|bolder|border-box|both|bottom|box|break-all|break-word|capitalize|caps-height|caption|center|central|char|circle|cjk-ideographic|clone|close-quote|col-resize|collapse|column|consider-shifts|contain|content-box|cover|crosshair|cubic-bezier|dashed|decimal-leading-zero|decimal|default|disabled|disc|disregard-shifts|distribute-all-lines|distribute-letter|distribute-space|distribute|dotted|double|e-resize|ease-in|ease-in-out|ease-out|ease|ellipsis|end|exclude-ruby|fill|fixed|georgian|glyphs|grid-height|groove|hand|hanging|hebrew|help|hidden|hiragana-iroha|hiragana|horizontal|icon|ideograph-alpha|ideograph-numeric|ideograph-parenthesis|ideograph-space|ideographic|inactive|include-ruby|inherit|initial|inline-block|inline-box|inline-line-height|inline-table|inline|inset|inside|inter-ideograph|inter-word|invert|italic|justify|katakana-iroha|katakana|keep-all|last|left|lighter|line-edge|line-through|line|linear|list-item|local|loose|lower-alpha|lower-greek|lower-latin|lower-roman|lowercase|lr-tb|ltr|mathematical|max-height|max-size|medium|menu|message-box|middle|move|n-resize|ne-resize|newspaper|no-change|no-close-quote|no-drop|no-open-quote|no-repeat|none|normal|not-allowed|nowrap|nw-resize|oblique|open-quote|outset|outside|overline|padding-box|page|pointer|pre-line|pre-wrap|pre|preserve-3d|progress|relative|repeat-x|repeat-y|repeat|replaced|reset-size|ridge|right|round|row-resize|rtl|s-resize|scroll|se-resize|separate|slice|small-caps|small-caption|solid|space|square|start|static|status-bar|step-end|step-start|steps|stretch|strict|sub|super|sw-resize|table-caption|table-cell|table-column-group|table-column|table-footer-group|table-header-group|table-row-group|table-row|table|tb-rl|text-after-edge|text-before-edge|text-bottom|text-size|text-top|text|thick|thin|transparent|underline|upper-alpha|upper-latin|upper-roman|uppercase|use-script|vertical-ideographic|vertical-text|visible|w-resize|wait|whitespace|z-index|zero|zoom";var c=t.supportConstantColor="aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkgrey|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkslategrey|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dimgrey|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|grey|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgray|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightslategrey|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|rebeccapurple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|slategrey|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|violet|wheat|white|whitesmoke|yellow|yellowgreen";var u=t.supportConstantFonts="arial|century|comic|courier|cursive|fantasy|garamond|georgia|helvetica|impact|lucida|symbol|system|tahoma|times|trebuchet|utopia|verdana|webdings|sans-serif|serif|monospace";var g=t.numRe="\\-?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))";var d=t.pseudoElements="(\\:+)\\b(after|before|first-letter|first-line|moz-selection|selection)\\b";var h=t.pseudoClasses="(:)\\b(active|checked|disabled|empty|enabled|first-child|first-of-type|focus|hover|indeterminate|invalid|last-child|last-of-type|link|not|nth-child|nth-last-child|nth-last-of-type|nth-of-type|only-child|only-of-type|required|root|target|valid|visited)\\b";var p=function(){var e=this.createKeywordMapper({"support.function":s,"support.constant":l,"support.type":i,"support.constant.color":c,"support.constant.fonts":u},"text",true);this.$rules={start:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"ruleset"},{token:"paren.rparen",regex:"\\}"},{token:"string",regex:"@(?!viewport)",next:"media"},{token:"keyword",regex:"#[a-z0-9-_]+"},{token:"keyword",regex:"%"},{token:"variable",regex:"\\.[a-z0-9-_]+"},{token:"string",regex:":[a-z0-9-_]+"},{token:"constant.numeric",regex:g},{token:"constant",regex:"[a-z0-9-_]+"},{caseInsensitive:true}],media:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"start"},{token:"paren.rparen",regex:"\\}",next:"start"},{token:"string",regex:";",next:"start"},{token:"keyword",regex:"(?:media|supports|document|charset|import|namespace|media|supports|document"+"|page|font|keyframes|viewport|counter-style|font-feature-values"+"|swash|ornaments|annotation|stylistic|styleset|character-variant)"}],comments:[{token:"comment",regex:"\\/\\*",push:[{token:"comment",regex:"\\*\\/",next:"pop"},{defaultToken:"comment"}]}],ruleset:[{regex:"-(webkit|ms|moz|o)-",token:"text"},{token:"punctuation.operator",regex:"[:;]"},{token:"paren.rparen",regex:"\\}",next:"start"},{include:["strings","url","comments"]},{token:["constant.numeric","keyword"],regex:"("+g+")(ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vmax|vmin|vm|vw|%)"},{token:"constant.numeric",regex:g},{token:"constant.numeric",regex:"#[a-f0-9]{6}"},{token:"constant.numeric",regex:"#[a-f0-9]{3}"},{token:["punctuation","entity.other.attribute-name.pseudo-element.css"],regex:d},{token:["punctuation","entity.other.attribute-name.pseudo-class.css"],regex:h},{include:"url"},{token:e,regex:"\\-?[a-zA-Z_][a-zA-Z0-9_\\-]*"},{caseInsensitive:true}],url:[{token:"support.function",regex:"(?:url(:?-prefix)?|domain|regexp)\\(",push:[{token:"support.function",regex:"\\)",next:"pop"},{defaultToken:"string"}]}],strings:[{token:"string.start",regex:"'",push:[{token:"string.end",regex:"'|$",next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:true},{defaultToken:"string"}]},{token:"string.start",regex:'"',push:[{token:"string.end",regex:'"|$',next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:true},{defaultToken:"string"}]}],escapes:[{token:"constant.language.escape",regex:/\\([a-fA-F\d]{1,6}|[^a-fA-F\d])/}]};this.normalizeRules()};r.inherits(p,a);t.CssHighlightRules=p}));ace.define("ace/mode/css_completions",["require","exports","module"],(function(e,t,n){"use strict";var r={background:{"#$0":1},"background-color":{"#$0":1,transparent:1,fixed:1},"background-image":{"url('/$0')":1},"background-repeat":{repeat:1,"repeat-x":1,"repeat-y":1,"no-repeat":1,inherit:1},"background-position":{bottom:2,center:2,left:2,right:2,top:2,inherit:2},"background-attachment":{scroll:1,fixed:1},"background-size":{cover:1,contain:1},"background-clip":{"border-box":1,"padding-box":1,"content-box":1},"background-origin":{"border-box":1,"padding-box":1,"content-box":1},border:{"solid $0":1,"dashed $0":1,"dotted $0":1,"#$0":1},"border-color":{"#$0":1},"border-style":{solid:2,dashed:2,dotted:2,double:2,groove:2,hidden:2,inherit:2,inset:2,none:2,outset:2,ridged:2},"border-collapse":{collapse:1,separate:1},bottom:{px:1,em:1,"%":1},clear:{left:1,right:1,both:1,none:1},color:{"#$0":1,"rgb(#$00,0,0)":1},cursor:{default:1,pointer:1,move:1,text:1,wait:1,help:1,progress:1,"n-resize":1,"ne-resize":1,"e-resize":1,"se-resize":1,"s-resize":1,"sw-resize":1,"w-resize":1,"nw-resize":1},display:{none:1,block:1,inline:1,"inline-block":1,"table-cell":1},"empty-cells":{show:1,hide:1},float:{left:1,right:1,none:1},"font-family":{Arial:2,"Comic Sans MS":2,Consolas:2,"Courier New":2,Courier:2,Georgia:2,Monospace:2,"Sans-Serif":2,"Segoe UI":2,Tahoma:2,"Times New Roman":2,"Trebuchet MS":2,Verdana:1},"font-size":{px:1,em:1,"%":1},"font-weight":{bold:1,normal:1},"font-style":{italic:1,normal:1},"font-variant":{normal:1,"small-caps":1},height:{px:1,em:1,"%":1},left:{px:1,em:1,"%":1},"letter-spacing":{normal:1},"line-height":{normal:1},"list-style-type":{none:1,disc:1,circle:1,square:1,decimal:1,"decimal-leading-zero":1,"lower-roman":1,"upper-roman":1,"lower-greek":1,"lower-latin":1,"upper-latin":1,georgian:1,"lower-alpha":1,"upper-alpha":1},margin:{px:1,em:1,"%":1},"margin-right":{px:1,em:1,"%":1},"margin-left":{px:1,em:1,"%":1},"margin-top":{px:1,em:1,"%":1},"margin-bottom":{px:1,em:1,"%":1},"max-height":{px:1,em:1,"%":1},"max-width":{px:1,em:1,"%":1},"min-height":{px:1,em:1,"%":1},"min-width":{px:1,em:1,"%":1},overflow:{hidden:1,visible:1,auto:1,scroll:1},"overflow-x":{hidden:1,visible:1,auto:1,scroll:1},"overflow-y":{hidden:1,visible:1,auto:1,scroll:1},padding:{px:1,em:1,"%":1},"padding-top":{px:1,em:1,"%":1},"padding-right":{px:1,em:1,"%":1},"padding-bottom":{px:1,em:1,"%":1},"padding-left":{px:1,em:1,"%":1},"page-break-after":{auto:1,always:1,avoid:1,left:1,right:1},"page-break-before":{auto:1,always:1,avoid:1,left:1,right:1},position:{absolute:1,relative:1,fixed:1,static:1},right:{px:1,em:1,"%":1},"table-layout":{fixed:1,auto:1},"text-decoration":{none:1,underline:1,"line-through":1,blink:1},"text-align":{left:1,right:1,center:1,justify:1},"text-transform":{capitalize:1,uppercase:1,lowercase:1,none:1},top:{px:1,em:1,"%":1},"vertical-align":{top:1,bottom:1},visibility:{hidden:1,visible:1},"white-space":{nowrap:1,normal:1,pre:1,"pre-line":1,"pre-wrap":1},width:{px:1,em:1,"%":1},"word-spacing":{normal:1},filter:{"alpha(opacity=$0100)":1},"text-shadow":{"$02px 2px 2px #777":1},"text-overflow":{"ellipsis-word":1,clip:1,ellipsis:1},"-moz-border-radius":1,"-moz-border-radius-topright":1,"-moz-border-radius-bottomright":1,"-moz-border-radius-topleft":1,"-moz-border-radius-bottomleft":1,"-webkit-border-radius":1,"-webkit-border-top-right-radius":1,"-webkit-border-top-left-radius":1,"-webkit-border-bottom-right-radius":1,"-webkit-border-bottom-left-radius":1,"-moz-box-shadow":1,"-webkit-box-shadow":1,transform:{"rotate($00deg)":1,"skew($00deg)":1},"-moz-transform":{"rotate($00deg)":1,"skew($00deg)":1},"-webkit-transform":{"rotate($00deg)":1,"skew($00deg)":1}};var o=function(){};(function(){this.completionsDefined=false;this.defineCompletions=function(){if(document){var e=document.createElement("c").style;for(var t in e){if(typeof e[t]!=="string")continue;var n=t.replace(/[A-Z]/g,(function(e){return"-"+e.toLowerCase()}));if(!r.hasOwnProperty(n))r[n]=1}}this.completionsDefined=true};this.getCompletions=function(e,t,n,r){if(!this.completionsDefined){this.defineCompletions()}if(e==="ruleset"||t.$mode.$id=="ace/mode/scss"){var o=t.getLine(n.row).substr(0,n.column);if(/:[^;]+$/.test(o)){/([\w\-]+):[^:]*$/.test(o);return this.getPropertyValueCompletions(e,t,n,r)}else{return this.getPropertyCompletions(e,t,n,r)}}return[]};this.getPropertyCompletions=function(e,t,n,o){var a=Object.keys(r);return a.map((function(e){return{caption:e,snippet:e+": $0;",meta:"property",score:1e6}}))};this.getPropertyValueCompletions=function(e,t,n,o){var a=t.getLine(n.row).substr(0,n.column);var i=(/([\w\-]+):[^:]*$/.exec(a)||{})[1];if(!i)return[];var s=[];if(i in r&&typeof r[i]==="object"){s=Object.keys(r[i])}return s.map((function(e){return{caption:e,snippet:e,meta:"property value",score:1e6}}))}}).call(o.prototype);t.CssCompletions=o}));ace.define("ace/mode/behaviour/css",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/mode/behaviour/cstyle","ace/token_iterator"],(function(e,t,n){"use strict";var r=e("../../lib/oop");var o=e("../behaviour").Behaviour;var a=e("./cstyle").CstyleBehaviour;var i=e("../../token_iterator").TokenIterator;var s=function(){this.inherit(a);this.add("colon","insertion",(function(e,t,n,r,o){if(o===":"&&n.selection.isEmpty()){var a=n.getCursorPosition();var s=new i(r,a.row,a.column);var l=s.getCurrentToken();if(l&&l.value.match(/\s+/)){l=s.stepBackward()}if(l&&l.type==="support.type"){var c=r.doc.getLine(a.row);var u=c.substring(a.column,a.column+1);if(u===":"){return{text:"",selection:[1,1]}}if(/^(\s+[^;]|\s*$)/.test(c.substring(a.column))){return{text:":;",selection:[1,1]}}}}}));this.add("colon","deletion",(function(e,t,n,r,o){var a=r.doc.getTextRange(o);if(!o.isMultiLine()&&a===":"){var s=n.getCursorPosition();var l=new i(r,s.row,s.column);var c=l.getCurrentToken();if(c&&c.value.match(/\s+/)){c=l.stepBackward()}if(c&&c.type==="support.type"){var u=r.doc.getLine(o.start.row);var g=u.substring(o.end.column,o.end.column+1);if(g===";"){o.end.column++;return o}}}}));this.add("semicolon","insertion",(function(e,t,n,r,o){if(o===";"&&n.selection.isEmpty()){var a=n.getCursorPosition();var i=r.doc.getLine(a.row);var s=i.substring(a.column,a.column+1);if(s===";"){return{text:"",selection:[1,1]}}}}));this.add("!important","insertion",(function(e,t,n,r,o){if(o==="!"&&n.selection.isEmpty()){var a=n.getCursorPosition();var i=r.doc.getLine(a.row);if(/^\s*(;|}|$)/.test(i.substring(a.column))){return{text:"!important",selection:[10,10]}}}}))};r.inherits(s,a);t.CssBehaviour=s}));ace.define("ace/mode/css",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/css_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/css_completions","ace/mode/behaviour/css","ace/mode/folding/cstyle"],(function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("./text").Mode;var a=e("./css_highlight_rules").CssHighlightRules;var i=e("./matching_brace_outdent").MatchingBraceOutdent;var s=e("../worker/worker_client").WorkerClient;var l=e("./css_completions").CssCompletions;var c=e("./behaviour/css").CssBehaviour;var u=e("./folding/cstyle").FoldMode;var g=function(){this.HighlightRules=a;this.$outdent=new i;this.$behaviour=new c;this.$completer=new l;this.foldingRules=new u};r.inherits(g,o);(function(){this.foldingRules="cStyle";this.blockComment={start:"/*",end:"*/"};this.getNextLineIndent=function(e,t,n){var r=this.$getIndent(t);var o=this.getTokenizer().getLineTokens(t,e).tokens;if(o.length&&o[o.length-1].type=="comment"){return r}var a=t.match(/^.*\{\s*$/);if(a){r+=n}return r};this.checkOutdent=function(e,t,n){return this.$outdent.checkOutdent(t,n)};this.autoOutdent=function(e,t,n){this.$outdent.autoOutdent(t,n)};this.getCompletions=function(e,t,n,r){return this.$completer.getCompletions(e,t,n,r)};this.createWorker=function(e){var t=new s(["ace"],"ace/mode/css_worker","Worker");t.attachToDocument(e.getDocument());t.on("annotate",(function(t){e.setAnnotations(t.data)}));t.on("terminate",(function(){e.clearAnnotations()}));return t};this.$id="ace/mode/css";this.snippetFileId="ace/snippets/css"}).call(g.prototype);t.Mode=g}));ace.define("ace/mode/html_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/css_highlight_rules","ace/mode/javascript_highlight_rules","ace/mode/xml_highlight_rules"],(function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("../lib/lang");var a=e("./css_highlight_rules").CssHighlightRules;var i=e("./javascript_highlight_rules").JavaScriptHighlightRules;var s=e("./xml_highlight_rules").XmlHighlightRules;var l=o.createMap({a:"anchor",button:"form",form:"form",img:"image",input:"form",label:"form",option:"form",script:"script",select:"form",textarea:"form",style:"style",table:"table",tbody:"table",td:"table",tfoot:"table",th:"table",tr:"table"});var c=function(){s.call(this);this.addRules({attributes:[{include:"tag_whitespace"},{token:"entity.other.attribute-name.xml",regex:"[-_a-zA-Z0-9:.]+"},{token:"keyword.operator.attribute-equals.xml",regex:"=",push:[{include:"tag_whitespace"},{token:"string.unquoted.attribute-value.html",regex:"[^<>='\"`\\s]+",next:"pop"},{token:"empty",regex:"",next:"pop"}]},{include:"attribute_value"}],tag:[{token:function(e,t){var n=l[t];return["meta.tag.punctuation."+(e=="<"?"":"end-")+"tag-open.xml","meta.tag"+(n?"."+n:"")+".tag-name.xml"]},regex:"(</?)([-_a-zA-Z0-9:.]+)",next:"tag_stuff"}],tag_stuff:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]});this.embedTagRules(a,"css-","style");this.embedTagRules(new i({jsx:false}).getRules(),"js-","script");if(this.constructor===c)this.normalizeRules()};r.inherits(c,s);t.HtmlHighlightRules=c}));ace.define("ace/mode/folding/mixed",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode"],(function(e,t,n){"use strict";var r=e("../../lib/oop");var o=e("./fold_mode").FoldMode;var a=t.FoldMode=function(e,t){this.defaultMode=e;this.subModes=t};r.inherits(a,o);(function(){this.$getMode=function(e){if(typeof e!="string")e=e[0];for(var t in this.subModes){if(e.indexOf(t)===0)return this.subModes[t]}return null};this.$tryMode=function(e,t,n,r){var o=this.$getMode(e);return o?o.getFoldWidget(t,n,r):""};this.getFoldWidget=function(e,t,n){return this.$tryMode(e.getState(n-1),e,t,n)||this.$tryMode(e.getState(n),e,t,n)||this.defaultMode.getFoldWidget(e,t,n)};this.getFoldWidgetRange=function(e,t,n){var r=this.$getMode(e.getState(n-1));if(!r||!r.getFoldWidget(e,t,n))r=this.$getMode(e.getState(n));if(!r||!r.getFoldWidget(e,t,n))r=this.defaultMode;return r.getFoldWidgetRange(e,t,n)}}).call(a.prototype)}));ace.define("ace/mode/folding/html",["require","exports","module","ace/lib/oop","ace/mode/folding/mixed","ace/mode/folding/xml","ace/mode/folding/cstyle"],(function(e,t,n){"use strict";var r=e("../../lib/oop");var o=e("./mixed").FoldMode;var a=e("./xml").FoldMode;var i=e("./cstyle").FoldMode;var s=t.FoldMode=function(e,t){o.call(this,new a(e,t),{"js-":new i,"css-":new i})};r.inherits(s,o)}));ace.define("ace/mode/html_completions",["require","exports","module","ace/token_iterator"],(function(e,t,n){"use strict";var r=e("../token_iterator").TokenIterator;var o=["accesskey","class","contenteditable","contextmenu","dir","draggable","dropzone","hidden","id","inert","itemid","itemprop","itemref","itemscope","itemtype","lang","spellcheck","style","tabindex","title","translate"];var a=["onabort","onblur","oncancel","oncanplay","oncanplaythrough","onchange","onclick","onclose","oncontextmenu","oncuechange","ondblclick","ondrag","ondragend","ondragenter","ondragleave","ondragover","ondragstart","ondrop","ondurationchange","onemptied","onended","onerror","onfocus","oninput","oninvalid","onkeydown","onkeypress","onkeyup","onload","onloadeddata","onloadedmetadata","onloadstart","onmousedown","onmousemove","onmouseout","onmouseover","onmouseup","onmousewheel","onpause","onplay","onplaying","onprogress","onratechange","onreset","onscroll","onseeked","onseeking","onselect","onshow","onstalled","onsubmit","onsuspend","ontimeupdate","onvolumechange","onwaiting"];var i=o.concat(a);var s={a:{href:1,target:{_blank:1,top:1},ping:1,rel:{nofollow:1,alternate:1,author:1,bookmark:1,help:1,license:1,next:1,noreferrer:1,prefetch:1,prev:1,search:1,tag:1},media:1,hreflang:1,type:1},abbr:{},address:{},area:{shape:1,coords:1,href:1,hreflang:1,alt:1,target:1,media:1,rel:1,ping:1,type:1},article:{pubdate:1},aside:{},audio:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},muted:{muted:1},preload:{auto:1,metadata:1,none:1}},b:{},base:{href:1,target:1},bdi:{},bdo:{},blockquote:{cite:1},body:{onafterprint:1,onbeforeprint:1,onbeforeunload:1,onhashchange:1,onmessage:1,onoffline:1,onpopstate:1,onredo:1,onresize:1,onstorage:1,onundo:1,onunload:1},br:{},button:{autofocus:1,disabled:{disabled:1},form:1,formaction:1,formenctype:1,formmethod:1,formnovalidate:1,formtarget:1,name:1,value:1,type:{button:1,submit:1}},canvas:{width:1,height:1},caption:{},cite:{},code:{},col:{span:1},colgroup:{span:1},command:{type:1,label:1,icon:1,disabled:1,checked:1,radiogroup:1,command:1},data:{},datalist:{},dd:{},del:{cite:1,datetime:1},details:{open:1},dfn:{},dialog:{open:1},div:{},dl:{},dt:{},em:{},embed:{src:1,height:1,width:1,type:1},fieldset:{disabled:1,form:1,name:1},figcaption:{},figure:{},footer:{},form:{"accept-charset":1,action:1,autocomplete:1,enctype:{"multipart/form-data":1,"application/x-www-form-urlencoded":1},method:{get:1,post:1},name:1,novalidate:1,target:{_blank:1,top:1}},h1:{},h2:{},h3:{},h4:{},h5:{},h6:{},head:{},header:{},hr:{},html:{manifest:1},i:{},iframe:{name:1,src:1,height:1,width:1,sandbox:{"allow-same-origin":1,"allow-top-navigation":1,"allow-forms":1,"allow-scripts":1},seamless:{seamless:1}},img:{alt:1,src:1,height:1,width:1,usemap:1,ismap:1},input:{type:{text:1,password:1,hidden:1,checkbox:1,submit:1,radio:1,file:1,button:1,reset:1,image:31,color:1,date:1,datetime:1,"datetime-local":1,email:1,month:1,number:1,range:1,search:1,tel:1,time:1,url:1,week:1},accept:1,alt:1,autocomplete:{on:1,off:1},autofocus:{autofocus:1},checked:{checked:1},disabled:{disabled:1},form:1,formaction:1,formenctype:{"application/x-www-form-urlencoded":1,"multipart/form-data":1,"text/plain":1},formmethod:{get:1,post:1},formnovalidate:{formnovalidate:1},formtarget:{_blank:1,_self:1,_parent:1,_top:1},height:1,list:1,max:1,maxlength:1,min:1,multiple:{multiple:1},name:1,pattern:1,placeholder:1,readonly:{readonly:1},required:{required:1},size:1,src:1,step:1,width:1,files:1,value:1},ins:{cite:1,datetime:1},kbd:{},keygen:{autofocus:1,challenge:{challenge:1},disabled:{disabled:1},form:1,keytype:{rsa:1,dsa:1,ec:1},name:1},label:{form:1,for:1},legend:{},li:{value:1},link:{href:1,hreflang:1,rel:{stylesheet:1,icon:1},media:{all:1,screen:1,print:1},type:{"text/css":1,"image/png":1,"image/jpeg":1,"image/gif":1},sizes:1},main:{},map:{name:1},mark:{},math:{},menu:{type:1,label:1},meta:{"http-equiv":{"content-type":1},name:{description:1,keywords:1},content:{"text/html; charset=UTF-8":1},charset:1},meter:{value:1,min:1,max:1,low:1,high:1,optimum:1},nav:{},noscript:{href:1},object:{param:1,data:1,type:1,height:1,width:1,usemap:1,name:1,form:1,classid:1},ol:{start:1,reversed:1},optgroup:{disabled:1,label:1},option:{disabled:1,selected:1,label:1,value:1},output:{for:1,form:1,name:1},p:{},param:{name:1,value:1},pre:{},progress:{value:1,max:1},q:{cite:1},rp:{},rt:{},ruby:{},s:{},samp:{},script:{charset:1,type:{"text/javascript":1},src:1,defer:1,async:1},select:{autofocus:1,disabled:1,form:1,multiple:{multiple:1},name:1,size:1,readonly:{readonly:1}},small:{},source:{src:1,type:1,media:1},span:{},strong:{},style:{type:1,media:{all:1,screen:1,print:1},scoped:1},sub:{},sup:{},svg:{},table:{summary:1},tbody:{},td:{headers:1,rowspan:1,colspan:1},textarea:{autofocus:{autofocus:1},disabled:{disabled:1},form:1,maxlength:1,name:1,placeholder:1,readonly:{readonly:1},required:{required:1},rows:1,cols:1,wrap:{on:1,off:1,hard:1,soft:1}},tfoot:{},th:{headers:1,rowspan:1,colspan:1,scope:1},thead:{},time:{datetime:1},title:{},tr:{},track:{kind:1,src:1,srclang:1,label:1,default:1},section:{},summary:{},u:{},ul:{},var:{},video:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},width:1,height:1,poster:1,muted:{muted:1},preload:{auto:1,metadata:1,none:1}},wbr:{}};var l=Object.keys(s);function c(e,t){return e.type.lastIndexOf(t+".xml")>-1}function u(e,t){var n=new r(e,t.row,t.column);var o=n.getCurrentToken();while(o&&!c(o,"tag-name")){o=n.stepBackward()}if(o)return o.value}function g(e,t){var n=new r(e,t.row,t.column);var o=n.getCurrentToken();while(o&&!c(o,"attribute-name")){o=n.stepBackward()}if(o)return o.value}var d=function(){};(function(){this.getCompletions=function(e,t,n,r){var o=t.getTokenAt(n.row,n.column);if(!o)return[];if(c(o,"tag-name")||c(o,"tag-open")||c(o,"end-tag-open"))return this.getTagCompletions(e,t,n,r);if(c(o,"tag-whitespace")||c(o,"attribute-name"))return this.getAttributeCompletions(e,t,n,r);if(c(o,"attribute-value"))return this.getAttributeValueCompletions(e,t,n,r);var a=t.getLine(n.row).substr(0,n.column);if(/&[a-z]*$/i.test(a))return this.getHTMLEntityCompletions(e,t,n,r);return[]};this.getTagCompletions=function(e,t,n,r){return l.map((function(e){return{value:e,meta:"tag",score:1e6}}))};this.getAttributeCompletions=function(e,t,n,r){var o=u(t,n);if(!o)return[];var a=i;if(o in s){a=a.concat(Object.keys(s[o]))}return a.map((function(e){return{caption:e,snippet:e+'="$0"',meta:"attribute",score:1e6}}))};this.getAttributeValueCompletions=function(e,t,n,r){var o=u(t,n);var a=g(t,n);if(!o)return[];var i=[];if(o in s&&a in s[o]&&typeof s[o][a]==="object"){i=Object.keys(s[o][a])}return i.map((function(e){return{caption:e,snippet:e,meta:"attribute value",score:1e6}}))};this.getHTMLEntityCompletions=function(e,t,n,r){var o=["Aacute;","aacute;","Acirc;","acirc;","acute;","AElig;","aelig;","Agrave;","agrave;","alefsym;","Alpha;","alpha;","amp;","and;","ang;","Aring;","aring;","asymp;","Atilde;","atilde;","Auml;","auml;","bdquo;","Beta;","beta;","brvbar;","bull;","cap;","Ccedil;","ccedil;","cedil;","cent;","Chi;","chi;","circ;","clubs;","cong;","copy;","crarr;","cup;","curren;","Dagger;","dagger;","dArr;","darr;","deg;","Delta;","delta;","diams;","divide;","Eacute;","eacute;","Ecirc;","ecirc;","Egrave;","egrave;","empty;","emsp;","ensp;","Epsilon;","epsilon;","equiv;","Eta;","eta;","ETH;","eth;","Euml;","euml;","euro;","exist;","fnof;","forall;","frac12;","frac14;","frac34;","frasl;","Gamma;","gamma;","ge;","gt;","hArr;","harr;","hearts;","hellip;","Iacute;","iacute;","Icirc;","icirc;","iexcl;","Igrave;","igrave;","image;","infin;","int;","Iota;","iota;","iquest;","isin;","Iuml;","iuml;","Kappa;","kappa;","Lambda;","lambda;","lang;","laquo;","lArr;","larr;","lceil;","ldquo;","le;","lfloor;","lowast;","loz;","lrm;","lsaquo;","lsquo;","lt;","macr;","mdash;","micro;","middot;","minus;","Mu;","mu;","nabla;","nbsp;","ndash;","ne;","ni;","not;","notin;","nsub;","Ntilde;","ntilde;","Nu;","nu;","Oacute;","oacute;","Ocirc;","ocirc;","OElig;","oelig;","Ograve;","ograve;","oline;","Omega;","omega;","Omicron;","omicron;","oplus;","or;","ordf;","ordm;","Oslash;","oslash;","Otilde;","otilde;","otimes;","Ouml;","ouml;","para;","part;","permil;","perp;","Phi;","phi;","Pi;","pi;","piv;","plusmn;","pound;","Prime;","prime;","prod;","prop;","Psi;","psi;","quot;","radic;","rang;","raquo;","rArr;","rarr;","rceil;","rdquo;","real;","reg;","rfloor;","Rho;","rho;","rlm;","rsaquo;","rsquo;","sbquo;","Scaron;","scaron;","sdot;","sect;","shy;","Sigma;","sigma;","sigmaf;","sim;","spades;","sub;","sube;","sum;","sup;","sup1;","sup2;","sup3;","supe;","szlig;","Tau;","tau;","there4;","Theta;","theta;","thetasym;","thinsp;","THORN;","thorn;","tilde;","times;","trade;","Uacute;","uacute;","uArr;","uarr;","Ucirc;","ucirc;","Ugrave;","ugrave;","uml;","upsih;","Upsilon;","upsilon;","Uuml;","uuml;","weierp;","Xi;","xi;","Yacute;","yacute;","yen;","Yuml;","yuml;","Zeta;","zeta;","zwj;","zwnj;"];return o.map((function(e){return{caption:e,snippet:e,meta:"html entity",score:1e6}}))}}).call(d.prototype);t.HtmlCompletions=d}));ace.define("ace/mode/html",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text","ace/mode/javascript","ace/mode/css","ace/mode/html_highlight_rules","ace/mode/behaviour/xml","ace/mode/folding/html","ace/mode/html_completions","ace/worker/worker_client"],(function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("../lib/lang");var a=e("./text").Mode;var i=e("./javascript").Mode;var s=e("./css").Mode;var l=e("./html_highlight_rules").HtmlHighlightRules;var c=e("./behaviour/xml").XmlBehaviour;var u=e("./folding/html").FoldMode;var g=e("./html_completions").HtmlCompletions;var d=e("../worker/worker_client").WorkerClient;var h=["area","base","br","col","embed","hr","img","input","keygen","link","meta","menuitem","param","source","track","wbr"];var p=["li","dt","dd","p","rt","rp","optgroup","option","colgroup","td","th"];var m=function(e){this.fragmentContext=e&&e.fragmentContext;this.HighlightRules=l;this.$behaviour=new c;this.$completer=new g;this.createModeDelegates({"js-":i,"css-":s});this.foldingRules=new u(this.voidElements,o.arrayToMap(p))};r.inherits(m,a);(function(){this.blockComment={start:"\x3c!--",end:"--\x3e"};this.voidElements=o.arrayToMap(h);this.getNextLineIndent=function(e,t,n){return this.$getIndent(t)};this.checkOutdent=function(e,t,n){return false};this.getCompletions=function(e,t,n,r){return this.$completer.getCompletions(e,t,n,r)};this.createWorker=function(e){if(this.constructor!=m)return;var t=new d(["ace"],"ace/mode/html_worker","Worker");t.attachToDocument(e.getDocument());if(this.fragmentContext)t.call("setOptions",[{context:this.fragmentContext}]);t.on("error",(function(t){e.setAnnotations(t.data)}));t.on("terminate",(function(){e.clearAnnotations()}));return t};this.$id="ace/mode/html";this.snippetFileId="ace/snippets/html"}).call(m.prototype);t.Mode=m}));ace.define("ace/mode/markdown_highlight_rules",["require","exports","module","ace/config","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules","ace/mode/html_highlight_rules"],(function(e,t,n){"use strict";var r=e("../config").$modes;var o=e("../lib/oop");var a=e("../lib/lang");var i=e("./text_highlight_rules").TextHighlightRules;var s=e("./html_highlight_rules").HtmlHighlightRules;var l=function(e){return"(?:[^"+a.escapeRegExp(e)+"\\\\]|\\\\.)*"};var c=function(){s.call(this);var e={token:"support.function",regex:/^\s*(```+[^`]*|~~~+[^~]*)$/,onMatch:function(e,t,n,o){var a=e.match(/^(\s*)([`~]+)(.*)/);var i=/[\w-]+|$/.exec(a[3])[0];if(!r[i])i="";n.unshift("githubblock",[],[a[1],a[2],i],t);return this.token},next:"githubblock"};var t=[{token:"support.function",regex:".*",onMatch:function(e,t,n,o){var a=n[1];var i=n[2][0];var s=n[2][1];var l=n[2][2];var c=/^(\s*)(`+|~+)\s*$/.exec(e);if(c&&c[1].length<i.length+3&&c[2].length>=s.length&&c[2][0]==s[0]){n.splice(0,3);this.next=n.shift();return this.token}this.next="";if(l&&r[l]){var u=r[l].getTokenizer().getLineTokens(e,a.slice(0));n[1]=u.state;return u.tokens}return this.token}}];this.$rules["start"].unshift({token:"empty_line",regex:"^$",next:"allowBlock"},{token:"markup.heading.1",regex:"^=+(?=\\s*$)"},{token:"markup.heading.2",regex:"^\\-+(?=\\s*$)"},{token:function(e){return"markup.heading."+e.length},regex:/^#{1,6}(?=\s|$)/,next:"header"},e,{token:"string.blockquote",regex:"^\\s*>\\s*(?:[*+-]|\\d+\\.)?\\s+",next:"blockquote"},{token:"constant",regex:"^ {0,3}(?:(?:\\* ?){3,}|(?:\\- ?){3,}|(?:\\_ ?){3,})\\s*$",next:"allowBlock"},{token:"markup.list",regex:"^\\s{0,3}(?:[*+-]|\\d+\\.)\\s+",next:"listblock-start"},{include:"basic"});this.addRules({basic:[{token:"constant.language.escape",regex:/\\[\\`*_{}\[\]()#+\-.!]/},{token:"support.function",regex:"(`+)(.*?[^`])(\\1)"},{token:["text","constant","text","url","string","text"],regex:'^([ ]{0,3}\\[)([^\\]]+)(\\]:\\s*)([^ ]+)(\\s*(?:["][^"]+["])?(\\s*))$'},{token:["text","string","text","constant","text"],regex:"(\\[)("+l("]")+")(\\]\\s*\\[)("+l("]")+")(\\])"},{token:["text","string","text","markup.underline","string","text"],regex:"(\\!?\\[)("+l("]")+")(\\]\\()"+'((?:[^\\)\\s\\\\]|\\\\.|\\s(?=[^"]))*)'+'(\\s*"'+l('"')+'"\\s*)?'+"(\\))"},{token:"string.strong",regex:"([*]{2}|[_]{2}(?=\\S))(.*?\\S[*_]*)(\\1)"},{token:"string.emphasis",regex:"([*]|[_](?=\\S))(.*?\\S[*_]*)(\\1)"},{token:["text","url","text"],regex:"(<)("+"(?:https?|ftp|dict):[^'\">\\s]+"+"|"+"(?:mailto:)?[-.\\w]+\\@[-a-z0-9]+(?:\\.[-a-z0-9]+)*\\.[a-z]+"+")(>)"}],allowBlock:[{token:"support.function",regex:"^ {4}.+",next:"allowBlock"},{token:"empty_line",regex:"^$",next:"allowBlock"},{token:"empty",regex:"",next:"start"}],header:[{regex:"$",next:"start"},{include:"basic"},{defaultToken:"heading"}],"listblock-start":[{token:"support.variable",regex:/(?:\[[ x]\])?/,next:"listblock"}],listblock:[{token:"empty_line",regex:"^$",next:"start"},{token:"markup.list",regex:"^\\s{0,3}(?:[*+-]|\\d+\\.)\\s+",next:"listblock-start"},{include:"basic",noEscape:true},e,{defaultToken:"list"}],blockquote:[{token:"empty_line",regex:"^\\s*$",next:"start"},{token:"string.blockquote",regex:"^\\s*>\\s*(?:[*+-]|\\d+\\.)?\\s+",next:"blockquote"},{include:"basic",noEscape:true},{defaultToken:"string.blockquote"}],githubblock:t});this.normalizeRules()};o.inherits(c,i);t.MarkdownHighlightRules=c}));ace.define("ace/mode/folding/markdown",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range"],(function(e,t,n){"use strict";var r=e("../../lib/oop");var o=e("./fold_mode").FoldMode;var a=e("../../range").Range;var i=t.FoldMode=function(){};r.inherits(i,o);(function(){this.foldingStartMarker=/^(?:[=-]+\s*$|#{1,6} |`{3})/;this.getFoldWidget=function(e,t,n){var r=e.getLine(n);if(!this.foldingStartMarker.test(r))return"";if(r[0]=="`"){if(e.bgTokenizer.getState(n)=="start")return"end";return"start"}return"start"};this.getFoldWidgetRange=function(e,t,n){var r=e.getLine(n);var o=r.length;var i=e.getLength();var s=n;var l=n;if(!r.match(this.foldingStartMarker))return;if(r[0]=="`"){if(e.bgTokenizer.getState(n)!=="start"){while(++n<i){r=e.getLine(n);if(r[0]=="`"&r.substring(0,3)=="```")break}return new a(s,o,n,0)}else{while(n-- >0){r=e.getLine(n);if(r[0]=="`"&r.substring(0,3)=="```")break}return new a(n,r.length,s,0)}}var c;function u(t){c=e.getTokens(t)[0];return c&&c.type.lastIndexOf(g,0)===0}var g="markup.heading";function d(){var e=c.value[0];if(e=="=")return 6;if(e=="-")return 5;return 7-c.value.search(/[^#]|$/)}if(u(n)){var h=d();while(++n<i){if(!u(n))continue;var p=d();if(p>=h)break}l=n-(!c||["=","-"].indexOf(c.value[0])==-1?1:2);if(l>s){while(l>s&&/^\s*$/.test(e.getLine(l)))l--}if(l>s){var m=e.getLine(l).length;return new a(s,o,l,m)}}}}).call(i.prototype)}));ace.define("ace/mode/sh_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],(function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("./text_highlight_rules").TextHighlightRules;var a=t.reservedKeywords="!|{|}|case|do|done|elif|else|"+"esac|fi|for|if|in|then|until|while|"+"&|;|export|local|read|typeset|unset|"+"elif|select|set|function|declare|readonly";var i=t.languageConstructs="[|]|alias|bg|bind|break|builtin|"+"cd|command|compgen|complete|continue|"+"dirs|disown|echo|enable|eval|exec|"+"exit|fc|fg|getopts|hash|help|history|"+"jobs|kill|let|logout|popd|printf|pushd|"+"pwd|return|set|shift|shopt|source|"+"suspend|test|times|trap|type|ulimit|"+"umask|unalias|wait";var s=function(){var e=this.createKeywordMapper({keyword:a,"support.function.builtin":i,"invalid.deprecated":"debugger"},"identifier");var t="(?:(?:[1-9]\\d*)|(?:0))";var n="(?:\\.\\d+)";var r="(?:\\d+)";var o="(?:(?:"+r+"?"+n+")|(?:"+r+"\\.))";var s="(?:(?:"+o+"|"+r+")"+")";var l="(?:"+s+"|"+o+")";var c="(?:&"+r+")";var u="[a-zA-Z_][a-zA-Z0-9_]*";var g="(?:"+u+"(?==))";var d="(?:\\$(?:SHLVL|\\$|\\!|\\?))";var h="(?:"+u+"\\s*\\(\\))";this.$rules={start:[{token:"constant",regex:/\\./},{token:["text","comment"],regex:/(^|\s)(#.*)$/},{token:"string.start",regex:'"',push:[{token:"constant.language.escape",regex:/\\(?:[$`"\\]|$)/},{include:"variables"},{token:"keyword.operator",regex:/`/},{token:"string.end",regex:'"',next:"pop"},{defaultToken:"string"}]},{token:"string",regex:"\\$'",push:[{token:"constant.language.escape",regex:/\\(?:[abeEfnrtv\\'"]|x[a-fA-F\d]{1,2}|u[a-fA-F\d]{4}([a-fA-F\d]{4})?|c.|\d{1,3})/},{token:"string",regex:"'",next:"pop"},{defaultToken:"string"}]},{regex:"<<<",token:"keyword.operator"},{stateName:"heredoc",regex:"(<<-?)(\\s*)(['\"`]?)([\\w\\-]+)(['\"`]?)",onMatch:function(e,t,n){var r=e[2]=="-"?"indentedHeredoc":"heredoc";var o=e.split(this.splitRegex);n.push(r,o[4]);return[{type:"constant",value:o[1]},{type:"text",value:o[2]},{type:"string",value:o[3]},{type:"support.class",value:o[4]},{type:"string",value:o[5]}]},rules:{heredoc:[{onMatch:function(e,t,n){if(e===n[1]){n.shift();n.shift();this.next=n[0]||"start";return"support.class"}this.next="";return"string"},regex:".*$",next:"start"}],indentedHeredoc:[{token:"string",regex:"^\t+"},{onMatch:function(e,t,n){if(e===n[1]){n.shift();n.shift();this.next=n[0]||"start";return"support.class"}this.next="";return"string"},regex:".*$",next:"start"}]}},{regex:"$",token:"empty",next:function(e,t){if(t[0]==="heredoc"||t[0]==="indentedHeredoc")return t[0];return e}},{token:["keyword","text","text","text","variable"],regex:/(declare|local|readonly)(\s+)(?:(-[fixar]+)(\s+))?([a-zA-Z_][a-zA-Z0-9_]*\b)/},{token:"variable.language",regex:d},{token:"variable",regex:g},{include:"variables"},{token:"support.function",regex:h},{token:"support.function",regex:c},{token:"string",start:"'",end:"'"},{token:"constant.numeric",regex:l},{token:"constant.numeric",regex:t+"\\b"},{token:e,regex:"[a-zA-Z_][a-zA-Z0-9_]*\\b"},{token:"keyword.operator",regex:"\\+|\\-|\\*|\\*\\*|\\/|\\/\\/|~|<|>|<=|=>|=|!=|[%&|`]"},{token:"punctuation.operator",regex:";"},{token:"paren.lparen",regex:"[\\[\\(\\{]"},{token:"paren.rparen",regex:"[\\]]"},{token:"paren.rparen",regex:"[\\)\\}]",next:"pop"}],variables:[{token:"variable",regex:/(\$)(\w+)/},{token:["variable","paren.lparen"],regex:/(\$)(\()/,push:"start"},{token:["variable","paren.lparen","keyword.operator","variable","keyword.operator"],regex:/(\$)(\{)([#!]?)(\w+|[*@#?\-$!0_])(:[?+\-=]?|##?|%%?|,,?\/|\^\^?)?/,push:"start"},{token:"variable",regex:/\$[*@#?\-$!0_]/},{token:["variable","paren.lparen"],regex:/(\$)(\{)/,push:"start"}]};this.normalizeRules()};r.inherits(s,o);t.ShHighlightRules=s}));ace.define("ace/mode/sh",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/sh_highlight_rules","ace/range","ace/mode/folding/cstyle","ace/mode/behaviour/cstyle"],(function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("./text").Mode;var a=e("./sh_highlight_rules").ShHighlightRules;var i=e("../range").Range;var s=e("./folding/cstyle").FoldMode;var l=e("./behaviour/cstyle").CstyleBehaviour;var c=function(){this.HighlightRules=a;this.foldingRules=new s;this.$behaviour=new l};r.inherits(c,o);(function(){this.lineCommentStart="#";this.getNextLineIndent=function(e,t,n){var r=this.$getIndent(t);var o=this.getTokenizer().getLineTokens(t,e);var a=o.tokens;if(a.length&&a[a.length-1].type=="comment"){return r}if(e=="start"){var i=t.match(/^.*[\{\(\[:]\s*$/);if(i){r+=n}}return r};var e={pass:1,return:1,raise:1,break:1,continue:1};this.checkOutdent=function(t,n,r){if(r!=="\r\n"&&r!=="\r"&&r!=="\n")return false;var o=this.getTokenizer().getLineTokens(n.trim(),t).tokens;if(!o)return false;do{var a=o.pop()}while(a&&(a.type=="comment"||a.type=="text"&&a.value.match(/^\s+$/)));if(!a)return false;return a.type=="keyword"&&e[a.value]};this.autoOutdent=function(e,t,n){n+=1;var r=this.$getIndent(t.getLine(n));var o=t.getTabString();if(r.slice(-o.length)==o)t.remove(new i(n,r.length-o.length,n,r.length))};this.$id="ace/mode/sh";this.snippetFileId="ace/snippets/sh"}).call(c.prototype);t.Mode=c}));ace.define("ace/mode/markdown",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/javascript","ace/mode/xml","ace/mode/html","ace/mode/markdown_highlight_rules","ace/mode/folding/markdown","ace/mode/javascript","ace/mode/html","ace/mode/sh","ace/mode/sh","ace/mode/xml","ace/mode/css"],(function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("./text").Mode;var a=e("./javascript").Mode;var i=e("./xml").Mode;var s=e("./html").Mode;var l=e("./markdown_highlight_rules").MarkdownHighlightRules;var c=e("./folding/markdown").FoldMode;var u=function(){this.HighlightRules=l;this.createModeDelegates({javascript:e("./javascript").Mode,html:e("./html").Mode,bash:e("./sh").Mode,sh:e("./sh").Mode,xml:e("./xml").Mode,css:e("./css").Mode});this.foldingRules=new c;this.$behaviour=this.$defaultBehaviour};r.inherits(u,o);(function(){this.type="text";this.blockComment={start:"\x3c!--",end:"--\x3e"};this.$quotes={'"':'"',"`":"`"};this.getNextLineIndent=function(e,t,n){if(e=="listblock"){var r=/^(\s*)(?:([-+*])|(\d+)\.)(\s+)/.exec(t);if(!r)return"";var o=r[2];if(!o)o=parseInt(r[3],10)+1+".";return r[1]+o+r[4]}else{return this.$getIndent(t)}};this.$id="ace/mode/markdown";this.snippetFileId="ace/snippets/markdown"}).call(u.prototype);t.Mode=u}));ace.define("ace/mode/coffee_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],(function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("./text_highlight_rules").TextHighlightRules;r.inherits(a,o);function a(){var e="[$A-Za-z_\\x7f-\\uffff][$\\w\\x7f-\\uffff]*";var t="this|throw|then|try|typeof|super|switch|return|break|by|continue|"+"catch|class|in|instanceof|is|isnt|if|else|extends|for|own|"+"finally|function|while|when|new|no|not|delete|debugger|do|loop|of|off|"+"or|on|unless|until|and|yes|yield|export|import|default";var n="true|false|null|undefined|NaN|Infinity";var r="case|const|function|var|void|with|enum|implements|"+"interface|let|package|private|protected|public|static";var o="Array|Boolean|Date|Function|Number|Object|RegExp|ReferenceError|String|"+"Error|EvalError|InternalError|RangeError|ReferenceError|StopIteration|"+"SyntaxError|TypeError|URIError|"+"ArrayBuffer|Float32Array|Float64Array|Int16Array|Int32Array|Int8Array|"+"Uint16Array|Uint32Array|Uint8Array|Uint8ClampedArray";var a="Math|JSON|isNaN|isFinite|parseInt|parseFloat|encodeURI|"+"encodeURIComponent|decodeURI|decodeURIComponent|String|";var i="window|arguments|prototype|document";var s=this.createKeywordMapper({keyword:t,"constant.language":n,"invalid.illegal":r,"language.support.class":o,"language.support.function":a,"variable.language":i},"identifier");var l={token:["paren.lparen","variable.parameter","paren.rparen","text","storage.type"],regex:/(?:(\()((?:"[^")]*?"|'[^')]*?'|\/[^\/)]*?\/|[^()"'\/])*?)(\))(\s*))?([\-=]>)/.source};var c=/\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|[0-2][0-7]{0,2}|3[0-6][0-7]?|37[0-7]?|[4-7][0-7]?|.)/;this.$rules={start:[{token:"constant.numeric",regex:"(?:0x[\\da-fA-F]+|(?:\\d+(?:\\.\\d+)?|\\.\\d+)(?:[eE][+-]?\\d+)?)"},{stateName:"qdoc",token:"string",regex:"'''",next:[{token:"string",regex:"'''",next:"start"},{token:"constant.language.escape",regex:c},{defaultToken:"string"}]},{stateName:"qqdoc",token:"string",regex:'"""',next:[{token:"string",regex:'"""',next:"start"},{token:"paren.string",regex:"#{",push:"start"},{token:"constant.language.escape",regex:c},{defaultToken:"string"}]},{stateName:"qstring",token:"string",regex:"'",next:[{token:"string",regex:"'",next:"start"},{token:"constant.language.escape",regex:c},{defaultToken:"string"}]},{stateName:"qqstring",token:"string.start",regex:'"',next:[{token:"string.end",regex:'"',next:"start"},{token:"paren.string",regex:"#{",push:"start"},{token:"constant.language.escape",regex:c},{defaultToken:"string"}]},{stateName:"js",token:"string",regex:"`",next:[{token:"string",regex:"`",next:"start"},{token:"constant.language.escape",regex:c},{defaultToken:"string"}]},{regex:"[{}]",onMatch:function(e,t,n){this.next="";if(e=="{"&&n.length){n.unshift("start",t);return"paren"}if(e=="}"&&n.length){n.shift();this.next=n.shift()||"";if(this.next.indexOf("string")!=-1)return"paren.string"}return"paren"}},{token:"string.regex",regex:"///",next:"heregex"},{token:"string.regex",regex:/(?:\/(?![\s=])[^[\/\n\\]*(?:(?:\\[\s\S]|\[[^\]\n\\]*(?:\\[\s\S][^\]\n\\]*)*])[^[\/\n\\]*)*\/)(?:[imgy]{0,4})(?!\w)/},{token:"comment",regex:"###(?!#)",next:"comment"},{token:"comment",regex:"#.*"},{token:["punctuation.operator","text","identifier"],regex:"(\\.)(\\s*)("+r+")"},{token:"punctuation.operator",regex:"\\.{1,3}"},{token:["keyword","text","language.support.class","text","keyword","text","language.support.class"],regex:"(class)(\\s+)("+e+")(?:(\\s+)(extends)(\\s+)("+e+"))?"},{token:["entity.name.function","text","keyword.operator","text"].concat(l.token),regex:"("+e+")(\\s*)([=:])(\\s*)"+l.regex},l,{token:"variable",regex:"@(?:"+e+")?"},{token:s,regex:e},{token:"punctuation.operator",regex:"\\,|\\."},{token:"storage.type",regex:"[\\-=]>"},{token:"keyword.operator",regex:"(?:[-+*/%<>&|^!?=]=|>>>=?|\\-\\-|\\+\\+|::|&&=|\\|\\|=|<<=|>>=|\\?\\.|\\.{2,3}|[!*+-=><])"},{token:"paren.lparen",regex:"[({[]"},{token:"paren.rparen",regex:"[\\]})]"},{token:"text",regex:"\\s+"}],heregex:[{token:"string.regex",regex:".*?///[imgy]{0,4}",next:"start"},{token:"comment.regex",regex:"\\s+(?:#.*)?"},{token:"string.regex",regex:"\\S+"}],comment:[{token:"comment",regex:"###",next:"start"},{defaultToken:"comment"}]};this.normalizeRules()}t.CoffeeHighlightRules=a}));ace.define("ace/mode/folding/coffee",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range"],(function(e,t,n){"use strict";var r=e("../../lib/oop");var o=e("./fold_mode").FoldMode;var a=e("../../range").Range;var i=t.FoldMode=function(){};r.inherits(i,o);(function(){this.getFoldWidgetRange=function(e,t,n){var r=this.indentationBlock(e,n);if(r)return r;var o=/\S/;var i=e.getLine(n);var s=i.search(o);if(s==-1||i[s]!="#")return;var l=i.length;var c=e.getLength();var u=n;var g=n;while(++n<c){i=e.getLine(n);var d=i.search(o);if(d==-1)continue;if(i[d]!="#")break;g=n}if(g>u){var h=e.getLine(g).length;return new a(u,l,g,h)}};this.getFoldWidget=function(e,t,n){var r=e.getLine(n);var o=r.search(/\S/);var a=e.getLine(n+1);var i=e.getLine(n-1);var s=i.search(/\S/);var l=a.search(/\S/);if(o==-1){e.foldWidgets[n-1]=s!=-1&&s<l?"start":"";return""}if(s==-1){if(o==l&&r[o]=="#"&&a[o]=="#"){e.foldWidgets[n-1]="";e.foldWidgets[n+1]="";return"start"}}else if(s==o&&r[o]=="#"&&i[o]=="#"){if(e.getLine(n-2).search(/\S/)==-1){e.foldWidgets[n-1]="start";e.foldWidgets[n+1]="";return""}}if(s!=-1&&s<o)e.foldWidgets[n-1]="start";else e.foldWidgets[n-1]="";if(o<l)return"start";else return""}}).call(i.prototype)}));ace.define("ace/mode/coffee",["require","exports","module","ace/mode/coffee_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/folding/coffee","ace/range","ace/mode/text","ace/worker/worker_client","ace/lib/oop"],(function(e,t,n){"use strict";var r=e("./coffee_highlight_rules").CoffeeHighlightRules;var o=e("./matching_brace_outdent").MatchingBraceOutdent;var a=e("./folding/coffee").FoldMode;var i=e("../range").Range;var s=e("./text").Mode;var l=e("../worker/worker_client").WorkerClient;var c=e("../lib/oop");function u(){this.HighlightRules=r;this.$outdent=new o;this.foldingRules=new a}c.inherits(u,s);(function(){var e=/(?:[({[=:]|[-=]>|\b(?:else|try|(?:swi|ca)tch(?:\s+[$A-Za-z_\x7f-\uffff][$\w\x7f-\uffff]*)?|finally))\s*$|^\s*(else\b\s*)?(?:if|for|while|loop)\b(?!.*\bthen\b)/;this.lineCommentStart="#";this.blockComment={start:"###",end:"###"};this.getNextLineIndent=function(t,n,r){var o=this.$getIndent(n);var a=this.getTokenizer().getLineTokens(n,t).tokens;if(!(a.length&&a[a.length-1].type==="comment")&&t==="start"&&e.test(n))o+=r;return o};this.checkOutdent=function(e,t,n){return this.$outdent.checkOutdent(t,n)};this.autoOutdent=function(e,t,n){this.$outdent.autoOutdent(t,n)};this.createWorker=function(e){var t=new l(["ace"],"ace/mode/coffee_worker","Worker");t.attachToDocument(e.getDocument());t.on("annotate",(function(t){e.setAnnotations(t.data)}));t.on("terminate",(function(){e.clearAnnotations()}));return t};this.$id="ace/mode/coffee";this.snippetFileId="ace/snippets/coffee"}).call(u.prototype);t.Mode=u}));ace.define("ace/mode/scss_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules","ace/mode/css_highlight_rules"],(function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("../lib/lang");var a=e("./text_highlight_rules").TextHighlightRules;var i=e("./css_highlight_rules");var s=function(){var e=o.arrayToMap(i.supportType.split("|"));var t=o.arrayToMap(("hsl|hsla|rgb|rgba|url|attr|counter|counters|abs|adjust_color|adjust_hue|"+"alpha|join|blue|ceil|change_color|comparable|complement|darken|desaturate|"+"floor|grayscale|green|hue|if|invert|join|length|lighten|lightness|mix|"+"nth|opacify|opacity|percentage|quote|red|round|saturate|saturation|"+"scale_color|transparentize|type_of|unit|unitless|unquote").split("|"));var n=o.arrayToMap(i.supportConstant.split("|"));var r=o.arrayToMap(i.supportConstantColor.split("|"));var a=o.arrayToMap("@mixin|@extend|@include|@import|@media|@debug|@warn|@if|@for|@each|@while|@else|@font-face|@-webkit-keyframes|if|and|!default|module|def|end|declare".split("|"));var s=o.arrayToMap(("a|abbr|acronym|address|applet|area|article|aside|audio|b|base|basefont|bdo|"+"big|blockquote|body|br|button|canvas|caption|center|cite|code|col|colgroup|"+"command|datalist|dd|del|details|dfn|dir|div|dl|dt|em|embed|fieldset|"+"figcaption|figure|font|footer|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|"+"header|hgroup|hr|html|i|iframe|img|input|ins|keygen|kbd|label|legend|li|"+"link|map|mark|menu|meta|meter|nav|noframes|noscript|object|ol|optgroup|"+"option|output|p|param|pre|progress|q|rp|rt|ruby|s|samp|script|section|select|"+"small|source|span|strike|strong|style|sub|summary|sup|table|tbody|td|"+"textarea|tfoot|th|thead|time|title|tr|tt|u|ul|var|video|wbr|xmp").split("|"));var l="\\-?(?:(?:[0-9]+)|(?:[0-9]*\\.[0-9]+))";this.$rules={start:[{token:"comment",regex:"\\/\\/.*$"},{token:"comment",regex:"\\/\\*",next:"comment"},{token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'},{token:"string",regex:'["].*\\\\$',next:"qqstring"},{token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"string",regex:"['].*\\\\$",next:"qstring"},{token:"constant.numeric",regex:l+"(?:ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vmax|vmin|vm|vw|%)"},{token:"constant.numeric",regex:"#[a-f0-9]{6}"},{token:"constant.numeric",regex:"#[a-f0-9]{3}"},{token:"constant.numeric",regex:l},{token:["support.function","string","support.function"],regex:"(url\\()(.*)(\\))"},{token:function(o){if(e.hasOwnProperty(o.toLowerCase()))return"support.type";if(a.hasOwnProperty(o))return"keyword";else if(n.hasOwnProperty(o))return"constant.language";else if(t.hasOwnProperty(o))return"support.function";else if(r.hasOwnProperty(o.toLowerCase()))return"support.constant.color";else if(s.hasOwnProperty(o.toLowerCase()))return"variable.language";else return"text"},regex:"\\-?[@a-z_][@a-z0-9_\\-]*"},{token:"variable",regex:"[a-z_\\-$][a-z0-9_\\-$]*\\b"},{token:"variable.language",regex:"#[a-z0-9-_]+"},{token:"variable.language",regex:"\\.[a-z0-9-_]+"},{token:"variable.language",regex:":[a-z0-9-_]+"},{token:"constant",regex:"[a-z0-9-_]+"},{token:"keyword.operator",regex:"<|>|<=|>=|==|!=|-|%|#|\\+|\\$|\\+|\\*"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"},{caseInsensitive:true}],comment:[{token:"comment",regex:"\\*\\/",next:"start"},{defaultToken:"comment"}],qqstring:[{token:"string",regex:'(?:(?:\\\\.)|(?:[^"\\\\]))*?"',next:"start"},{token:"string",regex:".+"}],qstring:[{token:"string",regex:"(?:(?:\\\\.)|(?:[^'\\\\]))*?'",next:"start"},{token:"string",regex:".+"}]}};r.inherits(s,a);t.ScssHighlightRules=s}));ace.define("ace/mode/scss",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/scss_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/behaviour/css","ace/mode/folding/cstyle","ace/mode/css_completions"],(function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("./text").Mode;var a=e("./scss_highlight_rules").ScssHighlightRules;var i=e("./matching_brace_outdent").MatchingBraceOutdent;var s=e("./behaviour/css").CssBehaviour;var l=e("./folding/cstyle").FoldMode;var c=e("./css_completions").CssCompletions;var u=function(){this.HighlightRules=a;this.$outdent=new i;this.$behaviour=new s;this.$completer=new c;this.foldingRules=new l};r.inherits(u,o);(function(){this.lineCommentStart="//";this.blockComment={start:"/*",end:"*/"};this.getNextLineIndent=function(e,t,n){var r=this.$getIndent(t);var o=this.getTokenizer().getLineTokens(t,e).tokens;if(o.length&&o[o.length-1].type=="comment"){return r}var a=t.match(/^.*\{\s*$/);if(a){r+=n}return r};this.checkOutdent=function(e,t,n){return this.$outdent.checkOutdent(t,n)};this.autoOutdent=function(e,t,n){this.$outdent.autoOutdent(t,n)};this.getCompletions=function(e,t,n,r){return this.$completer.getCompletions(e,t,n,r)};this.$id="ace/mode/scss"}).call(u.prototype);t.Mode=u}));ace.define("ace/mode/sass_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/scss_highlight_rules"],(function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("../lib/lang");var a=e("./scss_highlight_rules").ScssHighlightRules;var i=function(){a.call(this);var e=this.$rules.start;if(e[1].token=="comment"){e.splice(1,1,{onMatch:function(e,t,n){n.unshift(this.next,-1,e.length-2,t);return"comment"},regex:/^\s*\/\*/,next:"comment"},{token:"error.invalid",regex:"/\\*|[{;}]"},{token:"support.type",regex:/^\s*:[\w\-]+\s/});this.$rules.comment=[{regex:/^\s*/,onMatch:function(e,t,n){if(n[1]===-1)n[1]=Math.max(n[2],e.length-1);if(e.length<=n[1]){n.shift();n.shift();n.shift();this.next=n.shift();return"text"}else{this.next="";return"comment"}},next:"start"},{defaultToken:"comment"}]}};r.inherits(i,a);t.SassHighlightRules=i}));ace.define("ace/mode/sass",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/sass_highlight_rules","ace/mode/folding/coffee"],(function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("./text").Mode;var a=e("./sass_highlight_rules").SassHighlightRules;var i=e("./folding/coffee").FoldMode;var s=function(){this.HighlightRules=a;this.foldingRules=new i;this.$behaviour=this.$defaultBehaviour};r.inherits(s,o);(function(){this.lineCommentStart="//";this.$id="ace/mode/sass"}).call(s.prototype);t.Mode=s}));ace.define("ace/mode/less_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules","ace/mode/css_highlight_rules"],(function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("./text_highlight_rules").TextHighlightRules;var a=e("./css_highlight_rules");var i=function(){var e="@import|@media|@font-face|@keyframes|@-webkit-keyframes|@supports|"+"@charset|@plugin|@namespace|@document|@page|@viewport|@-ms-viewport|"+"or|and|when|not";var t=e.split("|");var n=a.supportType.split("|");var r=this.createKeywordMapper({"support.constant":a.supportConstant,keyword:e,"support.constant.color":a.supportConstantColor,"support.constant.fonts":a.supportConstantFonts},"identifier",true);var o="\\-?(?:(?:[0-9]+)|(?:[0-9]*\\.[0-9]+))";this.$rules={start:[{token:"comment",regex:"\\/\\/.*$"},{token:"comment",regex:"\\/\\*",next:"comment"},{token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'},{token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:["constant.numeric","keyword"],regex:"("+o+")(ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vm|vw|%)"},{token:"constant.numeric",regex:"#[a-f0-9]{6}"},{token:"constant.numeric",regex:"#[a-f0-9]{3}"},{token:"constant.numeric",regex:o},{token:["support.function","paren.lparen","string","paren.rparen"],regex:"(url)(\\()(.*)(\\))"},{token:["support.function","paren.lparen"],regex:"(:extend|[a-z0-9_\\-]+)(\\()"},{token:function(e){if(t.indexOf(e.toLowerCase())>-1)return"keyword";else return"variable"},regex:"[@\\$][a-z0-9_\\-@\\$]*\\b"},{token:"variable",regex:"[@\\$]\\{[a-z0-9_\\-@\\$]*\\}"},{token:function(e,t){if(n.indexOf(e.toLowerCase())>-1){return["support.type.property","text"]}else{return["support.type.unknownProperty","text"]}},regex:"([a-z0-9-_]+)(\\s*:)"},{token:"keyword",regex:"&"},{token:r,regex:"\\-?[@a-z_][@a-z0-9_\\-]*"},{token:"variable.language",regex:"#[a-z0-9-_]+"},{token:"variable.language",regex:"\\.[a-z0-9-_]+"},{token:"variable.language",regex:":[a-z_][a-z0-9-_]*"},{token:"constant",regex:"[a-z0-9-_]+"},{token:"keyword.operator",regex:"<|>|<=|>=|=|!=|-|%|\\+|\\*"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"},{caseInsensitive:true}],comment:[{token:"comment",regex:"\\*\\/",next:"start"},{defaultToken:"comment"}]};this.normalizeRules()};r.inherits(i,o);t.LessHighlightRules=i}));ace.define("ace/mode/less",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/less_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/behaviour/css","ace/mode/css_completions","ace/mode/folding/cstyle"],(function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("./text").Mode;var a=e("./less_highlight_rules").LessHighlightRules;var i=e("./matching_brace_outdent").MatchingBraceOutdent;var s=e("./behaviour/css").CssBehaviour;var l=e("./css_completions").CssCompletions;var c=e("./folding/cstyle").FoldMode;var u=function(){this.HighlightRules=a;this.$outdent=new i;this.$behaviour=new s;this.$completer=new l;this.foldingRules=new c};r.inherits(u,o);(function(){this.lineCommentStart="//";this.blockComment={start:"/*",end:"*/"};this.getNextLineIndent=function(e,t,n){var r=this.$getIndent(t);var o=this.getTokenizer().getLineTokens(t,e).tokens;if(o.length&&o[o.length-1].type=="comment"){return r}var a=t.match(/^.*\{\s*$/);if(a){r+=n}return r};this.checkOutdent=function(e,t,n){return this.$outdent.checkOutdent(t,n)};this.autoOutdent=function(e,t,n){this.$outdent.autoOutdent(t,n)};this.getCompletions=function(e,t,n,r){return this.$completer.getCompletions("ruleset",t,n,r)};this.$id="ace/mode/less"}).call(u.prototype);t.Mode=u}));ace.define("ace/mode/ruby_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],(function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("./text_highlight_rules").TextHighlightRules;var a=t.constantOtherSymbol={token:"constant.other.symbol.ruby",regex:"[:](?:[A-Za-z_]|[@$](?=[a-zA-Z0-9_]))[a-zA-Z0-9_]*[!=?]?"};t.qString={token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"};t.qqString={token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'};t.tString={token:"string",regex:"[`](?:(?:\\\\.)|(?:[^'\\\\]))*?[`]"};var i=t.constantNumericHex={token:"constant.numeric",regex:"0[xX][0-9a-fA-F](?:[0-9a-fA-F]|_(?=[0-9a-fA-F]))*\\b"};var s=t.constantNumericBinary={token:"constant.numeric",regex:/\b(0[bB][01](?:[01]|_(?=[01]))*)\b/};var l=t.constantNumericDecimal={token:"constant.numeric",regex:/\b(0[dD](?:[1-9](?:[\d]|_(?=[\d]))*|0))\b/};var c=t.constantNumericDecimal={token:"constant.numeric",regex:/\b(0[oO]?(?:[1-7](?:[0-7]|_(?=[0-7]))*|0))\b/};var u=t.constantNumericRational={token:"constant.numeric",regex:/\b([\d]+(?:[./][\d]+)?ri?)\b/};var g=t.constantNumericComplex={token:"constant.numeric",regex:/\b([\d]i)\b/};var d=t.constantNumericFloat={token:"constant.numeric",regex:"[+-]?\\d(?:\\d|_(?=\\d))*(?:(?:\\.\\d(?:\\d|_(?=\\d))*)?(?:[eE][+-]?\\d+)?)?i?\\b"};var h=t.instanceVariable={token:"variable.instance",regex:"@{1,2}[a-zA-Z_\\d]+"};var p=function(){var e="abort|Array|assert|assert_equal|assert_not_equal|assert_same|assert_not_same|"+"assert_nil|assert_not_nil|assert_match|assert_no_match|assert_in_delta|assert_throws|"+"assert_raise|assert_nothing_raised|assert_instance_of|assert_kind_of|assert_respond_to|"+"assert_operator|assert_send|assert_difference|assert_no_difference|assert_recognizes|"+"assert_generates|assert_response|assert_redirected_to|assert_template|assert_select|"+"assert_select_email|assert_select_rjs|assert_select_encoded|css_select|at_exit|"+"attr|attr_writer|attr_reader|attr_accessor|attr_accessible|autoload|binding|block_given?|callcc|"+"caller|catch|chomp|chomp!|chop|chop!|defined?|delete_via_redirect|eval|exec|exit|"+"exit!|fail|Float|flunk|follow_redirect!|fork|form_for|form_tag|format|gets|global_variables|gsub|"+"gsub!|get_via_redirect|host!|https?|https!|include|Integer|lambda|link_to|"+"link_to_unless_current|link_to_function|link_to_remote|load|local_variables|loop|open|open_session|"+"p|print|printf|proc|putc|puts|post_via_redirect|put_via_redirect|raise|rand|"+"raw|readline|readlines|redirect?|request_via_redirect|require|scan|select|"+"set_trace_func|sleep|split|sprintf|srand|String|stylesheet_link_tag|syscall|system|sub|sub!|test|"+"throw|trace_var|trap|untrace_var|atan2|cos|exp|frexp|ldexp|log|log10|sin|sqrt|tan|"+"render|javascript_include_tag|csrf_meta_tag|label_tag|text_field_tag|submit_tag|check_box_tag|"+"content_tag|radio_button_tag|text_area_tag|password_field_tag|hidden_field_tag|"+"fields_for|select_tag|options_for_select|options_from_collection_for_select|collection_select|"+"time_zone_select|select_date|select_time|select_datetime|date_select|time_select|datetime_select|"+"select_year|select_month|select_day|select_hour|select_minute|select_second|file_field_tag|"+"file_field|respond_to|skip_before_filter|around_filter|after_filter|verify|"+"protect_from_forgery|rescue_from|helper_method|redirect_to|before_filter|"+"send_data|send_file|validates_presence_of|validates_uniqueness_of|validates_length_of|"+"validates_format_of|validates_acceptance_of|validates_associated|validates_exclusion_of|"+"validates_inclusion_of|validates_numericality_of|validates_with|validates_each|"+"authenticate_or_request_with_http_basic|authenticate_or_request_with_http_digest|"+"filter_parameter_logging|match|get|post|resources|redirect|scope|assert_routing|"+"translate|localize|extract_locale_from_tld|caches_page|expire_page|caches_action|expire_action|"+"cache|expire_fragment|expire_cache_for|observe|cache_sweeper|"+"has_many|has_one|belongs_to|has_and_belongs_to_many|p|warn|refine|using|module_function|extend|alias_method|"+"private_class_method|remove_method|undef_method";var t="alias|and|BEGIN|begin|break|case|class|def|defined|do|else|elsif|END|end|ensure|"+"__FILE__|finally|for|gem|if|in|__LINE__|module|next|not|or|private|protected|public|"+"redo|rescue|retry|return|super|then|undef|unless|until|when|while|yield|__ENCODING__|prepend";var n="true|TRUE|false|FALSE|nil|NIL|ARGF|ARGV|DATA|ENV|RUBY_PLATFORM|RUBY_RELEASE_DATE|"+"RUBY_VERSION|STDERR|STDIN|STDOUT|TOPLEVEL_BINDING|RUBY_PATCHLEVEL|RUBY_REVISION|RUBY_COPYRIGHT|RUBY_ENGINE|RUBY_ENGINE_VERSION|RUBY_DESCRIPTION";var r="$DEBUG|$defout|$FILENAME|$LOAD_PATH|$SAFE|$stdin|$stdout|$stderr|$VERBOSE|"+"$!|root_url|flash|session|cookies|params|request|response|logger|self";var o=this.$keywords=this.createKeywordMapper({keyword:t,"constant.language":n,"variable.language":r,"support.function":e,"invalid.deprecated":"debugger"},"identifier");var p="\\\\(?:n(?:[1-7][0-7]{0,2}|0)|[nsrtvfbae'\"\\\\]|c(?:\\\\M-)?.|M-(?:\\\\C-|\\\\c)?.|C-(?:\\\\M-)?.|[0-7]{3}|x[\\da-fA-F]{2}|u[\\da-fA-F]{4}|u{[\\da-fA-F]{1,6}(?:\\s[\\da-fA-F]{1,6})*})";var m={"(":")","[":"]","{":"}","<":">","^":"^","|":"|","%":"%"};this.$rules={start:[{token:"comment",regex:"#.*$"},{token:"comment.multiline",regex:"^=begin(?=$|\\s.*$)",next:"comment"},{token:"string.regexp",regex:/[/](?=.*\/)/,next:"regex"},[{token:["constant.other.symbol.ruby","string.start"],regex:/(:)?(")/,push:[{token:"constant.language.escape",regex:p},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/"/,next:"pop"},{defaultToken:"string"}]},{token:"string.start",regex:/`/,push:[{token:"constant.language.escape",regex:p},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/`/,next:"pop"},{defaultToken:"string"}]},{token:["constant.other.symbol.ruby","string.start"],regex:/(:)?(')/,push:[{token:"constant.language.escape",regex:/\\['\\]/},{token:"string.end",regex:/'/,next:"pop"},{defaultToken:"string"}]},{token:"string.start",regex:/%[qwx]([(\[<{^|%])/,onMatch:function(e,t,n){if(n.length)n=[];var r=e[e.length-1];n.unshift(r,t);this.next="qStateWithoutInterpolation";return this.token}},{token:"string.start",regex:/%[QWX]?([(\[<{^|%])/,onMatch:function(e,t,n){if(n.length)n=[];var r=e[e.length-1];n.unshift(r,t);this.next="qStateWithInterpolation";return this.token}},{token:"constant.other.symbol.ruby",regex:/%[si]([(\[<{^|%])/,onMatch:function(e,t,n){if(n.length)n=[];var r=e[e.length-1];n.unshift(r,t);this.next="sStateWithoutInterpolation";return this.token}},{token:"constant.other.symbol.ruby",regex:/%[SI]([(\[<{^|%])/,onMatch:function(e,t,n){if(n.length)n=[];var r=e[e.length-1];n.unshift(r,t);this.next="sStateWithInterpolation";return this.token}},{token:"string.regexp",regex:/%[r]([(\[<{^|%])/,onMatch:function(e,t,n){if(n.length)n=[];var r=e[e.length-1];n.unshift(r,t);this.next="rState";return this.token}}],{token:"punctuation",regex:"::"},h,{token:"variable.global",regex:"[$][a-zA-Z_\\d]+"},{token:"support.class",regex:"[A-Z][a-zA-Z_\\d]*"},{token:["punctuation.operator","support.function"],regex:/(\.)([a-zA-Z_\d]+)(?=\()/},{token:["punctuation.operator","identifier"],regex:/(\.)([a-zA-Z_][a-zA-Z_\d]*)/},{token:"string.character",regex:"\\B\\?(?:"+p+"|\\S)"},{token:"punctuation.operator",regex:/\?(?=.+:)/},u,g,a,i,d,s,l,c,{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:o,regex:"[a-zA-Z_$][a-zA-Z0-9_$]*\\b"},{token:"punctuation.separator.key-value",regex:"=>"},{stateName:"heredoc",onMatch:function(e,t,n){var r=e[2]=="-"||e[2]=="~"?"indentedHeredoc":"heredoc";var o=e.split(this.splitRegex);n.push(r,o[3]);return[{type:"constant",value:o[1]},{type:"string",value:o[2]},{type:"support.class",value:o[3]},{type:"string",value:o[4]}]},regex:"(<<[-~]?)(['\"`]?)([\\w]+)(['\"`]?)",rules:{heredoc:[{onMatch:function(e,t,n){if(e===n[1]){n.shift();n.shift();this.next=n[0]||"start";return"support.class"}this.next="";return"string"},regex:".*$",next:"start"}],indentedHeredoc:[{token:"string",regex:"^ +"},{onMatch:function(e,t,n){if(e===n[1]){n.shift();n.shift();this.next=n[0]||"start";return"support.class"}this.next="";return"string"},regex:".*$",next:"start"}]}},{regex:"$",token:"empty",next:function(e,t){if(t[0]==="heredoc"||t[0]==="indentedHeredoc")return t[0];return e}},{token:"keyword.operator",regex:"!|\\$|%|&|\\*|/|\\-\\-|\\-|\\+\\+|\\+|~|===|==|=|!=|!==|<=|>=|<<=|>>=|>>>=|<>|<|>|!|&&|\\|\\||\\?\\:|\\*=|%=|\\+=|\\-=|&=|\\^=|\\||\\b(?:in|instanceof|new|delete|typeof|void)"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]",onMatch:function(e,t,n){this.next="";if(e=="}"&&n.length>1&&n[1]!="start"){n.shift();this.next=n.shift()}return this.token}},{token:"text",regex:"\\s+"},{token:"punctuation.operator",regex:/[?:,;.]/}],comment:[{token:"comment.multiline",regex:"^=end(?=$|\\s.*$)",next:"start"},{token:"comment",regex:".+"}],qStateWithInterpolation:[{token:"string.start",regex:/[(\[<{]/,onMatch:function(e,t,n){if(n.length&&e===n[0]){n.unshift(e,t);return this.token}return"string"}},{token:"constant.language.escape",regex:p},{token:"constant.language.escape",regex:/\\./},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/[)\]>}^|%]/,onMatch:function(e,t,n){if(n.length&&e===m[n[0]]){n.shift();this.next=n.shift();return this.token}this.next="";return"string"}},{defaultToken:"string"}],qStateWithoutInterpolation:[{token:"string.start",regex:/[(\[<{]/,onMatch:function(e,t,n){if(n.length&&e===n[0]){n.unshift(e,t);return this.token}return"string"}},{token:"constant.language.escape",regex:/\\['\\]/},{token:"constant.language.escape",regex:/\\./},{token:"string.end",regex:/[)\]>}^|%]/,onMatch:function(e,t,n){if(n.length&&e===m[n[0]]){n.shift();this.next=n.shift();return this.token}this.next="";return"string"}},{defaultToken:"string"}],sStateWithoutInterpolation:[{token:"constant.other.symbol.ruby",regex:/[(\[<{]/,onMatch:function(e,t,n){if(n.length&&e===n[0]){n.unshift(e,t);return this.token}return"constant.other.symbol.ruby"}},{token:"constant.other.symbol.ruby",regex:/[)\]>}^|%]/,onMatch:function(e,t,n){if(n.length&&e===m[n[0]]){n.shift();this.next=n.shift();return this.token}this.next="";return"constant.other.symbol.ruby"}},{defaultToken:"constant.other.symbol.ruby"}],sStateWithInterpolation:[{token:"constant.other.symbol.ruby",regex:/[(\[<{]/,onMatch:function(e,t,n){if(n.length&&e===n[0]){n.unshift(e,t);return this.token}return"constant.other.symbol.ruby"}},{token:"constant.language.escape",regex:p},{token:"constant.language.escape",regex:/\\./},{token:"paren.start",regex:/#{/,push:"start"},{token:"constant.other.symbol.ruby",regex:/[)\]>}^|%]/,onMatch:function(e,t,n){if(n.length&&e===m[n[0]]){n.shift();this.next=n.shift();return this.token}this.next="";return"constant.other.symbol.ruby"}},{defaultToken:"constant.other.symbol.ruby"}],rState:[{token:"string.regexp",regex:/[(\[<{]/,onMatch:function(e,t,n){if(n.length&&e===n[0]){n.unshift(e,t);return this.token}return"constant.language.escape"}},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.regexp",regex:/\//},{token:"string.regexp",regex:/[)\]>}^|%][imxouesn]*/,onMatch:function(e,t,n){if(n.length&&e[0]===m[n[0]]){n.shift();this.next=n.shift();return this.token}this.next="";return"constant.language.escape"}},{include:"regex"},{defaultToken:"string.regexp"}],regex:[{token:"regexp.keyword",regex:/\\[wWdDhHsS]/},{token:"constant.language.escape",regex:/\\[AGbBzZ]/},{token:"constant.language.escape",regex:/\\g<[a-zA-Z0-9]*>/},{token:["constant.language.escape","regexp.keyword","constant.language.escape"],regex:/(\\p{\^?)(Alnum|Alpha|Blank|Cntrl|Digit|Graph|Lower|Print|Punct|Space|Upper|XDigit|Word|ASCII|Any|Assigned|Arabic|Armenian|Balinese|Bengali|Bopomofo|Braille|Buginese|Buhid|Canadian_Aboriginal|Carian|Cham|Cherokee|Common|Coptic|Cuneiform|Cypriot|Cyrillic|Deseret|Devanagari|Ethiopic|Georgian|Glagolitic|Gothic|Greek|Gujarati|Gurmukhi|Han|Hangul|Hanunoo|Hebrew|Hiragana|Inherited|Kannada|Katakana|Kayah_Li|Kharoshthi|Khmer|Lao|Latin|Lepcha|Limbu|Linear_B|Lycian|Lydian|Malayalam|Mongolian|Myanmar|New_Tai_Lue|Nko|Ogham|Ol_Chiki|Old_Italic|Old_Persian|Oriya|Osmanya|Phags_Pa|Phoenician|Rejang|Runic|Saurashtra|Shavian|Sinhala|Sundanese|Syloti_Nagri|Syriac|Tagalog|Tagbanwa|Tai_Le|Tamil|Telugu|Thaana|Thai|Tibetan|Tifinagh|Ugaritic|Vai|Yi|Ll|Lm|Lt|Lu|Lo|Mn|Mc|Me|Nd|Nl|Pc|Pd|Ps|Pe|Pi|Pf|Po|No|Sm|Sc|Sk|So|Zs|Zl|Zp|Cc|Cf|Cn|Co|Cs|N|L|M|P|S|Z|C)(})/},{token:["constant.language.escape","invalid","constant.language.escape"],regex:/(\\p{\^?)([^/]*)(})/},{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp",regex:/[/][imxouesn]*/,next:"start"},{token:"invalid",regex:/\{\d+\b,?\d*\}[+*]|[+*$^?][+*]|[$^][?]|\?{3,}/},{token:"constant.language.escape",regex:/\(\?(?:[:=!>]|<'?[a-zA-Z]*'?>|<[=!])|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/},{token:"constant.language.delimiter",regex:/\|/},{token:"regexp.keyword",regex:/\[\[:(?:alnum|alpha|blank|cntrl|digit|graph|lower|print|punct|space|upper|xdigit|word|ascii):\]\]/},{token:"constant.language.escape",regex:/\[\^?/,push:"regex_character_class"},{defaultToken:"string.regexp"}],regex_character_class:[{token:"regexp.keyword",regex:/\\[wWdDhHsS]/},{token:"regexp.charclass.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"constant.language.escape",regex:/&?&?\[\^?/,push:"regex_character_class"},{token:"constant.language.escape",regex:"]",next:"pop"},{token:"constant.language.escape",regex:"-"},{defaultToken:"string.regexp.characterclass"}]};this.normalizeRules()};r.inherits(p,o);t.RubyHighlightRules=p}));ace.define("ace/mode/folding/ruby",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range","ace/token_iterator"],(function(e,t,n){"use strict";var r=e("../../lib/oop");var o=e("./fold_mode").FoldMode;var a=e("../../range").Range;var i=e("../../token_iterator").TokenIterator;var s=t.FoldMode=function(){};r.inherits(s,o);(function(){this.indentKeywords={class:1,def:1,module:1,do:1,unless:1,if:1,while:1,for:1,until:1,begin:1,else:0,elsif:0,rescue:0,ensure:0,when:0,end:-1,case:1,"=begin":1,"=end":-1};this.foldingStartMarker=/(?:\s|^)(def|do|while|class|unless|module|if|for|until|begin|else|elsif|case|rescue|ensure|when)\b|({\s*$)|(=begin)/;this.foldingStopMarker=/(=end(?=$|\s.*$))|(^\s*})|\b(end)\b/;this.getFoldWidget=function(e,t,n){var r=e.getLine(n);var o=this.foldingStartMarker.test(r);var a=this.foldingStopMarker.test(r);if(o&&!a){var i=r.match(this.foldingStartMarker);if(i[1]){if(i[1]=="if"||i[1]=="else"||i[1]=="while"||i[1]=="until"||i[1]=="unless"){if(i[1]=="else"&&/^\s*else\s*$/.test(r)===false){return}if(/^\s*(?:if|else|while|until|unless)\s*/.test(r)===false){return}}if(i[1]=="when"){if(/\sthen\s/.test(r)===true){return}}if(e.getTokenAt(n,i.index+2).type==="keyword")return"start"}else if(i[3]){if(e.getTokenAt(n,i.index+1).type==="comment.multiline")return"start"}else{return"start"}}if(t!="markbeginend"||!a||o&&a)return"";var i=r.match(this.foldingStopMarker);if(i[3]==="end"){if(e.getTokenAt(n,i.index+1).type==="keyword")return"end"}else if(i[1]){if(e.getTokenAt(n,i.index+1).type==="comment.multiline")return"end"}else return"end"};this.getFoldWidgetRange=function(e,t,n){var r=e.doc.getLine(n);var o=this.foldingStartMarker.exec(r);if(o){if(o[1]||o[3])return this.rubyBlock(e,n,o.index+2);return this.openingBracketBlock(e,"{",n,o.index)}var o=this.foldingStopMarker.exec(r);if(o){if(o[3]==="end"){if(e.getTokenAt(n,o.index+1).type==="keyword")return this.rubyBlock(e,n,o.index+1)}if(o[1]==="=end"){if(e.getTokenAt(n,o.index+1).type==="comment.multiline")return this.rubyBlock(e,n,o.index+1)}return this.closingBracketBlock(e,"}",n,o.index+o[0].length)}};this.rubyBlock=function(e,t,n,r){var o=new i(e,t,n);var s=o.getCurrentToken();if(!s||s.type!="keyword"&&s.type!="comment.multiline")return;var l=s.value;var c=e.getLine(t);switch(s.value){case"if":case"unless":case"while":case"until":var u=new RegExp("^\\s*"+s.value);if(!u.test(c)){return}var g=this.indentKeywords[l];break;case"when":if(/\sthen\s/.test(c)){return}case"elsif":case"rescue":case"ensure":var g=1;break;case"else":var u=new RegExp("^\\s*"+s.value+"\\s*$");if(!u.test(c)){return}var g=1;break;default:var g=this.indentKeywords[l];break}var d=[l];if(!g)return;var h=g===-1?e.getLine(t-1).length:e.getLine(t).length;var p=t;var m=[];m.push(o.getCurrentTokenRange());o.step=g===-1?o.stepBackward:o.stepForward;if(s.type=="comment.multiline"){while(s=o.step()){if(s.type!=="comment.multiline")continue;if(g==1){h=6;if(s.value=="=end"){break}}else{if(s.value=="=begin"){break}}}}else{while(s=o.step()){var f=false;if(s.type!=="keyword")continue;var x=g*this.indentKeywords[s.value];c=e.getLine(o.getCurrentTokenRow());switch(s.value){case"do":for(var k=o.$tokenIndex-1;k>=0;k--){var v=o.$rowTokens[k];if(v&&(v.value=="while"||v.value=="until"||v.value=="for")){x=0;break}}break;case"else":var u=new RegExp("^\\s*"+s.value+"\\s*$");if(!u.test(c)||l=="case"){x=0;f=true}break;case"if":case"unless":case"while":case"until":var u=new RegExp("^\\s*"+s.value);if(!u.test(c)){x=0;f=true}break;case"when":if(/\sthen\s/.test(c)||l=="case"){x=0;f=true}break}if(x>0){d.unshift(s.value)}else if(x<=0&&f===false){d.shift();if(!d.length){if((l=="while"||l=="until"||l=="for")&&s.value!="do"){break}if(s.value=="do"&&g==-1&&x!=0)break;if(s.value!="do")break}if(x===0){d.unshift(s.value)}}}}if(!s)return null;if(r){m.push(o.getCurrentTokenRange());return m}var t=o.getCurrentTokenRow();if(g===-1){if(s.type==="comment.multiline"){var b=6}else{var b=e.getLine(t).length}return new a(t,b,p-1,h)}else return new a(p,h,t-1,e.getLine(t-1).length)}}).call(s.prototype)}));ace.define("ace/mode/ruby",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/ruby_highlight_rules","ace/mode/matching_brace_outdent","ace/range","ace/mode/behaviour/cstyle","ace/mode/folding/ruby"],(function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("./text").Mode;var a=e("./ruby_highlight_rules").RubyHighlightRules;var i=e("./matching_brace_outdent").MatchingBraceOutdent;var s=e("../range").Range;var l=e("./behaviour/cstyle").CstyleBehaviour;var c=e("./folding/ruby").FoldMode;var u=function(){this.HighlightRules=a;this.$outdent=new i;this.$behaviour=new l;this.foldingRules=new c;this.indentKeywords=this.foldingRules.indentKeywords};r.inherits(u,o);(function(){this.lineCommentStart="#";this.getNextLineIndent=function(e,t,n){var r=this.$getIndent(t);var o=this.getTokenizer().getLineTokens(t,e);var a=o.tokens;if(a.length&&a[a.length-1].type=="comment"){return r}if(e=="start"){var i=t.match(/^.*[\{\(\[]\s*$/);var s=t.match(/^\s*(class|def|module)\s.*$/);var l=t.match(/.*do(\s*|\s+\|.*\|\s*)$/);var c=t.match(/^\s*(if|else|when|elsif|unless|while|for|begin|rescue|ensure)\s*/);if(i||s||l||c){r+=n}}return r};this.checkOutdent=function(e,t,n){return/^\s+(end|else|rescue|ensure)$/.test(t+n)||this.$outdent.checkOutdent(t,n)};this.autoOutdent=function(e,t,n){var r=t.getLine(n);if(/}/.test(r))return this.$outdent.autoOutdent(t,n);var o=this.$getIndent(r);var a=t.getLine(n-1);var i=this.$getIndent(a);var l=t.getTabString();if(i.length<=o.length){if(o.slice(-l.length)==l)t.remove(new s(n,o.length-l.length,n,o.length))}};this.getMatching=function(e,t,n){if(t==undefined){var r=e.selection.lead;n=r.column;t=r.row}var o=e.getTokenAt(t,n);if(o&&o.value in this.indentKeywords)return this.foldingRules.rubyBlock(e,t,n,true)};this.$id="ace/mode/ruby";this.snippetFileId="ace/snippets/ruby"}).call(u.prototype);t.Mode=u}));ace.define("ace/mode/slim",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/slim_highlight_rules","ace/mode/javascript","ace/mode/markdown","ace/mode/coffee","ace/mode/scss","ace/mode/sass","ace/mode/less","ace/mode/ruby","ace/mode/css"],(function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("./text").Mode;var a=e("./slim_highlight_rules").SlimHighlightRules;var i=function(){o.call(this);this.HighlightRules=a;this.createModeDelegates({javascript:e("./javascript").Mode,markdown:e("./markdown").Mode,coffee:e("./coffee").Mode,scss:e("./scss").Mode,sass:e("./sass").Mode,less:e("./less").Mode,ruby:e("./ruby").Mode,css:e("./css").Mode})};r.inherits(i,o);(function(){this.$id="ace/mode/slim"}).call(i.prototype);t.Mode=i}));(function(){ace.require(["ace/mode/slim"],(function(e){if(typeof module=="object"&&typeof exports=="object"&&module){module.exports=e}}))})();