/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps;

import java.util.List;
import java.util.Map;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.TestListElement;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.JsonParser;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.RequestExecutor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.AbstractBuildStep;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.BuildProcessor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.BuildAbsoluteId;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.HttpBasedStep;

public class GatherTestList
extends AbstractBuildStep<GatherTestList>
implements HttpBasedStep {
    private CloseableHttpClient client;
    private HttpUriRequest method;
    private JsonParser parser;
    private Map<String, List<String>> testNamesWithLinkedTCMap;

    public GatherTestList(BuildProcessor processor) {
        super(processor);
    }

    @Override
    public void setClient(CloseableHttpClient client) {
        this.client = client;
    }

    @Override
    public void setMethod(HttpUriRequest method) {
        this.method = method;
    }

    @Override
    public void setParser(JsonParser parser) {
        this.parser = parser;
    }

    @Override
    public void setBuildAbsoluteId(BuildAbsoluteId absoluteId) {
    }

    public Map<String, List<String>> getTestNamesWithLinkedTCMap() {
        return this.testNamesWithLinkedTCMap;
    }

    @Override
    public boolean needsRescheduling() {
        return false;
    }

    @Override
    public void perform() throws Exception {
        String response = RequestExecutor.getInstance().execute(this.client, this.method);
        TestListElement testList = this.parser.getTestListFromJson(response);
        this.testNamesWithLinkedTCMap = testList.collectAllTestNamesWithLinkedTestCases();
    }

    @Override
    public void reset() {
        this.testNamesWithLinkedTCMap = null;
    }

    @Override
    public Integer suggestedReschedulingInterval() {
        return null;
    }
}

