/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.TestListElement;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.JsonParser;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.HttpClientProvider;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.HttpRequestFactory;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.RequestExecutor;

public class OptimisticTestList {
    private HttpClientProvider clientProvider;
    private TestAutomationProject project;
    private JsonParser parser = new JsonParser();
    private BasicAuthenticationCredentials basicAuthenticationCredentials;

    public OptimisticTestList(HttpClientProvider clientProvider, TestAutomationProject project, BasicAuthenticationCredentials basicAuthenticationCredentials) {
        this.clientProvider = clientProvider;
        this.project = project;
        this.basicAuthenticationCredentials = basicAuthenticationCredentials;
    }

    public Collection<AutomatedTest> run() {
        CloseableHttpClient client = this.clientProvider.getClientFor(this.project.getServer(), this.basicAuthenticationCredentials.getUsername(), String.valueOf(this.basicAuthenticationCredentials.getPassword()));
        HttpGet method = new HttpRequestFactory().newGetJsonTestList(this.project);
        try {
            String response = RequestExecutor.getInstance().execute(client, (HttpUriRequest)method);
            TestListElement testList = this.parser.getTestListFromJson(response);
            LinkedList<AutomatedTest> tests = new LinkedList<AutomatedTest>();
            Map<String, List<String>> testNamesWithLinkTCMap = testList.collectAllTestNamesWithLinkedTestCases();
            testNamesWithLinkTCMap.forEach((testName, linkedTestCases) -> {
                AutomatedTest test = new AutomatedTest(testName, this.project, linkedTestCases);
                tests.add(test);
            });
            LinkedList<AutomatedTest> linkedList = tests;
            return linkedList;
        }
        finally {
            method.releaseConnection();
        }
    }
}

