/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal;

import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.BuildStage;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.JsonParser;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.HttpRequestFactory;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.BuildProcessor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.BuildAbsoluteId;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.CheckBuildQueue;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.CheckBuildRunning;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.GatherTestList;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.GetBuildID;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.HttpBasedStep;

public abstract class AbstractHttpBasedStepSequence {
    protected HttpRequestFactory requestFactory = new HttpRequestFactory();
    protected JsonParser jsonParser = new JsonParser();
    protected BuildStage currentStage = BuildStage.WAITING;
    protected CloseableHttpClient client;
    protected TestAutomationProject project;
    protected BuildAbsoluteId absoluteId;

    void setClient(CloseableHttpClient client) {
        this.client = client;
    }

    void setProject(TestAutomationProject project) {
        this.project = project;
    }

    void setAbsoluteId(BuildAbsoluteId absoluteId) {
        this.absoluteId = absoluteId;
    }

    protected abstract BuildProcessor getProcessor();

    protected CheckBuildQueue newCheckQueue() {
        HttpGet method = this.requestFactory.newCheckQueue(this.project);
        CheckBuildQueue checkQueue = new CheckBuildQueue(this.getProcessor());
        this.wireHttpSteps(checkQueue, (HttpUriRequest)method);
        return checkQueue;
    }

    protected GetBuildID newGetBuildID() {
        HttpGet method = this.requestFactory.newGetBuildsForProject(this.project);
        GetBuildID getBuildID = new GetBuildID(this.getProcessor());
        this.wireHttpSteps(getBuildID, (HttpUriRequest)method);
        return getBuildID;
    }

    protected CheckBuildRunning newCheckBuildRunning() {
        HttpGet method = this.requestFactory.newGetBuild(this.project, this.absoluteId.getBuildId());
        CheckBuildRunning running = new CheckBuildRunning(this.getProcessor());
        this.wireHttpSteps(running, (HttpUriRequest)method);
        return running;
    }

    protected GatherTestList newGatherTestList() {
        HttpGet method = this.requestFactory.newGetJsonTestList(this.project);
        GatherTestList gatherList = new GatherTestList(this.getProcessor());
        this.wireHttpSteps(gatherList, (HttpUriRequest)method);
        return gatherList;
    }

    protected void wireHttpSteps(HttpBasedStep step, HttpUriRequest method) {
        step.setClient(this.client);
        step.setMethod(method);
        step.setParser(this.jsonParser);
        step.setBuildAbsoluteId(this.absoluteId);
    }
}

