/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal.net;

import java.io.IOException;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.testautomation.spi.AccessDenied;
import org.squashtest.tm.service.testautomation.spi.ServerConnectionFailed;

public class RequestExecutor {
    public static final Logger LOGGER = LoggerFactory.getLogger(RequestExecutor.class);
    private static RequestExecutor INSTANCE = new RequestExecutor();

    private RequestExecutor() {
    }

    public static RequestExecutor getInstance() {
        return INSTANCE;
    }

    public String execute(CloseableHttpClient client, HttpUriRequest method) {
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (CloseableHttpResponse resp = client.execute((ClassicHttpRequest)method);){
                this.checkResponseCode(resp.getCode());
                BasicHttpClientResponseHandler handler = new BasicHttpClientResponseHandler();
                return handler.handleResponse((ClassicHttpResponse)resp);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (AccessDenied ex) {
            throw new AccessDenied("Test automation - jenkins : operation rejected the operation because of wrong credentials", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new ServerConnectionFailed("Test automation - jenkins : could not connect to server due to technical error : ", (Throwable)ex);
        }
    }

    private void checkResponseCode(int code) {
        if (code == 200) {
            return;
        }
        switch (code) {
            case 401: 
            case 403: 
            case 407: {
                throw new AccessDenied();
            }
        }
    }
}

