/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.beans;

import java.util.Arrays;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.Action;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.Parameter;
import org.squashtest.tm.plugin.testautomation.jenkins.beans.Task;

public class Item {
    private Action[] actions;
    private Task task;
    int id;

    public Action[] getActions() {
        return this.actions;
    }

    public void setActions(Action[] actions) {
        this.actions = Arrays.copyOf(actions, actions.length);
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean representsProjectWithExtId(String projectName, String externalId) {
        return projectName.equals(this.getProjectName()) && this.hasExternalId(externalId);
    }

    public boolean representsProjectWithId(String projectName, int id) {
        return projectName.equals(this.getProjectName()) && this.getId() == id;
    }

    private boolean hasExternalId(String externalId) {
        if (this.actions == null) {
            return false;
        }
        Parameter extIdParam = Parameter.newExtIdParameter(externalId);
        Action[] actionArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            Action action = actionArray[n2];
            if (action != null && action.hasParameter(extIdParam)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getProjectName() {
        return this.task.getName();
    }
}

