/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks;

import org.springframework.scheduling.TaskScheduler;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.AbstractBuildProcessor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasks.ThreadPoolStepScheduler;

public abstract class DelayedBuildProcessor
extends AbstractBuildProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBuildProcessor.class);

    protected DelayedBuildProcessor(TaskScheduler scheduler) {
        this.scheduler = new ThreadPoolStepScheduler(scheduler);
    }

    @Override
    public void run() {
        this.notifyStepDone();
    }

    @Override
    public void notifyException(Exception ex) {
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void notifyStepDone() {
        if (this.getStepSequence().hasNext() && !this.isCanceled()) {
            this.scheduleNextStep();
        }
    }
}

