/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins.internal.net;

import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.auth.BasicSchemeFactory;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;

@Component
public class HttpClientProvider {
    public static final String BASIC = "Basic ";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientProvider.class);
    private static final int MAX_TOTAL_CONNECTIONS = 50;
    private static final int MAX_CONNECTIONS_PER_ROUTE = 20;
    public static final String AUTHORIZATION = "Authorization";
    private final PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setMaxConnTotal(50).setMaxConnPerRoute(20).build();
    private final CloseableHttpClient sharedHttpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionManager).setConnectionManagerShared(true).setDefaultAuthSchemeRegistry((Lookup)RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory()).build()).build();

    public HttpClientProvider() {
        LOGGER.info("Initialized HTTP connection pool with {} max total connections and {} max per route", (Object)50, (Object)20);
    }

    @PreDestroy
    public void destroy() {
        try {
            LOGGER.info("Shutting down HTTP connection manager");
            this.connectionManager.close();
            this.sharedHttpClient.close();
        }
        catch (IOException e) {
            LOGGER.warn("Error closing HTTP connection manager", (Throwable)e);
        }
    }

    public CloseableHttpClient getClientFor() {
        try {
            return this.sharedHttpClient;
        }
        catch (Exception e) {
            throw new TestAutomationException((Throwable)e);
        }
    }

    public RestTemplate getRestTemplateFor(TestAutomationServer server, String login, String password) {
        try {
            URI uri = new URI(server.getUrl());
            HttpHost targetHost = new HttpHost(uri.getScheme(), uri.getHost(), uri.getPort());
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(targetHost), (Credentials)new UsernamePasswordCredentials(login, password.toCharArray()));
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(targetHost, (AuthScheme)basicAuth);
            HttpClientContext context = HttpClientContext.create();
            context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            context.setAuthCache((AuthCache)authCache);
            HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((HttpClient)this.sharedHttpClient);
            factory.setHttpContextFactory((httpMethod, url) -> context);
            RestTemplate template = new RestTemplate((ClientHttpRequestFactory)factory);
            template.getInterceptors().add((request, body, execution) -> {
                if (!request.getHeaders().containsKey((Object)AUTHORIZATION)) {
                    String auth = login + ":" + password;
                    byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes());
                    String authHeader = BASIC + new String(encodedAuth);
                    request.getHeaders().set(AUTHORIZATION, authHeader);
                }
                return execution.execute(request, body);
            });
            return template;
        }
        catch (URISyntaxException e) {
            throw new TestAutomationException((Throwable)e);
        }
    }
}

