/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.jenkins;

import jakarta.inject.Inject;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.squashtest.csp.core.bugtracker.core.UnsupportedAuthenticationModeException;
import org.squashtest.tm.core.foundation.lang.Couple;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedSuiteWorkflow;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.BuildDef;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.FetchTestListBuildProcessor;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.JsonParser;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.OptimisticTestList;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.StartTestExecution;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.HttpClientProvider;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.net.HttpRequestFactory;
import org.squashtest.tm.plugin.testautomation.jenkins.internal.tasksteps.BuildAbsoluteId;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.testautomation.model.IterationTestPlanItemWithCustomFields;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.service.servers.UserCredentialsCache;
import org.squashtest.tm.service.testautomation.model.SquashAutomExecutionConfiguration;
import org.squashtest.tm.service.testautomation.spi.TestAutomationConnector;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;
import org.squashtest.tm.service.testautomation.spi.TestAutomationServerNoCredentialsException;
import org.squashtest.tm.service.testautomation.spi.UnreadableResponseException;

@Service(value="plugin.testautomation.jenkins.connector")
public class TestAutomationJenkinsConnector
implements TestAutomationConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAutomationConnector.class);
    private static final TestAutomationServerKind CONNECTOR_KIND = TestAutomationServerKind.jenkins;
    private static final int DEFAULT_SPAM_INTERVAL_MILLIS = 5000;
    private static final String GIVEN_PROTOCOL_NOT_SUPPORTED = "The given protocol %s is not supported.";
    @Inject
    private HttpClientProvider clientProvider;
    private final JsonParser jsonParser = new JsonParser();
    @Inject
    private HttpRequestFactory requestFactory;
    @Inject
    private CredentialsProvider credentialsProvider;
    @Inject
    private MessageSource i18nHelper;
    @Inject
    private FeatureManager featureManager;
    @Value(value="${tm.test.automation.pollinterval.millis}")
    private int spamInterval = 5000;

    private String getMessage(String i18nKey) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.i18nHelper.getMessage(i18nKey, null, locale);
    }

    public TestAutomationServerKind getConnectorKind() {
        return CONNECTOR_KIND;
    }

    public boolean checkCredentials(TestAutomationServer server, String login, String password) throws TestAutomationException {
        RestTemplate template = this.clientProvider.getRestTemplateFor(server, login, password);
        HttpGet credCheck = this.requestFactory.newCheckCredentialsMethod(server, login, password);
        try {
            template.execute(credCheck.getUri().toString(), HttpMethod.GET, null, null, new Object[0]);
            return true;
        }
        catch (Exception ex) {
            throw new TestAutomationException((Throwable)ex);
        }
    }

    public boolean checkCredentials(TestAutomationServer server, Credentials credentials) throws TestAutomationException {
        BasicAuthenticationCredentials basicCredentials = (BasicAuthenticationCredentials)credentials;
        return this.checkCredentials(server, basicCredentials.getUsername(), String.valueOf(basicCredentials.getPassword()));
    }

    public Collection<TestAutomationProject> listProjectsOnServer(TestAutomationServer server, Credentials credentials) throws TestAutomationException {
        BasicAuthenticationCredentials basicCredentials = (BasicAuthenticationCredentials)credentials;
        RestTemplate template = this.clientProvider.getRestTemplateFor(server, basicCredentials.getUsername(), String.valueOf(basicCredentials.getPassword()));
        HttpGet getJobsMethod = this.requestFactory.newGetJobsMethod(server);
        try {
            String response = (String)template.getForObject(getJobsMethod.getUri(), String.class);
            return this.jsonParser.readJobListFromJson(response);
        }
        catch (URISyntaxException | UnreadableResponseException ex) {
            throw new UnreadableResponseException("Test automation - jenkins : server '" + String.valueOf(server) + "' returned malformed response : ", ex);
        }
    }

    public Collection<AutomatedTest> listTestsInProject(TestAutomationProject project, String username) throws TestAutomationException {
        Collection<AutomatedTest> collection;
        this.initializeCredentialsCache(username);
        try {
            OptimisticTestList otl = new OptimisticTestList(this.clientProvider, project);
            collection = otl.run();
        }
        catch (Exception ex) {
            Object object;
            try {
                LOGGER.error("Error while fetching job list for project {}.", new Object[]{project});
                LOGGER.error(ex.toString(), new Object[0]);
                CloseableHttpClient client = this.clientProvider.getClientFor();
                FetchTestListBuildProcessor processor = new FetchTestListBuildProcessor();
                processor.setClient(client);
                processor.setProject(project);
                processor.setBuildAbsoluteId(new BuildAbsoluteId(project.getJobName(), this.generateNewId()));
                processor.setDefaultReschedulingDelay(this.spamInterval);
                processor.run();
                object = processor.getResult();
            }
            catch (Throwable throwable) {
                LOGGER.debug("TestAutomationJenkinsConnector : completed test fetching for automation project '{}'", new Object[]{project.getLabel()});
                this.credentialsProvider.unloadCache();
                throw throwable;
            }
            LOGGER.debug("TestAutomationJenkinsConnector : completed test fetching for automation project '{}'", new Object[]{project.getLabel()});
            this.credentialsProvider.unloadCache();
            return object;
        }
        LOGGER.debug("TestAutomationJenkinsConnector : completed test fetching for automation project '{}'", new Object[]{project.getLabel()});
        this.credentialsProvider.unloadCache();
        return collection;
    }

    public void executeParameterizedTests(Collection<Couple<AutomatedExecutionExtender, Map<String, Object>>> parameterizedExecutions, String externalId) {
        MultiValueMap<TestAutomationProject, Couple<AutomatedExecutionExtender, Map<String, Object>>> execsByProject = this.reduceToParamdExecsByProject(parameterizedExecutions);
        List<BuildDef> buildDefs = this.mapToJobDefs(execsByProject);
        for (BuildDef buildDef : buildDefs) {
            new StartTestExecution(buildDef, this.clientProvider, this.requestFactory, externalId).run();
        }
    }

    public List<AutomatedSuiteWorkflow> executeParameterizedTestsBasedOnITPICollection(Collection<IterationTestPlanItemWithCustomFields> tests, Long externalId, Collection<SquashAutomExecutionConfiguration> squashAutomExecutionConfigurations) {
        throw new UnsupportedOperationException();
    }

    private String generateNewId() {
        return Long.toString(System.currentTimeMillis());
    }

    private List<BuildDef> mapToJobDefs(MultiValueMap<TestAutomationProject, Couple<AutomatedExecutionExtender, Map<String, Object>>> execsByProject) {
        ArrayList<BuildDef> jobDefs = new ArrayList<BuildDef>(execsByProject.size());
        for (Map.Entry entry : execsByProject.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            Couple firstEntry = (Couple)((List)entry.getValue()).get(0);
            TestAutomationServer automationServer = ((TestAutomationProject)entry.getKey()).getServer();
            BasicAuthenticationCredentials credentials = this.getAutomationServerCredentials(automationServer);
            jobDefs.add(new BuildDef((TestAutomationProject)entry.getKey(), credentials, (List)entry.getValue(), ((AutomatedExecutionExtender)firstEntry.getA1()).getNodeName()));
        }
        return jobDefs;
    }

    private MultiValueMap<TestAutomationProject, Couple<AutomatedExecutionExtender, Map<String, Object>>> reduceToParamdExecsByProject(Collection<Couple<AutomatedExecutionExtender, Map<String, Object>>> parameterizedExecutions) {
        LinkedMultiValueMap execsByProject = new LinkedMultiValueMap();
        for (Couple<AutomatedExecutionExtender, Map<String, Object>> paramdExec : parameterizedExecutions) {
            execsByProject.add((Object)((AutomatedExecutionExtender)paramdExec.getA1()).getAutomatedProject(), paramdExec);
        }
        return execsByProject;
    }

    private BasicAuthenticationCredentials getAutomationServerCredentials(TestAutomationServer automationServer) {
        Supplier<TestAutomationServerNoCredentialsException> throwIfNull;
        Optional maybeCredentials = this.credentialsProvider.getAppLevelCredentials((ThirdPartyServer)automationServer);
        Credentials credentials = (Credentials)maybeCredentials.orElseThrow(throwIfNull = () -> {
            throw new TestAutomationServerNoCredentialsException(String.format(this.getMessage("message.testAutomationServer.noCredentials"), automationServer.getName()));
        });
        AuthenticationProtocol protocol = credentials.getImplementedProtocol();
        if (!this.supports(protocol)) {
            throw new UnsupportedAuthenticationModeException(protocol.toString());
        }
        return (BasicAuthenticationCredentials)credentials;
    }

    public URL findTestAutomationProjectURL(TestAutomationProject testAutomationProject) {
        String projectUrl = TestAutomationJenkinsConnector.getJobPath(testAutomationProject);
        try {
            return new URI(projectUrl).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            throw new TestAutomationProjectMalformedURLException(projectUrl, e);
        }
    }

    public boolean testListIsOrderGuaranteed(Collection<AutomatedTest> tests) {
        if (tests.isEmpty()) {
            return true;
        }
        Iterator<AutomatedTest> iterator = tests.iterator();
        String firstPath = iterator.next().getPath();
        for (AutomatedTest test : tests) {
            String path = test.getPath();
            if (firstPath.equals(path)) continue;
            return false;
        }
        return true;
    }

    public boolean supports(AuthenticationProtocol authenticationProtocol) {
        if (authenticationProtocol == AuthenticationProtocol.BASIC_AUTH) {
            return true;
        }
        throw new IllegalArgumentException(String.format(GIVEN_PROTOCOL_NOT_SUPPORTED, authenticationProtocol));
    }

    public AuthenticationProtocol[] getSupportedProtocols() {
        return new AuthenticationProtocol[]{AuthenticationProtocol.BASIC_AUTH};
    }

    public static String getJobPath(TestAutomationProject testAutomationProject) {
        TestAutomationServer server = testAutomationProject.getServer();
        String baseUrl = server.getUrl();
        String jobName = TestAutomationJenkinsConnector.getJobSubPath(testAutomationProject);
        return baseUrl + jobName;
    }

    public static String getJobSubPath(TestAutomationProject testAutomationProject) {
        String jobName = StringUtils.prependIfMissing((String)testAutomationProject.getJobName(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        jobName = jobName.replace("/", "/job/");
        return jobName;
    }

    private void initializeCredentialsCache(String username) {
        LOGGER.debug("TestAutomationJenkinsConnector : initializing the credentials cache", new Object[0]);
        UserCredentialsCache credentials = new UserCredentialsCache(username, this.featureManager);
        this.credentialsProvider.restoreCache(credentials);
    }

    public static class TestAutomationProjectMalformedURLException
    extends RuntimeException {
        private static final long serialVersionUID = -4904491027261699261L;

        public TestAutomationProjectMalformedURLException(String projectUrl, Exception e) {
            super("The test automation project url : " + projectUrl + ", is malformed", e);
        }
    }
}

