/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.mappers;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.squashtest.it.datasetbuilder.DatasetData;
import org.squashtest.it.datasetbuilder.SequenceGenerator;
import org.squashtest.it.datasetbuilder.TableRow;
import org.squashtest.it.datasetbuilder.api.model.ActionTestStepModel;
import org.squashtest.it.datasetbuilder.api.model.ActionWordModel;
import org.squashtest.it.datasetbuilder.api.model.CallTestStepModel;
import org.squashtest.it.datasetbuilder.api.model.KeywordTestStepModel;
import org.squashtest.it.datasetbuilder.api.model.TestStepModel;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderGlobalEntities;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderTestCaseWs;
import org.squashtest.it.datasetbuilder.mappers.CustomFieldMapper;
import org.squashtest.it.datasetbuilder.mappers.ProjectMapper;
import org.squashtest.it.datasetbuilder.parser.KeywordStepParser;
import org.squashtest.it.datasetbuilder.rowbuilders.ActionWordFragmentRow;
import org.squashtest.it.datasetbuilder.rowbuilders.ActionWordParameterValueRow;
import org.squashtest.it.datasetbuilder.rowbuilders.ActionWordRow;
import org.squashtest.it.datasetbuilder.rowbuilders.AttachmentListRow;
import org.squashtest.it.datasetbuilder.rowbuilders.RequirementVersionCoverageRow;
import org.squashtest.tm.domain.customfield.BindableEntity;

public final class TestStepMapper {
    private static final String ACTION_WORD_PARAM_NAME_PREFIX = "param";
    private static final String ACTION_WORD_TOKEN_TEXT_SEPARATOR = "-";

    private TestStepMapper() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static <T extends TestStepModel> DatasetData toDatasetData(List<T> models, Long tcId, ProjectMapper.ProjectData projectData, Map<Long, Long> coverageByRequirementVersionId) {
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        SequenceGenerator stepOrderGenerator = new SequenceGenerator();
        datasetData.addDatasetData(models.stream().map(model -> TestStepMapper.mapTestStep(model, tcId, projectData, stepOrderGenerator, coverageByRequirementVersionId)).toList());
        return datasetData;
    }

    static DatasetData mapTestStep(TestStepModel model, Long tcId, ProjectMapper.ProjectData projectData, SequenceGenerator stepOrderGenerator, Map<Long, Long> coverageByRequirementVersionId) {
        TestStepModel testStepModel = model;
        Objects.requireNonNull(testStepModel);
        TestStepModel testStepModel2 = testStepModel;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ActionTestStepModel.class, KeywordTestStepModel.class, CallTestStepModel.class}, (Object)testStepModel2, n)) {
            case 0 -> {
                ActionTestStepModel actionTestStep = (ActionTestStepModel)testStepModel2;
                yield TestStepMapper.mapActionTestStep(actionTestStep, tcId, projectData, stepOrderGenerator, coverageByRequirementVersionId);
            }
            case 1 -> {
                KeywordTestStepModel keywordTestStep = (KeywordTestStepModel)testStepModel2;
                yield TestStepMapper.mapKeywordTestStep(keywordTestStep, tcId, projectData, stepOrderGenerator);
            }
            case 2 -> {
                CallTestStepModel callTestStepModel = (CallTestStepModel)testStepModel2;
                yield TestStepMapper.mapCallTestStep(callTestStepModel, tcId, stepOrderGenerator);
            }
            default -> throw new IllegalArgumentException("Unsupported test step type: " + model.getClass().getName());
        };
    }

    private static DatasetData mapActionTestStep(ActionTestStepModel model, Long tcId, ProjectMapper.ProjectData projectData, SequenceGenerator stepOrderGenerator, Map<Long, Long> coverageByRequirementVersionId) {
        Long attachmentListId = AttachmentListRow.sequence.nextId();
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        datasetData.addTableRowInsert(BuilderGlobalEntities.getAttachmentListTableRow(attachmentListId), BuilderTestCaseWs.getTestStepTableRow(model.getStepId()), BuilderTestCaseWs.getActionTestStepTableRow(model, attachmentListId), BuilderTestCaseWs.getTestCaseStepsTableRow(tcId, model.getStepId(), stepOrderGenerator.getIdAndIncrement()));
        datasetData.addDatasetData(CustomFieldMapper.toDatasetData(projectData, model.getStepId(), BindableEntity.TEST_STEP, model.getCustomFieldValues()));
        model.getRequirementVersionIds().forEach(requirementVersionId -> {
            Long requirementVersionCoverageId;
            if (coverageByRequirementVersionId.containsKey(requirementVersionId)) {
                requirementVersionCoverageId = (Long)coverageByRequirementVersionId.get(requirementVersionId);
            } else {
                requirementVersionCoverageId = RequirementVersionCoverageRow.sequence.nextId();
                datasetData.addTableRowInsert(BuilderTestCaseWs.getRequirementVersionCoverage(requirementVersionCoverageId, requirementVersionId, tcId));
            }
            datasetData.addTableRowInsert(BuilderTestCaseWs.getVerifyingSteps(model.getStepId(), requirementVersionCoverageId));
        });
        return datasetData;
    }

    private static DatasetData mapKeywordTestStep(KeywordTestStepModel model, Long tcId, ProjectMapper.ProjectData projectData, SequenceGenerator stepOrderGenerator) {
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        datasetData.addTableRowInsert(BuilderTestCaseWs.getTestStepTableRow(model.getStepId()));
        datasetData.addTableRowInsert(BuilderTestCaseWs.getTestCaseStepsTableRow(tcId, model.getStepId(), stepOrderGenerator.getIdAndIncrement()));
        if (model.getActionWord() != null) {
            Long actionWordId = ActionWordRow.sequence.nextId();
            ActionWordFragments actionWordFragments = TestStepMapper.mapActionWordFragments(model.getActionWord(), model.getStepId(), actionWordId);
            datasetData.addTableRowInsert(BuilderTestCaseWs.getActionWordTableRow(model.getActionWord(), actionWordId, projectData.projectId(), actionWordFragments.token()));
            datasetData.addTableRowInsert(BuilderTestCaseWs.getActionWordLibraryNodeTableRow(model.getActionWord(), projectData, actionWordId));
            datasetData.addTableRowInsert(BuilderTestCaseWs.getKeywordStepTableRow(model, actionWordId));
            datasetData.addTableRowInsert(actionWordFragments.rows());
        }
        return datasetData;
    }

    private static ActionWordFragments mapActionWordFragments(ActionWordModel model, Long keywordStepId, Long actionWordId) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        StringBuilder prefixTokenBuilder = new StringBuilder();
        StringBuilder textTokenBuilder = new StringBuilder(ACTION_WORD_TOKEN_TEXT_SEPARATOR);
        SequenceGenerator paramGenerator = new SequenceGenerator();
        paramGenerator.getIdAndIncrement();
        SequenceGenerator stepOrder = new SequenceGenerator();
        KeywordStepParser parser = new KeywordStepParser(Objects.requireNonNullElse(model.getWords(), ""), true);
        List<KeywordStepParser.AWToken> awTokens = parser.tokenize();
        awTokens.forEach(token -> {
            Long actionWordFragmentId = ActionWordFragmentRow.sequence.nextId();
            rows.add(BuilderTestCaseWs.getActionWordFragmentRow(actionWordId, actionWordFragmentId, stepOrder.getIdAndIncrement()));
            switch (token.type()) {
                case PLAIN_TEXT: {
                    rows.add(BuilderTestCaseWs.getActionWordText(actionWordFragmentId, token.lexeme()));
                    prefixTokenBuilder.append("T");
                    textTokenBuilder.append(token.lexeme()).append(ACTION_WORD_TOKEN_TEXT_SEPARATOR);
                    break;
                }
                case NUMBER: {
                    prefixTokenBuilder.append("P");
                    rows.addAll(TestStepMapper.mapActionWordParameter(keywordStepId, actionWordFragmentId, token.lexeme(), token.lexeme(), paramGenerator));
                    break;
                }
                case QUOTED_VALUE: {
                    prefixTokenBuilder.append("P");
                    String value = token.lexeme().substring(1, token.lexeme().length() - 1);
                    rows.addAll(TestStepMapper.mapActionWordParameter(keywordStepId, actionWordFragmentId, value, value, paramGenerator));
                    break;
                }
                case ANGLED_VALUE: {
                    prefixTokenBuilder.append("P");
                    String value = token.lexeme().replaceAll("\\s*([<>])\\s*", "").replaceAll("(\\s)+|[^\\w<>-]", "_");
                    value = String.format("&lt;%s&gt;", value);
                    rows.addAll(TestStepMapper.mapActionWordParameter(keywordStepId, actionWordFragmentId, "", value, paramGenerator));
                }
            }
        });
        return new ActionWordFragments(prefixTokenBuilder.append((CharSequence)textTokenBuilder).toString(), rows);
    }

    private static List<TableRow> mapActionWordParameter(Long keywordStepId, Long actionWordFragmentId, String defaultValue, String value, SequenceGenerator paramGenerator) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        Long actionWordParameterValueId = ActionWordParameterValueRow.sequence.nextId();
        String paramName = ACTION_WORD_PARAM_NAME_PREFIX + paramGenerator.getIdAndIncrement();
        rows.add(BuilderTestCaseWs.getActionWordParameter(actionWordFragmentId, paramName, defaultValue));
        rows.add(BuilderTestCaseWs.getActionWordParameterValue(actionWordParameterValueId, actionWordFragmentId, value, keywordStepId));
        return rows;
    }

    private static DatasetData mapCallTestStep(CallTestStepModel model, Long tcId, SequenceGenerator stepOrderGenerator) {
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        datasetData.addTableRowInsert(BuilderTestCaseWs.getTestStepTableRow(model.getStepId()), BuilderTestCaseWs.getTestCaseStepsTableRow(tcId, model.getStepId(), stepOrderGenerator.getIdAndIncrement()), BuilderTestCaseWs.getCallTestStepTableRow(model));
        return datasetData;
    }

    private record ActionWordFragments(String token, List<TableRow> rows) {
    }
}

