/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.domain.bdd.util.ActionWordUtil;
import org.squashtest.tm.exception.actionword.InvalidActionWordInputNameException;
import org.squashtest.tm.exception.actionword.InvalidActionWordTextException;

public class KeywordStepParser {
    private static final List<Character> DELIMITERS = Arrays.asList(Character.valueOf('\"'), Character.valueOf('<'), Character.valueOf('>'));
    private final String source;
    private final boolean allowsNamedParameters;
    private int start = 0;
    private int current = 0;
    private final List<AWToken> tokens = new ArrayList<AWToken>();

    public KeywordStepParser(String source, boolean allowsNamedParameters) {
        this.source = source;
        this.allowsNamedParameters = allowsNamedParameters;
    }

    public List<AWToken> tokenize() {
        while (!this.isAtEnd()) {
            this.start = this.current;
            this.scanToken();
        }
        return this.tokens;
    }

    private boolean isAtEnd() {
        return this.current >= this.source.length();
    }

    private void scanToken() {
        char c = this.peek();
        switch (c) {
            case '\"': {
                this.parseQuotedValue();
                break;
            }
            case '<': {
                this.parseAngledValue();
                break;
            }
            case '>': {
                this.handleHangingCloseAngle();
                break;
            }
            default: {
                this.parsePlainTextAndNumbers();
            }
        }
    }

    private void handleHangingCloseAngle() {
        if (this.allowsNamedParameters) {
            throw new InvalidActionWordTextException("Expected opening delimiter '<' before closing '>' delimiter.");
        }
        throw new InvalidActionWordInputNameException();
    }

    private char peek() {
        if (this.isAtEnd()) {
            return '\u0000';
        }
        return this.source.charAt(this.current);
    }

    private char peekNext() {
        if (this.current + 1 >= this.source.length()) {
            return '\u0000';
        }
        return this.source.charAt(this.current + 1);
    }

    private void advance() {
        ++this.current;
    }

    private void parseQuotedValue() {
        this.advance();
        int openPosition = this.current;
        this.consumeQuotedText();
        if (this.peek() != '\"' || this.isAtEnd()) {
            throw new IllegalArgumentException(String.format("Unclosed quoted value at position %d in source: %s", openPosition, this.source));
        }
        this.advance();
        String text = this.source.substring(this.start, this.current);
        this.tokens.add(new AWToken(AWTokenType.QUOTED_VALUE, text));
    }

    private void parseAngledValue() {
        if (!this.allowsNamedParameters) {
            throw new IllegalArgumentException(String.format("Named parameters are not allowed in source: %s", this.source));
        }
        this.advance();
        int openPosition = this.current;
        while (this.peek() != '>' && !this.isAtEnd()) {
            this.advance();
        }
        if (this.isAtEnd()) {
            throw new IllegalArgumentException(String.format("Unclosed angle bracket at position %d in source: %s", openPosition, this.source));
        }
        this.advance();
        String parameterName = this.source.substring(this.start, this.current);
        this.tokens.add(new AWToken(AWTokenType.ANGLED_VALUE, parameterName));
    }

    private void parsePlainTextAndNumbers() {
        String valueSoFar = this.consumeText();
        this.addTextAndNumbers(valueSoFar);
    }

    private void addTextAndNumbers(String valueSoFar) {
        if (StringUtils.isBlank((CharSequence)valueSoFar)) {
            this.tokens.add(new AWToken(AWTokenType.PLAIN_TEXT, valueSoFar));
            return;
        }
        String[] split = valueSoFar.split("((?<=\\s)|(?=\\s+))");
        StringBuilder textBuilder = new StringBuilder();
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (ActionWordUtil.isNumber((String)part)) {
                if (!textBuilder.isEmpty()) {
                    this.tokens.add(new AWToken(AWTokenType.PLAIN_TEXT, textBuilder.toString()));
                    textBuilder.setLength(0);
                }
                this.tokens.add(new AWToken(AWTokenType.NUMBER, part));
            } else {
                textBuilder.append(part);
            }
            ++n2;
        }
        if (!textBuilder.isEmpty()) {
            this.tokens.add(new AWToken(AWTokenType.PLAIN_TEXT, textBuilder.toString()));
        }
    }

    private String consumeText() {
        while (!KeywordStepParser.isDelimiter(this.peek()) && !this.isAtEnd()) {
            if (this.peek() == '\\' && ActionWordUtil.isEscapableCharacter((char)this.peekNext())) {
                this.advance();
            }
            this.advance();
        }
        return this.source.substring(this.start, this.current);
    }

    private String consumeQuotedText() {
        while (this.peek() != '\"' && !this.isAtEnd()) {
            if (this.peek() == '\\' && ActionWordUtil.isEscapableCharacter((char)this.peekNext())) {
                this.advance();
            }
            this.advance();
        }
        return this.source.substring(this.start, this.current);
    }

    private static boolean isDelimiter(char c) {
        return DELIMITERS.contains(Character.valueOf(c));
    }

    public record AWToken(AWTokenType type, String lexeme) {
    }

    public static enum AWTokenType {
        PLAIN_TEXT,
        NUMBER,
        QUOTED_VALUE,
        ANGLED_VALUE;

    }
}

