/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.mappers;

import java.util.ArrayList;
import java.util.List;
import org.squashtest.it.datasetbuilder.SequenceGenerator;
import org.squashtest.it.datasetbuilder.TableRow;
import org.squashtest.it.datasetbuilder.api.model.InfoListItemModel;
import org.squashtest.it.datasetbuilder.api.model.InfoListModel;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderAdminWsEntities;

public final class InfoListMapper {
    private InfoListMapper() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static InfoListData toInfoListData(InfoListModel model) {
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>();
        Long infoListId = model.getIlId();
        tableRows.add(BuilderAdminWsEntities.getInfoListTableRow(model, infoListId));
        SequenceGenerator itemIndex = new SequenceGenerator();
        Long defaultItemId = null;
        for (InfoListItemModel infoListItem : model.getInfoListItems()) {
            TableRow infoListItemRow = BuilderAdminWsEntities.getInfoListItemTableRow(infoListItem, infoListId, itemIndex.getIdAndIncrement());
            tableRows.add(infoListItemRow);
            if (!infoListItem.getIsDefault()) continue;
            defaultItemId = infoListItem.getIliId();
        }
        return new InfoListData(infoListId, defaultItemId, tableRows);
    }

    public record InfoListData(Long infoListId, Long defaultItemId, List<TableRow> tableRows) {
    }
}

