/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.mappers;

import java.util.ArrayList;
import java.util.List;
import org.squashtest.it.datasetbuilder.DatasetData;
import org.squashtest.it.datasetbuilder.SequenceGenerator;
import org.squashtest.it.datasetbuilder.TableRow;
import org.squashtest.it.datasetbuilder.api.model.DatasetModel;
import org.squashtest.it.datasetbuilder.api.model.ParameterModel;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderTestCaseWs;
import org.squashtest.it.datasetbuilder.rowbuilders.DatasetParamValueRow;

public final class DatasetAndParameterMapper {
    private DatasetAndParameterMapper() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static DatasetData toDatasetData(List<ParameterModel> parametersModels, List<DatasetModel> datasetModels, Long testCaseId) {
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        SequenceGenerator parameterOrderGenerator = new SequenceGenerator();
        ArrayList parameterIds = new ArrayList();
        parametersModels.forEach(parameterModel -> {
            datasetData.addTableRowInsert(BuilderTestCaseWs.getParameterTableRow(parameterModel, testCaseId, parameterOrderGenerator.getIdAndIncrement()));
            parameterIds.add(parameterModel.getParamId());
        });
        datasetModels.forEach(datasetModel -> datasetData.addTableRowInsert(DatasetAndParameterMapper.mapDatasetWithValue(datasetModel, testCaseId, parameterIds)));
        return datasetData;
    }

    private static List<TableRow> mapDatasetWithValue(DatasetModel datasetModel, Long testCaseId, List<Long> parameterIds) {
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>();
        tableRows.add(BuilderTestCaseWs.getDatasetTableRow(datasetModel, testCaseId));
        int i = 0;
        while (i < parameterIds.size()) {
            Long datasetParamId = DatasetParamValueRow.sequence.nextId();
            String paramValue = null;
            if (i < datasetModel.getValues().size()) {
                paramValue = (String)datasetModel.getValues().get(i);
            }
            tableRows.add(BuilderTestCaseWs.getDatasetParameterTableRow(datasetParamId, datasetModel.getDatasetId(), parameterIds.get(i), paramValue));
            ++i;
        }
        return tableRows;
    }
}

